/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.canvas;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;
import pipe.gui.canvas.DrawingSurfaceImpl;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.PetriNetObject;

public class SelectionManager
extends JComponent {
    private Point startPoint;
    private final Point upperLeftCorner = new Point(0, 0);
    private final Rectangle selectionRectangle = new Rectangle(-1, -1);
    private boolean isSelecting;
    private static final Color selectionColor = new Color(0, 0, 255, 30);
    private static final Color selectionColorOutline = new Color(0, 0, 100);
    private final DrawingSurfaceImpl drawingSurface;

    public SelectionManager(DrawingSurfaceImpl _view) {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1 && !e.isControlDown()) {
                    SelectionManager.this.isSelecting = true;
                    SelectionManager.this.drawingSurface.add(SelectionManager.this);
                    SelectionManager.this.drawingSurface.setLayer(SelectionManager.this, 90);
                    SelectionManager.this.startPoint = e.getPoint();
                    SelectionManager.this.selectionRectangle.setSize(0, 0);
                    SelectionManager.this.upperLeftCorner.setLocation(e.getPoint());
                    SelectionManager.this.processSelection(e);
                    SelectionManager.this.updateBounds();
                    SelectionManager.this.repaint();
                } else {
                    SelectionManager.this.startPoint = e.getPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SelectionManager.this.isSelecting) {
                    SelectionManager.this.processSelection(e);
                    SelectionManager.this.isSelecting = false;
                    SelectionManager.this.drawingSurface.setLayer(SelectionManager.this, 0);
                    SelectionManager.this.selectionRectangle.setSize(0, 0);
                    SelectionManager.this.upperLeftCorner.setLocation(0, 0);
                    SelectionManager.this.updateBounds();
                    SelectionManager.this.drawingSurface.remove(SelectionManager.this);
                    SelectionManager.this.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SelectionManager.this.isSelecting) {
                    SelectionManager.this.selectionRectangle.setSize((int)Math.abs((double)e.getX() - SelectionManager.this.startPoint.getX()), (int)Math.abs((double)e.getY() - SelectionManager.this.startPoint.getY()));
                    SelectionManager.this.upperLeftCorner.setLocation((int)Math.min(SelectionManager.this.startPoint.getX(), (double)e.getX()), (int)Math.min(SelectionManager.this.startPoint.getY(), (double)e.getY()));
                    SelectionManager.this.processSelection(e);
                    SelectionManager.this.updateBounds();
                    SelectionManager.this.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.drawingSurface = _view;
    }

    private void updateBounds() {
        this.setBounds(this.upperLeftCorner.x, this.upperLeftCorner.y, this.selectionRectangle.width + 1, this.selectionRectangle.height + 1);
    }

    private void processSelection(MouseEvent e) {
        if (!e.isShiftDown()) {
            this.clearSelection();
        }
        Rectangle intersectionRectangle = new Rectangle(this.upperLeftCorner.x, this.upperLeftCorner.y, this.selectionRectangle.width + 1, this.selectionRectangle.height + 1);
        for (PetriNetObject pnObject : this.drawingSurface.getGuiModel().getPlaceTransitionObjects()) {
            pnObject.select(intersectionRectangle);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(selectionColor);
        g2d.fill(this.selectionRectangle);
        g2d.setPaint(selectionColorOutline);
        g2d.draw(this.selectionRectangle);
    }

    public void clearSelection() {
        for (PetriNetObject pnObject : this.drawingSurface.getGuiModel().getPNObjects()) {
            if (!pnObject.isSelectable()) continue;
            pnObject.deselect();
        }
    }

    public void translateSelection(int transX, int transY) {
        if (transX == 0 && transY == 0) {
            return;
        }
        ArrayList<PetriNetObject> selection = this.getSelection();
        Point topleft = this.getTopLeftMostPoint(selection);
        if (topleft != null) {
            topleft.translate(transX, transY);
            if (topleft.x < 0) {
                transX -= topleft.x;
            }
            if (topleft.y < 0) {
                transY -= topleft.y;
            }
            if (transX == 0 && transY == 0) {
                return;
            }
        }
        for (PetriNetObject pnObject : selection) {
            pnObject.translate(transX, transY);
        }
        this.drawingSurface.updatePreferredSize();
    }

    @Nullable
    private Point getTopLeftMostPoint(List<PetriNetObject> selection) {
        Point topleft = null;
        for (PetriNetObject pnObject : selection) {
            if (!pnObject.isSelected() || pnObject instanceof Arc) continue;
            Point point = pnObject.getLocation();
            if (topleft == null) {
                topleft = point;
                continue;
            }
            if (point.x < topleft.x) {
                topleft.x = point.x;
            }
            if (point.y >= topleft.y) continue;
            topleft.y = point.y;
        }
        return topleft;
    }

    public ArrayList<PetriNetObject> getSelection() {
        ArrayList<PetriNetObject> selection = new ArrayList<PetriNetObject>();
        for (PetriNetObject pnObject : this.drawingSurface.getGuiModel().getPNObjects()) {
            if (!pnObject.isSelected()) continue;
            selection.add(pnObject);
        }
        return selection;
    }

    public void selectAll() {
        for (PetriNetObject pnObject : this.drawingSurface.getGuiModel().getPNObjects()) {
            pnObject.select(false);
        }
        this.drawingSurface.repaint();
    }
}

