/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.versioncheck;

import dk.aau.cs.debug.Logger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;
import net.tapaal.Preferences;
import net.tapaal.TAPAAL;
import net.tapaal.resourcemanager.ResourceManager;

public class VersionChecker {
    private static final String versionURL = "http://versioncheck.tapaal.net/version.txt";
    private static final int timeoutMs = 2500;
    private URL url;
    private String newestVersion;
    String changelog = "";

    public VersionChecker() {
        try {
            this.url = new URL(versionURL);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public boolean checkForNewVersion(boolean forcecheck) {
        if (!TAPAAL.IS_DEV && this.url != null) {
            this.getNewestVersion();
            String ignoreversion = Preferences.getInstance().getLatestVersion();
            boolean check = ignoreversion == null || ignoreversion.isEmpty() || forcecheck || this.newestVersion == null || this.newestVersion.isEmpty() ? true : this.compareVersions(ignoreversion);
            if (this.newestVersion != null && !this.newestVersion.isEmpty() && check) {
                boolean result = this.compareVersions("4.0.3");
                if (forcecheck && !result) {
                    JOptionPane.showMessageDialog(null, "There is no new version of TAPAAL available at the moment.", "No Update for " + TAPAAL.getProgramName(), 1, ResourceManager.appIcon());
                }
                return result;
            }
            if (forcecheck) {
                JOptionPane.showMessageDialog(null, "It is impossible to establish a connection to the server. Try again later.", "No Update for " + TAPAAL.getProgramName(), 1, ResourceManager.appIcon());
            }
        } else if (forcecheck) {
            JOptionPane.showMessageDialog(null, "The development version of TAPAAL does not support update notification.", "No Update for " + TAPAAL.getProgramName(), 1, ResourceManager.appIcon());
        }
        return false;
    }

    private boolean compareVersions(String versionString) {
        int[] currentVersionNumbers = null;
        int[] newestVersionNumbers = null;
        try {
            currentVersionNumbers = this.getVersionNumbers(versionString);
            newestVersionNumbers = this.getVersionNumbers(this.newestVersion);
        }
        catch (Exception e) {
            return false;
        }
        if (currentVersionNumbers.length != 3 || newestVersionNumbers.length != 3) {
            return false;
        }
        if (newestVersionNumbers[0] > currentVersionNumbers[0]) {
            return true;
        }
        if (newestVersionNumbers[0] == currentVersionNumbers[0] && newestVersionNumbers[1] > currentVersionNumbers[1]) {
            return true;
        }
        if (newestVersionNumbers[0] == currentVersionNumbers[0] && newestVersionNumbers[1] == currentVersionNumbers[1] && newestVersionNumbers[2] > currentVersionNumbers[2]) {
            return true;
        }
        if (newestVersionNumbers[0] == currentVersionNumbers[0] && newestVersionNumbers[1] == currentVersionNumbers[1] && newestVersionNumbers[2] == currentVersionNumbers[2]) {
            return this.isCurrentPreRelease(versionString);
        }
        return false;
    }

    private boolean isCurrentPreRelease(String versionString) {
        return versionString.contains(" ");
    }

    private int[] getVersionNumbers(String version) {
        version = version.split("\\s+")[0];
        String delimiter = "\\.";
        String[] split = version.split(delimiter);
        return new int[]{Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2])};
    }

    private void getNewestVersion() {
        try {
            String s;
            URLConnection conn = this.url.openConnection();
            conn.setConnectTimeout(2500);
            conn.setReadTimeout(2500);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            this.newestVersion = in.readLine();
            in.readLine();
            StringBuilder sb = new StringBuilder();
            while ((s = in.readLine()) != null) {
                sb.append(s + "\n");
            }
            this.changelog = sb.toString();
            this.changelog = this.changelog.replace("Changelog:\n", "");
            in.close();
        }
        catch (Exception e) {
            Logger.log("Could not check for new version.");
        }
    }

    public String getNewVersionNumber() {
        return this.newestVersion;
    }

    public String getChangelog() {
        return this.changelog;
    }
}

