/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.swinghelpers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class WidthAdjustingComboBox<E>
extends JComboBox<E> {
    public WidthAdjustingComboBox(int maxNumberOfPlacesToShowAtOnce) {
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                WidthAdjustingComboBox.this.adjustWidthOfPopUpMenu();
            }
        });
        this.setMaximumRowCount(maxNumberOfPlacesToShowAtOnce);
    }

    private void adjustWidthOfPopUpMenu() {
        if (this.getItemCount() == 0) {
            return;
        }
        Accessible comp = this.getUI().getAccessibleChild(this, 0);
        if (!(comp instanceof JPopupMenu)) {
            return;
        }
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int maxWidth = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            int currentWidth;
            if (this.getItemAt(i) == null || maxWidth >= (currentWidth = metrics.stringWidth(this.getItemAt(i).toString()))) continue;
            maxWidth = currentWidth;
        }
        JPopupMenu popup = (JPopupMenu)comp;
        Component[] listOfComponents = popup.getComponents();
        JScrollPane scrollPane = null;
        for (Component element : listOfComponents) {
            if (!(element instanceof JScrollPane)) continue;
            scrollPane = (JScrollPane)element;
            Dimension size = scrollPane.getPreferredSize();
            if (size.width < maxWidth + 70) {
                size.width = maxWidth + 70;
            }
            scrollPane.setPreferredSize(size);
            scrollPane.setMaximumSize(size);
            break;
        }
    }
}

