/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.swinghelpers;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;

public abstract class ExtendedJTabbedPane<T extends Component>
extends JTabbedPane
implements Iterable<T> {
    public abstract Component generator();

    private void setTabComponent(Component component) {
        int index = this.indexOfComponent(component);
        if (index >= 0) {
            this.setTabComponentAt(index, this.generator());
        }
    }

    @Override
    public Component add(Component component) {
        Component toReturn = super.add(component);
        this.setTabComponent(toReturn);
        return toReturn;
    }

    @Override
    public Component add(Component component, int index) {
        Component toReturn = super.add(component, index);
        this.setTabComponent(toReturn);
        return toReturn;
    }

    @Override
    public Component add(String title, Component component) {
        Component toReturn = super.add(title, component);
        this.setTabComponent(toReturn);
        return toReturn;
    }

    @Override
    public void add(Component component, Object constraints) {
        super.add(component, constraints);
        this.setTabComponent(component);
    }

    @Override
    public void add(Component component, Object constraints, int index) {
        super.add(component, constraints, index);
        this.setTabComponent(component);
    }

    @Override
    public void addTab(String title, Component component) {
        super.addTab(title, component);
        this.setTabComponent(component);
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        super.addTab(title, icon, component);
        this.setTabComponent(component);
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
        this.setTabComponent(component);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new TabIterator();
    }

    private class TabIterator
    implements Iterator<T> {
        private int position = 0;

        private TabIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < ExtendedJTabbedPane.this.getTabCount();
        }

        @Override
        public T next() {
            Component toReturn = ExtendedJTabbedPane.this.getTabComponentAt(this.position);
            ++this.position;
            return toReturn;
        }
    }
}

