/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.swinghelpers;

import java.text.DecimalFormatSymbols;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class DecimalOnlyDocumentFilter
extends DocumentFilter {
    final int numberOfDecimalPlaces;

    public DecimalOnlyDocumentFilter(int numberOfDecimalPlaces) {
        this.numberOfDecimalPlaces = numberOfDecimalPlaces;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        String old = fb.getDocument().getText(0, fb.getDocument().getLength());
        StringBuilder newString = new StringBuilder(old);
        newString.replace(offset, length + offset, "");
        if (this.stringIsValidDecimal(newString.toString())) {
            super.remove(fb, offset, length);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        String old = fb.getDocument().getText(0, fb.getDocument().getLength());
        StringBuilder newString = new StringBuilder(old);
        newString.replace(offset, length + offset, text);
        if (this.stringIsValidDecimal(newString.toString())) {
            super.replace(fb, offset, length, text, attrs);
        }
    }

    private boolean stringIsValidDecimal(String text) {
        char localDecimalseparator = DecimalFormatSymbols.getInstance().getDecimalSeparator();
        Pattern pattern = Pattern.compile("^(([1-9]([0-9])*)?|0)(" + Pattern.quote(Character.toString(localDecimalseparator)) + "([0-9]*))?$");
        Matcher m = pattern.matcher(text);
        return m.matches() && (this.numberOfDecimalPlaces < 0 || m.group(5) == null || m.group(5).length() <= this.numberOfDecimalPlaces);
    }
}

