/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.swinghelpers;

import java.awt.KeyboardFocusManager;
import java.text.NumberFormat;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;
import net.tapaal.swinghelpers.SwingHelper;

public class CustomJSpinner
extends JSpinner {
    @Override
    public Object getValue() {
        Object originalValue = this.getModel().getValue();
        int val = originalValue instanceof Long ? (int)((Long)originalValue).longValue() : (Integer)originalValue;
        return new Integer(val);
    }

    public CustomJSpinner(Integer value, final Integer minimumValue, final Integer maximumValue) {
        JSpinner.NumberEditor jsEditor = (JSpinner.NumberEditor)this.getEditor();
        JFormattedTextField textField = jsEditor.getTextField();
        final DocumentFilter digitOnlyFilter = new DocumentFilter(this){
            final /* synthetic */ CustomJSpinner this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                String old = fb.getDocument().getText(0, fb.getDocument().getLength());
                StringBuilder newString = new StringBuilder(old);
                newString.replace(offset, length + offset, "");
                if (this.stringIsValidInteger(newString.toString())) {
                    super.remove(fb, offset, length);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                String old = fb.getDocument().getText(0, fb.getDocument().getLength());
                StringBuilder newString = new StringBuilder(old);
                newString.replace(offset, length + offset, text);
                if (this.stringIsValidInteger(newString.toString())) {
                    super.replace(fb, offset, length, text, attrs);
                }
            }

            private boolean stringIsValidInteger(String text) {
                Integer intValue = null;
                if (text.equals("")) {
                    return true;
                }
                if (!Pattern.matches("^([1-9]([0-9])*)?|0$", text)) {
                    return false;
                }
                try {
                    intValue = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return intValue >= minimumValue && intValue <= maximumValue;
            }
        };
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
        textField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this, format){
            final /* synthetic */ CustomJSpinner this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            protected DocumentFilter getDocumentFilter() {
                return digitOnlyFilter;
            }
        }));
        if (value != null) {
            this.setValue(value);
        }
        this.addChangeListener(e -> {
            if ((Integer)((JSpinner)e.getSource()).getValue() < minimumValue) {
                ((JSpinner)e.getSource()).setValue(minimumValue);
            } else if ((Integer)((JSpinner)e.getSource()).getValue() > maximumValue) {
                ((JSpinner)e.getSource()).setValue(maximumValue);
            }
        });
        SwingHelper.setPreferredWidth(this, 100);
        CustomJSpinner spinner = this;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(ke -> {
            if (ke.getID() == 401 && ke.getKeyCode() == 10 && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == textField) {
                try {
                    spinner.commitEdit();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(spinner, ke);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        });
    }

    public CustomJSpinner(Integer value, JButton okButton) {
        this(value);
        if (okButton != null) {
            JSpinner.NumberEditor jsEditor = (JSpinner.NumberEditor)this.getEditor();
            JFormattedTextField textField = jsEditor.getTextField();
            textField.addActionListener(e -> {
                okButton.requestFocusInWindow();
                okButton.doClick();
            });
        }
    }

    public CustomJSpinner(Integer value) {
        this(value, 0, Integer.MAX_VALUE);
    }
}

