/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.swingcomponents;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MultiLineAutoWrappingTooltipUI
extends BasicToolTipUI {
    private static final MultiLineAutoWrappingTooltipUI sharedInstance = new MultiLineAutoWrappingTooltipUI();
    protected CellRendererPane rendererPane;
    private static JTextArea textArea;

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.rendererPane = new CellRendererPane();
        c.add(this.rendererPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.remove(this.rendererPane);
        this.rendererPane = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        textArea.setBackground(new ColorUIResource(255, 247, 200));
        this.rendererPane.paintComponent(g, textArea, c, 1, 1, size.width - 1, size.height - 1, true);
    }

    @Override
    public Dimension getPreferredSize(JComponent tooltip) {
        if (tooltip instanceof JToolTip) {
            String tipText = ((JToolTip)tooltip).getTipText();
            if (tipText == null) {
                return new Dimension(0, 0);
            }
            textArea = new JTextArea(tipText);
            Dimension originalDim = textArea.getPreferredSize();
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setMargin(new Insets(5, 5, 5, 5));
            textArea.setBackground(tooltip.getBackground());
            textArea.setForeground(tooltip.getForeground());
            int width = 400;
            Dimension dim = textArea.getPreferredSize();
            dim.width = originalDim.width > width ? width : originalDim.width + 10;
            ++dim.height;
            textArea.setSize(dim);
            this.rendererPane.removeAll();
            this.rendererPane.add(textArea);
            this.rendererPane.setBackground(tooltip.getBackground());
            dim = textArea.getPreferredSize();
            ++dim.height;
            ++dim.width;
            return dim;
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

