/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.swingcomponents;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.MultiSplitLayout;

public class BugHandledJXMultisplitPane
extends JXMultiSplitPane {
    public BugHandledJXMultisplitPane() {
        super.setLayout((LayoutManager)((Object)new BugHandledMultiSplitLayout()));
    }

    private class BugHandledMultiSplitLayout
    extends MultiSplitLayout {
        private BugHandledMultiSplitLayout() {
        }

        public Component getComponentForName(String name) {
            return this.getComponentForNode(this.getNodeForName(name));
        }

        public void displayNode(String name, boolean visible) {
            super.displayNode(name, visible);
            Component c = this.getComponentForName(name);
            this.fixDividersError(c);
        }

        private void fixDividersError(Component changedComponent) {
            List t = ((MultiSplitLayout.Split)this.getModel()).getChildren();
            for (int i = t.size() - 1; i > -1; --i) {
                MultiSplitLayout.Node n = (MultiSplitLayout.Node)t.get(i);
                if (!n.isVisible()) continue;
                if (!(n instanceof MultiSplitLayout.Divider)) break;
                n.setVisible(false);
                break;
            }
            if (changedComponent.isVisible() && this.getNodeForComponent(changedComponent).isVisible()) {
                int heigh = 0;
                int i = 0;
                int[] distribution = this.getComponentDistribution();
                for (MultiSplitLayout.Node n : t) {
                    if (n instanceof MultiSplitLayout.Leaf && n.isVisible()) {
                        Component component = this.getComponentForNode(n);
                        n.setBounds(new Rectangle(new Point(0, heigh), new Dimension(component.getPreferredSize().width, distribution[i])));
                        heigh += distribution[i++];
                        continue;
                    }
                    if (!(n instanceof MultiSplitLayout.Divider) || !n.isVisible()) continue;
                    n.setBounds(new Rectangle(0, heigh, n.getBounds().width, n.getBounds().height));
                    heigh += n.getBounds().height;
                }
            }
            BugHandledJXMultisplitPane.this.repaint();
        }

        private int getNumberOfShownComponents() {
            int result = 0;
            List t = ((MultiSplitLayout.Split)this.getModel()).getChildren();
            for (MultiSplitLayout.Node n : t) {
                if (!(n instanceof MultiSplitLayout.Leaf) || !n.isVisible()) continue;
                ++result;
            }
            return result;
        }

        private int[] getComponentDistribution() {
            double totalMinSize = 0.0;
            List t = ((MultiSplitLayout.Split)this.getModel()).getChildren();
            for (MultiSplitLayout.Node n : t) {
                if (!(n instanceof MultiSplitLayout.Leaf) || !n.isVisible()) continue;
                totalMinSize += this.getComponentForNode(n).getPreferredSize().getHeight();
            }
            int i = 0;
            int numberOfShownComponents = this.getNumberOfShownComponents();
            int[] result = new int[numberOfShownComponents];
            double componentArea = BugHandledJXMultisplitPane.this.getSize().getHeight() - (double)(7 * (numberOfShownComponents - 1));
            for (MultiSplitLayout.Node n : t) {
                if (!(n instanceof MultiSplitLayout.Leaf) || !n.isVisible()) continue;
                Component c = this.getComponentForNode(n);
                result[i++] = (int)Math.floor(componentArea * (c.getPreferredSize().getHeight() / totalMinSize) + 0.5);
            }
            return result;
        }
    }
}

