/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.verification;

import dk.aau.cs.Messenger;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLTrueNode;
import dk.aau.cs.TCTL.visitors.CTLQueryVisitor;
import dk.aau.cs.io.LoadedModel;
import dk.aau.cs.io.PNMLWriter;
import dk.aau.cs.io.PNMLoader;
import dk.aau.cs.io.TapnEngineXmlLoader;
import dk.aau.cs.io.TimedArcPetriNetNetworkWriter;
import dk.aau.cs.io.queries.XMLQueryLoader;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.util.FormatException;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.UnsupportedModelException;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.ProcessRunner;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.VerificationOptions;
import dk.aau.cs.verification.VerifyTAPN.ColorBindingParser;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPNUnfoldOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyPNUnfoldOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.TabTransformer;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.PetriNetObject;

public class UnfoldNet
extends SwingWorker<String, Void> {
    protected final ModelChecker modelChecker;
    protected final HashMap<TimedArcPetriNet, DataLayer> guiModels;
    protected final Messenger messenger;
    protected TimedArcPetriNetNetwork model;
    protected Iterable<TAPNQuery> queries;
    protected PetriNetTab oldTab;
    protected final boolean partition;
    protected final boolean computeColorFixpoint;
    protected final boolean symmetricVars;
    private final int maxNetSize = 4000;
    private boolean netTooBig = false;

    public UnfoldNet(ModelChecker modelChecker, Messenger messenger, HashMap<TimedArcPetriNet, DataLayer> guiModels, boolean partition, boolean computeColorFixpoint, boolean useSymmetricVars) {
        this.modelChecker = modelChecker;
        this.messenger = messenger;
        this.guiModels = guiModels;
        this.partition = partition;
        this.computeColorFixpoint = computeColorFixpoint;
        this.symmetricVars = useSymmetricVars;
    }

    public void execute(TimedArcPetriNetNetwork model, PetriNetTab oldTab) {
        this.model = model;
        this.oldTab = oldTab;
        this.execute();
    }

    @Override
    protected String doInBackground() throws Exception {
        String line;
        TAPNLens lens = this.oldTab.getLens();
        TAPNComposer composer = new TAPNComposer(new MessengerImpl(), this.guiModels, lens, true, true);
        Tuple<TimedArcPetriNet, NameMapping> transformedModel = composer.transformModel(this.model);
        StringBuilder error = new StringBuilder();
        File modelFile = null;
        File queryFile = null;
        File modelOut = null;
        File queryOut = null;
        try {
            modelFile = lens.isTimed() ? File.createTempFile("modelInUnfold", ".xml") : File.createTempFile("modelInUnfold", ".tapn");
            queryFile = File.createTempFile("queryInUnfold", ".xml");
            modelOut = File.createTempFile("modelOut", ".xml");
            queryOut = File.createTempFile("queryOut", ".xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            error.append(e.getMessage());
            return error.toString();
        }
        try {
            TimedArcPetriNetNetwork network = new TimedArcPetriNetNetwork();
            ArrayList<Template> templates = new ArrayList<Template>(1);
            ArrayList<TAPNQuery> queries = new ArrayList<TAPNQuery>(1);
            network.add(transformedModel.value1());
            for (ColorType ct : this.model.colorTypes()) {
                network.add(ct);
            }
            for (Variable variable : this.model.variables()) {
                network.add(variable);
            }
            templates.add(new Template(transformedModel.value1(), composer.getGuiModel(), new Zoomer()));
            if (lens.isTimed()) {
                TimedArcPetriNetNetworkWriter writerTACPN = new TimedArcPetriNetNetworkWriter(network, templates, queries, this.model.constants(), lens);
                writerTACPN.savePNML(modelFile, false);
            } else {
                HashMap<TimedArcPetriNet, DataLayer> guiModels = new HashMap<TimedArcPetriNet, DataLayer>();
                guiModels.put(transformedModel.value1(), composer.getGuiModel());
                PNMLWriter writerTACPN = new PNMLWriter(network, guiModels, lens);
                writerTACPN.savePNML(modelFile);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            e.printStackTrace();
            error.append(e.getMessage());
            return error.toString();
        }
        Vector<TAPNQuery> clonedQueries = new Vector<TAPNQuery>();
        TCTLEFNode efNode = new TCTLEFNode(new TCTLTrueNode());
        TAPNQuery test = new TAPNQuery("placeholder", 1000, efNode, null, null, null, false, false, false, false, null, null, lens.isColored());
        TabTransformer.mapQueryToNewNames(test, transformedModel.value2());
        clonedQueries.add(test);
        try {
            PrintStream queryStream = new PrintStream(queryFile);
            CTLQueryVisitor XMLVisitor = new CTLQueryVisitor();
            String formattedQueries = "";
            for (TAPNQuery query : clonedQueries) {
                formattedQueries = XMLVisitor.getXMLQueryFor(query.getProperty(), query.getName(), lens.isGame());
            }
            queryStream.append(formattedQueries);
            queryStream.close();
        }
        catch (FileNotFoundException e) {
            System.err.append("An error occurred while exporting the model to verifytapn. Verification cancelled.");
            error.append("An error occurred while exporting the model to verifytapn. Verification cancelled.");
            error.append(e.getMessage());
            return error.toString();
        }
        VerificationOptions unfoldTACPNOptions = lens.isTimed() ? new VerifyDTAPNUnfoldOptions(modelOut.getAbsolutePath(), queryOut.getAbsolutePath(), this.model.marking().size() * 2, clonedQueries.size()) : new VerifyPNUnfoldOptions(modelOut.getAbsolutePath(), queryOut.getAbsolutePath(), clonedQueries.size(), this.partition, this.computeColorFixpoint, this.symmetricVars);
        ProcessRunner runner = new ProcessRunner(this.modelChecker.getPath(), TabTransformer.createUnfoldArgumentString(modelFile.getAbsolutePath(), queryFile.getAbsolutePath(), unfoldTACPNOptions));
        runner.run();
        ArrayList<String> outputLines = new ArrayList<String>();
        BufferedReader reader = runner.standardOutput();
        while ((line = reader.readLine()) != null) {
            outputLines.add(line);
        }
        int netSize = this.readUnfoldedSize(outputLines);
        if (netSize > 4000) {
            new Thread(() -> JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The unfolded net is too large to be loaded")).start();
            this.netTooBig = true;
            this.cancel(true);
            return null;
        }
        File fileOut = new File(modelOut.getAbsolutePath());
        LoadedModel loadedModel = null;
        try {
            loadedModel = lens.isTimed() ? new TapnEngineXmlLoader().load(fileOut) : new PNMLoader().load(fileOut);
            if (loadedModel == null) {
                error.append("Unfolded model could not be loaded");
                return error.toString();
            }
            PetriNetTab newTab = new PetriNetTab(loadedModel.network(), loadedModel.templates(), loadedModel.queries(), new TAPNLens(this.oldTab.getLens().isTimed(), this.oldTab.getLens().isGame(), false, this.oldTab.getLens().isStochastic()));
            newTab.setInitialName(this.oldTab.getTabTitle().replace(".tapn", "") + "-unfolded");
            Thread thread = new Thread(() -> TAPAALGUI.getAppGuiController().openTab(newTab));
            thread.start();
            while (thread.isAlive()) {
                if (!this.isCancelled()) continue;
                thread.stop();
            }
            ColorBindingParser parser = new ColorBindingParser();
            parser.addBindings(loadedModel, String.join((CharSequence)System.lineSeparator(), outputLines));
        }
        catch (FormatException e) {
            e.printStackTrace();
            error.append(e.getMessage());
            return error.toString();
        }
        catch (ThreadDeath d) {
            error.append(d.getMessage());
            return error.toString();
        }
        if (runner.error()) {
            error.append(runner.errorOutput());
            return error.toString();
        }
        return null;
    }

    public static List<TAPNQuery> getQueries(File queryFile, TimedArcPetriNetNetwork network, TAPNQuery.QueryCategory queryCategory) {
        return UnfoldNet.getQueries(queryFile, network, List.of(queryCategory));
    }

    public static List<TAPNQuery> getQueries(File queryFile, TimedArcPetriNetNetwork network, List<TAPNQuery.QueryCategory> queryCategories) {
        XMLQueryLoader queryLoader = new XMLQueryLoader(queryFile, network, queryCategories);
        try {
            return new ArrayList<TAPNQuery>(queryLoader.parseQueries().getQueries());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private void addLocation(LoadedModel loadedModel, TAPNComposer composer) {
        for (Template net : loadedModel.templates()) {
            int shifterX = this.calculateShift(net, true);
            int shifterY = this.calculateShift(net, false);
            if (shifterY > shifterX) {
                shifterY = 0;
            } else {
                shifterX = 0;
            }
            int counterX = shifterX;
            int counterY = shifterY;
            for (PetriNetObject object : net.guiModel().getPetriNetObjects()) {
                for (PetriNetObject modelObject : composer.getGuiModel().getPetriNetObjects()) {
                    if (!object.getName().startsWith(modelObject.getName())) continue;
                    object.setOriginalX(modelObject.getOriginalX() + shifterX);
                    object.setOriginalY(modelObject.getOriginalY() + shifterY);
                    break;
                }
                shifterX += counterX;
                shifterY += counterY;
            }
        }
    }

    private int calculateShift(Template net, boolean calculatingX) {
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (PetriNetObject object : net.guiModel().getPetriNetObjects()) {
            if (calculatingX) {
                if (object.getX() > max) {
                    max = object.getX();
                }
                if (object.getX() >= min) continue;
                min = object.getX();
                continue;
            }
            if (object.getY() > max) {
                max = object.getY();
            }
            if (object.getY() >= min) continue;
            min = object.getY();
        }
        return max - min + 30 + 10;
    }

    private int readUnfoldedSize(List<String> lines) {
        int numElements = 0;
        for (String line : lines) {
            if (!line.startsWith("Size of unfolded net: ")) continue;
            Pattern p = Pattern.compile("\\d+");
            Matcher m = p.matcher(line);
            while (m.find()) {
                numElements += Integer.parseInt(m.group());
            }
        }
        return numElements;
    }

    @Override
    protected void done() {
        if (!this.isCancelled()) {
            String result = null;
            try {
                result = (String)this.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.showErrorMessage(e.getMessage());
                return;
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof UnsupportedModelException)) {
                    e.printStackTrace();
                }
                this.showErrorMessage(e.getMessage());
                return;
            }
            if (result != null) {
                this.showErrorMessage(result);
            } else {
                this.firePropertyChange("state", (Object)SwingWorker.StateValue.PENDING, (Object)SwingWorker.StateValue.DONE);
                this.firePropertyChange("unfolding", (Object)SwingWorker.StateValue.PENDING, (Object)SwingWorker.StateValue.DONE);
            }
        } else {
            this.modelChecker.kill();
            if (this.netTooBig) {
                this.netTooBig = false;
                return;
            }
            this.messenger.displayInfoMessage("Unfolding was interrupted by the user", "Unfolding Cancelled");
        }
    }

    void showErrorMessage(String error) {
        JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The unfolding failed with error:\n" + error, "Unfolding Error", 0);
    }
}

