/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.verification;

import dk.aau.cs.Messenger;
import dk.aau.cs.TCTL.visitors.RenameAllPlacesVisitor;
import dk.aau.cs.TCTL.visitors.RenameAllTransitionsVisitor;
import dk.aau.cs.approximation.ApproximationWorker;
import dk.aau.cs.approximation.OverApproximation;
import dk.aau.cs.approximation.UnderApproximation;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.TimedArcPetriNetTrace;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.UnsupportedModelException;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.QueryType;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.TAPNTraceDecomposer;
import dk.aau.cs.verification.VerificationOptions;
import dk.aau.cs.verification.VerificationResult;
import dk.aau.cs.verification.VerifyTAPN.ModelReduction;
import dk.aau.cs.verification.VerifyTAPN.VerifyPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyPNOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOptions;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.verification.KBoundAnalyzer;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.FileFinder;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.dataLayer.DataLayer;

public abstract class RunVerificationBase
extends SwingWorker<VerificationResult<TAPNNetworkTrace>, Void> {
    protected final ModelChecker modelChecker;
    protected VerificationOptions options;
    protected TimedArcPetriNetNetwork model;
    protected DataLayer guiModel;
    protected dk.aau.cs.model.tapn.TAPNQuery query;
    protected dk.aau.cs.model.tapn.TAPNQuery clonedQuery;
    protected TAPNQuery dataLayerQuery;
    protected HashMap<TimedArcPetriNet, DataLayer> guiModels;
    protected final String reducedNetFilePath;
    protected final boolean reduceNetOnly;
    protected boolean reducedNetOpened = false;
    protected final JSpinner spinner;
    protected final Messenger messenger;
    TAPNLens lens;
    private String error;

    public RunVerificationBase(ModelChecker modelChecker, Messenger messenger, HashMap<TimedArcPetriNet, DataLayer> guiModels, String reducedNetFilePath, boolean reduceNetOnly, JSpinner spinner) {
        this.modelChecker = modelChecker;
        this.messenger = messenger;
        this.guiModels = guiModels;
        this.reducedNetFilePath = reducedNetFilePath;
        this.reduceNetOnly = reduceNetOnly;
        this.spinner = spinner;
    }

    public void execute(VerificationOptions options, TimedArcPetriNetNetwork model, dk.aau.cs.model.tapn.TAPNQuery query, TAPNQuery dataLayerQuery, TAPNLens lens) {
        this.model = model;
        this.options = options;
        this.query = query;
        this.dataLayerQuery = dataLayerQuery;
        this.lens = lens;
        this.execute();
    }

    public void execute(VerificationOptions options, TimedArcPetriNetNetwork model, dk.aau.cs.model.tapn.TAPNQuery query, TAPNQuery dataLayerQuery) {
        this.execute(options, model, query, dataLayerQuery, null);
    }

    @Override
    protected VerificationResult<TAPNNetworkTrace> doInBackground() throws Exception {
        TAPNComposer composer = new TAPNComposer(this.messenger, this.guiModels, this.lens, false, true);
        Tuple<TimedArcPetriNet, NameMapping> transformedModel = composer.transformModel(this.model);
        this.guiModel = composer.getGuiModel();
        if (this.options.enabledOverApproximation()) {
            OverApproximation overaprx = new OverApproximation();
            overaprx.modifyTAPN(transformedModel.value1(), this.options.approximationDenominator());
        } else if (this.options.enabledUnderApproximation()) {
            UnderApproximation underaprx = new UnderApproximation();
            underaprx.modifyTAPN(transformedModel.value1(), this.options.approximationDenominator());
        }
        this.clonedQuery = new dk.aau.cs.model.tapn.TAPNQuery(this.query.getProperty().copy(), this.query.getExtraTokens(), this.query.getSMCSettings());
        this.MapQueryToNewNames(this.clonedQuery, transformedModel.value2());
        if (this.dataLayerQuery != null) {
            this.clonedQuery.setCategory(this.dataLayerQuery.getCategory());
            this.clonedQuery.setVerificationType(this.dataLayerQuery.getVerificationType());
            this.clonedQuery.setTraceList(this.dataLayerQuery.getTraceList());
            this.clonedQuery.setSMCSettings(this.dataLayerQuery.getSmcSettings());
        }
        if (!(!this.options.enabledStateequationsCheck() || this.query.queryType() != QueryType.EF && this.query.queryType() != QueryType.AG || this.query.hasDeadlock() || this.options instanceof VerifyPNOptions)) {
            VerifyPN verifypn = new VerifyPN(new FileFinder(), new MessengerImpl());
            verifypn.supportsModel(transformedModel.value1(), this.options);
            if (!verifypn.setup()) {
                this.messenger.displayInfoMessage("Over-approximation check is skipped because VerifyPN is not available.", "VerifyPN unavailable");
            } else {
                VerificationResult<TimedArcPetriNetTrace> skeletonAnalysisResult = null;
                skeletonAnalysisResult = this.dataLayerQuery != null ? verifypn.verify((VerificationOptions)new VerifyPNOptions(this.options.extraTokens(), TAPNQuery.TraceOption.NONE, TAPNQuery.SearchOption.OVERAPPROXIMATE, true, ModelReduction.AGGRESSIVE, this.options.enabledOverApproximation(), this.options.enabledUnderApproximation(), this.options.approximationDenominator(), this.dataLayerQuery.getCategory(), this.dataLayerQuery.getAlgorithmOption(), this.dataLayerQuery.isSiphontrapEnabled(), this.dataLayerQuery.isQueryReductionEnabled() ? TAPNQuery.QueryReductionTime.UnlimitedTime : TAPNQuery.QueryReductionTime.NoTime, this.dataLayerQuery.isStubbornReductionEnabled(), this.reducedNetFilePath, this.dataLayerQuery.isTarOptionEnabled(), this.dataLayerQuery.isTarjan(), this.model.isColored(), this.model.isColored() && (!this.model.isUntimed() || this.options.traceOption() != TAPNQuery.TraceOption.NONE), this.dataLayerQuery.usePartitioning(), this.dataLayerQuery.useColorFixpoint(), this.dataLayerQuery.useSymmetricVars(), this.dataLayerQuery.useExplicitSearch()), transformedModel, this.clonedQuery, composer.getGuiModel(), this.dataLayerQuery, null) : verifypn.verify((VerificationOptions)new VerifyPNOptions(this.options.extraTokens(), TAPNQuery.TraceOption.NONE, TAPNQuery.SearchOption.OVERAPPROXIMATE, true, ModelReduction.AGGRESSIVE, this.options.enabledOverApproximation(), this.options.enabledUnderApproximation(), this.options.approximationDenominator(), TAPNQuery.QueryCategory.Default, TAPNQuery.AlgorithmOption.CERTAIN_ZERO, false, TAPNQuery.QueryReductionTime.UnlimitedTime, false, this.reducedNetFilePath, false, true, this.model.isColored(), this.model.isColored() && (!this.model.isUntimed() || this.options.traceOption() != TAPNQuery.TraceOption.NONE), true, true, this.options.useExplicitSearch()), transformedModel, this.clonedQuery, composer.getGuiModel(), this.dataLayerQuery, null);
                if (skeletonAnalysisResult.getQueryResult() != null && !skeletonAnalysisResult.error() && (this.model.isUntimed() && this.options.traceOption() == TAPNQuery.TraceOption.NONE || this.query.queryType() == QueryType.EF && !skeletonAnalysisResult.getQueryResult().isQuerySatisfied() || this.query.queryType() == QueryType.AG && skeletonAnalysisResult.getQueryResult().isQuerySatisfied())) {
                    VerificationResult<TAPNNetworkTrace> value = new VerificationResult<TAPNNetworkTrace>(skeletonAnalysisResult.getQueryResult(), this.decomposeTrace(skeletonAnalysisResult.getTrace(), transformedModel.value2()), skeletonAnalysisResult.verificationTime(), skeletonAnalysisResult.stats(), skeletonAnalysisResult.getRawOutput());
                    value.setResolvedUsingSkeletonAnalysisPreprocessor(true);
                    value.setNameMapping(transformedModel.value2());
                    return value;
                }
            }
        }
        ApproximationWorker worker = new ApproximationWorker();
        return worker.normalWorker(this.options, this.modelChecker, transformedModel, composer, this.clonedQuery, this, this.model, this.guiModel, this.dataLayerQuery, this.lens);
    }

    private TAPNNetworkTrace decomposeTrace(TimedArcPetriNetTrace trace, NameMapping mapping) {
        if (trace == null) {
            return null;
        }
        TAPNTraceDecomposer decomposer = new TAPNTraceDecomposer(trace, this.model, mapping);
        return decomposer.decompose();
    }

    private void MapQueryToNewNames(dk.aau.cs.model.tapn.TAPNQuery query, NameMapping mapping) {
        RenameAllPlacesVisitor placeVisitor = new RenameAllPlacesVisitor(mapping);
        RenameAllTransitionsVisitor transitionVisitor = new RenameAllTransitionsVisitor(mapping);
        query.getProperty().accept(placeVisitor, null);
        query.getProperty().accept(transitionVisitor, null);
    }

    @Override
    protected void done() {
        if (!this.isCancelled()) {
            VerificationResult result = null;
            try {
                result = (VerificationResult)this.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.showErrorMessage(e.getMessage());
                return;
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof UnsupportedModelException)) {
                    e.printStackTrace();
                }
                this.showErrorMessage(e.getMessage());
                return;
            }
            this.firePropertyChange("state", (Object)SwingWorker.StateValue.PENDING, (Object)SwingWorker.StateValue.DONE);
            if (result == null) {
                return;
            }
            if (this.showResult(result) && this.spinner != null) {
                TAPNQuery.QueryReductionTime reductionTime = TAPNQuery.QueryReductionTime.UnlimitedTime;
                if (this.dataLayerQuery != null) {
                    reductionTime = this.dataLayerQuery.isQueryReductionEnabled() ? TAPNQuery.QueryReductionTime.UnlimitedTime : TAPNQuery.QueryReductionTime.NoTime;
                }
                this.options = new VerifyPNOptions(this.options.extraTokens(), TAPNQuery.TraceOption.NONE, TAPNQuery.SearchOption.BFS, false, ModelReduction.BOUNDPRESERVING, false, false, 1, TAPNQuery.QueryCategory.CTL, TAPNQuery.AlgorithmOption.CERTAIN_ZERO, false, reductionTime, false, null, false, false, false, false, false, false, false, this.options.useExplicitSearch());
                KBoundAnalyzer optimizer = new KBoundAnalyzer(this.model, TAPAALGUI.getCurrentTab().lens, this.guiModels, this.options.extraTokens(), this.modelChecker, new MessengerImpl(), this.spinner, this.dataLayerQuery);
                optimizer.analyze((VerifyTAPNOptions)this.options, true);
            }
            if (result.getQueryResult() != null && result.getQueryResult().isQuerySatisfied() && result.getTrace() != null) {
                this.firePropertyChange("unfolding", (Object)SwingWorker.StateValue.PENDING, (Object)SwingWorker.StateValue.DONE);
            }
        } else {
            this.modelChecker.kill();
            this.messenger.displayInfoMessage("Verification was interrupted by the user. No result found!", "Verification Cancelled");
        }
    }

    private void showErrorMessage(String errorMessage) {
        this.error = errorMessage;
        SwingUtilities.invokeLater(() -> {
            this.messenger.displayErrorMessage("The engine selected in the query dialog cannot verify this model.\nPlease choose another engine.\n" + this.error);
            TAPAALGUI.getCurrentTab().editSelectedQuery();
        });
    }

    protected abstract boolean showResult(VerificationResult<TAPNNetworkTrace> var1);
}

