/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.verification;

import dk.aau.cs.Messenger;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.util.MemoryMonitor;
import dk.aau.cs.util.VerificationCallback;
import dk.aau.cs.verification.IconSelector;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.QueryType;
import dk.aau.cs.verification.SMCResultPanel;
import dk.aau.cs.verification.StatisticsPanel;
import dk.aau.cs.verification.VerificationResult;
import dk.aau.cs.verification.VerifyTAPN.ColorBindingParser;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.tapaal.gui.petrinet.verification.RunVerificationBase;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.swinghelpers.GridBagHelper;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;

public class RunVerification
extends RunVerificationBase {
    private final IconSelector iconSelector;
    private final VerificationCallback callback;

    public RunVerification(ModelChecker modelChecker, IconSelector selector, Messenger messenger, VerificationCallback callback, HashMap<TimedArcPetriNet, DataLayer> guiModels, String reducedNetFilePath, boolean reduceNetOnly) {
        super(modelChecker, messenger, guiModels, reducedNetFilePath, reduceNetOnly, null);
        this.iconSelector = selector;
        this.callback = callback;
    }

    public RunVerification(ModelChecker modelChecker, IconSelector selector, Messenger messenger, VerificationCallback callback, HashMap<TimedArcPetriNet, DataLayer> guiModels) {
        this(modelChecker, selector, messenger, callback, guiModels, null, false);
    }

    public RunVerification(ModelChecker modelChecker, IconSelector selector, Messenger messenger) {
        this(modelChecker, selector, messenger, null, null, null, false);
    }

    @Override
    protected boolean showResult(VerificationResult<TAPNNetworkTrace> result) {
        if (this.reduceNetOnly) {
            if (result != null && result.stats().transitionsCount() == 0 && result.stats().placeBoundCount() == 0) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), this.createMessagePanel(result), "Verification Result", 1, this.iconSelector.getIconFor(result));
            }
        } else if (result != null && !result.error()) {
            if (this.callback != null) {
                this.callback.run(result);
            } else {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), this.createMessagePanel(result), "Verification Result", 1, this.iconSelector.getIconFor(result));
                boolean isNetDrawable = true;
                if (result.getUnfoldedTab() != null) {
                    isNetDrawable = result.getUnfoldedTab().network().paintNet();
                }
                if (result.getUnfoldedTab() != null) {
                    ColorBindingParser parser = new ColorBindingParser();
                    parser.addBindings(result.getUnfoldedTab().getModel(), result.getRawOutput());
                }
                if ((this.options.traceOption() != TAPNQuery.TraceOption.NONE || this.lens.isStochastic() && this.options.isSimulate()) && isNetDrawable) {
                    if (!this.reducedNetOpened && Objects.nonNull(result.getTrace()) && Objects.nonNull(TAPAALGUI.getAnimator())) {
                        if ((this.lens != null && this.lens.isColored() || this.model.isColored()) && !this.options.useExplicitSearch()) {
                            int dialogResult = JOptionPane.showConfirmDialog(null, "There is a trace that will be displayed in a new tab on the unfolded net/query.", "Open trace", 2);
                            if (dialogResult == 0) {
                                TAPAALGUI.openNewTabFromStream(result.getUnfoldedTab());
                            } else {
                                return false;
                            }
                        }
                        if (result.getTraceMap() == null) {
                            TAPAALGUI.getAnimator().setTrace(result.getTrace());
                        } else if (this.lens.isStochastic() && this.options.isSimulate()) {
                            TAPAALGUI.getAnimator().setTrace(result.getTrace(), result.getTraceMap());
                        } else {
                            HashMap<String, TAPNNetworkTrace> traceMap = new HashMap<String, TAPNNetworkTrace>();
                            for (String key : result.getTraceMap().keySet()) {
                                if (!this.query.toString().contains(key)) continue;
                                traceMap.put(key, result.getTraceMap().get(key));
                            }
                            TAPAALGUI.getAnimator().setTrace(result.getTrace(), traceMap);
                        }
                    } else if (this.query.getProperty() instanceof TCTLEFNode && result.isQuerySatisfied() || this.query.getProperty() instanceof TCTLAGNode && !result.isQuerySatisfied() || this.query.getProperty() instanceof TCTLEGNode && result.isQuerySatisfied() || this.query.getProperty() instanceof TCTLAFNode && !result.isQuerySatisfied()) {
                        String message = "A trace exists but could not be generated by the engine.\n\n";
                        this.messenger.displayWrappedErrorMessage(message, "No trace generated");
                    }
                } else if (!isNetDrawable) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The net is too large to be loaded and drawn in the GUI", "Error", 0));
                }
            }
        } else {
            if ((this.lens != null && this.lens.isColored() || this.model.isColored()) && result != null && result.errorMessage().contains("Only weight=1")) {
                String[] names;
                String[] split1 = result.errorMessage().split("between ", 2);
                Object message = "The unfolding of this colored net created an unfolded P/T that contains weights on arcs.\nThe verification of such a net is not supported by the continuous timed engine verifytapn.";
                if (split1.length > 1 && (names = split1[1].split(" and | ", 2)) != null && names.length > 1) {
                    String place = names[0];
                    String transition = names[1].strip();
                    message = (String)message + "\nThe arc between" + place + " and " + transition + " is causing that the unfolded net is weighted.";
                }
                message = (String)message + "\n\nThe problem can be also caused by the presence of an inhibitor arc.";
                this.messenger.displayInfoMessage((String)message, "Could not verify the query");
                return false;
            }
            String extraInformation = "";
            if (result != null && (result.errorMessage().contains("relocation") || result.errorMessage().toLowerCase().contains("internet connection is required for activation"))) {
                extraInformation = "We detected an error that often arises when UPPAAL is missing a valid Licence file.\nOpen the UPPAAL GUI while connected to the internet to correct this problem.";
            }
            String message = "An error occurred during the verification." + System.getProperty("line.separator") + System.getProperty("line.separator");
            if (!extraInformation.equals("")) {
                message = message + extraInformation + System.getProperty("line.separator") + System.getProperty("line.separator");
            }
            message = message + "Model checker output:\n" + result.errorMessage();
            this.messenger.displayWrappedErrorMessage(message, "Error during verification");
        }
        return false;
    }

    private String toHTML(String string) {
        return "<html>" + string.replace(System.getProperty("line.separator"), "<br/>") + "</html>";
    }

    private int displayStats(JPanel panel, String stats, String[] explanations, int startOffset) {
        String[] statsStrings = stats.split(System.getProperty("line.separator"));
        for (int i = 0; i < statsStrings.length; ++i) {
            GridBagConstraints gbc = GridBagHelper.as(i / 4, i % 4 + startOffset, GridBagHelper.Anchor.WEST, new Insets(0, i >= 4 ? 10 : 0, 0, 0));
            JLabel statLabel = new JLabel(statsStrings[i]);
            if (explanations.length > i) {
                statLabel.setToolTipText(explanations[i]);
            }
            panel.add((Component)statLabel, gbc);
        }
        return startOffset + statsStrings.length;
    }

    private JPanel createRawQueryPanel(String rawOutput) {
        final JPanel fullPanel = new JPanel(new GridBagLayout());
        JTextArea rawQueryLabel = new JTextArea(rawOutput);
        rawQueryLabel.setEditable(false);
        JScrollPane scroll = new JScrollPane(rawQueryLabel);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setPreferredSize(new Dimension(640, 400));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        fullPanel.add((Component)scroll, gbc);
        fullPanel.addHierarchyListener(new HierarchyListener(){
            final /* synthetic */ RunVerification this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Window window = SwingUtilities.getWindowAncestor(fullPanel);
                if (window instanceof Dialog) {
                    Dialog dialog = (Dialog)window;
                    dialog.setMinimumSize(dialog.getPreferredSize());
                    if (!dialog.isResizable()) {
                        dialog.setResizable(true);
                    }
                }
            }
        });
        return fullPanel;
    }

    private JPanel createMessagePanel(VerificationResult<TAPNNetworkTrace> result) {
        JPanel panel = new JPanel(new GridBagLayout());
        if (result.getQueryResult().isSMC()) {
            return new SMCResultPanel(result);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 15, 0);
        gbc.anchor = 17;
        panel.add((Component)new JLabel(this.toHTML(result.getResultString())), gbc);
        if (result.getBound() != -1 && result.getBound() < result.getQueryResult().boundednessAnalysis().usedTokens() && !result.getQueryResult().toString().toLowerCase().contains("only markings with")) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            panel.add((Component)new JLabel("<html><br/><br/>Only markings with at most " + result.getBound() + " tokens were explored<br/><br/></html>"), gbc);
        }
        boolean isCTLQuery = result.getQueryResult().isCTL;
        int rowOffset = 1;
        JButton showRawQueryButton = null;
        if (this.modelChecker.supportsStats() && !result.isSolvedUsingQuerySimplification() && !isCTLQuery) {
            rowOffset = this.displayStats(panel, result.getStatsAsString(), this.modelChecker.getStatsExplanations(), 1);
            if (!result.getTransitionStatistics().isEmpty()) {
                if (!result.getTransitionStatistics().isEmpty()) {
                    JButton transitionStatsButton = new JButton("Transition Statistics");
                    transitionStatsButton.addActionListener(arg0 -> JOptionPane.showMessageDialog(panel, StatisticsPanel.createPanel(result, true), "Transition Statistics", 1));
                    gbc = GridBagHelper.as(0, 4, GridBagHelper.Anchor.WEST, new Insets(10, 0, 10, 0));
                    panel.add((Component)transitionStatsButton, gbc);
                }
                if (!result.getPlaceBoundStatistics().isEmpty()) {
                    JButton placeStatsButton = new JButton("Place-Bound Statistics");
                    placeStatsButton.addActionListener(arg0 -> JOptionPane.showMessageDialog(panel, StatisticsPanel.createPanel(result, false), "Place-Bound Statistics", 1));
                    gbc = GridBagHelper.as(1, 4, GridBagHelper.Anchor.WEST, new Insets(10, 0, 10, 0));
                    panel.add((Component)placeStatsButton, gbc);
                }
            }
            if (result.getRawOutput() != null) {
                showRawQueryButton = new JButton("Show raw query results");
                showRawQueryButton.addActionListener(arg0 -> JOptionPane.showMessageDialog(panel, this.createRawQueryPanel(result.getRawOutput()), "Raw query results", 1));
                gbc = GridBagHelper.as(1, 5, GridBagHelper.Anchor.WEST, new Insets(0, 0, 10, 0));
                panel.add((Component)showRawQueryButton, gbc);
            }
            if (!result.getReductionResultAsString().isEmpty()) {
                JLabel reductionStatsLabel = new JLabel(this.toHTML(result.getReductionResultAsString()));
                gbc = GridBagHelper.as(0, 6, GridBagHelper.Anchor.WEST, new Insets(0, 0, 10, -90));
                panel.add((Component)reductionStatsLabel, gbc);
                if (result.reductionRulesApplied()) {
                    JButton openReducedButton = new JButton("Open reduced net");
                    openReducedButton.addActionListener(e -> {
                        openReducedButton.setEnabled(false);
                        this.reducedNetOpened = true;
                        File reducedNetFile = new File(this.reducedNetFilePath);
                        if (reducedNetFile.exists() && reducedNetFile.isFile() && reducedNetFile.canRead()) {
                            try {
                                PetriNetTab reducedNetTab = PetriNetTab.createNewTabFromPNMLFile(reducedNetFile);
                                if (reducedNetTab.currentTemplate().guiModel().getPlaces().length > 0 || reducedNetTab.currentTemplate().guiModel().getTransitions().length > 0) {
                                    reducedNetTab.setInitialName("reduced-" + TAPAALGUI.getAppGui().getCurrentTabName());
                                    TAPNQuery convertedQuery = this.dataLayerQuery.convertPropertyForReducedNet(reducedNetTab.currentTemplate().toString());
                                    reducedNetTab.addQuery(convertedQuery);
                                    TAPAALGUI.openNewTabFromStream(reducedNetTab);
                                }
                            }
                            catch (Exception e1) {
                                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), e1.getMessage(), "Error loading reduced net file", 0);
                            }
                        }
                    });
                    gbc = GridBagHelper.as(0, 5, GridBagHelper.Anchor.WEST, new Insets(0, 0, 10, 0));
                    panel.add((Component)openReducedButton, gbc);
                }
                if (!result.getPlaceBoundStatistics().isEmpty()) {
                    JButton placeStatsButton = new JButton("Place-Bound Statistics");
                    placeStatsButton.addActionListener(arg0 -> JOptionPane.showMessageDialog(panel, StatisticsPanel.createPanel(result, false), "Place-Bound Statistics", 1));
                    gbc = GridBagHelper.as(1, 4, GridBagHelper.Anchor.WEST, new Insets(10, 0, 10, 0));
                    panel.add((Component)placeStatsButton, gbc);
                }
            }
            rowOffset = 6;
        } else if (this.modelChecker.supportsStats() && !result.isSolvedUsingQuerySimplification() && isCTLQuery) {
            rowOffset = this.displayStats(panel, result.getCTLStatsAsString(), this.modelChecker.getStatsExplanations(), 1);
            if (result.getRawOutput() != null) {
                showRawQueryButton = new JButton("Show raw query results");
                showRawQueryButton.addActionListener(arg0 -> JOptionPane.showMessageDialog(panel, this.createRawQueryPanel(result.getRawOutput()), "Raw query results", 1));
                gbc = GridBagHelper.as(1, rowOffset + 1, GridBagHelper.Anchor.WEST, new Insets(0, 0, 10, 0));
                panel.add((Component)showRawQueryButton, gbc);
            }
        }
        if (result.isResolvedUsingSkeletonPreprocessor()) {
            gbc = GridBagHelper.as(0, rowOffset + 2, GridBagHelper.Anchor.WEST, new Insets(0, 0, 15, 0));
            gbc.gridwidth = 2;
            panel.add((Component)new JLabel(this.toHTML("The query was answered by Skeleton Analysis preprocessing.")), gbc);
        }
        gbc = GridBagHelper.as(0, rowOffset + 3, GridBagHelper.Anchor.WEST, new Insets(0, 0, 15, 0));
        gbc.gridwidth = 2;
        if (result.isSolvedUsingQuerySimplification()) {
            panel.add((Component)new JLabel(this.toHTML("The query was resolved using Query Simplification.")), gbc);
        } else if (result.isSolvedUsingTraceAbstractRefinement()) {
            panel.add((Component)new JLabel(this.toHTML("The query was resolved using Trace Abstraction Refinement.")), gbc);
        } else if (result.isSolvedUsingSiphonTrap()) {
            panel.add((Component)new JLabel(this.toHTML("The query was resolved using Siphon Trap.")), gbc);
        }
        if (showRawQueryButton == null && result.getRawOutput() != null) {
            showRawQueryButton = new JButton("Show raw query results");
            showRawQueryButton.addActionListener(arg0 -> JOptionPane.showMessageDialog(panel, this.createRawQueryPanel(result.getRawOutput()), "Raw query results", 1));
            gbc = GridBagHelper.as(1, ++rowOffset + 3, GridBagHelper.Anchor.WEST, new Insets(0, 0, 10, 0));
            panel.add((Component)showRawQueryButton, gbc);
        }
        gbc = GridBagHelper.as(0, rowOffset + 4, GridBagHelper.Anchor.WEST);
        gbc.gridwidth = 2;
        panel.add((Component)new JLabel(result.getVerificationTimeString()), gbc);
        gbc = GridBagHelper.as(0, rowOffset + 5, GridBagHelper.Anchor.WEST);
        gbc.gridwidth = 2;
        panel.add((Component)new JLabel("Estimated memory usage: " + MemoryMonitor.getPeakMemory()), gbc);
        QueryResult queryResult = result.getQueryResult();
        if ((queryResult.hasDeadlock() && queryResult.queryType() == QueryType.EF && !queryResult.isQuerySatisfied() || queryResult.hasDeadlock() && queryResult.queryType() == QueryType.AG && queryResult.isQuerySatisfied() || queryResult.queryType() == QueryType.EG && !queryResult.isQuerySatisfied() || queryResult.queryType() == QueryType.AF && queryResult.isQuerySatisfied()) && this.modelChecker.useDiscreteSemantics()) {
            gbc = GridBagHelper.as(0, rowOffset + 8, GridBagHelper.Anchor.WEST);
            gbc.gridwidth = 2;
            panel.add((Component)new JLabel("<html><font color=red>The verification answer is guaranteed for<br/>the discrete semantics only (integer delays).</font></html>"), gbc);
        }
        return panel;
    }
}

