/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.verification;

import dk.aau.cs.Messenger;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.verification.Boundedness;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.VerificationResult;
import dk.aau.cs.verification.VerifyTAPN.VerifyPN;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import net.tapaal.gui.petrinet.verification.RunVerificationBase;
import net.tapaal.resourcemanager.ResourceManager;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.dataLayer.DataLayer;

public class RunKBoundAnalysis
extends RunVerificationBase {
    private final JSpinner spinner;
    private final boolean resultShown;

    public RunKBoundAnalysis(ModelChecker modelChecker, Messenger messenger, HashMap<TimedArcPetriNet, DataLayer> guiModels, JSpinner spinner, boolean resultShown) {
        super(modelChecker, messenger, null, "", false, spinner);
        this.spinner = spinner;
        this.resultShown = resultShown;
        this.guiModels = guiModels;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean showResult(VerificationResult<TAPNNetworkTrace> result) {
        if (result != null && !result.error()) {
            if (result.getBound() != -1 && result.getQueryResult().boundednessAnalysis().usedTokens() > result.getBound() || !result.getQueryResult().boundednessAnalysis().boundednessResult().equals((Object)Boundedness.Bounded)) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), this.getAnswerNotBoundedString(), "Analysis Result", 1);
                return false;
            }
            if (this.modelChecker instanceof VerifyPN && !this.resultShown) {
                Object[] options = new Object[]{"Ok", "Minimize extra tokens"};
                int answer = JOptionPane.showOptionDialog(TAPAALGUI.getApp(), this.getPNAnswerBoundedString(), "Analysis Result,", 2, 1, ResourceManager.satisfiedIcon(), options, 0);
                if (answer != 0 && result.getRawOutput().contains("max tokens:")) {
                    this.spinner.setValue(result.getQueryResult().boundednessAnalysis().usedTokens() - result.getQueryResult().boundednessAnalysis().tokensInNet());
                    return false;
                }
                if (answer == 0) return false;
                return true;
            }
            if (this.modelChecker instanceof VerifyPN) {
                this.spinner.setValue(result.getQueryResult().boundednessAnalysis().usedTokens() - result.getQueryResult().boundednessAnalysis().tokensInNet());
                return false;
            }
            this.spinner.setValue(result.getQueryResult().boundednessAnalysis().usedTokens() - result.getQueryResult().boundednessAnalysis().tokensInNet());
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), this.getAnswerBoundedString(), "Analysis Result", 1, ResourceManager.satisfiedIcon());
            return false;
        }
        String message = "An error occurred during the verification." + System.getProperty("line.separator") + System.getProperty("line.separator");
        message = message + "Model checker output:\n" + result.errorMessage();
        this.messenger.displayWrappedErrorMessage(message, "Error during verification");
        return false;
    }

    protected String getAnswerNotBoundedString() {
        return "The net with the specified extra number of tokens is either unbounded or\nmore extra tokens have to be added in order to achieve an exact analysis.\n\nThis means that the analysis using the currently selected number \nof extra tokens provides only an under-approximation of the net behaviour.\nIf you think that the net is bounded, try to add more extra tokens in order\nto achieve exact verification analysis.\n";
    }

    protected String getAnswerBoundedString() {
        return "The net with the specified extra number of tokens is bounded.\n\nThis means that the analysis will be exact and always give \nthe correct answer.\n\nThe number of extra tokens was automatically lowered to the\nminimum number of tokens needed for an exact analysis.";
    }

    protected String getPNAnswerBoundedString() {
        return "The net with the specified extra number of tokens is bounded.\n\nThis means that the analysis will be exact and always give \nthe correct answer.\n\nThe number of extra tokens can be lowered to the minimum number\nof tokens needed for an exact analysis.";
    }
}

