/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.verification;

import dk.aau.cs.Messenger;
import dk.aau.cs.TCTL.AritmeticOperator;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.TCTLAtomicPropositionNode;
import dk.aau.cs.TCTL.TCTLConstNode;
import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.TCTL.TCTLTermListNode;
import dk.aau.cs.TCTL.TCTLTrueNode;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.VerifyTAPN.ModelReduction;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPNOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyPNOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOptions;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JSpinner;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.verification.RunKBoundAnalysis;
import net.tapaal.gui.petrinet.verification.RunningVerificationDialog;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.dataLayer.DataLayer;

public class KBoundAnalyzer {
    protected final TimedArcPetriNetNetwork tapnNetwork;
    protected final int k;
    private final TAPNLens lens;
    private final ModelChecker modelChecker;
    private final Messenger messenger;
    private final JSpinner spinner;
    private final HashMap<TimedArcPetriNet, DataLayer> guiModels;
    private final TAPNQuery dataLayerQuery;
    private boolean useRawVerification = false;
    private String rawVerificationPrompt = "";

    public KBoundAnalyzer(TimedArcPetriNetNetwork tapnNetwork, TAPNLens lens, HashMap<TimedArcPetriNet, DataLayer> guiModels, int k, ModelChecker modelChecker, Messenger messenger, JSpinner tokensControl, TAPNQuery query) {
        this.lens = lens;
        this.k = k;
        this.tapnNetwork = tapnNetwork;
        this.modelChecker = modelChecker;
        this.messenger = messenger;
        this.guiModels = guiModels;
        this.spinner = tokensControl;
        this.dataLayerQuery = query;
        if (this.dataLayerQuery != null) {
            this.useRawVerification = this.dataLayerQuery.getRawVerification();
            this.rawVerificationPrompt = this.dataLayerQuery.getRawVerificationPrompt();
        }
    }

    public void analyze() {
        this.analyze(this.verificationOptions(), false);
    }

    public void analyze(VerifyTAPNOptions options, boolean resultShown) {
        dk.aau.cs.model.tapn.TAPNQuery query = this.modelChecker instanceof VerifyPN ? this.getPNBoundednessQuery() : this.getBoundednessQuery();
        RunKBoundAnalysis analyzer = new RunKBoundAnalysis(this.modelChecker, this.messenger, this.guiModels, this.spinner, resultShown);
        RunningVerificationDialog dialog = new RunningVerificationDialog(TAPAALGUI.getApp(), analyzer);
        analyzer.execute(options, this.tapnNetwork, query, this.dataLayerQuery);
        dialog.setVisible(true);
    }

    protected VerifyTAPNOptions verificationOptions() {
        if (this.modelChecker instanceof VerifyPN) {
            return new VerifyPNOptions(this.k, TAPNQuery.TraceOption.NONE, TAPNQuery.SearchOption.BFS, false, ModelReduction.BOUNDPRESERVING, false, false, 1, TAPNQuery.QueryCategory.CTL, TAPNQuery.AlgorithmOption.CERTAIN_ZERO, false, TAPNQuery.QueryReductionTime.NoTime, false, null, false, true, this.tapnNetwork.isColored(), false, true, true, true, this.useRawVerification, this.rawVerificationPrompt);
        }
        if (this.modelChecker instanceof VerifyTAPN) {
            return new VerifyTAPNOptions(this.k, TAPNQuery.TraceOption.NONE, TAPNQuery.SearchOption.BFS, true, false, true, false, false, 1, this.dataLayerQuery.getRawVerification(), this.dataLayerQuery.getRawVerificationPrompt());
        }
        if (this.modelChecker instanceof VerifyDTAPN) {
            boolean gcd = !this.lens.isGame() && !this.lens.isStochastic();
            boolean dart = !this.tapnNetwork.hasUrgentTransitions() && !this.lens.isGame() && !this.lens.isStochastic();
            return new VerifyDTAPNOptions(true, this.k, TAPNQuery.TraceOption.NONE, TAPNQuery.SearchOption.BFS, true, gcd, dart, true, false, false, 1, false, true, true, this.tapnNetwork.isColored(), this.useRawVerification, this.rawVerificationPrompt);
        }
        return null;
    }

    protected dk.aau.cs.model.tapn.TAPNQuery getBoundednessQuery() {
        TCTLAGNode property = new TCTLAGNode(new TCTLTrueNode());
        return new dk.aau.cs.model.tapn.TAPNQuery(property, this.k);
    }

    protected dk.aau.cs.model.tapn.TAPNQuery getPNBoundednessQuery() {
        int totalTokens = this.k + this.tapnNetwork.marking().size();
        TCTLAtomicPropositionNode child = new TCTLAtomicPropositionNode(new TCTLTermListNode(this.getFactors()), "<=", new TCTLConstNode(totalTokens));
        TCTLAGNode property = new TCTLAGNode(child);
        dk.aau.cs.model.tapn.TAPNQuery query = new dk.aau.cs.model.tapn.TAPNQuery(property, this.k);
        this.dataLayerQuery.setCategory(TAPNQuery.QueryCategory.CTL);
        return query;
    }

    private ArrayList<TCTLAbstractStateProperty> getFactors() {
        TimedArcPetriNet net = this.mergeNetComponents();
        ArrayList<TCTLAbstractStateProperty> factors = new ArrayList<TCTLAbstractStateProperty>();
        this.tapnNetwork.sharedPlaces().forEach(o -> {
            if (net.getPlaceByName(o.name()) != null && !net.getPlaceByName(o.name()).name().contains("Shared_")) {
                net.getPlaceByName(o.name()).setName("Shared_" + o.name());
            }
        });
        this.tapnNetwork.allTemplates().forEach(o -> o.places().forEach(x -> {
            if (net.getPlaceByName(x.name()) != null) {
                net.getPlaceByName(x.name()).setName(o.name() + "_" + x.name());
            }
        }));
        for (TimedPlace place : net.places()) {
            factors.add(new TCTLPlaceNode(place.name()));
            factors.add(new AritmeticOperator("+"));
        }
        if (factors.get(factors.size() - 1) instanceof AritmeticOperator) {
            factors.remove(factors.size() - 1);
        }
        return factors;
    }

    private TimedArcPetriNet mergeNetComponents() {
        HashMap<TimedArcPetriNet, DataLayer> guiModels = this.guiModels;
        HashMap<TimedArcPetriNet, DataLayer> updatedModels = new HashMap<TimedArcPetriNet, DataLayer>();
        for (TimedArcPetriNet net : guiModels.keySet()) {
            if (this.tapnNetwork.getTAPNByName(net.name()) != null) {
                DataLayer dl = guiModels.get(net);
                updatedModels.put(this.tapnNetwork.getTAPNByName(net.name()), dl);
                continue;
            }
            updatedModels.put(net, guiModels.get(net));
        }
        TAPNComposer composer = new TAPNComposer(new MessengerImpl(), updatedModels, null, true, true);
        Tuple<TimedArcPetriNet, NameMapping> transformedModel = composer.transformModel(this.tapnNetwork);
        return transformedModel.value1();
    }
}

