/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo.manualEdit;

import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import net.tapaal.gui.petrinet.editor.ConstantsPane;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.undo.manualEdit.NetworkState;
import pipe.gui.TAPAALGUI;

public class EditConstantsCommand
implements Command {
    private final NetworkState oldState;
    private final NetworkState newState;
    private final TimedArcPetriNetNetwork network;
    private final ConstantsPane.ColorTypesListModel colorTypesListModel;
    private final ConstantsPane.VariablesListModel variablesListModel;

    public EditConstantsCommand(NetworkState oldState, TimedArcPetriNetNetwork network, ConstantsPane.ColorTypesListModel colorTypesListModel, ConstantsPane.VariablesListModel variablesListModel) {
        this.oldState = oldState;
        this.newState = new NetworkState(network);
        this.network = network;
        this.colorTypesListModel = colorTypesListModel;
        this.variablesListModel = variablesListModel;
    }

    @Override
    public void undo() {
        this.network.getConstantStore().clear();
        this.network.setConstants(this.oldState.getConstants());
        this.network.setColorTypes(this.oldState.getColorTypes());
        this.network.setVariables(this.oldState.getVariables());
        TAPAALGUI.getCurrentTab().updateConstantsList();
        this.colorTypesListModel.updateName();
        this.variablesListModel.updateName();
    }

    @Override
    public void redo() {
        this.network.getConstantStore().clear();
        this.network.setConstants(this.newState.getConstants());
        this.network.setColorTypes(this.newState.getColorTypes());
        this.network.setVariables(this.newState.getVariables());
        TAPAALGUI.getCurrentTab().updateConstantsList();
        this.colorTypesListModel.updateName();
        this.variablesListModel.updateName();
    }
}

