/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantStore;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.TAPAALGUI;

public class UpdateConstantEditCommand
implements Command {
    private final Constant newConstant;
    private final ConstantStore store;
    private final Constant oldConstant;
    private final TimedArcPetriNetNetwork model;

    public UpdateConstantEditCommand(Constant oldConstant, Constant newConstant, ConstantStore store, TimedArcPetriNetNetwork model) {
        this.oldConstant = oldConstant;
        this.newConstant = newConstant;
        this.store = store;
        this.model = model;
    }

    @Override
    public void redo() {
        this.store.remove(this.oldConstant);
        this.store.add(this.newConstant);
        this.model.updateGuardsAndWeightsWithNewConstant(this.oldConstant.name(), this.newConstant);
        TAPAALGUI.getCurrentTab().updateConstantsList();
    }

    @Override
    public void undo() {
        this.store.remove(this.newConstant);
        this.store.add(this.oldConstant);
        this.model.updateGuardsAndWeightsWithNewConstant(this.newConstant.name(), this.oldConstant);
        TAPAALGUI.getCurrentTab().updateConstantsList();
    }
}

