/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.TCTL.visitors.RenameTransitionTCTLVisitor;
import dk.aau.cs.model.tapn.TimedTransition;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.petrinet.PetriNetTab;

public class RenameTimedTransitionCommand
implements Command {
    private final TimedTransition transition;
    private final String oldName;
    private final String newName;
    private final PetriNetTab tabContent;

    public RenameTimedTransitionCommand(PetriNetTab tabContent, TimedTransition transition, String oldName, String newName) {
        this.tabContent = tabContent;
        this.transition = transition;
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public void redo() {
        this.transition.setName(this.newName);
        this.updateQueries(this.oldName, this.newName);
    }

    @Override
    public void undo() {
        this.transition.setName(this.oldName);
        this.updateQueries(this.newName, this.oldName);
    }

    private void updateQueries(String nameToFind, String nameToInsert) {
        RenameTransitionTCTLVisitor renameVisitor = new RenameTransitionTCTLVisitor(nameToFind, nameToInsert);
        for (TAPNQuery q : this.tabContent.queries()) {
            q.getProperty().accept(renameVisitor, null);
        }
    }
}

