/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.TCTL.visitors.RenamePlaceTCTLVisitor;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.petrinet.PetriNetTab;

public class RenameTimedPlaceCommand
implements Command {
    private final LocalTimedPlace place;
    private final String oldName;
    private final String newName;
    private final PetriNetTab tabContent;

    public RenameTimedPlaceCommand(PetriNetTab tabContent, LocalTimedPlace place, String oldName, String newName) {
        this.tabContent = tabContent;
        this.place = place;
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public void redo() {
        this.place.setName(this.newName);
        this.updateQueries(this.oldName, this.newName);
    }

    @Override
    public void undo() {
        this.place.setName(this.oldName);
        this.updateQueries(this.newName, this.oldName);
    }

    private void updateQueries(String nameToFind, String nameToInsert) {
        RenamePlaceTCTLVisitor renameVisitor = new RenamePlaceTCTLVisitor(nameToFind, nameToInsert);
        for (TAPNQuery q : this.tabContent.queries()) {
            q.getProperty().accept(renameVisitor, null);
        }
    }
}

