/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.TCTL.visitors.RenameSharedTransitionVisitor;
import dk.aau.cs.model.tapn.SharedTransition;
import net.tapaal.gui.petrinet.editor.SharedPlacesAndTransitionsPanel;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.petrinet.PetriNetTab;

public class RenameSharedTransitionCommand
implements Command {
    private final SharedTransition transition;
    private final String oldName;
    private final String newName;
    private final PetriNetTab tab;
    private final SharedPlacesAndTransitionsPanel.SharedTransitionsListModel listModel;

    public RenameSharedTransitionCommand(SharedTransition transition, PetriNetTab tab, String oldName, String name, SharedPlacesAndTransitionsPanel.SharedTransitionsListModel listModel) {
        this.transition = transition;
        this.oldName = oldName;
        this.newName = name;
        this.tab = tab;
        this.listModel = listModel;
    }

    @Override
    public void redo() {
        this.transition.setName(this.newName);
        this.listModel.updatedName();
        this.updateQueries(this.oldName, this.newName);
    }

    private void updateQueries(String nameToFind, String nameToReplaceWith) {
        for (TAPNQuery query : this.tab.queries()) {
            query.getProperty().accept(new RenameSharedTransitionVisitor(nameToFind, nameToReplaceWith), null);
        }
    }

    @Override
    public void undo() {
        this.transition.setName(this.oldName);
        this.listModel.updatedName();
        this.updateQueries(this.newName, this.oldName);
    }
}

