/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.TCTL.visitors.RenameSharedPlaceVisitor;
import dk.aau.cs.model.tapn.SharedPlace;
import net.tapaal.gui.petrinet.editor.SharedPlacesAndTransitionsPanel;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.petrinet.PetriNetTab;

public class RenameSharedPlaceCommand
implements Command {
    private final SharedPlace place;
    private final String oldName;
    private final String newName;
    private final PetriNetTab tab;
    private final SharedPlacesAndTransitionsPanel.SharedPlacesListModel listModel;

    public RenameSharedPlaceCommand(SharedPlace place, SharedPlacesAndTransitionsPanel.SharedPlacesListModel model, PetriNetTab tab, String oldName, String newName) {
        this.place = place;
        this.listModel = model;
        this.tab = tab;
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public void redo() {
        this.place.setName(this.newName);
        this.updateQueries(this.oldName, this.newName);
        this.listModel.updatedName();
    }

    private void updateQueries(String nameToFind, String nameToReplaceWith) {
        for (TAPNQuery query : this.tab.queries()) {
            query.getProperty().accept(new RenameSharedPlaceVisitor(nameToFind, nameToReplaceWith), null);
        }
    }

    @Override
    public void undo() {
        this.place.setName(this.oldName);
        this.updateQueries(this.newName, this.oldName);
        this.listModel.updatedName();
    }
}

