/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import java.awt.Point;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.canvas.DrawingSurfaceImpl;
import pipe.gui.canvas.Grid;
import pipe.gui.petrinet.graphicElements.PetriNetObject;

public class MovePetriNetObjectCommand
implements Command {
    private final int newY;
    private final int newX;
    private final PetriNetObject objectToBeMoved;
    private final int oldY;
    private final int oldX;
    private final DrawingSurfaceImpl canvas;

    public MovePetriNetObjectCommand(PetriNetObject object, Point point, DrawingSurfaceImpl canvas) {
        this.objectToBeMoved = object;
        this.newX = point.x;
        this.newY = point.y;
        this.oldY = this.objectToBeMoved.getOriginalY();
        this.oldX = this.objectToBeMoved.getOriginalX();
        this.canvas = canvas;
    }

    @Override
    public void undo() {
        Grid.disableGrid();
        this.objectToBeMoved.setOriginalX(this.oldX);
        this.objectToBeMoved.setOriginalY(this.oldY);
        Grid.enableGrid();
        this.objectToBeMoved.updateOnMoveOrZoom();
        this.objectToBeMoved.repaint();
        this.canvas.updatePreferredSize();
    }

    @Override
    public void redo() {
        Grid.disableGrid();
        this.objectToBeMoved.setOriginalX(this.newX);
        this.objectToBeMoved.setOriginalY(this.newY);
        Grid.enableGrid();
        this.objectToBeMoved.updateOnMoveOrZoom();
        this.objectToBeMoved.repaint();
        this.canvas.updatePreferredSize();
    }
}

