/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.widgets.SidePane;

public class MoveElementUpCommand
implements Command {
    final int oldIndex;
    final int newIndex;
    final SidePane sidePane;

    public MoveElementUpCommand(SidePane sidePane, int oldIndex, int newIndex) {
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.sidePane = sidePane;
    }

    @Override
    public void redo() {
        if (this.sidePane.getJList().getSelectedIndex() == this.oldIndex) {
            this.sidePane.moveUp(this.oldIndex);
            this.sidePane.getJList().setSelectedIndex(this.oldIndex - 1);
            this.sidePane.getJList().ensureIndexIsVisible(this.oldIndex - 1);
        } else if (this.sidePane.getJList().getSelectedIndex() == this.oldIndex - 1) {
            this.sidePane.moveUp(this.oldIndex);
            this.sidePane.getJList().setSelectedIndex(this.newIndex + 1);
            this.sidePane.getJList().ensureIndexIsVisible(this.newIndex + 1);
        } else {
            this.sidePane.moveUp(this.oldIndex);
        }
        this.sidePane.getJList().updateUI();
    }

    @Override
    public void undo() {
        if (this.sidePane.getJList().getSelectedIndex() == this.newIndex) {
            this.sidePane.moveDown(this.newIndex);
            this.sidePane.getJList().setSelectedIndex(this.newIndex + 1);
            this.sidePane.getJList().ensureIndexIsVisible(this.newIndex + 1);
        } else if (this.sidePane.getJList().getSelectedIndex() == this.newIndex + 1) {
            this.sidePane.moveDown(this.newIndex);
            this.sidePane.getJList().setSelectedIndex(this.oldIndex - 1);
            this.sidePane.getJList().ensureIndexIsVisible(this.oldIndex - 1);
        } else {
            this.sidePane.moveDown(this.newIndex);
        }
        this.sidePane.getJList().updateUI();
    }
}

