/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.widgets.SidePane;

public class MoveElementDownCommand
implements Command {
    final int oldIndex;
    final int newIndex;
    final SidePane sidePane;

    public MoveElementDownCommand(SidePane sidePane, int oldIndex, int newIndex) {
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.sidePane = sidePane;
    }

    @Override
    public void redo() {
        if (this.sidePane.getJList().getSelectedIndex() == this.oldIndex) {
            this.sidePane.moveDown(this.oldIndex);
            this.sidePane.getJList().setSelectedIndex(this.oldIndex + 1);
        } else if (this.sidePane.getJList().getSelectedIndex() == this.oldIndex + 1) {
            this.sidePane.moveDown(this.oldIndex);
            this.sidePane.getJList().setSelectedIndex(this.newIndex - 1);
        } else {
            this.sidePane.moveDown(this.oldIndex);
        }
        this.sidePane.getJList().updateUI();
    }

    @Override
    public void undo() {
        if (this.sidePane.getJList().getSelectedIndex() == this.newIndex) {
            this.sidePane.moveUp(this.newIndex);
            this.sidePane.getJList().setSelectedIndex(this.newIndex - 1);
        } else if (this.sidePane.getJList().getSelectedIndex() == this.newIndex - 1) {
            this.sidePane.moveUp(this.newIndex);
            this.sidePane.getJList().setSelectedIndex(this.oldIndex + 1);
        } else {
            this.sidePane.moveUp(this.newIndex);
        }
        this.sidePane.getJList().updateUI();
    }
}

