/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedTransition;
import net.tapaal.gui.petrinet.editor.SharedPlacesAndTransitionsPanel;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.petrinet.PetriNetTab;

public class MakeTransitionNewSharedCommand
implements Command {
    private SharedTransition sharedTransition = null;
    private final TimedTransition timedTransition;
    private final String newName;
    private final String oldName;
    private final TimedArcPetriNet tapn;
    private final SharedPlacesAndTransitionsPanel sharedPanel;
    private final boolean multiShare;

    public MakeTransitionNewSharedCommand(TimedArcPetriNet tapn, String newName, TimedTransition timedTransition, PetriNetTab tabContent, boolean multiShare) {
        this.tapn = tapn;
        this.timedTransition = timedTransition;
        this.newName = newName;
        this.oldName = timedTransition.name();
        this.sharedPanel = tabContent.getSharedPlacesAndTransitionsPanel();
        this.multiShare = multiShare;
    }

    @Override
    public void redo() {
        this.tapn.remove(this.timedTransition);
        if (this.sharedTransition == null) {
            this.sharedTransition = new SharedTransition(this.newName);
        }
        this.sharedPanel.addSharedTransition(this.sharedTransition, this.multiShare);
        this.sharedTransition.makeShared(this.timedTransition);
        this.tapn.add(this.timedTransition);
    }

    @Override
    public void undo() {
        this.tapn.add(this.timedTransition);
        if (this.sharedTransition != null) {
            this.sharedPanel.removeSharedTransition(this.sharedTransition);
        }
        this.timedTransition.unshare();
        this.timedTransition.setName(this.oldName);
    }
}

