/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.TCTL.visitors.BooleanResult;
import dk.aau.cs.TCTL.visitors.MakePlaceSharedVisitor;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.util.Require;
import java.util.Hashtable;
import java.util.List;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;

public class MakePlaceSharedCommand
implements Command {
    private final SharedPlace sharedPlace;
    private final TimedPlace place;
    private final TimedArcPetriNet tapn;
    private final TimedPlaceComponent placeComponent;
    private final boolean multishare;
    private final Hashtable<TAPNQuery, TAPNQuery> newQueryToOldQueryMapping;
    private final List<TimedToken> oldTokens;
    private final PetriNetTab currentTab;

    public MakePlaceSharedCommand(TimedArcPetriNet tapn, SharedPlace sharedPlace, TimedPlace place, TimedPlaceComponent placeComponent, PetriNetTab currentTab, boolean multishare) {
        Require.that(tapn != null, "tapn cannot be null");
        Require.that(sharedPlace != null, "sharedPlace cannot be null");
        Require.that(place != null, "timedPlace cannot be null");
        Require.that(placeComponent != null, "placeComponent cannot be null");
        Require.that(currentTab != null, "currentTab cannot be null");
        this.tapn = tapn;
        this.sharedPlace = sharedPlace;
        this.place = place;
        this.placeComponent = placeComponent;
        this.multishare = multishare;
        this.oldTokens = place.tokens();
        this.currentTab = currentTab;
        this.newQueryToOldQueryMapping = new Hashtable();
    }

    public MakePlaceSharedCommand(TimedArcPetriNet tapn, SharedPlace sharedPlace, TimedPlace place, TimedPlaceComponent placeComponent, PetriNetTab currentTab) {
        this(tapn, sharedPlace, place, placeComponent, currentTab, false);
    }

    @Override
    public void redo() {
        this.updateArcs(this.place, this.sharedPlace);
        this.tapn.remove(this.place);
        this.tapn.add(this.sharedPlace, this.multishare);
        this.placeComponent.setUnderlyingPlace(this.sharedPlace);
        this.updateQueries(this.place, this.sharedPlace);
    }

    @Override
    public void undo() {
        this.updateArcs(this.sharedPlace, this.place);
        this.tapn.remove(this.sharedPlace);
        this.tapn.add(this.place, this.multishare);
        this.place.addTokens(this.oldTokens);
        this.placeComponent.setUnderlyingPlace(this.place);
        this.undoQueryChanges(this.sharedPlace, this.place);
    }

    private void updateArcs(TimedPlace toReplace, TimedPlace replacement) {
        for (TimedInputArc timedInputArc : this.tapn.inputArcs()) {
            if (!timedInputArc.source().equals(toReplace)) continue;
            timedInputArc.setSource(replacement);
            replacement.addInputArc(timedInputArc);
        }
        for (TimedInhibitorArc timedInhibitorArc : this.tapn.inhibitorArcs()) {
            if (!timedInhibitorArc.source().equals(toReplace)) continue;
            timedInhibitorArc.setSource(replacement);
            replacement.addInhibitorArc(timedInhibitorArc);
        }
        for (TransportArc transportArc : this.tapn.transportArcs()) {
            if (transportArc.source().equals(toReplace)) {
                transportArc.setSource(replacement);
                replacement.addTransportArc(transportArc);
            }
            if (!transportArc.destination().equals(toReplace)) continue;
            transportArc.setDestination(replacement);
            replacement.addTransportArc(transportArc);
        }
        for (TimedOutputArc timedOutputArc : this.tapn.outputArcs()) {
            if (!timedOutputArc.destination().equals(toReplace)) continue;
            timedOutputArc.setDestination(replacement);
            replacement.addOutputArc(timedOutputArc);
        }
    }

    private void updateQueries(TimedPlace toReplace, TimedPlace replacement) {
        MakePlaceSharedVisitor visitor = new MakePlaceSharedVisitor(toReplace.isShared() ? "" : this.tapn.name(), toReplace.name(), replacement.isShared() ? "" : this.tapn.name(), replacement.name());
        for (TAPNQuery query : this.currentTab.queries()) {
            TAPNQuery oldCopy = query.copy();
            BooleanResult isQueryAffected = new BooleanResult(false);
            query.getProperty().accept(visitor, isQueryAffected);
            if (!isQueryAffected.result()) continue;
            this.newQueryToOldQueryMapping.put(query, oldCopy);
        }
    }

    private void undoQueryChanges(SharedPlace toReplace, TimedPlace replacement) {
        for (TAPNQuery query : this.currentTab.queries()) {
            if (!this.newQueryToOldQueryMapping.containsKey(query)) continue;
            query.set(this.newQueryToOldQueryMapping.get(query));
        }
        this.newQueryToOldQueryMapping.clear();
    }
}

