/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.undo;

import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import java.util.ArrayList;
import java.util.List;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.undo.TAPNElementCommand;

public class DeleteTimedPlaceCommand
extends TAPNElementCommand {
    private final TimedPlaceComponent timedPlaceComponent;
    private final TimedPlace timedPlace;
    private final List<TimedToken> tokens;
    private final ArrayList<TAPNQuery> queriesInclusion = new ArrayList();

    public DeleteTimedPlaceCommand(TimedPlaceComponent timedPlaceComponent, TimedArcPetriNet tapn, DataLayer guiModel) {
        super(tapn, guiModel);
        this.timedPlaceComponent = timedPlaceComponent;
        this.tokens = timedPlaceComponent.underlyingPlace().tokens();
        this.timedPlace = timedPlaceComponent.underlyingPlace();
        Iterable<TAPNQuery> queries = TAPAALGUI.getCurrentTab().queries();
        for (TAPNQuery q : queries) {
            if (!q.inclusionPlaces().inclusionPlaces().contains(this.timedPlace)) continue;
            this.queriesInclusion.add(q);
        }
    }

    @Override
    public void redo() {
        for (TAPNQuery q : this.queriesInclusion) {
            q.inclusionPlaces().removePlace(this.timedPlace);
        }
        this.tapn.remove(this.timedPlace);
        this.guiModel.removePetriNetObject(this.timedPlaceComponent);
    }

    @Override
    public void undo() {
        this.timedPlaceComponent.deselect();
        this.guiModel.addPetriNetObject(this.timedPlaceComponent);
        this.tapn.add(this.timedPlace);
        if (!this.timedPlace.isShared()) {
            for (TimedToken token : this.tokens) {
                this.tapn.addToken(token);
            }
        }
        for (TAPNQuery q : this.queriesInclusion) {
            q.inclusionPlaces().inclusionPlaces().add(this.timedPlace);
        }
    }
}

