/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.smartdraw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import net.tapaal.gui.petrinet.smartdraw.SmartDrawListener;
import net.tapaal.gui.petrinet.smartdraw.SmartDrawWorker;
import net.tapaal.resourcemanager.ResourceManager;
import net.tapaal.swinghelpers.CustomJSpinner;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.PetriNetObject;

public class SmartDrawDialog
extends JDialog {
    private final PetriNetTab tab;
    JPanel mainPanel;
    String startingObject = "Random";
    final JComboBox<String> objectDropdown = new JComboBox();
    JCheckBox randomStartObjectCheckBox;
    JDialog loadingDialogFrame;
    SmartDrawWorker worker;
    final JLabel timerLabel = new JLabel("Time elapsed: ");
    final JLabel progressLabel = new JLabel("Objects placed: ");
    JLabel statusLabel;
    JSpinner xSpinner;
    JButton drawButton;
    long startTimeMs;
    int xSpacing = 80;
    int ySpacing = 80;
    String searchOption = "DFS";
    int straightWeight = 5;
    int diagonalWeight = 8;
    int distanceWeight = 10;
    int overlappingArcWeight = 100;
    int minimumIterations = 3;
    private final Timer timer = new Timer(1000, new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SmartDrawDialog.this.timerLabel.setText("Time elapsed: " + (System.currentTimeMillis() - SmartDrawDialog.this.startTimeMs) / 1000L + " s");
        }
    });

    private static String getHelpMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<b>Automatic net layout options</b><br/>");
        buffer.append("<br/><br/>");
        buffer.append("<b>Search Option</b><br/>\n");
        buffer.append("You can choose between drawing in a Depth First (DFS) or a Breadth First (BFS)\n");
        buffer.append("manner. This may yield a difference as an object is only place once and thus\n");
        buffer.append("reserves its given position. This choice affects which objects are placed first.\n");
        buffer.append("<br/><br/>");
        buffer.append("<b>Functionality</b><br/>");
        buffer.append("The automatic layout works by choosing a starting object.\n");
        buffer.append("From there we try different positions around the starting object and choose the position with lowest <em>penalty</em>.\n");
        buffer.append("<br/><br/>");
        buffer.append("We try each multiple of x-spacing between <em>parent.x + x-spacing * layer</em> and \n");
        buffer.append("<em>parent.x - x-spacing * layer</em> with each multiple of y-spacing\n");
        buffer.append("between <em>y-spacing * layer</em> and <em>-y-spacing * layer</em>.\n");
        buffer.append("The value of <em>layer</em> will increment with each iteration and start with value 1.\n");
        buffer.append("As such choosing the minimum iterations will decide how many layers we try.\n");
        buffer.append("Minimum Iterations heavily affects how long it will take to do the layout, so a small number is recommended.\n");
        buffer.append("It is also recommended that x-spacing = y-spacing.\n");
        buffer.append("<br/><br/>");
        buffer.append("<b>Penalties</b><br/>");
        buffer.append("The penalties should be seen as punishments for choosing a position.\n");
        buffer.append("The higher the penalty the higher the punishment; the position with the lowest\n");
        buffer.append("accumulated penalty is where the object will be placed.");
        buffer.append("<br/><br/>");
        buffer.append("<em>Straight arc penalty</em> is a penalty punishing going straight\n");
        buffer.append("i.e. if the candidate position's x or y equals the parent's x or y,\n");
        buffer.append("the <em>straight penalty * layer</em> is added to the total penalty.\n");
        buffer.append("If not, <em>Diagonal arc penalty * layer</em> is added instead.");
        buffer.append("<br/><br/>");
        buffer.append("<em>Distance penalty</em> punishes candidate positions depending on\n");
        buffer.append("how far away from the starting point they are. As such a higher\n");
        buffer.append("distance penalty will make more compact nets.");
        buffer.append("<br/><br/>");
        buffer.append("<em>Overlapping arc penalty</em> punishes arcs laying directly on top of each other.");
        buffer.append("<br/><br/>");
        buffer.append("<b>Example:</b><br/>");
        buffer.append("<br/><br/>");
        buffer.append("<img src=\"" + String.valueOf(Thread.currentThread().getContextClassLoader().getResource("Images/SmartDrawExampleWithLayers.png")) + "\" />");
        buffer.append("<br/><br/>");
        buffer.append("This layout was created with the default values.\n");
        buffer.append("On the figure the numbers and boxes describe the layer. Furthermore, the effect of the <em>Overlapping arc penalty</em> can be seen\n");
        buffer.append("as the objects in layer 2 prefer going diagonal rather than overlap due to the penalties.");
        buffer.append("</html>");
        return buffer.toString();
    }

    public static void showSmartDrawDialog() {
        SmartDrawDialog smartDrawDialog = new SmartDrawDialog((Frame)TAPAALGUI.getApp(), "Smart Draw", true, TAPAALGUI.getCurrentTab());
        smartDrawDialog.pack();
        smartDrawDialog.setPreferredSize(smartDrawDialog.getSize());
        smartDrawDialog.setMinimumSize(new Dimension(smartDrawDialog.getWidth(), smartDrawDialog.getHeight()));
        smartDrawDialog.setLocationRelativeTo(null);
        smartDrawDialog.setResizable(false);
        smartDrawDialog.updateLists();
        smartDrawDialog.enableButtons();
        smartDrawDialog.setEnabled(true);
        smartDrawDialog.setVisible(true);
    }

    private SmartDrawDialog(Frame frame, String title, boolean modal, PetriNetTab tab) {
        super(frame, title, modal);
        this.tab = tab;
        this.initComponents();
    }

    private void updateLists() {
        this.objectDropdown.removeAllItems();
        for (String name : this.getObjectNames()) {
            this.objectDropdown.addItem(name);
        }
    }

    public static void setupWorkerListener(SwingWorker<?, ?> worker) {
        if (worker != null) {
            worker.addPropertyChangeListener(event -> {
                int dialogResult;
                SwingWorker.StateValue stateValue;
                if (event.getPropertyName().equals("unfolding") && (stateValue = (SwingWorker.StateValue)((Object)((Object)event.getNewValue()))).equals((Object)SwingWorker.StateValue.DONE) && !TAPAALGUI.getCurrentTab().currentTemplate().getHasPositionalInfo() && TAPAALGUI.getCurrentTab().currentTemplate().guiModel().getPlaces().length + TAPAALGUI.getCurrentTab().currentTemplate().guiModel().getTransitions().length > 0 && (dialogResult = JOptionPane.showConfirmDialog(null, "The net does not have any layout information. Would you like to do automatic layout?", "Automatic Layout?", 0)) == 0) {
                    SmartDrawDialog.showSmartDrawDialog();
                }
            });
        }
    }

    private void initComponents() {
        this.setLayout(new FlowLayout());
        this.mainPanel = new JPanel(new GridBagLayout());
        this.initSpacingSelecters();
        this.initCheckBoxes();
        this.initAdvancedOptionsPanel();
        JButton helpButton = new JButton("Help");
        helpButton.setToolTipText("Help with the different options");
        helpButton.addActionListener(e -> JOptionPane.showMessageDialog(TAPAALGUI.getApp(), this.getMessageComponent(), "Help", 1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 16;
        this.mainPanel.add((Component)helpButton, gbc);
        this.drawButton = new JButton("Smart Draw");
        this.drawButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataLayer model = SmartDrawDialog.this.tab.drawingSurface().getGuiModel();
                final int modelSize = model.getPlaceTransitionObjects().size();
                SmartDrawDialog.this.initLoadingFrame();
                SmartDrawDialog.this.worker = new SmartDrawWorker(SmartDrawDialog.this.tab.drawingSurface(), model, SmartDrawDialog.this.tab.getUndoManager(), SmartDrawDialog.this.xSpacing, SmartDrawDialog.this.ySpacing, SmartDrawDialog.this.searchOption, SmartDrawDialog.this.straightWeight, SmartDrawDialog.this.diagonalWeight, SmartDrawDialog.this.distanceWeight, SmartDrawDialog.this.overlappingArcWeight, SmartDrawDialog.this.startingObject, SmartDrawDialog.this.minimumIterations);
                SmartDrawDialog.this.worker.addSmartDrawListener(new SmartDrawListener(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void fireStatusChanged(int objectsPlaced) {
                        this.this$1.SmartDrawDialog.this.progressLabel.setText("Objects placed: " + objectsPlaced + "/" + (modelSize - 1));
                    }

                    @Override
                    public void fireStartDraw() {
                        this.this$1.SmartDrawDialog.this.statusLabel.setText("Working...");
                        if (this.this$1.SmartDrawDialog.this.timer.isRunning()) {
                            this.this$1.SmartDrawDialog.this.timer.restart();
                        } else {
                            this.this$1.SmartDrawDialog.this.timer.start();
                        }
                        this.this$1.SmartDrawDialog.this.startTimeMs = System.currentTimeMillis();
                    }

                    @Override
                    public void fireDone(boolean cancelled) {
                        if (!cancelled) {
                            this.this$1.SmartDrawDialog.this.loadingDialogFrame.dispose();
                            TAPAALGUI.getAppGui().toFront();
                            TAPAALGUI.getAppGui().requestFocus();
                        } else {
                            this.this$1.SmartDrawDialog.this.statusLabel.setText("Cancelling/Undoing");
                        }
                    }
                });
                SmartDrawDialog.this.worker.execute();
                SmartDrawDialog.this.setVisible(false);
                SmartDrawDialog.this.loadingDialogFrame.setVisible(true);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 14;
        this.mainPanel.add((Component)this.drawButton, gbc);
        this.getRootPane().setDefaultButton(this.drawButton);
        this.drawButton.requestFocus();
        int extraWidth = 100;
        Dimension preferredSize = this.mainPanel.getPreferredSize();
        int preferredWidth = preferredSize.width + extraWidth;
        int preferredHeight = preferredSize.height;
        Dimension newPreferredSize = new Dimension(preferredWidth, preferredHeight);
        this.mainPanel.setPreferredSize(newPreferredSize);
        JScrollPane scrollPane = new JScrollPane(this.mainPanel);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setBorder(null);
        this.setContentPane(scrollPane);
    }

    private void initAdvancedOptionsPanel() {
        JPanel advancedOptionsPanel = new JPanel(new GridBagLayout());
        advancedOptionsPanel.setBorder(new TitledBorder("Advanced Options"));
        JLabel comboBoxLabel = new JLabel("Choose Initial Object:");
        comboBoxLabel.setToolTipText("Choose a starting object");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)comboBoxLabel, gbc);
        this.objectDropdown.setEnabled(false);
        this.objectDropdown.setToolTipText("Choose a starting object");
        this.objectDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SmartDrawDialog.this.objectDropdown.getSelectedItem() != null && SmartDrawDialog.this.objectDropdown.isEnabled()) {
                    SmartDrawDialog.this.startingObject = SmartDrawDialog.this.objectDropdown.getSelectedItem().toString();
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add(this.objectDropdown, gbc);
        this.randomStartObjectCheckBox = new JCheckBox("Random Initial Object:", true);
        this.randomStartObjectCheckBox.setHorizontalTextPosition(2);
        this.randomStartObjectCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SmartDrawDialog.this.randomStartObjectCheckBox.isSelected()) {
                    SmartDrawDialog.this.startingObject = "Random";
                    SmartDrawDialog.this.objectDropdown.setEnabled(false);
                } else {
                    SmartDrawDialog.this.objectDropdown.setEnabled(true);
                    SmartDrawDialog.this.startingObject = SmartDrawDialog.this.objectDropdown.getSelectedItem().toString();
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)this.randomStartObjectCheckBox, gbc);
        JLabel straightWeightLabel = new JLabel("Straight Arc Penalty:");
        straightWeightLabel.setToolTipText("Higher number decreases the number of horizontal and vertical arcs");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)straightWeightLabel, gbc);
        CustomJSpinner straightWeightSpinner = new CustomJSpinner(this.straightWeight);
        straightWeightSpinner.setToolTipText("Higher number decreases the number of horizontal and vertical arcs");
        straightWeightSpinner.addChangeListener(e -> {
            this.straightWeight = (Integer)straightWeightSpinner.getValue();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)straightWeightSpinner, gbc);
        JLabel diagonalWeightLabel = new JLabel("Diagonal Arc Penalty:");
        diagonalWeightLabel.setToolTipText("Higher number decreases the number of diagonal arcs");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)diagonalWeightLabel, gbc);
        CustomJSpinner diagonalWeightSpinner = new CustomJSpinner(this.diagonalWeight);
        diagonalWeightSpinner.setToolTipText("Higher number decreases the number of diagonal arcs");
        diagonalWeightSpinner.addChangeListener(e -> {
            this.diagonalWeight = (Integer)diagonalWeightSpinner.getValue();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)diagonalWeightSpinner, gbc);
        JLabel distanceWeightLabel = new JLabel("Distance Penalty:");
        distanceWeightLabel.setToolTipText("Higher penalty will make the layout more compact");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)distanceWeightLabel, gbc);
        CustomJSpinner distanceWeightSpinner = new CustomJSpinner(this.distanceWeight);
        distanceWeightSpinner.setToolTipText("Higher penalty will make the layout more compact");
        distanceWeightSpinner.addChangeListener(e -> {
            this.distanceWeight = (Integer)distanceWeightSpinner.getValue();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)distanceWeightSpinner, gbc);
        JLabel overlappingWeightLabel = new JLabel("Overlapping Arc Penalty:");
        overlappingWeightLabel.setToolTipText("Higher penalty will decrease the number of arcs that cross other objects");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)overlappingWeightLabel, gbc);
        CustomJSpinner overlappingWeightSpinner = new CustomJSpinner(this.overlappingArcWeight);
        overlappingWeightSpinner.setToolTipText("Higher penalty will decrease the number of arcs that cross other objects");
        overlappingWeightSpinner.addChangeListener(e -> {
            this.overlappingArcWeight = (Integer)overlappingWeightSpinner.getValue();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)overlappingWeightSpinner, gbc);
        JLabel minimumIterationsLabel = new JLabel("Minimum Iterations:");
        minimumIterationsLabel.setToolTipText("Higher number increases the number of positions tried for each object");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)minimumIterationsLabel, gbc);
        CustomJSpinner minimumIterationSpinner = new CustomJSpinner(this.minimumIterations);
        minimumIterationSpinner.setToolTipText("Higher number increases the number of positions tried for each object");
        minimumIterationSpinner.addChangeListener(e -> {
            this.minimumIterations = (Integer)minimumIterationSpinner.getValue();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        advancedOptionsPanel.add((Component)minimumIterationSpinner, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 3;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        this.mainPanel.add((Component)advancedOptionsPanel, gbc);
    }

    private void initCheckBoxes() {
        JPanel checkBoxPanel = new JPanel(new GridBagLayout());
        checkBoxPanel.setBorder(new TitledBorder("Search Option"));
        JRadioButton DFS = new JRadioButton("DFS:");
        DFS.setToolTipText("Draw in a depth first manner from start object");
        DFS.addActionListener(e -> {
            this.searchOption = "DFS";
        });
        JRadioButton BFS = new JRadioButton("BFS:");
        BFS.setToolTipText("Draw in a breadth first manner from start object");
        BFS.addActionListener(e -> {
            this.searchOption = "BFS";
        });
        ButtonGroup group = new ButtonGroup();
        group.add(DFS);
        group.add(BFS);
        DFS.setSelected(true);
        DFS.setHorizontalTextPosition(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        checkBoxPanel.add((Component)DFS, gbc);
        BFS.setHorizontalTextPosition(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        checkBoxPanel.add((Component)BFS, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        this.mainPanel.add((Component)checkBoxPanel, gbc);
    }

    private void initSpacingSelecters() {
        JPanel spacingPanel = new JPanel(new GridBagLayout());
        spacingPanel.setBorder(new TitledBorder("Spacing"));
        JLabel xLabel = new JLabel("Spacing on the x-axis:");
        xLabel.setToolTipText("Set the distance there should be between objects on the x-axis");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 0);
        gbc.anchor = 18;
        spacingPanel.add((Component)xLabel, gbc);
        this.xSpinner = new CustomJSpinner(this.xSpacing);
        this.xSpinner.setToolTipText("Set the distance there should be between objects on the x-axis");
        this.xSpinner.addChangeListener(e -> {
            this.xSpacing = (Integer)this.xSpinner.getValue();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 10, 10);
        gbc.anchor = 18;
        spacingPanel.add((Component)this.xSpinner, gbc);
        JLabel yLabel = new JLabel("Spacing on the y-axis:");
        yLabel.setToolTipText("Set the distance there should be between objects on the y-axis");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 0);
        gbc.anchor = 18;
        spacingPanel.add((Component)yLabel, gbc);
        CustomJSpinner ySpinner = new CustomJSpinner(this.ySpacing);
        ySpinner.setToolTipText("Set the distance there should be between objects on the y-axis");
        ySpinner.addChangeListener(e -> {
            this.ySpacing = (Integer)ySpinner.getValue();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 10, 10);
        gbc.anchor = 18;
        spacingPanel.add((Component)ySpinner, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 10, 0);
        gbc.anchor = 18;
        this.mainPanel.add((Component)spacingPanel, gbc);
    }

    private String[] getObjectNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (PetriNetObject object : this.tab.drawingSurface().getGuiModel().getPlaceTransitionObjects()) {
            names.add(object.getName());
        }
        return (String[])Arrays.copyOf(names.toArray(), names.toArray().length, String[].class);
    }

    private void initLoadingFrame() {
        this.loadingDialogFrame = new JDialog(TAPAALGUI.getApp(), "Working...", true);
        this.loadingDialogFrame.setLayout(new GridBagLayout());
        ImageIcon loadingGIF = ResourceManager.getIcon("ajax-loader.gif");
        JLabel workingLabel = new JLabel("<html><div style='text-align: center;'>Currently doing layout...<br/>This may take several minutes depending on the size of the net...</div></html>", 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 11;
        this.loadingDialogFrame.add((Component)workingLabel, gbc);
        this.statusLabel = new JLabel("Working... ", loadingGIF, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 11;
        this.loadingDialogFrame.add((Component)this.statusLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 0, 0);
        gbc.anchor = 11;
        this.loadingDialogFrame.add((Component)this.timerLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 0, 0);
        gbc.anchor = 11;
        this.loadingDialogFrame.add((Component)this.progressLabel, gbc);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmartDrawDialog.this.cancelWorker();
                SmartDrawDialog.this.tab.getUndoManager().undo();
                SmartDrawDialog.this.tab.drawingSurface().repaintAll();
                SmartDrawDialog.this.loadingDialogFrame.setVisible(false);
                TAPAALGUI.getAppGui().toFront();
                TAPAALGUI.getAppGui().requestFocus();
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 11;
        this.loadingDialogFrame.add((Component)cancelButton, gbc);
        this.loadingDialogFrame.setDefaultCloseOperation(0);
        this.loadingDialogFrame.setSize(400, 300);
        this.loadingDialogFrame.setVisible(false);
        this.loadingDialogFrame.setLocationRelativeTo(TAPAALGUI.getApp());
        this.loadingDialogFrame.pack();
        this.loadingDialogFrame.setAlwaysOnTop(false);
        this.loadingDialogFrame.setAutoRequestFocus(false);
    }

    private Object getMessageComponent() {
        JTextPane pane = new JTextPane();
        pane.setContentType("text/html");
        pane.setText(SmartDrawDialog.getHelpMessage());
        pane.setEditable(false);
        pane.setCaretPosition(0);
        for (MouseListener listener : pane.getMouseListeners()) {
            pane.removeMouseListener(listener);
        }
        Dimension dim = new Dimension(500, 400);
        pane.setPreferredSize(dim);
        pane.setMargin(new Insets(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(pane);
        scrollPane.setPreferredSize(dim);
        return scrollPane;
    }

    private void cancelWorker() {
        if (this.worker != null && !this.worker.isDone()) {
            boolean cancelled = false;
            while (!(cancelled = this.worker.cancel(true))) {
            }
        }
    }

    private void enableButtons() {
        if (this.tab.drawingSurface().getGuiModel().getPlaceTransitionObjects().size() > 0) {
            this.drawButton.setEnabled(true);
            this.drawButton.setToolTipText("Smart draw with the current options");
            if (!this.randomStartObjectCheckBox.isSelected()) {
                this.objectDropdown.setEnabled(true);
            }
            this.randomStartObjectCheckBox.setEnabled(true);
        } else {
            this.drawButton.setEnabled(false);
            this.drawButton.setToolTipText("You must have at least one object to smart draw");
            this.objectDropdown.setEnabled(false);
            this.randomStartObjectCheckBox.setEnabled(false);
        }
    }
}

