/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.smartdraw;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.tapaal.gui.petrinet.smartdraw.Boundary;

public class Quadtree {
    final int capacity = 4;
    final Boundary boundary;
    final boolean isParent;
    List<Point> points = new ArrayList<Point>();
    Quadtree northWest;
    Quadtree northEast;
    Quadtree southWest;
    Quadtree southEast;

    private Quadtree(Boundary boundary, boolean isParent) {
        this.boundary = boundary;
        this.isParent = isParent;
    }

    public Quadtree(Boundary boundary) {
        this(boundary, true);
    }

    public Quadtree() {
        this(new Boundary(Boundary.DEFAULT_CENTER, 10000));
    }

    public boolean insert(Point point) {
        while (!this.boundary.contains(point)) {
            if (!this.isParent) {
                return false;
            }
            this.resize();
        }
        if (this.points.size() < 4 && this.northWest == null) {
            this.points.add(point);
            return true;
        }
        if (this.northWest == null) {
            this.subdivide();
        }
        if (this.northWest.insert(point)) {
            return true;
        }
        if (this.northEast.insert(point)) {
            return true;
        }
        if (this.southWest.insert(point)) {
            return true;
        }
        return this.southEast.insert(point);
    }

    private void subdivide() {
        Point center = this.boundary.getCenter();
        int halfDimension = this.boundary.getHalfDimension() / 2;
        Boundary northWestBoundary = new Boundary(new Point(center.x - halfDimension, center.y - halfDimension), halfDimension);
        Boundary northEastBoundary = new Boundary(new Point(center.x + halfDimension, center.y - halfDimension), halfDimension);
        Boundary southWestBoundary = new Boundary(new Point(center.x - halfDimension, center.y + halfDimension), halfDimension);
        Boundary southEastBoundary = new Boundary(new Point(center.x + halfDimension, center.y + halfDimension), halfDimension);
        this.northWest = new Quadtree(northWestBoundary, false);
        this.northEast = new Quadtree(northEastBoundary, false);
        this.southWest = new Quadtree(southWestBoundary, false);
        this.southEast = new Quadtree(southEastBoundary, false);
    }

    public List<Point> queryRange(Boundary range) {
        ArrayList<Point> pointsInRange = new ArrayList<Point>();
        if (!this.boundary.intersects(range)) {
            return pointsInRange;
        }
        for (Point point : this.points) {
            if (!range.contains(point)) continue;
            pointsInRange.add(point);
        }
        if (this.northWest == null) {
            return pointsInRange;
        }
        pointsInRange.addAll(this.northWest.queryRange(range));
        pointsInRange.addAll(this.northEast.queryRange(range));
        pointsInRange.addAll(this.southWest.queryRange(range));
        pointsInRange.addAll(this.southEast.queryRange(range));
        return pointsInRange;
    }

    public boolean containsWithin(Point point, int range) {
        if (range < 1) {
            return false;
        }
        Boundary boundaryToCheck = new Boundary(point, range);
        return !this.queryRange(boundaryToCheck).isEmpty();
    }

    public boolean contains(Point point) {
        return this.containsWithin(point, 1);
    }

    private void resize() {
        this.boundary.resize();
        if (this.northWest != null) {
            this.northWest.resize();
            this.northEast.resize();
            this.southWest.resize();
            this.southEast.resize();
        }
        ArrayList<Point> pointsToMove = new ArrayList<Point>();
        for (Point point : this.points) {
            Quadtree quadrant = this.getQuadrantForPoint(point);
            if (quadrant != null && quadrant.contains(point)) continue;
            pointsToMove.add(point);
        }
        this.points.removeAll(pointsToMove);
        for (Point point : pointsToMove) {
            this.insert(point);
        }
    }

    private Quadtree getQuadrantForPoint(Point point) {
        if (point.x < this.boundary.getCenter().x) {
            if (point.y < this.boundary.getCenter().y) {
                return this.northWest;
            }
            return this.southWest;
        }
        if (point.y < this.boundary.getCenter().y) {
            return this.northEast;
        }
        return this.southEast;
    }

    public String toString() {
        return "quadTree[points=" + String.valueOf(this.points) + ", " + String.valueOf(this.boundary) + "]";
    }
}

