/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.smartdraw;

import java.awt.Point;

public class Boundary {
    public static final int DEFAULT_HALF_DIMENSION = 10000;
    public static final Point DEFAULT_CENTER = new Point(0, 0);
    private final Point center;
    private int halfDimension;

    public Boundary(Point center, int halfDimension) {
        this.halfDimension = Math.max(halfDimension, 1);
        this.center = center;
    }

    public void resize() {
        this.halfDimension = this.halfDimension <= 0x3FFFFFFF ? (this.halfDimension *= 2) : Integer.MAX_VALUE;
    }

    public Point getCenter() {
        return this.center;
    }

    public int getHalfDimension() {
        return this.halfDimension;
    }

    public boolean contains(Point point) {
        return Math.abs(this.center.x - point.x) <= this.halfDimension && Math.abs(this.center.y - point.y) <= this.halfDimension;
    }

    public boolean intersects(Boundary other) {
        return Math.abs(this.center.x - other.center.x) < this.halfDimension + other.halfDimension && Math.abs(this.center.y - other.center.y) < this.halfDimension + other.halfDimension;
    }

    public String toString() {
        return "boundary[center=" + String.valueOf(this.center) + ", halfDimension=" + this.halfDimension + "]";
    }
}

