/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.TCTL.visitors.BooleanResult;
import dk.aau.cs.TCTL.visitors.ContainsPlaceWithDisabledTemplateVisitor;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.Tuple;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.undo.AddTemplateCommand;
import net.tapaal.gui.petrinet.undo.MoveElementDownCommand;
import net.tapaal.gui.petrinet.undo.MoveElementUpCommand;
import net.tapaal.gui.petrinet.undo.RemoveTemplateCommand;
import net.tapaal.gui.petrinet.undo.RenameTemplateCommand;
import net.tapaal.gui.petrinet.undo.SortTemplatesCommand;
import net.tapaal.gui.petrinet.undo.ToggleTemplateActivationCommand;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.widgets.SidePane;
import net.tapaal.gui.swingcomponents.NonsearchableJList;
import net.tapaal.resourcemanager.ResourceManager;
import net.tapaal.swinghelpers.GridBagHelper;
import net.tapaal.swinghelpers.RequestFocusListener;
import net.tapaal.swinghelpers.SwingHelper;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.undo.UndoManager;
import pipe.gui.swingcomponents.EscapableDialog;

public class TemplateExplorer
extends JPanel
implements SidePane {
    private JPanel templatePanel;
    private JScrollPane scrollpane;
    private JList<Template> templateList;
    private DefaultListModel<Template> listModel;
    private JPanel buttonPanel;
    private JButton newTemplateButton;
    private JButton removeTemplateButton;
    private JButton renameButton;
    private JButton copyButton;
    private final PetriNetTab parent;
    private final UndoManager undoManager;
    private boolean isInAnimationMode;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton sortButton;
    private static final String toolTipNewComponent = "Create a new component";
    private static final String toolTipRemoveComponent = "Remove the selected component";
    private static final String toolTipCopyComponent = "Copy the selected component";
    private static final String toolTipRenameComponent = "Rename the selected component";
    private static final String toolTipSortComponents = "Sort the components alphabetically";
    private static final String toolTipMoveUp = "Move the selected component up";
    private static final String toolTipMoveDown = "Move the selected component down";
    private EscapableDialog dialog;
    private JPanel container;
    private JTextField nameTextField;
    private JLabel nameLabel;
    private JPanel buttonContainer;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel nameContainer;

    public TemplateExplorer(PetriNetTab parent) {
        this(parent, false);
    }

    public TemplateExplorer(PetriNetTab parent, boolean hideButtons) {
        this.parent = parent;
        this.undoManager = parent.getUndoManager();
        this.init(hideButtons);
    }

    public void selectPrevious() {
        int index = this.templateList.getSelectedIndex() - 1;
        if (index == -1) {
            index = this.listModel.getSize() - 1;
        }
        this.templateList.setSelectedIndex(index);
    }

    public void selectNext() {
        int index = this.templateList.getSelectedIndex() + 1;
        if (index == this.listModel.size()) {
            index = 0;
        }
        this.templateList.setSelectedIndex(index);
    }

    public Integer indexOfSelectedTemplate() {
        return this.templateList.getSelectedIndex();
    }

    public void restoreSelectedTemplate(Integer value) {
        this.templateList.setSelectedIndex(value);
    }

    private void init(boolean hideButtons) {
        this.setLayout(new BorderLayout());
        this.isInAnimationMode = false;
        this.initExplorerPanel();
        this.initButtonsPanel();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Components"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.setToolTipText("List of components. Click a component to display it.");
        this.addCreatedComponents(hideButtons);
        this.addComponentListener(new ComponentListener(){
            final int minimumHegiht;
            {
                this.minimumHegiht = TemplateExplorer.this.getMinimumSize().height + TemplateExplorer.this.sortButton.getMinimumSize().height;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (!TemplateExplorer.this.isInAnimationMode) {
                    TemplateExplorer.this.sortButton.setVisible(TemplateExplorer.this.getSize().height > this.minimumHegiht);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void addCreatedComponents(boolean hideButtons) {
        this.removeAll();
        if (!hideButtons) {
            this.add((Component)this.templatePanel, "Center");
            this.moveDownButton.setVisible(true);
            this.moveUpButton.setVisible(true);
            this.sortButton.setVisible(true);
            this.add((Component)this.buttonPanel, "Last");
        } else {
            this.add((Component)this.templatePanel, "Center");
            this.moveDownButton.setVisible(false);
            this.moveUpButton.setVisible(false);
            this.sortButton.setVisible(false);
            this.setMinimumSize(null);
        }
    }

    private void initExplorerPanel() {
        this.templatePanel = new JPanel(new GridBagLayout());
        this.listModel = new DefaultListModel();
        for (Template net : this.parent.allTemplates()) {
            this.listModel.addElement(net);
        }
        this.listModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent arg0) {
                TemplateExplorer.this.removeTemplateButton.setEnabled(TemplateExplorer.this.parent.numberOfActiveTemplates() <= 1);
            }

            @Override
            public void intervalAdded(ListDataEvent arg0) {
                TemplateExplorer.this.templateList.setSelectedIndex(arg0.getIndex0());
                TemplateExplorer.this.templateList.ensureIndexIsVisible(arg0.getIndex0());
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
                int index = arg0.getIndex0() == 0 ? 0 : arg0.getIndex0() - 1;
                TemplateExplorer.this.templateList.setSelectedIndex(index);
                TemplateExplorer.this.templateList.ensureIndexIsVisible(index);
            }
        });
        this.templateList = new NonsearchableJList<Template>(this.listModel);
        this.templateList.setSelectionMode(0);
        this.templateList.setSelectedIndex(0);
        this.templateList.setCellRenderer(new TemplateListCellRenderer<Template>(this.templateList.getCellRenderer()));
        TemplateListManager manager = new TemplateListManager(this.templateList);
        this.templateList.addListSelectionListener(manager);
        this.templateList.addMouseListener(manager);
        this.scrollpane = new JScrollPane(this.templateList);
        this.scrollpane.setMinimumSize(new Dimension(this.scrollpane.getMinimumSize().width, this.scrollpane.getMinimumSize().height + 20));
        GridBagConstraints gbc = GridBagHelper.as(0, 0, GridBagHelper.Anchor.NORTHWEST, GridBagHelper.Fill.BOTH);
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.templatePanel.add((Component)this.scrollpane, gbc);
        this.moveUpButton = new JButton(ResourceManager.getIcon("Up.png"));
        this.moveUpButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setToolTipText(toolTipMoveUp);
        this.moveUpButton.addActionListener(e -> {
            int index = this.templateList.getSelectedIndex();
            if (index > 0) {
                MoveElementUpCommand c = new MoveElementUpCommand(this, index, index - 1);
                this.undoManager.addNewEdit(c);
                c.redo();
                this.templateList.ensureIndexIsVisible(index + 1);
                this.templateList.setSelectedIndex(index - 1);
            }
        });
        gbc = GridBagHelper.as(1, 0, GridBagHelper.Anchor.SOUTH);
        this.templatePanel.add((Component)this.moveUpButton, gbc);
        this.moveDownButton = new JButton(ResourceManager.getIcon("Down.png"));
        this.moveDownButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setToolTipText(toolTipMoveDown);
        this.moveDownButton.addActionListener(e -> {
            int index = this.templateList.getSelectedIndex();
            if (index < this.parent.network().allTemplates().size() - 1) {
                MoveElementDownCommand c = new MoveElementDownCommand(this, index, index + 1);
                this.undoManager.addNewEdit(c);
                c.redo();
                this.templateList.ensureIndexIsVisible(index + 1);
                this.templateList.setSelectedIndex(index + 1);
            }
        });
        gbc = GridBagHelper.as(1, 1, GridBagHelper.Anchor.NORTH);
        this.templatePanel.add((Component)this.moveDownButton, gbc);
        this.sortButton = new JButton(ResourceManager.getIcon("Sort.png"));
        this.sortButton.setMargin(new Insets(2, 2, 2, 2));
        this.sortButton.setToolTipText(toolTipSortComponents);
        this.sortButton.setEnabled(false);
        this.sortButton.addActionListener(e -> {
            SortTemplatesCommand command = new SortTemplatesCommand(this.parent, this, this.templateList, this.listModel);
            this.undoManager.addNewEdit(command);
            command.redo();
        });
        gbc = GridBagHelper.as(1, 2, GridBagHelper.Anchor.NORTH, GridBagHelper.Fill.HORIZONTAL);
        this.templatePanel.add((Component)this.sortButton, gbc);
    }

    private void initButtonsPanel() {
        this.buttonPanel = new JPanel(new GridBagLayout());
        Dimension dimension = new Dimension(82, 28);
        this.newTemplateButton = new JButton("New");
        this.newTemplateButton.setEnabled(true);
        this.newTemplateButton.setPreferredSize(dimension);
        this.newTemplateButton.setToolTipText(toolTipNewComponent);
        this.newTemplateButton.addActionListener(arg0 -> this.ShowNewTemplateDialog(""));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        this.buttonPanel.add((Component)this.newTemplateButton, gbc);
        this.removeTemplateButton = new JButton("Remove");
        this.removeTemplateButton.setEnabled(false);
        this.removeTemplateButton.setPreferredSize(dimension);
        this.removeTemplateButton.setToolTipText(toolTipRemoveComponent);
        this.removeTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = TemplateExplorer.this.templateList.getSelectedIndex();
                Template template = TemplateExplorer.this.selectedModel();
                HashSet<TAPNQuery> queriesToDelete = this.findQueriesAffectedByRemoval(template);
                int choice = 1;
                if (!queriesToDelete.isEmpty()) {
                    StringBuilder warning = this.buildWarningMessage(queriesToDelete);
                    choice = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), warning.toString(), "Warning", 0, 3);
                    if (choice == 0) {
                        for (TAPNQuery q : queriesToDelete) {
                            TemplateExplorer.this.parent.removeQuery(q);
                        }
                    }
                }
                if (queriesToDelete.isEmpty() || choice == 0) {
                    ArrayList<Tuple<TimedTransition, SharedTransition>> transitionsToUnshare = new ArrayList<Tuple<TimedTransition, SharedTransition>>();
                    for (TimedTransition transition : template.model().transitions()) {
                        if (!transition.isShared()) continue;
                        transitionsToUnshare.add(new Tuple<TimedTransition, SharedTransition>(transition, transition.sharedTransition()));
                    }
                    RemoveTemplateCommand command = new RemoveTemplateCommand(TemplateExplorer.this.parent, TemplateExplorer.this, template, index, queriesToDelete, transitionsToUnshare);
                    TemplateExplorer.this.undoManager.addNewEdit(command);
                    command.redo();
                }
            }

            private HashSet<TAPNQuery> findQueriesAffectedByRemoval(Template template) {
                Iterable<TAPNQuery> queries = TemplateExplorer.this.parent.queries();
                HashSet<TAPNQuery> queriesToDelete = new HashSet<TAPNQuery>();
                for (TimedPlace p : template.model().places()) {
                    for (TAPNQuery q : queries) {
                        if (!q.getProperty().containsAtomicPropositionWithSpecificPlaceInTemplate(template.model().name(), p.name())) continue;
                        queriesToDelete.add(q);
                    }
                }
                for (TimedTransition t : template.model().transitions()) {
                    for (TAPNQuery q : queries) {
                        if (!q.getProperty().containsAtomicPropositionWithSpecificTransitionInTemplate(template.model().name(), t.name())) continue;
                        queriesToDelete.add(q);
                    }
                }
                return queriesToDelete;
            }

            private StringBuilder buildWarningMessage(HashSet<TAPNQuery> queriesToDelete) {
                StringBuilder s = new StringBuilder();
                s.append("The following queries are associated with the currently selected objects:\n\n");
                for (TAPNQuery q : queriesToDelete) {
                    s.append(q.getName());
                    s.append('\n');
                }
                s.append("\nAre you sure you want to remove the current selection and all associated queries?");
                return s;
            }
        });
        gbc = GridBagHelper.as(0, 1, GridBagHelper.Anchor.WEST);
        this.buttonPanel.add((Component)this.removeTemplateButton, gbc);
        this.renameButton = new JButton("Rename");
        this.renameButton.setEnabled(false);
        this.renameButton.setPreferredSize(dimension);
        this.renameButton.setToolTipText(toolTipRenameComponent);
        this.renameButton.addActionListener(arg0 -> {
            this.showRenameTemplateDialog("");
            this.templateList.validate();
        });
        gbc = GridBagHelper.as(1, 0, GridBagHelper.Anchor.WEST);
        this.buttonPanel.add((Component)this.renameButton, gbc);
        this.copyButton = new JButton("Copy");
        this.copyButton.setEnabled(false);
        this.copyButton.setPreferredSize(dimension);
        this.copyButton.setToolTipText(toolTipCopyComponent);
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Template template = TemplateExplorer.this.selectedModel().copy();
                String name = template.model().name();
                if (TemplateExplorer.this.parent.network().hasTAPNCalled(name)) {
                    int i = 2;
                    while (TemplateExplorer.this.parent.network().hasTAPNCalled(name + i)) {
                        ++i;
                    }
                    template.model().setName(name + i);
                }
                int index = TemplateExplorer.this.listModel.size();
                TemplateExplorer.this.undoManager.addNewEdit(new AddTemplateCommand(TemplateExplorer.this, template, index));
                TemplateExplorer.this.parent.addTemplate(template);
            }
        });
        gbc = GridBagHelper.as(0, 0, GridBagHelper.Anchor.WEST);
        this.buttonPanel.add((Component)this.copyButton, gbc);
    }

    private void onOKRenameTemplate() {
        Template template = this.selectedModel();
        String newName = this.nameTextField.getText().trim();
        if (template.model().name().equals(newName)) {
            this.exit();
            return;
        }
        if (!this.isNameAllowed(newName)) {
            JOptionPane.showMessageDialog(this.parent.drawingSurface(), "Acceptable names for components are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*.\n\nThe component could not be renamed.", "Error Renaming Component", 0);
            this.exit();
            this.showRenameTemplateDialog(newName);
            return;
        }
        if (this.parent.network().hasTAPNCalled(newName) && !template.model().name().equals(newName)) {
            JOptionPane.showMessageDialog(this.parent.drawingSurface(), "A component named \"" + newName + "\" already exists. Try another name.", "Error", 0);
            this.exit();
            this.showRenameTemplateDialog(newName);
            return;
        }
        this.parent.getNameGenerator().updateTemplateIndex(newName);
        RenameTemplateCommand command = new RenameTemplateCommand(this, this.parent, template.model(), template.model().name(), newName);
        this.undoManager.addNewEdit(command);
        command.redo();
        this.exit();
    }

    private void onOK() {
        String templateName = this.nameTextField.getText().trim();
        if (!this.isNameAllowed(templateName)) {
            JOptionPane.showMessageDialog(this.parent.drawingSurface(), "Acceptable names for components are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*\n\nThe new component could not be created.", "Error Creating Component", 0);
            this.exit();
            this.ShowNewTemplateDialog(templateName);
            return;
        }
        if (this.parent.network().hasTAPNCalled(templateName)) {
            JOptionPane.showMessageDialog(this.parent.drawingSurface(), "A component named \"" + templateName + "\" already exists.\n\nThe new component could not be created.", "Error Creating Component", 0);
            this.exit();
            this.ShowNewTemplateDialog(templateName);
            return;
        }
        Template template = this.createNewTemplate(templateName);
        int index = this.listModel.size();
        this.undoManager.addNewEdit(new AddTemplateCommand(this, template, index));
        this.parent.addTemplate(template);
        this.exit();
    }

    private void exit() {
        this.dialog.setVisible(false);
    }

    private void initComponentsOfNewTemplateDialog(String nameToShow) {
        this.container = new JPanel();
        this.container.setLayout(new GridBagLayout());
        this.nameContainer = new JPanel();
        this.nameContainer.setLayout(new GridBagLayout());
        this.nameTextField = new JTextField();
        SwingHelper.setPreferredWidth(this.nameTextField, 330);
        this.nameTextField.setText(nameToShow);
        this.nameTextField.addAncestorListener(new RequestFocusListener());
        this.nameTextField.addActionListener(e -> {
            this.okButton.requestFocusInWindow();
            this.okButton.doClick();
        });
        GridBagConstraints gbc = GridBagHelper.as(0, 1, 1, GridBagHelper.Anchor.WEST, new Insets(4, 4, 2, 4));
        this.nameContainer.add((Component)this.nameTextField, gbc);
        this.nameLabel = new JLabel();
        this.nameLabel.setText("Name of component: ");
        gbc = GridBagHelper.as(0, 0, 1, GridBagHelper.Anchor.WEST, new Insets(4, 4, 2, 4));
        this.nameContainer.add((Component)this.nameLabel, gbc);
        this.buttonContainer = new JPanel();
        this.buttonContainer.setLayout(new GridBagLayout());
        this.okButton = new JButton();
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.setMnemonic(79);
        gbc = GridBagHelper.as(1, 0, GridBagHelper.Anchor.WEST, new Insets(5, 5, 5, 5));
        this.buttonContainer.add((Component)this.okButton, gbc);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(100, 25));
        this.cancelButton.setMinimumSize(new Dimension(100, 25));
        this.cancelButton.setPreferredSize(new Dimension(100, 25));
        this.cancelButton.setMnemonic(67);
        gbc = GridBagHelper.as(0, 0, -1, GridBagHelper.Anchor.EAST);
        this.buttonContainer.add((Component)this.cancelButton, gbc);
        this.okButton.addActionListener(e -> this.onOK());
        this.cancelButton.addActionListener(e -> this.exit());
        gbc = GridBagHelper.as(0, 1, 1, GridBagHelper.Anchor.EAST, new Insets(0, 8, 5, 8));
        this.container.add((Component)this.buttonContainer, gbc);
        gbc = GridBagHelper.as(0, 0, 1, GridBagHelper.Anchor.WEST, new Insets(0, 8, 5, 8));
        this.container.add((Component)this.nameContainer, gbc);
    }

    private void ShowNewTemplateDialog(String nameToShow) {
        this.dialog = new EscapableDialog(TAPAALGUI.getApp(), "Enter Component Name", true);
        this.initComponentsOfNewTemplateDialog(nameToShow);
        JScrollPane scrollPane = new JScrollPane(this.container);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setBorder(null);
        this.dialog.add(scrollPane);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    private boolean isNameAllowed(String templateName) {
        Require.that(templateName != null, "The template name cannot be null");
        return !templateName.isEmpty() && Pattern.matches("[a-zA-Z]([_a-zA-Z0-9])*", templateName);
    }

    private void initComponentsOfRenameTemplateDialog(String oldname) {
        this.nameContainer = new JPanel();
        this.nameContainer.setLayout(new GridBagLayout());
        this.nameTextField = new JTextField();
        SwingHelper.setPreferredWidth(this.nameTextField, 330);
        this.nameTextField.setText(oldname);
        this.nameTextField.addAncestorListener(new RequestFocusListener());
        this.nameTextField.addActionListener(e -> {
            this.okButton.requestFocusInWindow();
            this.okButton.doClick();
        });
        GridBagConstraints gbc = GridBagHelper.as(0, 1, 1, GridBagHelper.Anchor.WEST, new Insets(4, 4, 2, 4));
        this.nameContainer.add((Component)this.nameTextField, gbc);
        this.nameLabel = new JLabel();
        this.nameLabel.setText("Name of component: ");
        gbc = GridBagHelper.as(0, 0, 1, GridBagHelper.Anchor.WEST, new Insets(4, 4, 2, 4));
        this.nameContainer.add((Component)this.nameLabel, gbc);
        this.buttonContainer = new JPanel();
        this.buttonContainer.setLayout(new GridBagLayout());
        this.okButton = new JButton();
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.setMnemonic(79);
        gbc = GridBagHelper.as(1, 0, GridBagHelper.Anchor.WEST, new Insets(5, 5, 5, 5));
        this.buttonContainer.add((Component)this.okButton, gbc);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(100, 25));
        this.cancelButton.setMinimumSize(new Dimension(100, 25));
        this.cancelButton.setPreferredSize(new Dimension(100, 25));
        this.cancelButton.setMnemonic(67);
        gbc = GridBagHelper.as(0, 0, -1, GridBagHelper.Anchor.EAST);
        this.buttonContainer.add((Component)this.cancelButton, gbc);
        this.okButton.addActionListener(e -> this.onOKRenameTemplate());
        this.cancelButton.addActionListener(e -> this.exit());
        this.container = new JPanel();
        this.container.setLayout(new GridBagLayout());
        gbc = GridBagHelper.as(0, 1, 1, GridBagHelper.Anchor.EAST, new Insets(0, 8, 5, 8));
        this.container.add((Component)this.buttonContainer, gbc);
        gbc = GridBagHelper.as(0, 0, 1, GridBagHelper.Anchor.WEST, new Insets(0, 8, 5, 8));
        this.container.add((Component)this.nameContainer, gbc);
    }

    private void showRenameTemplateDialog(String nameToShow) {
        this.dialog = new EscapableDialog(TAPAALGUI.getApp(), "Enter Component Name", true);
        Template template = this.selectedModel();
        if (nameToShow.equals("")) {
            this.initComponentsOfRenameTemplateDialog(template.model().name());
        } else {
            this.initComponentsOfRenameTemplateDialog(nameToShow);
        }
        JScrollPane scrollPane = new JScrollPane(this.container);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setBorder(null);
        this.dialog.add(scrollPane);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    public Template createNewTemplate(String name) {
        TimedArcPetriNet tapn = new TimedArcPetriNet(name);
        return new Template(tapn, new DataLayer(), new Zoomer());
    }

    public void removeTemplate(int index, Template template) {
        this.listModel.removeElement(template);
        this.parent.removeTemplate(template);
        this.templateList.setSelectedIndex(index);
    }

    public void addTemplate(int index, Template template) {
        this.listModel.add(index, template);
        this.parent.addTemplate(template);
    }

    public void openSelectedTemplate() {
        Template tapn = this.selectedModel();
        if (tapn != null) {
            this.parent.changeToTemplate(tapn);
        }
    }

    public Template selectedModel() {
        return this.templateList.getSelectedValue();
    }

    public void selectTemplate(Template template) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (!this.listModel.getElementAt(i).equals(template)) continue;
            this.templateList.setSelectedIndex(i);
            return;
        }
    }

    public void updateTemplateList() {
        int selectedIndex = this.templateList.getSelectedIndex();
        DefaultListModel<Template> newList = new DefaultListModel<Template>();
        if (this.isInAnimationMode) {
            for (Template net : this.parent.activeTemplates()) {
                newList.addElement(net);
            }
        } else {
            for (Template net : this.parent.allTemplates()) {
                newList.addElement(net);
            }
        }
        this.templateList.setSelectedIndex(selectedIndex);
        if (newList.size() != this.listModel.size() || selectedIndex == -1) {
            selectedIndex = newList.size() - 1;
        }
        this.listModel = newList;
        this.templateList.setModel(this.listModel);
        this.templateList.setSelectedIndex(selectedIndex);
    }

    public void selectFirst() {
        this.templateList.setSelectedIndex(0);
    }

    public void hideButtons() {
        this.addCreatedComponents(true);
    }

    public void showButtons() {
        this.addCreatedComponents(false);
    }

    public void switchToAnimationMode() {
        this.hideButtons();
        this.isInAnimationMode = true;
        this.updateTemplateList();
    }

    @Override
    public void moveUp(int index) {
        this.parent.swapTemplates(index, index - 1);
        Template o = this.listModel.getElementAt(index);
        this.listModel.setElementAt(this.listModel.getElementAt(index - 1), index);
        this.listModel.setElementAt(o, index - 1);
    }

    @Override
    public void moveDown(int index) {
        this.parent.swapTemplates(index, index + 1);
        Template o = this.listModel.getElementAt(index);
        this.listModel.setElementAt(this.listModel.getElementAt(index + 1), index);
        this.listModel.setElementAt(o, index + 1);
    }

    @Override
    public JList<Template> getJList() {
        return this.templateList;
    }

    private class TemplateListCellRenderer<T>
    extends JPanel
    implements ListCellRenderer<T> {
        private static final String UNCHECK_TO_DEACTIVATE = "Uncheck to deactive the component";
        private static final String CHECK_TO_ACTIVATE = "Check to active the component";
        private final JCheckBox activeCheckbox = new JCheckBox();
        private final ListCellRenderer<T> cellRenderer;

        public TemplateListCellRenderer(ListCellRenderer<T> renderer) {
            this.cellRenderer = renderer;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.activeCheckbox.setOpaque(false);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = this.cellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.removeAll();
            if (!TemplateExplorer.this.isInAnimationMode) {
                boolean isActive = ((Template)value).isActive();
                this.activeCheckbox.setSelected(isActive);
                this.setToolTipText(isActive ? UNCHECK_TO_DEACTIVATE : CHECK_TO_ACTIVATE);
                this.add((Component)this.activeCheckbox, "West");
            } else {
                this.setToolTipText(null);
            }
            this.add(renderer, "Center");
            return this;
        }
    }

    private class TemplateListManager
    extends MouseAdapter
    implements ListSelectionListener,
    ActionListener {
        private final int checkBoxWidth;
        private final ListSelectionModel selectionModel;
        private final JList<Template> list;

        public TemplateListManager(JList<Template> list) {
            this.checkBoxWidth = new JCheckBox().getPreferredSize().width;
            this.list = list;
            this.selectionModel = list.getSelectionModel();
            this.list.registerKeyboardAction(this, KeyStroke.getKeyStroke(32, 0), 0);
        }

        private void toggleSelection(int index) {
            if (index < 0) {
                return;
            }
            Template item = this.list.getModel().getElementAt(index);
            if (!this.selectionModel.isSelectedIndex(index)) {
                this.selectionModel.addSelectionInterval(index, index);
            }
            boolean newValue = !item.isActive();
            item.setActive(newValue);
            if (TemplateExplorer.this.parent.numberOfActiveTemplates() == 0) {
                item.setActive(!newValue);
                JOptionPane.showMessageDialog(TemplateExplorer.this.parent, "At least one component must be active.", "Cannot Deactive All Components", 1);
            } else {
                TemplateExplorer.this.undoManager.addNewEdit(new ToggleTemplateActivationCommand(TemplateExplorer.this.parent.getTemplateExplorer(), item, newValue));
            }
            if (!TemplateExplorer.this.selectedModel().isActive()) {
                TemplateExplorer.this.removeTemplateButton.setEnabled(true);
            } else {
                TemplateExplorer.this.removeTemplateButton.setEnabled(TemplateExplorer.this.parent.numberOfActiveTemplates() > 1);
            }
            this.toggleAffectedQueries();
            this.list.repaint();
        }

        private void toggleAffectedQueries() {
            for (TAPNQuery query : TemplateExplorer.this.parent.queries()) {
                ContainsPlaceWithDisabledTemplateVisitor visitor = new ContainsPlaceWithDisabledTemplateVisitor(TemplateExplorer.this.parent.network());
                BooleanResult result = new BooleanResult(true);
                query.getProperty().accept(visitor, result);
                if (query.isActive()) {
                    if (result.result()) continue;
                    query.setActive(false);
                    continue;
                }
                if (!result.result()) continue;
                query.setActive(true);
            }
            TemplateExplorer.this.parent.updateQueryList();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index = TemplateExplorer.this.templateList.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            if (e.getX() > TemplateExplorer.this.templateList.getCellBounds((int)index, (int)index).x + this.checkBoxWidth) {
                return;
            }
            if (!TemplateExplorer.this.isInAnimationMode) {
                this.toggleSelection(index);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int index = TemplateExplorer.this.templateList.getSelectedIndex();
                if (index == -1) {
                    TemplateExplorer.this.removeTemplateButton.setEnabled(false);
                    TemplateExplorer.this.renameButton.setEnabled(false);
                    TemplateExplorer.this.copyButton.setEnabled(false);
                    TemplateExplorer.this.moveUpButton.setEnabled(false);
                    TemplateExplorer.this.moveDownButton.setEnabled(false);
                    TemplateExplorer.this.sortButton.setEnabled(false);
                } else {
                    if (TemplateExplorer.this.buttonPanel != null) {
                        if (TemplateExplorer.this.parent.numberOfActiveTemplates() > 1) {
                            TemplateExplorer.this.removeTemplateButton.setEnabled(true);
                        } else {
                            TemplateExplorer.this.removeTemplateButton.setEnabled(!TemplateExplorer.this.selectedModel().isActive());
                        }
                        TemplateExplorer.this.renameButton.setEnabled(true);
                        TemplateExplorer.this.copyButton.setEnabled(true);
                        TemplateExplorer.this.sortButton.setEnabled(TemplateExplorer.this.templateList.getModel().getSize() >= 2);
                        TemplateExplorer.this.moveUpButton.setEnabled(index > 0);
                        TemplateExplorer.this.moveDownButton.setEnabled(index < TemplateExplorer.this.parent.network().allTemplates().size() - 1);
                    }
                    TemplateExplorer.this.templateList.ensureIndexIsVisible(index);
                    TemplateExplorer.this.openSelectedTemplate();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TemplateExplorer.this.isInAnimationMode) {
                this.toggleSelection(this.list.getSelectedIndex());
            }
        }
    }
}

