/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.TCTL.visitors.RenameSharedTransitionVisitor;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.util.RequireException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.NameGenerator;
import net.tapaal.gui.petrinet.editor.SharedPlacesAndTransitionsPanel;
import net.tapaal.gui.petrinet.undo.AddSharedTransitionCommand;
import net.tapaal.gui.petrinet.undo.RenameSharedTransitionCommand;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.swinghelpers.SwingHelper;
import pipe.gui.petrinet.undo.UndoManager;

public class SharedTransitionNamePanel
extends JPanel {
    private final JRootPane rootPane;
    private final SharedPlacesAndTransitionsPanel.SharedTransitionsListModel listModel;
    private JTextField nameField;
    private final SharedTransition transitionToEdit;
    private final UndoManager undoManager;
    private final NameGenerator nameGenerator;
    private final Context context;
    JButton okButton;

    public SharedTransitionNamePanel(JRootPane rootPane, SharedPlacesAndTransitionsPanel.SharedTransitionsListModel sharedTransitionsListModel, UndoManager undoManager, NameGenerator nameGenerator, Context context, SharedTransition transitionToEdit) {
        this.rootPane = rootPane;
        this.listModel = sharedTransitionsListModel;
        this.undoManager = undoManager;
        this.nameGenerator = nameGenerator;
        this.transitionToEdit = transitionToEdit;
        this.context = context;
        this.initComponents();
    }

    public void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel namePanel = this.createNamePanel();
        JPanel buttonPanel = this.createButtonPanel();
        GridBagConstraints gbcNamePanel = new GridBagConstraints();
        gbcNamePanel.insets = new Insets(4, 4, 2, 4);
        gbcNamePanel.gridx = 0;
        gbcNamePanel.gridy = 0;
        gbcNamePanel.gridwidth = 1;
        gbcNamePanel.anchor = 13;
        this.add((Component)namePanel, gbcNamePanel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 8, 5, 8);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        this.add((Component)buttonPanel, gbc);
    }

    private JPanel createNamePanel() {
        JPanel namePanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Enter a shared transition name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 2, 4);
        namePanel.add((Component)label, gbc);
        String initialText = this.transitionToEdit == null ? "" : this.transitionToEdit.name();
        this.nameField = new JTextField(initialText);
        SwingHelper.setPreferredWidth(this.nameField, 330);
        this.nameField.addActionListener(e -> {
            this.okButton.requestFocusInWindow();
            this.okButton.doClick();
        });
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 2, 4);
        namePanel.add((Component)this.nameField, gbc);
        return namePanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.okButton = new JButton("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.setMnemonic(79);
        GridBagConstraints gbcOk = new GridBagConstraints();
        gbcOk.gridx = 1;
        gbcOk.gridy = 0;
        gbcOk.anchor = 17;
        gbcOk.insets = new Insets(5, 5, 5, 5);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String name = SharedTransitionNamePanel.this.nameField.getText();
                if (name == null || name.isEmpty()) {
                    JOptionPane.showMessageDialog(SharedTransitionNamePanel.this, "You must specify a name.", "Error", 0);
                    SharedTransitionNamePanel.this.nameField.requestFocusInWindow();
                    return;
                }
                boolean success = true;
                if (SharedTransitionNamePanel.this.transitionToEdit == null) {
                    success = this.addNewSharedTransition(name);
                } else if (!name.equals(SharedTransitionNamePanel.this.transitionToEdit.name())) {
                    success = this.updateExistingTransition(name);
                }
                if (success) {
                    SharedTransitionNamePanel.this.nameGenerator.updateIndicesForAllModels(name);
                    SharedTransitionNamePanel.this.exit();
                }
            }

            private boolean updateExistingTransition(String name) {
                String oldName = SharedTransitionNamePanel.this.transitionToEdit.name();
                if (SharedTransitionNamePanel.this.transitionToEdit.network().isNameUsed(name) && !oldName.equals(name)) {
                    JOptionPane.showMessageDialog(SharedTransitionNamePanel.this, "The specified name is already used by a place or transition in one of the components.", "Error", 0);
                    SharedTransitionNamePanel.this.nameField.requestFocusInWindow();
                    return false;
                }
                try {
                    SharedTransitionNamePanel.this.transitionToEdit.setName(name);
                }
                catch (RequireException e) {
                    JOptionPane.showMessageDialog(SharedTransitionNamePanel.this, "The specified name is invalid.\nAcceptable names are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*", "Error", 0);
                    SharedTransitionNamePanel.this.nameField.requestFocusInWindow();
                    return false;
                }
                for (TAPNQuery query : SharedTransitionNamePanel.this.context.queries()) {
                    query.getProperty().accept(new RenameSharedTransitionVisitor(oldName, name), null);
                }
                SharedTransitionNamePanel.this.listModel.updatedName();
                SharedTransitionNamePanel.this.undoManager.addNewEdit(new RenameSharedTransitionCommand(SharedTransitionNamePanel.this.transitionToEdit, SharedTransitionNamePanel.this.context.tabContent(), oldName, name, SharedTransitionNamePanel.this.listModel));
                return true;
            }

            private boolean addNewSharedTransition(String name) {
                SharedTransition transition = null;
                try {
                    transition = new SharedTransition(name);
                }
                catch (RequireException e) {
                    JOptionPane.showMessageDialog(SharedTransitionNamePanel.this, "The specified name is invalid.\nAcceptable names are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*", "Error", 0);
                    SharedTransitionNamePanel.this.nameField.requestFocusInWindow();
                    return false;
                }
                try {
                    SharedTransitionNamePanel.this.listModel.addElement(transition);
                }
                catch (RequireException e) {
                    JOptionPane.showMessageDialog(SharedTransitionNamePanel.this, "A transition or place with the specified name already exists.", "Error", 0);
                    SharedTransitionNamePanel.this.nameField.requestFocusInWindow();
                    return false;
                }
                SharedTransitionNamePanel.this.undoManager.addNewEdit(new AddSharedTransitionCommand(SharedTransitionNamePanel.this.listModel, transition));
                return true;
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMaximumSize(new Dimension(100, 25));
        cancelButton.setMinimumSize(new Dimension(100, 25));
        cancelButton.setPreferredSize(new Dimension(100, 25));
        cancelButton.setMnemonic(67);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 13;
        cancelButton.addActionListener(e -> this.exit());
        buttonPanel.add((Component)cancelButton, gbc);
        buttonPanel.add((Component)this.okButton, gbcOk);
        return buttonPanel;
    }

    private void exit() {
        this.rootPane.getParent().setVisible(false);
    }
}

