/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.util.Require;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.NameGenerator;
import net.tapaal.gui.petrinet.editor.DeleteSharedPlaceOrTransitionAction;
import net.tapaal.gui.petrinet.editor.SharedPlaceNamePanel;
import net.tapaal.gui.petrinet.editor.SharedTransitionNamePanel;
import net.tapaal.gui.petrinet.undo.MoveElementDownCommand;
import net.tapaal.gui.petrinet.undo.MoveElementUpCommand;
import net.tapaal.gui.petrinet.undo.SortSharedPlacesCommand;
import net.tapaal.gui.petrinet.undo.SortSharedTransitionsCommand;
import net.tapaal.gui.petrinet.widgets.SidePane;
import net.tapaal.gui.swingcomponents.NonsearchableJList;
import net.tapaal.resourcemanager.ResourceManager;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.undo.UndoManager;
import pipe.gui.swingcomponents.EscapableDialog;

public class SharedPlacesAndTransitionsPanel
extends JPanel
implements SidePane {
    private static final String TRANSITION_IS_USED_MESSAGE = "<html>The shared transition is used in one or more components.<br/>TAPAAL will unshare all transitions under this name,<br/>but leave the transitions in the components.</html>";
    private static final String PLACE_IS_USED_MESSAGE = "<html>The shared place is used in one or more components.<br/>TAPAAL will unshare all places under this name,<br/>but leave the places in the components.</html>";
    private static final String TRANSITIONS = "Transitions";
    private static final String PLACES = "Places";
    private final JList<Object> list = new NonsearchableJList<Object>();
    private final SharedPlacesListModel sharedPlacesListModel;
    private final SharedTransitionsListModel sharedTransitionsListModel;
    private final JComboBox<String> placesTransitionsComboBox = new JComboBox<String>(new String[]{"Places", "Transitions"});
    private final UndoManager undoManager;
    private final NameGenerator nameGenerator;
    private final PetriNetTab tab;
    private final JButton renameButton = new JButton("Rename");
    private final JButton removeButton = new JButton("Remove");
    private final JButton addButton = new JButton("New");
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton sortButton;
    private static final String toolTipNewPlace = "Create a new place";
    private static final String toolTipRemovePlace = "Remove the selected place";
    private static final String toolTipRenamePlace = "Rename the selected place";
    private static final String toolTipSortTransitions = "Sort the shared transitions alphabetically";
    private static final String toolTipSortPlaces = "Sort the shared places alphabetically";
    private static final String toolTipMoveUp = "Move the selected item up";
    private static final String toolTipMoveDown = "Move the selected item down";
    private static final String toolTipNewTransition = "Create a new transition";
    private static final String toolTipRenameTransition = "Rename the selected transition";
    private static final String toolTipRemoveTransition = "Remove the selected transition";
    private static final String toolTipChangeBetweenPlacesAndTransitions = "Switch between shared places and transitions";

    public SharedPlacesAndTransitionsPanel(PetriNetTab tab) {
        Require.that(tab != null, "tab cannot be null");
        this.undoManager = tab.getUndoManager();
        this.nameGenerator = tab.getNameGenerator();
        this.tab = tab;
        this.sharedPlacesListModel = new SharedPlacesListModel(tab.network());
        this.sharedTransitionsListModel = new SharedTransitionsListModel(tab.network());
        this.setLayout(new GridBagLayout());
        this.initComponents();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Shared Places and Transitions"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.setToolTipText("Shared places and transitions define the interface among the different components");
        this.addComponentListener(new ComponentListener(){
            final int minimumHegiht;
            {
                this.minimumHegiht = SharedPlacesAndTransitionsPanel.this.getMinimumSize().height;
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SharedPlacesAndTransitionsPanel.this.sortButton.setVisible(SharedPlacesAndTransitionsPanel.this.getSize().height > this.minimumHegiht);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.setMinimumSize(new Dimension(this.getMinimumSize().width, this.getMinimumSize().height - this.sortButton.getMinimumSize().height));
    }

    public void setNetwork(TimedArcPetriNetNetwork network) {
        this.sharedPlacesListModel.setNetwork(network);
        this.sharedTransitionsListModel.setNetwork(network);
    }

    private void initComponents() {
        JPanel listPanel = new JPanel(new GridBagLayout());
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JList source = (JList)e.getSource();
                    if (source.getSelectedIndex() == -1) {
                        SharedPlacesAndTransitionsPanel.this.removeButton.setEnabled(false);
                        SharedPlacesAndTransitionsPanel.this.renameButton.setEnabled(false);
                    } else {
                        SharedPlacesAndTransitionsPanel.this.removeButton.setEnabled(true);
                        if (SharedPlacesAndTransitionsPanel.this.list.getSelectedIndices().length == 1) {
                            SharedPlacesAndTransitionsPanel.this.renameButton.setEnabled(true);
                        } else {
                            SharedPlacesAndTransitionsPanel.this.renameButton.setEnabled(false);
                        }
                    }
                    int index = SharedPlacesAndTransitionsPanel.this.list.getSelectedIndex();
                    if (index > 0 && SharedPlacesAndTransitionsPanel.this.list.getSelectedIndices().length == 1) {
                        SharedPlacesAndTransitionsPanel.this.moveUpButton.setEnabled(true);
                    } else {
                        SharedPlacesAndTransitionsPanel.this.moveUpButton.setEnabled(false);
                    }
                    if (SharedPlacesAndTransitionsPanel.this.isDisplayingTransitions()) {
                        if (index < SharedPlacesAndTransitionsPanel.this.sharedTransitionsListModel.getSize() - 1 && SharedPlacesAndTransitionsPanel.this.list.getSelectedIndices().length == 1) {
                            SharedPlacesAndTransitionsPanel.this.moveDownButton.setEnabled(true);
                        } else {
                            SharedPlacesAndTransitionsPanel.this.moveDownButton.setEnabled(false);
                        }
                        if (SharedPlacesAndTransitionsPanel.this.sharedTransitionsListModel.getSize() >= 2) {
                            SharedPlacesAndTransitionsPanel.this.sortButton.setEnabled(true);
                        } else {
                            SharedPlacesAndTransitionsPanel.this.sortButton.setEnabled(false);
                        }
                    } else {
                        if (index < SharedPlacesAndTransitionsPanel.this.sharedPlacesListModel.getSize() - 1 && SharedPlacesAndTransitionsPanel.this.list.getSelectedIndices().length == 1) {
                            SharedPlacesAndTransitionsPanel.this.moveDownButton.setEnabled(true);
                        } else {
                            SharedPlacesAndTransitionsPanel.this.moveDownButton.setEnabled(false);
                        }
                        if (SharedPlacesAndTransitionsPanel.this.sharedPlacesListModel.getSize() >= 2) {
                            SharedPlacesAndTransitionsPanel.this.sortButton.setEnabled(true);
                        } else {
                            SharedPlacesAndTransitionsPanel.this.sortButton.setEnabled(false);
                        }
                    }
                }
            }
        });
        this.list.addMouseListener(this.createDoubleClickMouseAdapter());
        JScrollPane scrollPane = new JScrollPane(this.list);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        listPanel.add((Component)scrollPane, gbc);
        this.moveUpButton = new JButton(ResourceManager.getIcon("Up.png"));
        this.moveUpButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setToolTipText(toolTipMoveUp);
        this.moveUpButton.addActionListener(e -> {
            int index = this.list.getSelectedIndex();
            if (index > 0) {
                MoveElementUpCommand c = new MoveElementUpCommand(this, index, index - 1);
                this.undoManager.addNewEdit(c);
                c.redo();
                this.list.setSelectedIndex(index - 1);
                this.list.ensureIndexIsVisible(index - 1);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 15;
        listPanel.add((Component)this.moveUpButton, gbc);
        this.moveDownButton = new JButton(ResourceManager.getIcon("Down.png"));
        this.moveDownButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setToolTipText(toolTipMoveDown);
        this.moveDownButton.addActionListener(e -> {
            int index = this.list.getSelectedIndex();
            MoveElementDownCommand c = new MoveElementDownCommand(this, index, index + 1);
            this.undoManager.addNewEdit(c);
            c.redo();
            this.list.setSelectedIndex(index + 1);
            this.list.ensureIndexIsVisible(index + 1);
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 11;
        listPanel.add((Component)this.moveDownButton, gbc);
        this.sortButton = new JButton(ResourceManager.getIcon("Sort.png"));
        this.sortButton.setMargin(new Insets(2, 2, 2, 2));
        this.sortButton.setToolTipText(toolTipSortPlaces);
        this.sortButton.setEnabled(false);
        this.sortButton.addActionListener(e -> {
            if (this.isDisplayingTransitions()) {
                SortSharedTransitionsCommand c = new SortSharedTransitionsCommand(this.sharedTransitionsListModel);
                this.undoManager.addNewEdit(c);
                c.redo();
            } else {
                SortSharedPlacesCommand c = new SortSharedPlacesCommand(this.sharedPlacesListModel);
                this.undoManager.addNewEdit(c);
                c.redo();
            }
        });
        this.sortButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SharedPlacesAndTransitionsPanel.this.isDisplayingTransitions()) {
                    SharedPlacesAndTransitionsPanel.this.sortButton.setToolTipText(SharedPlacesAndTransitionsPanel.toolTipSortTransitions);
                } else {
                    SharedPlacesAndTransitionsPanel.this.sortButton.setToolTipText(SharedPlacesAndTransitionsPanel.toolTipSortPlaces);
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.anchor = 11;
        listPanel.add((Component)this.sortButton, gbc);
        this.placesTransitionsComboBox.setToolTipText(toolTipChangeBetweenPlacesAndTransitions);
        this.placesTransitionsComboBox.addActionListener(e -> {
            JComboBox source = (JComboBox)e.getSource();
            String selectedItem = (String)source.getSelectedItem();
            if (selectedItem.equals(PLACES)) {
                this.list.setModel(this.sharedPlacesListModel);
                this.renameButton.setToolTipText(toolTipRenamePlace);
                this.addButton.setToolTipText(toolTipNewPlace);
                this.removeButton.setToolTipText(toolTipRemovePlace);
            } else if (selectedItem.equals(TRANSITIONS)) {
                this.list.setModel(this.sharedTransitionsListModel);
                this.renameButton.setToolTipText(toolTipRenameTransition);
                this.addButton.setToolTipText(toolTipNewTransition);
                this.removeButton.setToolTipText(toolTipRemoveTransition);
            }
            if (this.list.getModel().getSize() > 0) {
                this.list.setSelectedIndex(0);
                this.list.ensureIndexIsVisible(0);
            } else {
                this.moveDownButton.setEnabled(false);
                this.moveUpButton.setEnabled(false);
                this.sortButton.setEnabled(false);
            }
            if (this.list.getModel().getSize() <= 0) {
                this.renameButton.setEnabled(false);
                this.removeButton.setEnabled(false);
            }
        });
        this.placesTransitionsComboBox.setSelectedIndex(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.fill = 2;
        listPanel.add(this.placesTransitionsComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)listPanel, gbc);
        JPanel buttonPanel = new JPanel();
        if (this.list.getModel().getSize() > 0) {
            this.renameButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.renameButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        if (this.isDisplayingTransitions()) {
            this.renameButton.setToolTipText(toolTipRenameTransition);
        } else {
            this.renameButton.setToolTipText(toolTipRenamePlace);
        }
        this.renameButton.addActionListener(arg0 -> {
            if (this.isDisplayingTransitions()) {
                this.showSharedTransitionNameDialog((SharedTransition)this.list.getSelectedValue());
            } else {
                this.showSharedPlaceNameDialog((SharedPlace)this.list.getSelectedValue());
            }
        });
        if (this.isDisplayingTransitions()) {
            this.removeButton.setToolTipText(toolTipRemoveTransition);
        } else {
            this.removeButton.setToolTipText(toolTipRemovePlace);
        }
        this.removeButton.addActionListener(new DeleteSharedPlaceOrTransitionAction(this.list, this, this.tab, this.sharedPlacesListModel, this.sharedTransitionsListModel, this.nameGenerator));
        if (this.isDisplayingTransitions()) {
            this.addButton.setToolTipText(toolTipNewTransition);
        } else {
            this.addButton.setToolTipText(toolTipNewPlace);
        }
        this.addButton.addActionListener(arg0 -> {
            if (this.isDisplayingTransitions()) {
                this.showSharedTransitionNameDialog(null);
            } else {
                this.showSharedPlaceNameDialog(null);
            }
        });
        buttonPanel.add(this.renameButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(this.addButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        this.add((Component)buttonPanel, gbc);
    }

    private MouseListener createDoubleClickMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (!SharedPlacesAndTransitionsPanel.this.list.isSelectionEmpty() && arg0.getButton() == 1 && arg0.getClickCount() == 2) {
                    if (SharedPlacesAndTransitionsPanel.this.isDisplayingTransitions()) {
                        SharedPlacesAndTransitionsPanel.this.showSharedTransitionNameDialog((SharedTransition)SharedPlacesAndTransitionsPanel.this.list.getSelectedValue());
                    } else {
                        SharedPlacesAndTransitionsPanel.this.showSharedPlaceNameDialog((SharedPlace)SharedPlacesAndTransitionsPanel.this.list.getSelectedValue());
                    }
                }
            }
        };
    }

    protected boolean isDisplayingTransitions() {
        return this.placesTransitionsComboBox.getSelectedItem().equals(TRANSITIONS);
    }

    private void showSharedTransitionNameDialog(SharedTransition transitionToEdit) {
        EscapableDialog guiDialog = new EscapableDialog(TAPAALGUI.getApp(), "Edit Shared Transition", true);
        Container contentPane = guiDialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        SharedTransitionNamePanel panel = new SharedTransitionNamePanel(guiDialog.getRootPane(), this.sharedTransitionsListModel, this.undoManager, this.nameGenerator, new Context(this.tab), transitionToEdit);
        contentPane.add(panel);
        guiDialog.setResizable(false);
        guiDialog.pack();
        guiDialog.setLocationRelativeTo(null);
        guiDialog.setVisible(true);
    }

    private void showSharedPlaceNameDialog(SharedPlace placeToEdit) {
        EscapableDialog guiDialog = new EscapableDialog(TAPAALGUI.getApp(), "Edit Shared Place", true);
        Container contentPane = guiDialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        SharedPlaceNamePanel panel = new SharedPlaceNamePanel(guiDialog.getRootPane(), this.sharedPlacesListModel, new Context(this.tab), placeToEdit);
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setBorder(null);
        contentPane.add(scrollPane);
        guiDialog.setResizable(false);
        guiDialog.pack();
        guiDialog.setLocationRelativeTo(null);
        guiDialog.setVisible(true);
    }

    public void removeSharedPlace(SharedPlace place) {
        if (this.sharedPlacesListModel.network.getSharedPlaceByName(place.name()) != null) {
            this.sharedPlacesListModel.removeElement(place);
        }
    }

    public void addSharedPlace(SharedPlace place, boolean multiAdd) {
        this.sharedPlacesListModel.addElement(place, multiAdd);
    }

    public void removeSharedTransition(SharedTransition transition) {
        if (this.sharedTransitionsListModel.network.getSharedTransitionByName(transition.name()) != null) {
            this.sharedTransitionsListModel.removeElement(transition);
        }
    }

    public void addSharedTransition(SharedTransition transition, boolean multiAdd) {
        this.sharedTransitionsListModel.addElement(transition, multiAdd);
    }

    @Override
    public void moveUp(int index) {
        if (this.isDisplayingTransitions()) {
            this.sharedTransitionsListModel.swap(index, index - 1);
        } else {
            this.sharedPlacesListModel.swap(index, index - 1);
        }
    }

    @Override
    public void moveDown(int index) {
        if (this.isDisplayingTransitions()) {
            if (index < this.sharedTransitionsListModel.getSize() - 1) {
                this.sharedTransitionsListModel.swap(index, index + 1);
            }
        } else if (index < this.sharedPlacesListModel.getSize() - 1) {
            this.sharedPlacesListModel.swap(index, index + 1);
        }
    }

    @Override
    public JList getJList() {
        return this.list;
    }

    public class SharedPlacesListModel
    extends AbstractListModel {
        private TimedArcPetriNetNetwork network;

        public SharedPlacesListModel(TimedArcPetriNetNetwork network) {
            Require.that(network != null, "network must not be null");
            this.network = network;
            this.addListDataListener(new ListDataListener(){
                final /* synthetic */ SharedPlacesListModel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void intervalAdded(ListDataEvent arg0) {
                    this.this$1.SharedPlacesAndTransitionsPanel.this.list.setSelectedIndex(arg0.getIndex0());
                    this.this$1.SharedPlacesAndTransitionsPanel.this.list.ensureIndexIsVisible(arg0.getIndex0());
                }

                @Override
                public void intervalRemoved(ListDataEvent arg0) {
                    int index = arg0.getIndex0() == 0 ? 0 : arg0.getIndex0() - 1;
                    this.this$1.SharedPlacesAndTransitionsPanel.this.list.setSelectedIndex(index);
                    this.this$1.SharedPlacesAndTransitionsPanel.this.list.ensureIndexIsVisible(index);
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }
            });
        }

        public void swap(int currentIndex, int newIndex) {
            this.network.swapSharedPlaces(currentIndex, newIndex);
        }

        public SharedPlace[] sort() {
            SharedPlace[] oldOrder = this.network.sortSharedPlaces();
            this.fireContentsChanged(this, 0, this.getSize());
            return oldOrder;
        }

        public void undoSort(SharedPlace[] oldOrder) {
            this.network.undoSort(oldOrder);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public Object getElementAt(int index) {
            return this.network.getSharedPlaceByIndex(index);
        }

        @Override
        public int getSize() {
            return this.network.numberOfSharedPlaces();
        }

        public void addElement(SharedPlace place) {
            this.addElement(place, false);
        }

        public void addElement(SharedPlace place, boolean multiAdd) {
            this.network.add(place, multiAdd);
            this.fireIntervalAdded(this, this.network.numberOfSharedPlaces() - 1, this.network.numberOfSharedPlaces());
        }

        public void removeElement(SharedPlace place) {
            this.network.remove(place);
            this.fireContentsChanged(this, 0, this.getSize());
            int numElements = SharedPlacesAndTransitionsPanel.this.list.getModel().getSize();
            if (numElements <= 1) {
                SharedPlacesAndTransitionsPanel.this.moveDownButton.setEnabled(false);
                SharedPlacesAndTransitionsPanel.this.moveUpButton.setEnabled(false);
                SharedPlacesAndTransitionsPanel.this.sortButton.setEnabled(false);
            }
            if (numElements <= 0) {
                SharedPlacesAndTransitionsPanel.this.removeButton.setEnabled(false);
                SharedPlacesAndTransitionsPanel.this.renameButton.setEnabled(false);
            }
        }

        public void updatedName() {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void setNetwork(TimedArcPetriNetNetwork network) {
            Require.that(network != null, "network cannot be null");
            this.network = network;
            this.fireContentsChanged(this, 0, network.numberOfSharedPlaces());
        }
    }

    public class SharedTransitionsListModel
    extends AbstractListModel {
        private TimedArcPetriNetNetwork network;

        public SharedTransitionsListModel(TimedArcPetriNetNetwork network) {
            Require.that(network != null, "network must not be null");
            this.network = network;
            this.addListDataListener(new ListDataListener(){
                final /* synthetic */ SharedTransitionsListModel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void intervalAdded(ListDataEvent arg0) {
                    this.this$1.SharedPlacesAndTransitionsPanel.this.list.setSelectedIndex(arg0.getIndex0());
                    this.this$1.SharedPlacesAndTransitionsPanel.this.list.ensureIndexIsVisible(arg0.getIndex0());
                }

                @Override
                public void intervalRemoved(ListDataEvent arg0) {
                    int index = arg0.getIndex0() == 0 ? 0 : arg0.getIndex0() - 1;
                    this.this$1.SharedPlacesAndTransitionsPanel.this.list.setSelectedIndex(index);
                    this.this$1.SharedPlacesAndTransitionsPanel.this.list.ensureIndexIsVisible(index);
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }
            });
        }

        @Override
        public Object getElementAt(int index) {
            return this.network.getSharedTransitionByIndex(index);
        }

        public void swap(int currentIndex, int newIndex) {
            this.network.swapSharedTransitions(currentIndex, newIndex);
        }

        public SharedTransition[] sort() {
            SharedTransition[] oldOrder = this.network.sortSharedTransitions();
            this.fireContentsChanged(this, 0, this.getSize());
            return oldOrder;
        }

        public void undoSort(SharedTransition[] oldOrder) {
            this.network.undoSort(oldOrder);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public int getSize() {
            return this.network.numberOfSharedTransitions();
        }

        public void addElement(SharedTransition transition) {
            this.addElement(transition, false);
        }

        public void addElement(SharedTransition transition, boolean multiAdd) {
            this.network.add(transition, multiAdd);
            this.fireIntervalAdded(this, this.network.numberOfSharedTransitions() - 1, this.network.numberOfSharedTransitions());
        }

        public void removeElement(SharedTransition transition) {
            this.network.remove(transition);
            this.fireContentsChanged(this, 0, this.getSize());
            int numElements = SharedPlacesAndTransitionsPanel.this.list.getModel().getSize();
            if (numElements <= 1) {
                SharedPlacesAndTransitionsPanel.this.moveDownButton.setEnabled(false);
                SharedPlacesAndTransitionsPanel.this.moveUpButton.setEnabled(false);
                SharedPlacesAndTransitionsPanel.this.sortButton.setEnabled(false);
            }
            if (numElements <= 0) {
                SharedPlacesAndTransitionsPanel.this.removeButton.setEnabled(false);
                SharedPlacesAndTransitionsPanel.this.renameButton.setEnabled(false);
            }
        }

        public void updatedName() {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void setNetwork(TimedArcPetriNetNetwork network) {
            Require.that(network != null, "network cannot be null");
            this.network = network;
            this.fireContentsChanged(this, 0, network.numberOfSharedTransitions());
        }
    }
}

