/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.TCTL.visitors.RenameSharedPlaceVisitor;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.util.RequireException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.editor.SharedPlacesAndTransitionsPanel;
import net.tapaal.gui.petrinet.undo.AddSharedPlaceCommand;
import net.tapaal.gui.petrinet.undo.RenameSharedPlaceCommand;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.swinghelpers.SwingHelper;

public class SharedPlaceNamePanel
extends JPanel {
    private final JRootPane rootPane;
    private final SharedPlacesAndTransitionsPanel.SharedPlacesListModel listModel;
    private JTextField nameField;
    private final SharedPlace placeToEdit;
    private final Context context;
    JButton okButton;

    public SharedPlaceNamePanel(JRootPane rootPane, SharedPlacesAndTransitionsPanel.SharedPlacesListModel sharedPlacesListModel, Context context, SharedPlace placeToEdit) {
        this.rootPane = rootPane;
        this.listModel = sharedPlacesListModel;
        this.placeToEdit = placeToEdit;
        this.context = context;
        this.initComponents();
    }

    public void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel namePanel = this.createNamePanel();
        JPanel buttonPanel = this.createButtonPanel();
        GridBagConstraints gbcNamePanel = new GridBagConstraints();
        gbcNamePanel.insets = new Insets(4, 4, 2, 4);
        gbcNamePanel.gridx = 0;
        gbcNamePanel.gridy = 0;
        gbcNamePanel.gridwidth = 1;
        gbcNamePanel.anchor = 13;
        this.add((Component)namePanel, gbcNamePanel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 8, 5, 8);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        this.add((Component)buttonPanel, gbc);
    }

    private JPanel createNamePanel() {
        JPanel namePanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Enter a shared place name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 2, 4);
        namePanel.add((Component)label, gbc);
        String initialText = this.placeToEdit == null ? "" : this.placeToEdit.name();
        this.nameField = new JTextField(initialText);
        SwingHelper.setPreferredWidth(this.nameField, 330);
        this.nameField.addActionListener(e -> {
            this.okButton.requestFocusInWindow();
            this.okButton.doClick();
        });
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 4, 2, 4);
        namePanel.add((Component)this.nameField, gbc);
        return namePanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.okButton = new JButton("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.setMnemonic(79);
        GridBagConstraints gbcOk = new GridBagConstraints();
        gbcOk.gridx = 1;
        gbcOk.gridy = 0;
        gbcOk.anchor = 17;
        gbcOk.insets = new Insets(5, 5, 5, 5);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String name = SharedPlaceNamePanel.this.nameField.getText();
                if (name == null || name.isEmpty()) {
                    JOptionPane.showMessageDialog(SharedPlaceNamePanel.this, "You must specify a name.", "Error", 0);
                    SharedPlaceNamePanel.this.nameField.requestFocusInWindow();
                    return;
                }
                boolean success = false;
                success = SharedPlaceNamePanel.this.placeToEdit == null ? this.addNewSharedPlace(name) : (!name.equals(SharedPlaceNamePanel.this.placeToEdit.name()) ? this.updateExistingPlace(name) : true);
                if (success) {
                    SharedPlaceNamePanel.this.context.nameGenerator().updateIndicesForAllModels(name);
                    SharedPlaceNamePanel.this.exit();
                }
            }

            private boolean updateExistingPlace(String name) {
                String oldName = SharedPlaceNamePanel.this.placeToEdit.name();
                if (SharedPlaceNamePanel.this.placeToEdit.network().isNameUsed(name) && !oldName.equals(name)) {
                    JOptionPane.showMessageDialog(SharedPlaceNamePanel.this, "The specified name is already used by a place or transition in one of the components.", "Error", 0);
                    SharedPlaceNamePanel.this.nameField.requestFocusInWindow();
                    return false;
                }
                try {
                    SharedPlaceNamePanel.this.placeToEdit.setName(name);
                }
                catch (RequireException e) {
                    JOptionPane.showMessageDialog(SharedPlaceNamePanel.this, "The specified name is invalid.\nAcceptable names are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]* \n\nNote that \"true\" and \"false\" are reserved keywords.", "Error", 0);
                    SharedPlaceNamePanel.this.nameField.requestFocusInWindow();
                    return false;
                }
                for (TAPNQuery query : SharedPlaceNamePanel.this.context.queries()) {
                    query.getProperty().accept(new RenameSharedPlaceVisitor(oldName, name), null);
                }
                SharedPlaceNamePanel.this.listModel.updatedName();
                SharedPlaceNamePanel.this.context.undoManager().addNewEdit(new RenameSharedPlaceCommand(SharedPlaceNamePanel.this.placeToEdit, SharedPlaceNamePanel.this.listModel, SharedPlaceNamePanel.this.context.tabContent(), oldName, name));
                return true;
            }

            private boolean addNewSharedPlace(String name) {
                SharedPlace place = null;
                try {
                    place = new SharedPlace(name);
                }
                catch (RequireException e) {
                    JOptionPane.showMessageDialog(SharedPlaceNamePanel.this, "The specified name is invalid.\nAcceptable names are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]* \n\nNote that \"true\" and \"false\" are reserved keywords.", "Error", 0);
                    SharedPlaceNamePanel.this.nameField.requestFocusInWindow();
                    return false;
                }
                try {
                    SharedPlaceNamePanel.this.listModel.addElement(place);
                }
                catch (RequireException e) {
                    JOptionPane.showMessageDialog(SharedPlaceNamePanel.this, "A transition or place with the specified name already exists.", "Error", 0);
                    SharedPlaceNamePanel.this.nameField.requestFocusInWindow();
                    return false;
                }
                SharedPlaceNamePanel.this.context.undoManager().addNewEdit(new AddSharedPlaceCommand(SharedPlaceNamePanel.this.listModel, place));
                return true;
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMaximumSize(new Dimension(100, 25));
        cancelButton.setMinimumSize(new Dimension(100, 25));
        cancelButton.setPreferredSize(new Dimension(100, 25));
        cancelButton.setMnemonic(67);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 13;
        cancelButton.addActionListener(e -> this.exit());
        buttonPanel.add((Component)cancelButton, gbc);
        buttonPanel.add((Component)this.okButton, gbcOk);
        return buttonPanel;
    }

    private void exit() {
        this.rootPane.getParent().setVisible(false);
    }
}

