/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ConstantsParser.ConstantsParser;
import dk.aau.cs.model.CPN.ConstantsParser.ParseException;
import dk.aau.cs.model.CPN.ConstantsParser.TokenMgrError;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.tapaal.gui.petrinet.editor.ConstantsListModel;
import net.tapaal.gui.petrinet.editor.ConstantsPane;
import net.tapaal.gui.petrinet.undo.manualEdit.EditConstantsCommand;
import net.tapaal.gui.petrinet.undo.manualEdit.NetworkState;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.undo.UndoManager;
import pipe.gui.swingcomponents.EscapableDialog;

public class ManuallyEditDialogPanel
extends EscapableDialog {
    private static final int GAP = 10;
    private static final int TEXT_TO_BORDER_MARGIN = 10;
    private static final int FONT_SIZE = 14;
    private final ConstantsPane.ColorTypesListModel colorTypesListModel;
    private final ConstantsPane.VariablesListModel variablesListModel;
    private final ConstantsListModel constantsListModel;
    private final TimedArcPetriNetNetwork network;
    private final UndoManager undoManager;
    private JTextArea constantsArea;

    public ManuallyEditDialogPanel(ConstantsPane.ColorTypesListModel colorTypesListModel, ConstantsPane.VariablesListModel variablesListModel, ConstantsListModel constantsListModel, TimedArcPetriNetNetwork network, UndoManager undoManager) {
        super(TAPAALGUI.getApp(), "Manually Edit", false);
        this.colorTypesListModel = colorTypesListModel;
        this.variablesListModel = variablesListModel;
        this.constantsListModel = constantsListModel;
        this.network = network;
        this.undoManager = undoManager;
        this.init();
    }

    public void showDialog() {
        String ctName;
        String cleanHtml = "</?(html|b)>";
        String angleBracketOpen = "&lt;";
        String angleBracketClose = "&gt; ";
        for (int i = 0; i < this.colorTypesListModel.getSize(); ++i) {
            ColorType ct = (ColorType)this.colorTypesListModel.getElementAt(i);
            if (ct.getName().equals("dot")) continue;
            Object colorTypeStr = "type ";
            colorTypeStr = ct.isIntegerRange() && !ct.getColorList().isEmpty() ? (String)colorTypeStr + ct.getName() + " is [" + ct.getLowerBound() + ", " + ct.getUpperBound() + "]" : (String)colorTypeStr + String.valueOf(ct);
            colorTypeStr = (String)colorTypeStr + ";\n";
            colorTypeStr = ((String)colorTypeStr).replaceAll(cleanHtml, "");
            colorTypeStr = ((String)colorTypeStr).replace(angleBracketOpen, "<");
            colorTypeStr = ((String)colorTypeStr).replace(angleBracketClose, ">");
            this.constantsArea.append((String)colorTypeStr);
        }
        LinkedHashMap variableTypeToName = new LinkedHashMap();
        for (int i = 0; i < this.variablesListModel.getSize(); ++i) {
            Variable v = (Variable)this.variablesListModel.getElementAt(i);
            ctName = v.getColorType().getName();
            String varName = v.getName();
            variableTypeToName.putIfAbsent(ctName, new ArrayList());
            ((List)variableTypeToName.get(ctName)).add(varName);
        }
        for (Map.Entry entry : variableTypeToName.entrySet()) {
            ctName = (String)entry.getKey();
            List varNames = (List)entry.getValue();
            Object varStr = "var ";
            for (String varName : varNames) {
                varStr = (String)varStr + varName + ", ";
            }
            varStr = ((String)varStr).substring(0, ((String)varStr).length() - 2);
            varStr = (String)varStr + " in " + ctName + ";\n";
            ((String)varStr).replaceAll(cleanHtml, "");
            this.constantsArea.append((String)varStr);
        }
        for (int i = 0; i < this.constantsListModel.getSize(); ++i) {
            this.constantsArea.append("const " + String.valueOf(this.constantsListModel.getElementAt(i)) + ";\n");
        }
        this.setVisible(true);
    }

    private void init() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel constantsLabel = new JLabel("Color Types, Variables, and Constants");
        constantsLabel.setAlignmentX(0.5f);
        this.constantsArea = new JTextArea();
        this.constantsArea.setLineWrap(true);
        this.constantsArea.setWrapStyleWord(true);
        this.constantsArea.setMargin(new Insets(10, 10, 10, 10));
        this.constantsArea.setFont(new Font(this.constantsArea.getFont().getName(), 0, 14));
        JScrollPane constantsScrollPane = new JScrollPane(this.constantsArea);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel helpPanel = new JPanel();
        JButton helpButton = new JButton("Help");
        helpButton.addActionListener(e -> this.showHelpDialog(this.network.isColored()));
        helpPanel.add(helpButton);
        JPanel actionPanel = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.dispose());
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(e -> this.save());
        actionPanel.add(cancelButton);
        actionPanel.add(saveButton);
        buttonPanel.add((Component)helpPanel, "West");
        buttonPanel.add((Component)actionPanel, "East");
        buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, helpButton.getPreferredSize().height));
        panel.add(constantsLabel);
        panel.add(constantsScrollPane);
        panel.add(Box.createVerticalStrut(10));
        panel.add(buttonPanel);
        this.add(panel);
        this.setSize(650, 500);
        this.setLocationRelativeTo(null);
    }

    private void save() {
        try {
            NetworkState oldState = new NetworkState(this.network);
            boolean resultOk = ConstantsParser.parse(this.constantsArea.getText(), this.network);
            if (resultOk) {
                EditConstantsCommand command = new EditConstantsCommand(oldState, this.network, this.colorTypesListModel, this.variablesListModel);
                command.redo();
                this.undoManager.addNewEdit(command);
                this.dispose();
            }
        }
        catch (ParseException | TokenMgrError e) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), e.getMessage(), "Error during parsing", 0);
        }
    }

    private void showHelpDialog(boolean isColored) {
        EscapableDialog helpDialog = new EscapableDialog(this, "Help", true);
        JTextArea helpTextArea = new JTextArea();
        helpTextArea.setEditable(false);
        String helpText = "Syntax for defining " + (isColored ? "color types, variables, and " : "") + "constants:\nconst {ID} = {INTEGER};\ne.g. const a = 5; is a valid constant.\n\n" + (isColored ? "Syntax for defining color types:\ntype {ID} is [{COLOR}, ..., {COLOR}];\ntype {ID} is [{LOWER_BOUND}, {UPPER_BOUND}];\ntype {ID} is <{COLOR}, ..., {COLOR}>;\ne.g. type Colors is [red, green, blue]; is a valid color type.\n\n" : "") + (isColored ? "Syntax for defining variables:\nvar {ID}, ..., {ID} in {COLORTYPE};\ne.g. var a, b, c in Colors; is a valid variable\n\n" : "") + "All statements must end with a semicolon.";
        helpTextArea.setText(helpText);
        helpTextArea.setLineWrap(true);
        helpTextArea.setWrapStyleWord(true);
        helpTextArea.setMargin(new Insets(10, 10, 10, 10));
        helpTextArea.setFont(new Font(this.constantsArea.getFont().getName(), 0, 14));
        helpDialog.add(new JScrollPane(helpTextArea));
        int height = isColored ? 375 : 210;
        helpDialog.setSize(525, height);
        helpDialog.setLocationRelativeTo(this);
        helpDialog.setVisible(true);
    }
}

