/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.tapn.SMCConstantDistribution;
import dk.aau.cs.model.tapn.SMCDiscreteUniformDistribution;
import dk.aau.cs.model.tapn.SMCDistribution;
import dk.aau.cs.model.tapn.SMCErlangDistribution;
import dk.aau.cs.model.tapn.SMCExponentialDistribution;
import dk.aau.cs.model.tapn.SMCGammaDistribution;
import dk.aau.cs.model.tapn.SMCGeometricDistribution;
import dk.aau.cs.model.tapn.SMCLogNormalDistribution;
import dk.aau.cs.model.tapn.SMCNormalDistribution;
import dk.aau.cs.model.tapn.SMCTriangularDistribution;
import dk.aau.cs.model.tapn.SMCUniformDistribution;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.RequireException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.tapaal.swinghelpers.GridBagHelper;
import net.tapaal.swinghelpers.SwingHelper;
import pipe.gui.TAPAALGUI;
import pipe.gui.graph.DefaultGraphDialog;
import pipe.gui.graph.Graph;
import pipe.gui.graph.GraphDialog;
import pipe.gui.graph.GraphPoint;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.swingcomponents.EscapableDialog;

public class DistributionPanel
extends JPanel {
    private TimedTransitionComponent transition;
    private EscapableDialog dialog;
    private boolean updatingFields;
    private static final String[] continuous = new String[]{"constant", "uniform", "exponential", "normal", "gamma", "erlang", "triangular", "log normal"};
    private static final String[] discrete = new String[]{"discrete uniform", "geometric"};
    private JRadioButton useContinuousDistribution;
    private JRadioButton useDiscreteDistribution;
    private ButtonGroup distributionCategoryGroup;
    private JComboBox<String> distributionType;
    private JButton distributionShowGraph;
    private JLabel distributionParam1Label;
    private JLabel distributionParam2Label;
    private JLabel distributionParam3Label;
    private JTextField distributionParam1Field;
    private JTextField distributionParam2Field;
    private JTextField distributionParam3Field;
    private JLabel meanLabel;
    private JLabel meanValueLabel;

    public DistributionPanel(TimedTransitionComponent transition, EscapableDialog dialog) {
        this.transition = transition;
        this.dialog = dialog;
        this.initComponents();
        this.displayDistribution();
    }

    private void initComponents() {
        this.useContinuousDistribution = new JRadioButton("Continuous");
        this.useDiscreteDistribution = new JRadioButton("Discrete");
        this.distributionCategoryGroup = new ButtonGroup();
        this.distributionCategoryGroup.add(this.useContinuousDistribution);
        this.distributionCategoryGroup.add(this.useDiscreteDistribution);
        this.useContinuousDistribution.setSelected(true);
        this.useContinuousDistribution.addActionListener(act -> this.switchDistributionCategory(true));
        this.useDiscreteDistribution.addActionListener(act -> this.switchDistributionCategory(false));
        this.distributionType = new JComboBox<String>(continuous);
        this.distributionShowGraph = new JButton("Show density");
        this.distributionParam1Label = new JLabel();
        this.distributionParam2Label = new JLabel();
        this.distributionParam3Label = new JLabel();
        this.distributionParam1Field = new JTextField(5);
        this.distributionParam2Field = new JTextField(5);
        this.distributionParam3Field = new JTextField(5);
        this.meanLabel = new JLabel();
        this.meanValueLabel = new JLabel();
        SwingHelper.setPreferredWidth(this.distributionParam1Field, 100);
        SwingHelper.setPreferredWidth(this.distributionParam2Field, 100);
        SwingHelper.setPreferredWidth(this.distributionParam3Field, 100);
        this.distributionType.addActionListener(actionEvent -> {
            if (!this.distributionType.hasFocus()) {
                return;
            }
            this.displayDistributionFields(SMCDistribution.defaultDistributionFor(String.valueOf(this.distributionType.getSelectedItem())));
        });
        this.distributionShowGraph.addActionListener(actionEvent -> this.showDistributionGraph());
        DocumentListener updateDistribDisplay = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.display();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.display();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.display();
            }

            public void display() {
                SMCDistribution distrib = DistributionPanel.this.parseDistribution();
                if (distrib.getMean() != null && !(distrib instanceof SMCNormalDistribution) && !(distrib instanceof SMCExponentialDistribution)) {
                    DistributionPanel.this.meanLabel.setText("Mean :");
                    DistributionPanel.this.meanValueLabel.setText(DistributionPanel.this.formatValue(distrib.getMean()));
                } else {
                    DistributionPanel.this.meanLabel.setText("");
                    DistributionPanel.this.meanValueLabel.setText("");
                }
                DistributionPanel.this.distributionType.setToolTipText(distrib.explanation());
            }
        };
        DocumentListener rateFieldListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this::updateMeanFromRate);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this::updateMeanFromRate);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this::updateMeanFromRate);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateMeanFromRate() {
                if (DistributionPanel.this.distributionType.getSelectedItem().equals("exponential") && !DistributionPanel.this.updatingFields && DistributionPanel.this.distributionParam1Field.hasFocus()) {
                    try {
                        DistributionPanel.this.updatingFields = true;
                        String text = DistributionPanel.this.distributionParam1Field.getText();
                        if (!text.isEmpty()) {
                            double rate = Double.parseDouble(text);
                            DistributionPanel.this.distributionParam2Field.setText(DistributionPanel.this.formatValue(1.0 / rate));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    finally {
                        DistributionPanel.this.updatingFields = false;
                    }
                }
            }
        };
        DocumentListener meanFieldListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this::updateRateFromMean);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this::updateRateFromMean);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(this::updateRateFromMean);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateRateFromMean() {
                if (DistributionPanel.this.distributionType.getSelectedItem().equals("exponential") && !DistributionPanel.this.updatingFields && DistributionPanel.this.distributionParam2Field.hasFocus()) {
                    try {
                        DistributionPanel.this.updatingFields = true;
                        String text = DistributionPanel.this.distributionParam2Field.getText();
                        if (!text.isEmpty()) {
                            double mean = Double.parseDouble(text);
                            DistributionPanel.this.distributionParam1Field.setText(DistributionPanel.this.formatValue(1.0 / mean));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    finally {
                        DistributionPanel.this.updatingFields = false;
                    }
                }
            }
        };
        this.distributionParam1Field.getDocument().addDocumentListener(rateFieldListener);
        this.distributionParam2Field.getDocument().addDocumentListener(meanFieldListener);
        this.distributionParam1Field.getDocument().addDocumentListener(updateDistribDisplay);
        this.distributionParam2Field.getDocument().addDocumentListener(updateDistribDisplay);
        this.distributionParam3Field.getDocument().addDocumentListener(updateDistribDisplay);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Distribution and Firing Mode"));
        GridBagConstraints gbc = GridBagHelper.as(0, 0, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        this.add((Component)this.useContinuousDistribution, gbc);
        ++gbc.gridx;
        this.add((Component)this.useDiscreteDistribution, gbc);
        ++gbc.gridx;
        gbc.fill = 2;
        this.add(this.distributionType, gbc);
        gbc.fill = 0;
        ++gbc.gridx;
        gbc.anchor = 13;
        JPanel paramPanel = new JPanel(new GridBagLayout());
        gbc = GridBagHelper.as(0, 0, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        paramPanel.add((Component)this.distributionParam1Label, gbc);
        gbc.anchor = 17;
        ++gbc.gridx;
        gbc.fill = 2;
        paramPanel.add((Component)this.distributionParam1Field, gbc);
        gbc.fill = 1;
        ++gbc.gridx;
        gbc.anchor = 13;
        paramPanel.add((Component)this.distributionParam2Label, gbc);
        gbc.anchor = 17;
        ++gbc.gridx;
        gbc.fill = 2;
        paramPanel.add((Component)this.distributionParam2Field, gbc);
        gbc.anchor = 13;
        gbc.fill = 1;
        ++gbc.gridx;
        gbc.gridwidth = 1;
        paramPanel.add((Component)this.meanLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        paramPanel.add((Component)this.meanValueLabel, gbc);
        gbc.fill = 1;
        gbc.gridx -= 5;
        ++gbc.gridy;
        gbc.anchor = 13;
        paramPanel.add((Component)this.distributionParam3Label, gbc);
        gbc.anchor = 17;
        ++gbc.gridx;
        gbc.fill = 2;
        paramPanel.add((Component)this.distributionParam3Field, gbc);
        gbc = GridBagHelper.as(3, 0, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        gbc.fill = 2;
        paramPanel.setPreferredSize(new Dimension(450, paramPanel.getPreferredSize().height));
        this.add((Component)paramPanel, gbc);
        gbc.fill = 0;
        ++gbc.gridx;
        gbc.anchor = 13;
        this.add((Component)this.distributionShowGraph, gbc);
        this.setUrgent(this.transition.underlyingTransition().isUrgent());
    }

    private void switchDistributionCategory(boolean toContinuous) {
        boolean isUniformConversion;
        String currentDistribution = String.valueOf(this.distributionType.getSelectedItem());
        String a = this.distributionParam1Field.getText();
        String b = this.distributionParam2Field.getText();
        this.distributionType.setModel(new DefaultComboBoxModel<String>(toContinuous ? continuous : discrete));
        boolean bl = isUniformConversion = toContinuous && "discrete uniform".equals(currentDistribution) || !toContinuous && "uniform".equals(currentDistribution);
        if (isUniformConversion) {
            String targetDistribution = toContinuous ? "uniform" : "discrete uniform";
            this.distributionType.setSelectedItem(targetDistribution);
            this.displayDistributionFields(SMCDistribution.defaultDistributionFor(targetDistribution));
            this.distributionParam1Field.setText(a);
            this.distributionParam2Field.setText(b);
        } else {
            this.displayDistributionFields(SMCDistribution.defaultDistributionFor(String.valueOf(this.distributionType.getSelectedItem())));
        }
    }

    public void setUrgent(boolean urgent) {
        if (urgent) {
            this.displayDistributionFields(SMCDistribution.urgent());
            this.distributionType.setEnabled(false);
            this.useDiscreteDistribution.setEnabled(false);
            this.useContinuousDistribution.setEnabled(false);
            this.distributionParam1Field.setEnabled(false);
        } else {
            this.distributionType.setEnabled(true);
            this.useDiscreteDistribution.setEnabled(true);
            this.useContinuousDistribution.setEnabled(true);
            this.distributionParam1Field.setEnabled(true);
        }
    }

    public SMCDistribution parseDistribution() {
        if (this.transition.isUrgent()) {
            return SMCDistribution.urgent();
        }
        String type = String.valueOf(this.distributionType.getSelectedItem());
        try {
            switch (type) {
                case "constant": {
                    double value = Double.parseDouble(this.distributionParam1Field.getText());
                    return new SMCConstantDistribution(value);
                }
                case "uniform": {
                    double a = Double.parseDouble(this.distributionParam1Field.getText());
                    double b = Double.parseDouble(this.distributionParam2Field.getText());
                    return new SMCUniformDistribution(a, b);
                }
                case "exponential": {
                    double rate = Double.parseDouble(this.distributionParam1Field.getText());
                    return new SMCExponentialDistribution(rate);
                }
                case "normal": {
                    double mean = Double.parseDouble(this.distributionParam1Field.getText());
                    double stddev = Double.parseDouble(this.distributionParam2Field.getText());
                    return new SMCNormalDistribution(mean, stddev);
                }
                case "gamma": {
                    double shape = Double.parseDouble(this.distributionParam1Field.getText());
                    double scale = Double.parseDouble(this.distributionParam2Field.getText());
                    return new SMCGammaDistribution(shape, scale);
                }
                case "erlang": {
                    double eshape = Integer.parseInt(this.distributionParam1Field.getText());
                    double escale = Double.parseDouble(this.distributionParam2Field.getText());
                    return new SMCErlangDistribution(eshape, escale);
                }
                case "discrete uniform": {
                    double da = Integer.parseInt(this.distributionParam1Field.getText());
                    double db = Integer.parseInt(this.distributionParam2Field.getText());
                    return new SMCDiscreteUniformDistribution(da, db);
                }
                case "geometric": {
                    double p = Double.parseDouble(this.distributionParam1Field.getText());
                    return new SMCGeometricDistribution(p);
                }
                case "triangular": {
                    double ta = Double.parseDouble(this.distributionParam1Field.getText());
                    double tb = Double.parseDouble(this.distributionParam2Field.getText());
                    double tc = Double.parseDouble(this.distributionParam3Field.getText());
                    return new SMCTriangularDistribution(ta, tb, tc);
                }
                case "log normal": {
                    double logMean = Double.parseDouble(this.distributionParam1Field.getText());
                    double logStddev = Double.parseDouble(this.distributionParam2Field.getText());
                    return new SMCLogNormalDistribution(logMean, logStddev);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return SMCDistribution.defaultDistributionFor(type);
    }

    public void displayDistribution() {
        SMCDistribution distribution = this.transition.underlyingTransition().getDistribution();
        this.displayDistributionFields(distribution);
    }

    public void displayDistributionFields(SMCDistribution distribution) {
        if (Arrays.asList(continuous).contains(distribution.distributionName())) {
            this.useContinuousDistribution.setSelected(true);
            this.distributionType.setModel(new DefaultComboBoxModel<String>(continuous));
        } else {
            this.distributionType.setModel(new DefaultComboBoxModel<String>(discrete));
            this.useDiscreteDistribution.setSelected(true);
        }
        switch (distribution.distributionName()) {
            case "constant": {
                this.displayOneVariable("Value", ((SMCConstantDistribution)distribution).value);
                break;
            }
            case "uniform": {
                this.displayTwoVariables("A", ((SMCUniformDistribution)distribution).a, "B", ((SMCUniformDistribution)distribution).b);
                break;
            }
            case "exponential": {
                this.displayTwoVariables("Rate", ((SMCExponentialDistribution)distribution).rate, "Mean", ((SMCExponentialDistribution)distribution).getMean());
                break;
            }
            case "normal": {
                this.displayTwoVariables("Mean", ((SMCNormalDistribution)distribution).mean, "Std. Dev", ((SMCNormalDistribution)distribution).stddev);
                break;
            }
            case "gamma": {
                this.displayTwoVariables("Shape", ((SMCGammaDistribution)distribution).shape, "Scale", ((SMCGammaDistribution)distribution).scale);
                break;
            }
            case "erlang": {
                this.displayTwoVariables("Shape", ((SMCErlangDistribution)distribution).shape, "Scale", ((SMCErlangDistribution)distribution).scale);
                break;
            }
            case "discrete uniform": {
                this.displayTwoVariables("A", ((SMCDiscreteUniformDistribution)distribution).a, "B", ((SMCDiscreteUniformDistribution)distribution).b);
                break;
            }
            case "geometric": {
                this.displayOneVariable("P", ((SMCGeometricDistribution)distribution).p);
                break;
            }
            case "triangular": {
                this.displayThreeVariables("A", ((SMCTriangularDistribution)distribution).a, "B", ((SMCTriangularDistribution)distribution).b, "C", ((SMCTriangularDistribution)distribution).c);
                break;
            }
            case "log normal": {
                this.displayTwoVariables("Log Mean", ((SMCLogNormalDistribution)distribution).logMean, "Log Std. Dev", ((SMCLogNormalDistribution)distribution).logStddev);
                break;
            }
        }
        this.distributionType.setToolTipText(distribution.explanation());
        if (distribution.getMean() != null && !(distribution instanceof SMCNormalDistribution) && !(distribution instanceof SMCExponentialDistribution)) {
            this.meanLabel.setText("Mean :");
            this.meanValueLabel.setText(String.format("%.3f", distribution.getMean()));
        } else {
            this.meanLabel.setText("");
            this.meanValueLabel.setText("");
        }
        this.distributionType.setFocusable(false);
        this.distributionType.setSelectedItem(distribution.distributionName());
        this.distributionType.setFocusable(true);
        this.dialog.pack();
    }

    private void displayOneVariable(String name, double value) {
        this.distributionParam1Label.setText(name + " :");
        this.distributionParam1Field.setText(this.formatValue(value));
        this.distributionParam2Label.setVisible(false);
        this.distributionParam2Field.setVisible(false);
        this.distributionParam3Label.setVisible(false);
        this.distributionParam3Field.setVisible(false);
    }

    private void displayTwoVariables(String name1, double value1, String name2, double value2) {
        this.distributionParam1Label.setText(name1 + " :");
        this.distributionParam2Label.setText(name2 + " :");
        this.distributionParam1Field.setText(this.formatValue(value1));
        this.distributionParam2Field.setText(this.formatValue(value2));
        this.distributionParam2Label.setVisible(true);
        this.distributionParam2Field.setVisible(true);
        this.distributionParam3Label.setVisible(false);
        this.distributionParam3Field.setVisible(false);
    }

    private void displayThreeVariables(String name1, double value1, String name2, double value2, String name3, double value3) {
        this.distributionParam1Label.setText(name1 + " :");
        this.distributionParam2Label.setText(name2 + " :");
        this.distributionParam3Label.setText(name3 + " :");
        this.distributionParam1Field.setText(this.formatValue(value1));
        this.distributionParam2Field.setText(this.formatValue(value2));
        this.distributionParam3Field.setText(this.formatValue(value3));
        this.distributionParam2Label.setVisible(true);
        this.distributionParam2Field.setVisible(true);
        this.distributionParam3Label.setVisible(true);
        this.distributionParam3Field.setVisible(true);
    }

    private String formatValue(double value) {
        DecimalFormat df = new DecimalFormat("#.#####");
        return df.format(value);
    }

    private void showDistributionGraph() {
        SMCDistribution distribution = this.parseDistribution();
        try {
            GraphDialog dialog = this.createGraphDialog(distribution);
            dialog.display();
        }
        catch (RequireException e) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There was an error opening the graph. Reason: " + e.getMessage(), "Error", 0);
        }
    }

    private GraphDialog createGraphDialog(SMCDistribution distribution) {
        String title = "Probability Density Function";
        DefaultGraphDialog.GraphDialogBuilder builder = new DefaultGraphDialog.GraphDialogBuilder();
        if (distribution instanceof SMCConstantDistribution) {
            Graph graph = this.createGraph((SMCConstantDistribution)distribution);
            builder = builder.addGraph(graph).setTitle(title);
        } else if (distribution instanceof SMCDiscreteUniformDistribution) {
            Graph graph = this.createGraph((SMCDiscreteUniformDistribution)distribution);
            builder = builder.addGraph(graph).setPointPlot(true);
        } else if (distribution instanceof SMCExponentialDistribution) {
            Graph graph = this.createGraph((SMCExponentialDistribution)distribution);
            builder = builder.addGraph(graph);
        } else if (distribution instanceof SMCGammaDistribution) {
            Graph graph = this.createGraph((SMCGammaDistribution)distribution);
            builder = builder.addGraph(graph);
        } else if (distribution instanceof SMCErlangDistribution) {
            Graph graph = this.createGraph((SMCErlangDistribution)distribution);
            builder = builder.addGraph(graph);
        } else if (distribution instanceof SMCNormalDistribution) {
            Graph graph = this.createGraph((SMCNormalDistribution)distribution);
            builder = builder.addGraph(graph).setTitle(title);
        } else if (distribution instanceof SMCUniformDistribution) {
            List<Graph> graphs = this.createGraphs((SMCUniformDistribution)distribution);
            builder = builder.addGraphs(graphs).setPiecewise(true);
        } else if (distribution instanceof SMCGeometricDistribution) {
            Graph graph = this.createGraph((SMCGeometricDistribution)distribution);
            builder = builder.addGraph(graph).setPointPlot(true);
        } else if (distribution instanceof SMCTriangularDistribution) {
            Graph graph = this.createGraph((SMCTriangularDistribution)distribution);
            builder = builder.addGraph(graph);
        } else if (distribution instanceof SMCLogNormalDistribution) {
            Graph graph = this.createGraph((SMCLogNormalDistribution)distribution);
            builder = builder.addGraph(graph);
        }
        return builder.setTitle(title).build();
    }

    private Graph createGraph(SMCConstantDistribution distribution) {
        ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
        LinkedHashMap<String, Double> params = distribution.getParameters();
        double value = params.get("value");
        points.add(new GraphPoint(value, 0.0));
        points.add(new GraphPoint(value, 100.0));
        return new Graph("Constant Distribution", points, distribution.getMean());
    }

    private Graph createGraph(SMCDiscreteUniformDistribution distribution) {
        ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
        LinkedHashMap<String, Double> params = distribution.getParameters();
        double a = params.get("a");
        double b = params.get("b");
        double mean = distribution.getMean();
        double n = b - a + 1.0;
        for (int x = (int)a; x <= (int)b; ++x) {
            points.add(new GraphPoint(x, 1.0 / n));
        }
        return new Graph("Discrete Uniform Distribution", points, mean);
    }

    private Graph createGraph(SMCExponentialDistribution distribution) {
        double y;
        ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
        LinkedHashMap<String, Double> params = distribution.getParameters();
        double rate = params.get("rate");
        double mean = distribution.getMean();
        int x = 0;
        while (!((y = rate * Math.exp(-rate * (double)x)) < 1.0E-6)) {
            points.add(new GraphPoint(x, y));
            ++x;
        }
        return new Graph("Exponential Distribution", points, mean);
    }

    private Graph createGraph(SMCGammaDistribution distribution) {
        double y;
        ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
        LinkedHashMap<String, Double> params = distribution.getParameters();
        double shape = params.get("shape");
        double scale = params.get("scale");
        Require.that(shape > 0.0, "Shape must be a positive real");
        Require.that(scale > 0.0, "Scale must be a positive real");
        double gamma = this.spougeGammaApprox(shape - 1.0);
        double coefficient = 1.0 / (gamma * Math.pow(scale, shape));
        double step = 0.1;
        for (double x = 1.0E-300; !((y = coefficient * Math.pow(x, shape - 1.0) * Math.exp(-(x / scale))) < 1.0E-8) || !(x > 10.0); x += step) {
            points.add(new GraphPoint(x, y));
        }
        return new Graph("Gamma Distribution", points, distribution.getMean());
    }

    private Graph createGraph(SMCErlangDistribution distribution) {
        double y;
        ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
        LinkedHashMap<String, Double> params = distribution.getParameters();
        double shape = params.get("shape");
        double scale = params.get("scale");
        Require.that(shape >= 1.0 && shape % 1.0 == 0.0, "Shape must be a positive integer");
        Require.that(scale > 0.0, "Scale must be a positive real");
        double gamma = this.spougeGammaApprox(shape - 1.0);
        double coefficient = 1.0 / (gamma * Math.pow(scale, shape));
        double step = 0.1;
        for (double x = 1.0E-300; !((y = coefficient * Math.pow(x, shape - 1.0) * Math.exp(-(x / scale))) < 1.0E-8) || !(x > 10.0); x += step) {
            points.add(new GraphPoint(x, y));
        }
        return new Graph("Erlang Distribution", points, distribution.getMean());
    }

    private double spougeGammaApprox(double shape) {
        int a = 10;
        ArrayList<Double> c = new ArrayList<Double>();
        c.add(Math.sqrt(Math.PI * 2));
        for (int k = 1; k < a; ++k) {
            c.add(Math.pow(-1.0, k - 1) / (double)this.factorial(k - 1) * Math.pow(-k + a, (double)k - 0.5) * Math.exp(-k + a));
        }
        double sum = (Double)c.get(0);
        for (int k = 1; k < a; ++k) {
            sum += (Double)c.get(k) / (shape + (double)k);
        }
        double term = Math.pow(shape + (double)a, shape + 0.5) * Math.exp(-shape - (double)a);
        return term * sum;
    }

    private int factorial(int n) {
        int result = 1;
        if (n == 0) {
            return result;
        }
        for (int i = 1; i <= n; ++i) {
            result *= i;
        }
        return result;
    }

    private Graph createGraph(SMCNormalDistribution distribution) {
        ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
        LinkedHashMap<String, Double> params = distribution.getParameters();
        double mean = distribution.getMean();
        double stddev = params.get("stddev");
        double variance = Math.pow(stddev, 2.0);
        double coefficient = 1.0 / Math.sqrt(Math.PI * 2 * variance);
        double step = 0.1 * stddev;
        double twoVariance = 2.0 * variance;
        double negInvTwoVariance = -1.0 / twoVariance;
        double min = Math.max(mean - 3.0 * stddev, 0.0);
        double max = mean + 3.0 * stddev;
        for (double x = min; x <= max; x += step) {
            double exponent = Math.pow(x - mean, 2.0) * negInvTwoVariance;
            double y = coefficient * Math.exp(exponent);
            points.add(new GraphPoint(x, y));
        }
        return new Graph("Normal Distribution", points, mean);
    }

    private List<Graph> createGraphs(SMCUniformDistribution distribution) {
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        ArrayList<GraphPoint> pointsG1 = new ArrayList<GraphPoint>();
        ArrayList<GraphPoint> pointsG2 = new ArrayList<GraphPoint>();
        ArrayList<GraphPoint> pointsG3 = new ArrayList<GraphPoint>();
        LinkedHashMap<String, Double> params = distribution.getParameters();
        double a = params.get("a");
        double b = params.get("b");
        double mean = distribution.getMean();
        pointsG1.add(new GraphPoint(0.0, 0.0));
        pointsG1.add(new GraphPoint(a, 0.0));
        pointsG2.add(new GraphPoint(a, 1.0 / (b - a)));
        pointsG2.add(new GraphPoint(b, 1.0 / (b - a)));
        pointsG3.add(new GraphPoint(b, 0.0));
        pointsG3.add(new GraphPoint(b + a, 0.0));
        graphs.add(new Graph("Uniform Distribution", pointsG1, mean));
        graphs.add(new Graph("piece2", pointsG2));
        graphs.add(new Graph("piece3", pointsG3));
        return graphs;
    }

    private Graph createGraph(SMCGeometricDistribution distribution) {
        double p;
        ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
        LinkedHashMap<String, Double> params = distribution.getParameters();
        double y = p = params.get("p").doubleValue();
        for (int x = 0; y > 0.01 && x < 100; y *= 1.0 - p, ++x) {
            points.add(new GraphPoint(x, y));
        }
        return new Graph("Geometric distribution", points, distribution.getMean());
    }

    private Graph createGraph(SMCTriangularDistribution distribution) {
        ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
        double mean = distribution.getMean();
        points.add(new GraphPoint(distribution.a, 0.0));
        points.add(new GraphPoint(distribution.c, 2.0 / (distribution.b - distribution.a)));
        points.add(new GraphPoint(distribution.b, 0.0));
        return new Graph("Triangular Distribution", points, mean);
    }

    private Graph createGraph(SMCLogNormalDistribution distribution) {
        ArrayList<GraphPoint> points = new ArrayList<GraphPoint>();
        double mean = distribution.getMean();
        double logStddev = distribution.logStddev;
        double logMean = distribution.logMean;
        double min = Math.exp(logMean - 3.0 * logStddev);
        double max = Math.exp(logMean + 3.0 * logStddev);
        double step = (max - min) / 1000.0;
        for (double x = min; x <= max; x += step) {
            double y = distribution.pdf(x);
            points.add(new GraphPoint(x, y));
        }
        return new Graph("Log Normal Distribution", points, mean);
    }
}

