/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.TCTL.visitors.BooleanResult;
import dk.aau.cs.TCTL.visitors.ContainsSharedPlaceVisitor;
import dk.aau.cs.TCTL.visitors.ContainsSharedTransitionVisitor;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.tapaal.gui.petrinet.NameGenerator;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.editor.SharedPlacesAndTransitionsPanel;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.undo.DeleteQueriesCommand;
import net.tapaal.gui.petrinet.undo.DeleteSharedPlaceCommand;
import net.tapaal.gui.petrinet.undo.DeleteSharedTransitionCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedInhibitorArcCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedInputArcCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedOutputArcCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedPlaceCommand;
import net.tapaal.gui.petrinet.undo.DeleteTimedTransitionCommand;
import net.tapaal.gui.petrinet.undo.DeleteTransportArcCommand;
import net.tapaal.gui.petrinet.undo.RenameTimedPlaceCommand;
import net.tapaal.gui.petrinet.undo.RenameTimedTransitionCommand;
import net.tapaal.gui.petrinet.undo.UnsharePlaceCommand;
import net.tapaal.gui.petrinet.undo.UnshareTransitionCommand;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.DrawingSurfaceImpl;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;
import pipe.gui.petrinet.undo.UndoManager;

public final class DeleteSharedPlaceOrTransitionAction
implements ActionListener {
    private static final String TRANSITION_IS_USED_MESSAGE = "<html>The shared transition is used in one or more components.<br/>TAPAAL will unshare all transitions under this name,<br/>but leave the transitions in the components.</html>";
    private static final String PLACE_IS_USED_MESSAGE = "<html>The shared place is used in one or more components.<br/>TAPAAL will unshare all places under this name,<br/>but leave the places in the components.</html>";
    final JList list;
    final SharedPlacesAndTransitionsPanel sharedPlacesAndTransitionsPanel;
    final PetriNetTab tab;
    final UndoManager undoManager;
    final SharedPlacesAndTransitionsPanel.SharedPlacesListModel sharedPlacesListModel;
    final SharedPlacesAndTransitionsPanel.SharedTransitionsListModel sharedTransitionsListModel;
    final NameGenerator nameGenerator;
    boolean messageShown;

    public DeleteSharedPlaceOrTransitionAction(JList list, SharedPlacesAndTransitionsPanel sharedPlacesAndTransitionsPanel, PetriNetTab tab, SharedPlacesAndTransitionsPanel.SharedPlacesListModel sharedPlacesListModel, SharedPlacesAndTransitionsPanel.SharedTransitionsListModel sharedTransitionsListModel, NameGenerator nameGenerator) {
        this.list = list;
        this.sharedPlacesAndTransitionsPanel = sharedPlacesAndTransitionsPanel;
        this.tab = tab;
        this.undoManager = tab.getUndoManager();
        this.sharedPlacesListModel = sharedPlacesListModel;
        this.sharedTransitionsListModel = sharedTransitionsListModel;
        this.nameGenerator = nameGenerator;
    }

    public DeleteSharedResult showDeleteDialog(List<String> affectedComponents) {
        JCheckBox checkBox = new JCheckBox("Delete from all components");
        JLabel label = new JLabel(this.sharedPlacesAndTransitionsPanel.isDisplayingTransitions() ? TRANSITION_IS_USED_MESSAGE : PLACE_IS_USED_MESSAGE);
        JList<Object> listOfComponents = new JList<Object>(affectedComponents.toArray());
        JScrollPane scrollPane = new JScrollPane(listOfComponents);
        Object[] params = new Object[]{label, checkBox, new JLabel("Components affected:"), scrollPane};
        int result = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), params, "Warning", 2);
        boolean deleteFromTemplates = checkBox.isSelected();
        return new DeleteSharedResult(result, deleteFromTemplates);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        block12: {
            this.messageShown = false;
            if (this.list.getSelectedValuesList() == null) break block12;
            ArrayList<String> affectedComponents = new ArrayList<String>();
            ArrayList<String> affectedComponentsWithDupes = new ArrayList<String>();
            if (this.sharedPlacesAndTransitionsPanel.isDisplayingTransitions()) {
                for (Object transition : this.list.getSelectedValuesList()) {
                    affectedComponentsWithDupes.addAll(this.getComponentsUsingThisTransition((SharedTransition)transition));
                }
                for (String component : affectedComponentsWithDupes) {
                    if (affectedComponents.contains(component)) continue;
                    affectedComponents.add(component);
                }
            } else {
                for (Object place : this.list.getSelectedValuesList()) {
                    affectedComponentsWithDupes.addAll(((SharedPlace)place).getComponentsUsingThisPlace());
                }
                for (String component : affectedComponentsWithDupes) {
                    if (affectedComponents.contains(component)) continue;
                    affectedComponents.add(component);
                }
            }
            DeleteSharedResult result = new DeleteSharedResult(0, false);
            if (!affectedComponents.isEmpty()) {
                result = this.showDeleteDialog(affectedComponents);
            }
            if (result.choice == 0) {
                this.undoManager.newEdit();
                ArrayList<TAPNQuery> affectedQueries = new ArrayList();
                if (this.sharedPlacesAndTransitionsPanel.isDisplayingTransitions()) {
                    affectedQueries = this.findAffectedTransitionQueries(this.list.getSelectedValuesList());
                    for (Object transition : this.list.getSelectedValuesList()) {
                        this.deleteSharedTransition(result.deleteFromTemplates, (SharedTransition)transition, affectedQueries);
                    }
                } else {
                    affectedQueries = this.findAffectedPlaceQueries(this.list.getSelectedValuesList());
                    for (Object place : this.list.getSelectedValuesList()) {
                        this.deleteSharedPlace(result.deleteFromTemplates, (SharedPlace)place, affectedQueries);
                    }
                }
            }
        }
    }

    private void deleteSharedPlace(boolean deleteFromTemplates, SharedPlace placeToRemove, Collection<TAPNQuery> affectedQueries) {
        if (affectedQueries.size() > 0 && !this.messageShown) {
            this.messageShown = true;
            StringBuilder buffer = new StringBuilder("The following queries contains the shared place and will also be deleted:");
            buffer.append(System.getProperty("line.separator"));
            buffer.append(System.getProperty("line.separator"));
            for (TAPNQuery query : affectedQueries) {
                buffer.append(query.getName());
                buffer.append(System.getProperty("line.separator"));
            }
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Do you want to continue?");
            int choice = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), buffer.toString(), "Warning", 0, 2);
            if (choice == 1) {
                return;
            }
            DeleteQueriesCommand cmd = new DeleteQueriesCommand(this.tab, affectedQueries);
            cmd.redo();
            this.undoManager.addEdit(cmd);
        }
        if (deleteFromTemplates) {
            for (Template template : this.tab.allTemplates()) {
                TimedPlaceComponent place = (TimedPlaceComponent)template.guiModel().getPlaceByName(placeToRemove.name());
                if (place == null) continue;
                ArrayList<Arc> arcsToDelete = new ArrayList<Arc>();
                for (Arc arc2 : place.getPreset()) {
                    arcsToDelete.add(arc2);
                }
                for (Arc arc2 : place.getPostset()) {
                    arcsToDelete.add(arc2);
                }
                arcsToDelete.forEach(arc -> this.deleteArc((Arc)arc, template));
                DeleteTimedPlaceCommand cmd = new DeleteTimedPlaceCommand(place, template.model(), template.guiModel());
                cmd.redo();
                this.undoManager.addEdit(cmd);
            }
            this.tab.drawingSurface().repaint();
            this.sharedPlacesListModel.removeElement(placeToRemove);
            this.undoManager.addEdit(new DeleteSharedPlaceCommand(placeToRemove, this.sharedPlacesListModel));
        } else {
            Hashtable<LocalTimedPlace, String> createdPlaces = new Hashtable<LocalTimedPlace, String>();
            for (Template template : this.tab.allTemplates()) {
                TimedPlace place = template.model().getPlaceByName(placeToRemove.name());
                TimedPlaceComponent component = (TimedPlaceComponent)template.guiModel().getPlaceByName(placeToRemove.name());
                if (place == null) continue;
                String name = this.nameGenerator.getNewPlaceName(template.model());
                LocalTimedPlace localPlace = new LocalTimedPlace(name);
                createdPlaces.put(localPlace, name);
                UnsharePlaceCommand cmd = new UnsharePlaceCommand(template.model(), placeToRemove, localPlace, component);
                cmd.redo();
                this.undoManager.addEdit(cmd);
            }
            DeleteSharedPlaceCommand deleteCmd = new DeleteSharedPlaceCommand(placeToRemove, this.sharedPlacesListModel);
            deleteCmd.redo();
            this.undoManager.addEdit(deleteCmd);
            for (Map.Entry entry : createdPlaces.entrySet()) {
                RenameTimedPlaceCommand renameCmd = new RenameTimedPlaceCommand(this.tab, (LocalTimedPlace)entry.getKey(), (String)entry.getValue(), placeToRemove.name());
                renameCmd.redo();
                this.undoManager.addEdit(renameCmd);
            }
        }
    }

    private Collection<TAPNQuery> findAffectedPlaceQueries(List<Object> sharedPlaces) {
        ArrayList<TAPNQuery> queries = new ArrayList<TAPNQuery>();
        for (Object sharedPlace : sharedPlaces) {
            ContainsSharedPlaceVisitor visitor = new ContainsSharedPlaceVisitor(((SharedPlace)sharedPlace).name());
            for (TAPNQuery query : this.tab.queries()) {
                BooleanResult result = new BooleanResult();
                query.getProperty().accept(visitor, result);
                if (!result.result() || queries.contains(query)) continue;
                queries.add(query);
            }
        }
        return queries;
    }

    private Collection<TAPNQuery> findAffectedTransitionQueries(List<Object> sharedTransitions) {
        ArrayList<TAPNQuery> queries = new ArrayList<TAPNQuery>();
        for (Object sharedTransition : sharedTransitions) {
            ContainsSharedTransitionVisitor visitor = new ContainsSharedTransitionVisitor(((SharedTransition)sharedTransition).name());
            for (TAPNQuery query : this.tab.queries()) {
                BooleanResult result = new BooleanResult();
                query.getProperty().accept(visitor, result);
                if (!result.result() || queries.contains(query)) continue;
                queries.add(query);
            }
        }
        return queries;
    }

    private Command createDeleteArcCommand(Template template, Arc arc, DrawingSurfaceImpl drawingSurface) {
        if (arc instanceof TimedInhibitorArcComponent) {
            return new DeleteTimedInhibitorArcCommand((TimedInhibitorArcComponent)arc, template.model(), template.guiModel());
        }
        if (arc instanceof TimedTransportArcComponent) {
            TimedTransportArcComponent component = (TimedTransportArcComponent)arc;
            return new DeleteTransportArcCommand(component, component.underlyingTransportArc(), template.model(), template.guiModel());
        }
        if (arc instanceof TimedInputArcComponent) {
            return new DeleteTimedInputArcCommand((TimedInputArcComponent)arc, template.model(), template.guiModel());
        }
        return new DeleteTimedOutputArcCommand((TimedOutputArcComponent)arc, template.model(), template.guiModel());
    }

    private void deleteArc(Arc arc, Template template) {
        Command cmd = this.createDeleteArcCommand(template, arc, this.tab.drawingSurface());
        cmd.redo();
        this.undoManager.addEdit(cmd);
    }

    private void deleteSharedTransition(boolean deleteFromTemplates, SharedTransition transitionToBeRemoved, Collection<TAPNQuery> affectedQueries) {
        if (affectedQueries.size() > 0 && !this.messageShown) {
            this.messageShown = true;
            StringBuilder buffer = new StringBuilder("The following queries contains the shared transition and will also be deleted:");
            buffer.append(System.getProperty("line.separator"));
            buffer.append(System.getProperty("line.separator"));
            for (TAPNQuery tAPNQuery : affectedQueries) {
                buffer.append(tAPNQuery.getName());
                buffer.append(System.getProperty("line.separator"));
            }
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Do you want to continue?");
            int choice = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), buffer.toString(), "Warning", 0, 2);
            if (choice == 1) {
                return;
            }
            DeleteQueriesCommand deleteQueriesCommand = new DeleteQueriesCommand(this.tab, affectedQueries);
            deleteQueriesCommand.redo();
            this.undoManager.addEdit(deleteQueriesCommand);
        }
        if (deleteFromTemplates) {
            for (Template template : this.tab.allTemplates()) {
                TimedTransitionComponent timedTransitionComponent = (TimedTransitionComponent)template.guiModel().getTransitionByName(transitionToBeRemoved.name());
                if (timedTransitionComponent == null) continue;
                ArrayList<Arc> arcsToDelete = new ArrayList<Arc>();
                for (Arc arc2 : timedTransitionComponent.getPreset()) {
                    arcsToDelete.add(arc2);
                }
                for (Arc arc2 : timedTransitionComponent.getPostset()) {
                    arcsToDelete.add(arc2);
                }
                arcsToDelete.forEach(arc -> this.deleteArc((Arc)arc, template));
                DeleteTimedTransitionCommand c = new DeleteTimedTransitionCommand(timedTransitionComponent, timedTransitionComponent.underlyingTransition().model(), template.guiModel());
                this.undoManager.addEdit(c);
                c.redo();
            }
            this.tab.drawingSurface().repaint();
            this.sharedTransitionsListModel.removeElement(transitionToBeRemoved);
            this.undoManager.addEdit(new DeleteSharedTransitionCommand(transitionToBeRemoved, this.sharedTransitionsListModel));
        } else {
            ArrayList<TimedTransition> transitions = new ArrayList<TimedTransition>();
            for (Template template : this.tab.allTemplates()) {
                TimedTransition timedTransition = template.model().getTransitionByName(transitionToBeRemoved.name());
                if (timedTransition == null) continue;
                transitions.add(timedTransition);
            }
            for (TimedTransition timedTransition : transitions) {
                timedTransition.unshare();
                this.undoManager.addEdit(new UnshareTransitionCommand(transitionToBeRemoved, timedTransition));
            }
            this.sharedTransitionsListModel.removeElement(transitionToBeRemoved);
            this.undoManager.addEdit(new DeleteSharedTransitionCommand(transitionToBeRemoved, this.sharedTransitionsListModel));
            for (TimedTransition timedTransition : transitions) {
                String name = this.nameGenerator.getNewTransitionName(timedTransition.model());
                RenameTimedTransitionCommand renameCommand = new RenameTimedTransitionCommand(this.tab, timedTransition, name, timedTransition.name());
                renameCommand.redo();
                this.undoManager.addEdit(renameCommand);
            }
        }
    }

    public ArrayList<String> getComponentsUsingThisTransition(SharedTransition transition) {
        ArrayList<String> components = new ArrayList<String>();
        for (Template t : this.tab.allTemplates()) {
            TimedTransition tt = t.model().getTransitionByName(transition.name());
            if (tt == null) continue;
            components.add(t.model().name());
        }
        return components;
    }

    private static class DeleteSharedResult {
        public final int choice;
        public final boolean deleteFromTemplates;

        public DeleteSharedResult(int choice, boolean deleteFromTemplates) {
            this.choice = choice;
            this.deleteFromTemplates = deleteFromTemplates;
        }
    }
}

