/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.util.Require;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.editor.ColorTypeDialogPanel;
import net.tapaal.gui.petrinet.editor.ColortypeListCellRenderer;
import net.tapaal.gui.petrinet.editor.ConstantsDialogPanel;
import net.tapaal.gui.petrinet.editor.ConstantsListModel;
import net.tapaal.gui.petrinet.editor.ManuallyEditDialogPanel;
import net.tapaal.gui.petrinet.editor.VariablesDialogPanel;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.undo.SortConstantsCommand;
import net.tapaal.gui.petrinet.widgets.SidePane;
import net.tapaal.gui.swingcomponents.NonsearchableJList;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.undo.UndoManager;

public class ConstantsPane
extends JPanel
implements SidePane {
    private final JPanel constantsPanel;
    private final JPanel buttonsPanel;
    private final ColorTypesListModel colorTypesListModel;
    private final VariablesListModel variablesListModel;
    private final JList<?> list;
    private final ConstantsListModel constantsListModel;
    private JButton editBtn;
    private JButton removeBtn;
    private JButton addConstantButton;
    private JButton manuallyEditBtn;
    private final PetriNetTab tab;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton sortButton;
    private static final String titleBorder = "Global constants, Color types and Variables";
    private static final String titleBorderNoColor = "Global constants";
    private static final String titleBorderSMC = "Global constants and SMC Settings";
    private static final String titleBorderToolTip = "<html>Declaration of colors types, color variables and global integer constants.<br>To see a summary list press SHIFT + F</html>";
    private static final String titleBorderToolTipNoColor = "Declaration of global constants that can be used in intervals and age invariants";
    private static final String titleBorderToolTipSmc = "Declaration of global constants that can be used in intervals and age invariants, and editing of SMC engine settings";
    private static final String CONSTANTS = "Constants";
    private static final String COLORTYPES = "Color type";
    private static final String VARIABLES = "Variables";
    private static final String SMC_SETTINGS = "SMC Settings";
    private final JComboBox<String> constantsColorTypesVariablesComboBox = new JComboBox<String>(new String[]{"Color type", "Variables", "Constants"});
    private static final String toolTipComboBox = "Switch between constants, colors and variables";
    private static final String toolTipManuallyEdit = "Manualy edit the values of all constants, color types and variables";
    private static final String toolTipEditConstant = "Edit the value of the selected constant";
    private static final String toolTipRemoveConstant = "Remove the selected constant";
    private static final String toolTipNewConstant = "Create a new constant";
    private static final String toolTipSortConstants = "Sort the constants alphabetically";
    private static final String toolTipMoveUpConstant = "Move the selected constant up";
    private static final String toolTipMoveDownConstant = "Move the selected constant down";
    private static final String toolTipConstantList = "Shows every constant. displays the name and its assigned value";
    private static final String toolTipEditVariable = "Edit the value of the selected variable";
    private static final String toolTipRemoveVariable = "Remove the selected variable";
    private static final String toolTipNewVariable = "Create a new Variable";
    private static final String toolTipSortVariables = "sort the variables alphabetically";
    private static final String toolTipMoveUpVariable = "Move the selected variable up";
    private static final String toolTipMoveDownVariable = "Move the selected variable down";
    private static final String toolTipVariableList = "Displays all variables. Is only used for CPN. Shows";
    private static final String toolTipEditColorType = "Edit the value of the selected color type";
    private static final String toolTipRemoveColorType = "Remove the selected color type";
    private static final String toolTipNewColorType = "Create a new color type";
    private static final String toolTipSortColorTypes = "Sort the color types alphabetically";
    private static final String toolTipMoveUpColorType = "Move the selected color type up";
    private static final String toolTipMoveDownColorType = "Move down the selected color type";
    private static final String toolTipColorTypeList = "Shows all color types and product types. Product types are noted with DOMAIN. only usable in CPN";
    Timer timer;

    public ConstantsPane(final PetriNetTab currentTab) {
        this.tab = currentTab;
        this.list = new NonsearchableJList();
        this.list.setSelectionMode(2);
        this.constantsPanel = new JPanel(new GridBagLayout());
        this.buttonsPanel = new JPanel(new GridBagLayout());
        this.colorTypesListModel = new ColorTypesListModel(this.tab.network());
        this.variablesListModel = new VariablesListModel(this.tab.network());
        this.constantsListModel = new ConstantsListModel(this.tab.network());
        this.constantsListModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent arg0) {
            }

            @Override
            public void intervalAdded(ListDataEvent arg0) {
                ConstantsPane.this.list.setSelectedIndex(arg0.getIndex0());
                ConstantsPane.this.list.ensureIndexIsVisible(arg0.getIndex0());
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
                int index = arg0.getIndex0() == 0 ? 0 : arg0.getIndex0() - 1;
                ConstantsPane.this.list.setSelectedIndex(index);
                ConstantsPane.this.list.ensureIndexIsVisible(index);
            }
        });
        this.list.addListSelectionListener(e -> this.updateButtons());
        this.list.setCellRenderer(new ColortypeListCellRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (!ConstantsPane.this.list.isSelectionEmpty()) {
                    int index = ConstantsPane.this.list.locationToIndex(arg0.getPoint());
                    ListModel<?> dlm = ConstantsPane.this.list.getModel();
                    ConstantsPane.this.list.ensureIndexIsVisible(index);
                    ConstantsPane.this.highlightConstant(index);
                    if (arg0.getButton() == 1 && arg0.getClickCount() == 2) {
                        if (ConstantsPane.this.isDisplayingGlobalConstants()) {
                            Constant c = (Constant)dlm.getElementAt(index);
                            ConstantsPane.this.showEditConstantDialog(c);
                        } else if (ConstantsPane.this.isDisplayingVariables()) {
                            Variable v = (Variable)dlm.getElementAt(index);
                            ArrayList<String> messages = new ArrayList<String>();
                            if (ConstantsPane.this.tab.network().canVariableBeRemoved(v, messages)) {
                                ConstantsPane.this.showEditVariableDialog(v);
                            } else {
                                Object message = "Variable cannot be edited for the following reasons: \n\n";
                                message = (String)message + String.join((CharSequence)"\n", messages);
                                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, "Could not edit variable", 2);
                            }
                        } else {
                            ColorType ct = (ColorType)dlm.getElementAt(index);
                            if (ct.equals(ColorType.COLORTYPE_DOT)) {
                                JOptionPane.showMessageDialog(null, "Dot color cannot be edited");
                            } else {
                                ConstantsPane.this.showEditColorTypeDialog(ct);
                            }
                        }
                    }
                }
            }
        });
        this.list.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ ConstantsPane this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
                Constant c;
                ListModel<?> model = this.this$0.list.getModel();
                if (model.getSize() > 0 && this.this$0.isDisplayingGlobalConstants() && (c = (Constant)model.getElementAt(this.this$0.list.getSelectedIndex())) != null) {
                    if (arg0.getKeyCode() == 37) {
                        if (c.lowerBound() != c.value()) {
                            Command edit = this.this$0.tab.network().updateConstant(c.name(), new Constant(c.name(), c.value() - 1));
                            currentTab.getUndoManager().addNewEdit(edit);
                            this.this$0.tab.network().buildConstraints();
                        }
                    } else if (arg0.getKeyCode() == 39) {
                        if (c.upperBound() != c.value()) {
                            Command edit = this.this$0.tab.network().updateConstant(c.name(), new Constant(c.name(), c.value() + 1));
                            currentTab.getUndoManager().addNewEdit(edit);
                            this.this$0.tab.network().buildConstraints();
                        }
                    } else if (arg0.getKeyCode() == 38) {
                        if (this.this$0.list.getSelectedIndex() > 0) {
                            this.this$0.highlightConstant(this.this$0.list.getSelectedIndex() - 1);
                        }
                    } else if (arg0.getKeyCode() == 40 && this.this$0.list.getSelectedIndex() < this.this$0.list.getModel().getSize() - 1) {
                        this.this$0.highlightConstant(this.this$0.list.getSelectedIndex() + 1);
                    }
                }
            }
        });
        this.addConstantsComponents();
        this.addConstantsButtons();
        this.list.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ConstantsPane.this.removeConstantHighlights();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.constantsPanel, "Center");
        this.add((Component)this.buttonsPanel, "Last");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(titleBorder), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.setToolTipText(titleBorderToolTip);
        this.addComponentListener(new ComponentListener(){
            final int minimumHegiht;
            {
                this.minimumHegiht = ConstantsPane.this.getMinimumSize().height;
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ConstantsPane.this.sortButton.setVisible(ConstantsPane.this.getSize().height > this.minimumHegiht);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.setMinimumSize(new Dimension(this.getMinimumSize().width, this.getMinimumSize().height - this.sortButton.getMinimumSize().height));
        this.setPreferredSize(new Dimension(this.getMinimumSize().width, this.getMinimumSize().height - this.sortButton.getMinimumSize().height));
        this.hideIrrelevantInformation();
        this.enableButtons(false);
    }

    private void hideIrrelevantInformation() {
        if (!this.tab.getLens().isColored()) {
            this.constantsColorTypesVariablesComboBox.setVisible(false);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(titleBorderNoColor), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.setToolTipText(titleBorderToolTipNoColor);
            this.list.setModel(this.constantsListModel);
            this.list.setToolTipText(toolTipConstantList);
            this.addConstantButton.setToolTipText(toolTipNewConstant);
            this.editBtn.setToolTipText(toolTipEditConstant);
            this.removeBtn.setToolTipText(toolTipRemoveConstant);
            this.moveDownButton.setToolTipText(toolTipMoveDownConstant);
            this.moveUpButton.setToolTipText(toolTipMoveUpConstant);
            this.sortButton.setToolTipText(toolTipSortConstants);
            this.constantsColorTypesVariablesComboBox.setSelectedItem(CONSTANTS);
        } else {
            this.list.setModel(this.colorTypesListModel);
            this.constantsColorTypesVariablesComboBox.setVisible(true);
        }
    }

    private void updateButtons() {
        int index = this.list.getSelectedIndex();
        if (index == -1 || this.list.getSelectedValuesList().isEmpty()) {
            this.editBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        } else {
            if (this.list.getSelectedValue() != null && this.list.getSelectedValue().equals(ColorType.COLORTYPE_DOT)) {
                this.editBtn.setEnabled(false);
                this.removeBtn.setEnabled(false);
            } else {
                this.removeBtn.setEnabled(true);
                this.editBtn.setEnabled(true);
            }
            this.moveDownButton.setEnabled(index < this.list.getModel().getSize() - 1 && !this.list.getSelectedValuesList().isEmpty());
        }
        this.sortButton.setEnabled(this.list.getModel().getSize() >= 2);
        this.moveUpButton.setEnabled(index > 0 && !this.list.getSelectedValuesList().isEmpty());
    }

    private void enableButtons(boolean afterRemoving) {
        if (this.list.getSelectedIndex() != -1 && this.list.getModel().getSize() > 0) {
            if (afterRemoving) {
                if (this.list.getSelectedIndex() == this.list.getModel().getSize()) {
                    this.editBtn.setEnabled(false);
                    this.removeBtn.setEnabled(false);
                    this.moveDownButton.setEnabled(false);
                    this.moveUpButton.setEnabled(false);
                } else if (this.list.getSelectedIndex() + 1 == this.list.getModel().getSize()) {
                    this.moveDownButton.setEnabled(false);
                }
            } else {
                this.editBtn.setEnabled(true);
                this.removeBtn.setEnabled(true);
                if (this.list.getSelectedIndex() > 0) {
                    this.moveUpButton.setEnabled(true);
                }
                if (this.list.getSelectedIndex() != this.list.getModel().getSize() - 1) {
                    this.moveDownButton.setEnabled(true);
                }
            }
            if (this.list.getSelectedValue() != null && this.list.getSelectedValue().equals(ColorType.COLORTYPE_DOT)) {
                this.editBtn.setEnabled(false);
                this.removeBtn.setEnabled(false);
            }
        } else {
            this.editBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
        }
    }

    private void highlightConstant(int index) {
        if (this.isDisplayingColorTypes() || this.isDisplayingVariables()) {
            return;
        }
        ListModel<?> model = this.list.getModel();
        Constant c = (Constant)model.getElementAt(index);
        if (this.timer != null) {
            this.timer.stop();
        }
        if (c != null && !c.hasFocus()) {
            int i;
            for (i = 0; i < model.getSize(); ++i) {
                ((Constant)model.getElementAt(i)).setFocused(false);
            }
            for (i = 0; i < model.getSize(); ++i) {
                ((Constant)model.getElementAt(i)).setVisible(true);
            }
            c.setFocused(true);
            this.tab.drawingSurface().repaintAll();
            this.blinkConstant(c);
        }
    }

    public void removeConstantHighlights() {
        if (this.isDisplayingColorTypes() || this.isDisplayingVariables()) {
            return;
        }
        ListModel<?> model = this.list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ((Constant)model.getElementAt(i)).setFocused(false);
        }
        try {
            this.tab.drawingSurface().repaintAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void blinkConstant(final Constant c) {
        this.timer = new Timer(300, new ActionListener(){
            final long startTime = System.currentTimeMillis();
            final /* synthetic */ ConstantsPane this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (System.currentTimeMillis() - this.startTime < 2100L) {
                    if (!c.getVisible()) {
                        c.setVisible(true);
                        this.this$0.tab.drawingSurface().repaintAll();
                    } else {
                        c.setVisible(false);
                        this.this$0.tab.drawingSurface().repaintAll();
                    }
                } else {
                    ((Timer)e.getSource()).stop();
                }
            }
        });
        this.timer.setRepeats(true);
        this.timer.setCoalesce(true);
        this.timer.restart();
    }

    private void addConstantsButtons() {
        this.editBtn = new JButton("Edit");
        this.editBtn.setEnabled(false);
        this.editBtn.setToolTipText(toolTipEditColorType);
        this.editBtn.addActionListener(e -> {
            if (this.isDisplayingVariables()) {
                Variable v = (Variable)this.list.getSelectedValue();
                ArrayList<String> messages = new ArrayList<String>();
                if (this.tab.network().canVariableBeRemoved(v, messages)) {
                    this.showEditVariableDialog(v);
                } else {
                    Object message = "Variable cannot be edited for the following reasons: \n\n";
                    message = (String)message + String.join((CharSequence)"\n", messages);
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, "Could not edit variable", 2);
                }
            } else if (this.isDisplayingGlobalConstants()) {
                Constant c = (Constant)this.list.getSelectedValue();
                this.showEditConstantDialog(c);
            } else {
                ColorType ct = (ColorType)this.list.getSelectedValue();
                if (ct.equals(ColorType.COLORTYPE_DOT)) {
                    JOptionPane.showMessageDialog(null, "Dot color cannot be edited");
                } else {
                    this.showEditColorTypeDialog(ct);
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.buttonsPanel.add((Component)this.editBtn, gbc);
        this.removeBtn = new JButton("Remove");
        this.removeBtn.setEnabled(false);
        this.removeBtn.setToolTipText(toolTipRemoveColorType);
        this.removeBtn.addActionListener(e -> {
            if (this.isDisplayingGlobalConstants()) {
                this.removeConstants();
            } else if (this.isDisplayingVariables()) {
                this.removeVariables();
            } else {
                this.removeColorType();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.anchor = 17;
        this.buttonsPanel.add((Component)this.removeBtn, gbc);
        this.addConstantButton = new JButton("New");
        this.addConstantButton.setToolTipText(toolTipNewColorType);
        this.addConstantButton.setEnabled(true);
        this.addConstantButton.addActionListener(e -> {
            if (this.isDisplayingGlobalConstants()) {
                this.showEditConstantDialog(null);
            } else if (this.isDisplayingVariables()) {
                this.showEditVariableDialog(null);
            } else if (this.isDisplayingColorTypes()) {
                this.showEditColorTypeDialog(null);
            }
            this.enableButtons(false);
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.anchor = 17;
        this.buttonsPanel.add((Component)this.addConstantButton, gbc);
        this.manuallyEditBtn = new JButton("Manual edit");
        this.manuallyEditBtn.setToolTipText(toolTipManuallyEdit);
        this.manuallyEditBtn.addActionListener(e -> this.showEditManuallyDialog());
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 10;
        this.buttonsPanel.add((Component)this.manuallyEditBtn, gbc);
    }

    public void showConstants() {
        TimedArcPetriNetNetwork model = this.tab.network();
        if (model == null) {
            return;
        }
        this.constantsListModel.updateAll();
        this.updateButtons();
    }

    private void addConstantsComponents() {
        this.constantsColorTypesVariablesComboBox.setToolTipText(toolTipComboBox);
        this.constantsColorTypesVariablesComboBox.addActionListener(e -> {
            String selectedItem;
            JComboBox source = (JComboBox)e.getSource();
            switch (selectedItem = Objects.requireNonNull(source.getSelectedItem()).toString()) {
                case "Constants": {
                    this.list.setModel(this.constantsListModel);
                    this.list.setToolTipText(toolTipConstantList);
                    this.addConstantButton.setToolTipText(toolTipNewConstant);
                    this.editBtn.setToolTipText(toolTipEditConstant);
                    this.removeBtn.setToolTipText(toolTipRemoveConstant);
                    this.moveDownButton.setToolTipText(toolTipMoveDownConstant);
                    this.moveUpButton.setToolTipText(toolTipMoveUpConstant);
                    this.sortButton.setToolTipText(toolTipSortConstants);
                    break;
                }
                case "Color type": {
                    this.list.setModel(this.colorTypesListModel);
                    this.list.setToolTipText(toolTipColorTypeList);
                    this.addConstantButton.setToolTipText(toolTipNewColorType);
                    this.editBtn.setToolTipText(toolTipEditColorType);
                    this.removeBtn.setToolTipText(toolTipRemoveColorType);
                    this.moveDownButton.setToolTipText(toolTipMoveDownColorType);
                    this.moveUpButton.setToolTipText(toolTipMoveUpColorType);
                    this.sortButton.setToolTipText(toolTipSortColorTypes);
                    break;
                }
                case "Variables": {
                    this.list.setModel(this.variablesListModel);
                    this.list.setToolTipText(toolTipVariableList);
                    this.addConstantButton.setToolTipText(toolTipNewVariable);
                    this.editBtn.setToolTipText(toolTipEditVariable);
                    this.removeBtn.setToolTipText(toolTipRemoveVariable);
                    this.moveDownButton.setToolTipText(toolTipMoveDownVariable);
                    this.moveUpButton.setToolTipText(toolTipMoveUpVariable);
                    this.sortButton.setToolTipText(toolTipSortVariables);
                }
            }
            if (this.list.getModel().getSize() > 0) {
                this.list.setSelectedIndex(0);
                this.list.ensureIndexIsVisible(0);
            }
            this.enableButtons(false);
        });
        GridBagConstraints gbc = new GridBagConstraints();
        this.constantsColorTypesVariablesComboBox.setBackground(Color.white);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.fill = 2;
        this.constantsPanel.add(this.constantsColorTypesVariablesComboBox, gbc);
        JScrollPane constantsScroller = new JScrollPane(this.list);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        this.constantsPanel.add((Component)constantsScroller, gbc);
        this.moveUpButton = new JButton(new ImageIcon(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("Images/Up.png"))));
        this.moveUpButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setToolTipText(toolTipMoveUpColorType);
        this.moveUpButton.addActionListener(e -> {
            int index = this.list.getSelectedIndex();
            if (this.isDisplayingVariables() && index > 0) {
                this.tab.network().swapVariables(index, index - 1);
                this.variablesListModel.updateName();
                this.list.setSelectedIndex(index - 1);
            } else if (this.isDisplayingGlobalConstants() && index > 0) {
                this.tab.swapConstants(index, index - 1);
                this.showConstants();
                this.list.setSelectedIndex(index - 1);
            } else if (this.isDisplayingColorTypes() && index > 0) {
                this.tab.network().swapColorTypes(index, index - 1);
                this.colorTypesListModel.updateName();
                this.list.setSelectedIndex(index - 1);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 11;
        this.constantsPanel.add((Component)this.moveUpButton, gbc);
        this.moveDownButton = new JButton(new ImageIcon(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("Images/Down.png"))));
        this.moveDownButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setToolTipText(toolTipMoveDownColorType);
        this.moveDownButton.addActionListener(e -> {
            int index = this.list.getSelectedIndex();
            if (this.isDisplayingVariables() && index < this.tab.network().numberOfVariables() - 1) {
                this.tab.network().swapVariables(index, index + 1);
                this.variablesListModel.updateName();
                this.list.setSelectedIndex(index + 1);
            } else if (this.isDisplayingGlobalConstants() && index < this.tab.network().constants().size() - 1) {
                this.tab.swapConstants(index, index + 1);
                this.showConstants();
                this.list.setSelectedIndex(index + 1);
            } else if (this.isDisplayingColorTypes() && index < this.tab.network().numberOfColorTypes() - 1) {
                this.tab.network().swapColorTypes(index, index + 1);
                this.colorTypesListModel.updateName();
                this.list.setSelectedIndex(index + 1);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 11;
        this.constantsPanel.add((Component)this.moveDownButton, gbc);
        this.sortButton = new JButton(new ImageIcon(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("Images/Sort.png"))));
        this.sortButton.setMargin(new Insets(2, 2, 2, 2));
        this.sortButton.setToolTipText(toolTipSortColorTypes);
        this.sortButton.setEnabled(false);
        this.sortButton.addActionListener(e -> {
            if (this.isDisplayingGlobalConstants()) {
                SortConstantsCommand sortConstantsCommand = new SortConstantsCommand(this.tab, this);
                this.tab.getUndoManager().addNewEdit(sortConstantsCommand);
                sortConstantsCommand.redo();
            } else if (this.isDisplayingVariables()) {
                this.variablesListModel.sort();
            } else {
                this.colorTypesListModel.sort();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 11;
        this.constantsPanel.add((Component)this.sortButton, gbc);
    }

    private void showEditConstantDialog(Constant constant) {
        ConstantsDialogPanel panel = new ConstantsDialogPanel(this.tab.network(), constant);
        panel.showDialog();
        this.showConstants();
    }

    private void showEditVariableDialog(Variable variable) {
        VariablesDialogPanel panel = null;
        if (variable != null) {
            try {
                panel = new VariablesDialogPanel(new JRootPane(), this.variablesListModel, this.tab.network(), variable, this.tab.getUndoManager());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                panel = new VariablesDialogPanel(new JRootPane(), this.variablesListModel, this.tab.network(), this.tab.getUndoManager());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        panel.showDialog();
        this.variablesListModel.updateName();
    }

    private void showEditColorTypeDialog(ColorType colorType) {
        UndoManager undoManager = this.tab.getUndoManager();
        ColorTypeDialogPanel panel = colorType != null ? new ColorTypeDialogPanel(this.colorTypesListModel, this.tab.network(), colorType, undoManager) : new ColorTypeDialogPanel(this.colorTypesListModel, this.tab.network(), undoManager);
        panel.showDialog();
    }

    private void showEditManuallyDialog() {
        UndoManager undoManager = this.tab.getUndoManager();
        ManuallyEditDialogPanel panel = new ManuallyEditDialogPanel(this.colorTypesListModel, this.variablesListModel, this.constantsListModel, this.tab.network(), undoManager);
        panel.showDialog();
    }

    protected void removeConstants() {
        TimedArcPetriNetNetwork model = this.tab.network();
        ArrayList<String> unremovableConstants = new ArrayList<String>();
        this.tab.getUndoManager().newEdit();
        for (Object o : this.list.getSelectedValuesList()) {
            String name = ((Constant)o).name();
            Command command = model.removeConstant(name);
            if (command == null) {
                unremovableConstants.add(name);
                continue;
            }
            this.tab.getUndoManager().addEdit(command);
        }
        if (unremovableConstants.size() > 0) {
            StringBuilder message = new StringBuilder("The following constants could not be removed: \n");
            for (String name : unremovableConstants) {
                message.append("   - ");
                message.append(name);
                message.append("\n");
            }
            message.append("\nYou cannot remove a constant that is used in the net.\nRemove all references to the constant(s) in the net and try again.");
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message.toString(), "Constant in use", 0);
        }
    }

    private void removeVariables() {
        for (Object variable : this.list.getSelectedValuesList()) {
            if (!(variable instanceof Variable)) continue;
            this.variablesListModel.removeElement((Variable)variable);
        }
    }

    private void removeColorType() {
        for (Object colorType : this.list.getSelectedValuesList()) {
            if (!(colorType instanceof ColorType)) continue;
            if (colorType.equals(ColorType.COLORTYPE_DOT)) {
                JOptionPane.showMessageDialog(null, "Dot color cannot be removed");
                continue;
            }
            this.colorTypesListModel.removeElement((ColorType)colorType);
        }
    }

    public void setNetwork(TimedArcPetriNetNetwork tapnNetwork) {
        this.constantsListModel.setNetwork(tapnNetwork);
    }

    public void selectFirst() {
        this.list.setSelectedIndex(0);
    }

    protected boolean isDisplayingGlobalConstants() {
        return this.constantsColorTypesVariablesComboBox.getSelectedItem().equals(CONSTANTS);
    }

    protected boolean isDisplayingColorTypes() {
        return this.constantsColorTypesVariablesComboBox.getSelectedItem().equals(COLORTYPES);
    }

    protected boolean isDisplayingVariables() {
        return this.constantsColorTypesVariablesComboBox.getSelectedItem().equals(VARIABLES);
    }

    @Override
    public void moveUp(int index) {
        this.tab.swapConstants(index, index - 1);
        this.showConstants();
    }

    @Override
    public void moveDown(int index) {
        this.tab.swapConstants(index, index + 1);
        this.showConstants();
    }

    @Override
    public JList<?> getJList() {
        return this.list;
    }

    public class ColorTypesListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private TimedArcPetriNetNetwork network;

        public ColorTypesListModel(TimedArcPetriNetNetwork network) {
            Require.that(network != null, "network must not be null");
            this.addListDataListener(new ListDataListener(){
                final /* synthetic */ ColorTypesListModel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void intervalAdded(ListDataEvent arg0) {
                    this.this$1.ConstantsPane.this.list.setSelectedIndex(arg0.getIndex0());
                    this.this$1.ConstantsPane.this.list.ensureIndexIsVisible(arg0.getIndex0());
                }

                @Override
                public void intervalRemoved(ListDataEvent arg0) {
                    int index = arg0.getIndex0() == 0 ? 0 : arg0.getIndex0() - 1;
                    this.this$1.ConstantsPane.this.list.setSelectedIndex(index);
                    this.this$1.ConstantsPane.this.list.ensureIndexIsVisible(index);
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }
            });
            this.setNetwork(network);
        }

        public ColorType[] sort() {
            ColorType[] oldOrder = this.network.sortColorTypes();
            this.fireContentsChanged(this, 0, this.getSize());
            return oldOrder;
        }

        @Override
        public int getSize() {
            return this.network.numberOfColorTypes();
        }

        @Override
        public Object getElementAt(int i) {
            return this.network.getColorTypeByIndex(i);
        }

        public void addElement(ColorType colorType) {
            this.network.add(colorType);
            this.fireIntervalAdded(this, this.network.numberOfColorTypes() - 1, this.network.numberOfColorTypes());
        }

        @Override
        public void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
            if (ConstantsPane.this.editBtn != null) {
                ConstantsPane.this.updateButtons();
            }
        }

        public void removeElement(ColorType colorType) {
            UndoManager undoManager = ConstantsPane.this.tab.getUndoManager();
            undoManager.newEdit();
            ArrayList<String> messages = new ArrayList<String>();
            this.network.remove(colorType, ConstantsPane.this.colorTypesListModel, undoManager, messages);
            if (messages.isEmpty()) {
                ConstantsPane.this.enableButtons(true);
                this.updateName();
            } else {
                Object message = "Color type could not be removed for the following reasons: \n\n";
                message = (String)message + String.join((CharSequence)"", messages);
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, "Could not remove color type", 2);
            }
        }

        public void updateName() {
            this.fireContentsChanged(this, 0, this.getSize());
            for (Template activeTemplate : ConstantsPane.this.tab.activeTemplates()) {
                activeTemplate.guiModel().repaintAll(true);
            }
        }

        public void setNetwork(TimedArcPetriNetNetwork network) {
            Require.that(network != null, "network cannot be null");
            this.network = network;
            this.fireContentsChanged(this, 0, network.numberOfColorTypes());
        }
    }

    public class VariablesListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private TimedArcPetriNetNetwork network;

        public VariablesListModel(TimedArcPetriNetNetwork network) {
            this.network = network;
            this.addListDataListener(new ListDataListener(){
                final /* synthetic */ VariablesListModel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void intervalAdded(ListDataEvent arg0) {
                    this.this$1.ConstantsPane.this.list.setSelectedIndex(arg0.getIndex0());
                    this.this$1.ConstantsPane.this.list.ensureIndexIsVisible(arg0.getIndex0());
                }

                @Override
                public void intervalRemoved(ListDataEvent arg0) {
                    int index = arg0.getIndex0() == 0 ? 0 : arg0.getIndex0() - 1;
                    this.this$1.ConstantsPane.this.list.setSelectedIndex(index);
                    this.this$1.ConstantsPane.this.list.ensureIndexIsVisible(index);
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }
            });
        }

        @Override
        public Object getElementAt(int index) {
            return this.network.getVariableByIndex(index);
        }

        public Variable[] sort() {
            Variable[] oldOrder = this.network.sortVariables();
            this.fireContentsChanged(this, 0, this.getSize());
            return oldOrder;
        }

        public void undoSort(Variable[] oldOrder) {
            this.network.undoSort(oldOrder);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public int getSize() {
            return this.network.numberOfVariables();
        }

        public void addElement(Variable variable) {
            this.network.add(variable);
            this.fireIntervalAdded(this, this.network.numberOfVariables() - 1, this.network.numberOfVariables());
        }

        public void removeElement(Variable variable) {
            UndoManager undoManager = ConstantsPane.this.tab.getUndoManager();
            undoManager.newEdit();
            ArrayList<String> messages = new ArrayList<String>();
            this.network.remove(variable, ConstantsPane.this.variablesListModel, undoManager, messages);
            if (messages.isEmpty()) {
                ConstantsPane.this.enableButtons(true);
                this.updateName();
            } else {
                Object message = "Variable could not be removed for the following reasons: \n\n";
                message = (String)message + String.join((CharSequence)"\n", messages);
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, "Could not remove variable", 2);
            }
        }

        public void updateName() {
            this.fireContentsChanged(this, 0, this.getSize());
            for (Template activeTemplate : ConstantsPane.this.tab.activeTemplates()) {
                activeTemplate.guiModel().repaintAll(true);
            }
        }

        public void setNetwork(TimedArcPetriNetNetwork network) {
            Require.that(network != null, "network cannot be null");
            this.network = network;
            this.fireContentsChanged(this, 0, network.numberOfVariables());
        }
    }
}

