/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.editor;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.tapaal.gui.petrinet.editor.ColortypeListCellRenderer;
import net.tapaal.gui.petrinet.editor.ConstantsPane;
import net.tapaal.gui.petrinet.undo.Colored.AddColorTypeCommand;
import org.jdesktop.swingx.JXComboBox;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.undo.UndoManager;
import pipe.gui.swingcomponents.EscapableDialog;

public class ColorTypeDialogPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String toolTipColorComboBox = "Switch between the different defined color types";
    private static final String finiteEnumeration = "Finite Enumeration";
    private static final String cyclicEnumeration = "Cyclic Enumeration";
    private static final String rangeOfIntegers = "Range of Integers";
    private static final String productColor = "Product Color";
    private boolean rangeOfIntegersPanelEnabled = false;
    private final TimedArcPetriNetNetwork network;
    private EscapableDialog dialog;
    private List<ColorType> colorTypes;
    private ColorType oldColorType;
    private final String oldName;
    private final ConstantsPane.ColorTypesListModel colorTypesListModel;
    private final UndoManager undoManager;
    private JTextField nameTextField;
    private JComboBox colorTypeComboBox;
    private JLabel colorTypeLabel;
    private DefaultListModel productModel;
    private JButton productRemoveButton;
    private JList productColorTypeList;
    private JComboBox productTypeComboBox;
    private JTextField lowerBoundTextField;
    private JTextField upperBoundTextField;
    private JTextField enumTextField;
    private JButton enumAddButton;
    private JPanel cyclicAndFiniteEnumerationPanel;
    private JList enumList;
    private JPanel rangeOfIntegersPanel;
    private JPanel productTypePanel;
    private DefaultListModel cyclicModel;
    private JButton cyclicRemoveButton;
    private JButton okButton;
    private JScrollPane scrollPane;
    private static final int MAXIMUM_INTEGER = 10000;

    public ColorTypeDialogPanel(ConstantsPane.ColorTypesListModel colorTypesListModel, TimedArcPetriNetNetwork network, UndoManager undoManager) {
        this.oldName = "";
        this.network = network;
        this.colorTypesListModel = colorTypesListModel;
        this.undoManager = undoManager;
        this.initComponents();
        this.nameTextField.setText(this.oldName);
    }

    public ColorTypeDialogPanel(ConstantsPane.ColorTypesListModel colorTypesListModel, TimedArcPetriNetNetwork network, ColorType colortype, UndoManager undoManager) {
        this.oldColorType = colortype;
        this.oldName = colortype.getName();
        this.undoManager = undoManager;
        this.network = network;
        this.colorTypesListModel = colorTypesListModel;
        this.initComponents();
        this.initValues();
        this.colorTypeComboBox.setVisible(false);
        this.colorTypeLabel.setVisible(false);
    }

    public void showDialog() {
        this.dialog = new EscapableDialog(TAPAALGUI.getApp(), "Edit color type", true);
        this.scrollPane.setBorder(null);
        this.dialog.add((Component)this.scrollPane, "Center");
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.setResizable(true);
        this.dialog.pack();
        this.dialog.setMinimumSize(new Dimension(447, 231));
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    private void initValues() {
        this.nameTextField.setText(this.oldName);
        if (!(this.oldColorType instanceof ProductType)) {
            if (this.oldColorType.isIntegerRange()) {
                this.colorTypeComboBox.setSelectedIndex(1);
                for (Color element : this.oldColorType) {
                    this.cyclicModel.addElement(element);
                }
                this.lowerBoundTextField.setText(this.cyclicModel.get(0).toString());
                this.upperBoundTextField.setText(this.cyclicModel.get(this.cyclicModel.getSize() - 1).toString());
            } else {
                this.colorTypeComboBox.setSelectedIndex(0);
                for (Color element : this.oldColorType) {
                    this.cyclicModel.addElement(element);
                }
            }
            this.enumList.setModel(this.cyclicModel);
        } else {
            this.colorTypeComboBox.setSelectedIndex(2);
            for (ColorType type : ((ProductType)this.oldColorType).getColorTypes()) {
                this.productModel.addElement(type);
            }
            this.productColorTypeList.setModel(this.productModel);
        }
    }

    private void initComponents() {
        JPanel container = new JPanel();
        container.setLayout(new GridBagLayout());
        JPanel nameAndTypePanel = this.createNameAndTypePanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 8, 0, 8);
        container.add((Component)nameAndTypePanel, gbc);
        this.cyclicAndFiniteEnumerationPanel = this.createCyclicAndFiniteEnumerationPanel();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 8, 0, 8);
        container.add((Component)this.cyclicAndFiniteEnumerationPanel, gbc);
        this.rangeOfIntegersPanel = this.createRangeOfIntegersPanel();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 8, 0, 8);
        container.add((Component)this.rangeOfIntegersPanel, gbc);
        this.productTypePanel = this.createProductTypePanel();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 8, 0, 8);
        container.add((Component)this.productTypePanel, gbc);
        JPanel buttonPanel = this.createButtonPanel();
        gbc.insets = new Insets(0, 8, 5, 8);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        container.add((Component)buttonPanel, gbc);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(container);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.rangeOfIntegersPanel.setVisible(false);
        this.productTypePanel.setVisible(false);
    }

    private JPanel createNameAndTypePanel() {
        JPanel nameAndTypePanel = new JPanel();
        nameAndTypePanel.setLayout(new GridBagLayout());
        nameAndTypePanel.setBorder(BorderFactory.createTitledBorder("Name of Color Type"));
        JLabel nameLabel = new JLabel();
        nameLabel.setText("Name: ");
        GridBagConstraints gbcNL = new GridBagConstraints();
        gbcNL.gridx = 0;
        gbcNL.gridy = 0;
        gbcNL.gridwidth = 1;
        gbcNL.insets = new Insets(4, 4, 2, 4);
        gbcNL.anchor = 17;
        nameAndTypePanel.add((Component)nameLabel, gbcNL);
        this.nameTextField = new JTextField();
        Dimension size = new Dimension(330, 30);
        this.nameTextField.setPreferredSize(size);
        this.nameTextField.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                1 al = this;
                JComponent component = ancestorEvent.getComponent();
                component.requestFocusInWindow();
                component.removeAncestorListener(al);
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.nameTextField.addActionListener(e -> {
            this.okButton.requestFocusInWindow();
            this.okButton.doClick();
        });
        GridBagConstraints gbcNTF = new GridBagConstraints();
        gbcNTF.gridx = 1;
        gbcNTF.gridy = 0;
        gbcNTF.gridwidth = 1;
        gbcNTF.weightx = 1.0;
        gbcNTF.anchor = 17;
        gbcNTF.fill = 2;
        gbcNTF.insets = new Insets(4, 4, 2, 4);
        this.nameTextField.requestFocusInWindow();
        nameAndTypePanel.add((Component)this.nameTextField, gbcNTF);
        this.colorTypeLabel = new JLabel();
        this.colorTypeLabel.setText("Color type: ");
        GridBagConstraints gbcCTL = new GridBagConstraints();
        gbcCTL.insets = new Insets(2, 4, 2, 4);
        gbcCTL.gridx = 0;
        gbcCTL.gridy = 1;
        gbcCTL.gridwidth = 1;
        gbcCTL.anchor = 17;
        nameAndTypePanel.add((Component)this.colorTypeLabel, gbcCTL);
        this.colorTypeComboBox = new JXComboBox((Object[])new String[]{cyclicEnumeration, rangeOfIntegers, productColor});
        this.colorTypeComboBox.setToolTipText(toolTipColorComboBox);
        this.colorTypeComboBox.addActionListener(e -> {
            String selectedString;
            JXComboBox source = (JXComboBox)e.getSource();
            switch (selectedString = source.getSelectedItem().toString()) {
                case "Finite Enumeration": 
                case "Cyclic Enumeration": {
                    this.rangeOfIntegersPanel.setVisible(false);
                    this.productTypePanel.setVisible(false);
                    this.cyclicAndFiniteEnumerationPanel.setVisible(true);
                    this.rangeOfIntegersPanelEnabled = false;
                    break;
                }
                case "Range of Integers": {
                    this.cyclicAndFiniteEnumerationPanel.setVisible(false);
                    this.productTypePanel.setVisible(false);
                    this.rangeOfIntegersPanel.setVisible(true);
                    this.rangeOfIntegersPanelEnabled = true;
                    break;
                }
                case "Product Color": {
                    this.cyclicAndFiniteEnumerationPanel.setVisible(false);
                    this.productTypePanel.setVisible(true);
                    this.rangeOfIntegersPanel.setVisible(false);
                    this.rangeOfIntegersPanelEnabled = false;
                }
            }
            if (this.dialog != null) {
                this.dialog.pack();
            }
        });
        GridBagConstraints gbcCTCB = new GridBagConstraints();
        gbcCTCB.insets = new Insets(2, 4, 2, 4);
        gbcCTCB.gridx = 1;
        gbcCTCB.gridy = 1;
        gbcCTCB.gridwidth = 1;
        gbcCTCB.weightx = 1.0;
        gbcCTCB.anchor = 13;
        gbcCTCB.fill = 2;
        nameAndTypePanel.add((Component)this.colorTypeComboBox, gbcCTCB);
        return nameAndTypePanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.okButton = new JButton("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.setMnemonic(79);
        GridBagConstraints gbcOk = new GridBagConstraints();
        gbcOk.gridx = 1;
        gbcOk.gridy = 0;
        gbcOk.anchor = 17;
        gbcOk.insets = new Insets(5, 5, 5, 5);
        this.okButton.addActionListener(actionEvent -> this.onOK());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMaximumSize(new Dimension(100, 25));
        cancelButton.setMinimumSize(new Dimension(100, 25));
        cancelButton.setPreferredSize(new Dimension(100, 25));
        cancelButton.setMnemonic(67);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 13;
        cancelButton.addActionListener(e -> this.exit());
        buttonPanel.add((Component)cancelButton, gbc);
        buttonPanel.add((Component)this.okButton, gbcOk);
        return buttonPanel;
    }

    private JPanel createRangeOfIntegersPanel() {
        JPanel rangeOfIntegers = new JPanel();
        rangeOfIntegers.setLayout(new GridBagLayout());
        rangeOfIntegers.setBorder(BorderFactory.createTitledBorder("Range Of Integers"));
        JLabel lowerBoundLabel = new JLabel("Lower Bound: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(3, 3, 3, 3);
        rangeOfIntegers.add((Component)lowerBoundLabel, gbc);
        this.lowerBoundTextField = new JTextField();
        Dimension size = new Dimension(55, 30);
        this.lowerBoundTextField.setPreferredSize(size);
        this.lowerBoundTextField.setMaximumSize(size);
        this.lowerBoundTextField.setMaximumSize(size);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 2, 4);
        rangeOfIntegers.add((Component)this.lowerBoundTextField, gbc);
        JLabel upperBoundLabel = new JLabel("Upper Bound: ");
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(3, 3, 3, 3);
        rangeOfIntegers.add((Component)upperBoundLabel, gbc);
        this.upperBoundTextField = new JTextField();
        this.upperBoundTextField.setPreferredSize(size);
        this.upperBoundTextField.setMaximumSize(size);
        this.upperBoundTextField.setMaximumSize(size);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 2, 4);
        rangeOfIntegers.add((Component)this.upperBoundTextField, gbc);
        return rangeOfIntegers;
    }

    private JPanel createCyclicAndFiniteEnumerationPanel() {
        JPanel cyclicAndFiniteEnumeration = new JPanel();
        cyclicAndFiniteEnumeration.setLayout(new GridBagLayout());
        cyclicAndFiniteEnumeration.setBorder(BorderFactory.createTitledBorder("Cyclic and Finite Enumeration"));
        cyclicAndFiniteEnumeration.setPreferredSize(new Dimension(450, 250));
        JButton moveUpButton = new JButton(new ImageIcon(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("Images/Up.png"))));
        JButton moveDownButton = new JButton(new ImageIcon(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("Images/Down.png"))));
        JPanel firstRow = new JPanel();
        firstRow.setLayout(new GridBagLayout());
        JLabel enumNameLabel = new JLabel("Element name: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        firstRow.add((Component)enumNameLabel, gbc);
        this.enumTextField = new JTextField();
        GridBagConstraints gbcNTF = new GridBagConstraints();
        gbcNTF.gridx = 1;
        gbcNTF.gridy = 0;
        gbcNTF.gridwidth = 1;
        gbcNTF.weightx = 1.0;
        gbcNTF.anchor = 17;
        gbcNTF.fill = 2;
        gbcNTF.insets = new Insets(4, 4, 2, 4);
        this.nameTextField.requestFocusInWindow();
        firstRow.add((Component)this.enumTextField, gbcNTF);
        this.enumTextField.addActionListener(e -> this.enumAddButton.doClick());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        cyclicAndFiniteEnumeration.add((Component)firstRow, gbc);
        JPanel secondRow = new JPanel();
        secondRow.setLayout(new GridBagLayout());
        this.enumAddButton = new JButton("Add");
        this.enumAddButton.addActionListener(e -> {
            String enumerationName = this.enumTextField.getText();
            if (enumerationName == null || enumerationName.trim().isEmpty()) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You have to enter a name for the color", "Error", 0);
            } else if (!Pattern.matches("[a-zA-Z]([\\_a-zA-Z0-9])*", enumerationName)) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Acceptable names for enumerations are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*", "Error", 0);
            } else if (enumerationName.equals("all") || enumerationName.equals("All") || enumerationName.equals("dot") || enumerationName.equals(".all") || enumerationName.equals(".All")) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The color cannot be named \"" + enumerationName + "\", as the name is reserved", "Error", 0);
            } else {
                boolean nameIsInUse = this.network.isNameUsedForVariable(enumerationName) || this.network.isNameUsedForColor(enumerationName, null) || this.network.isNameUsedForColorType(enumerationName) || this.network.isNameUsedForConstant(enumerationName) || this.nameTextField.getText().equals(enumerationName);
                for (int i = 0; i < this.cyclicModel.getSize(); ++i) {
                    String n = this.cyclicModel.getElementAt(i).toString();
                    if (!n.equals(enumerationName)) continue;
                    nameIsInUse = true;
                    break;
                }
                if (nameIsInUse) {
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "A color, color type, variable or constant with the name \"" + enumerationName + "\" already exists. Please chose an other name.", "Error", 0);
                } else {
                    this.cyclicModel.addElement(this.enumTextField.getText());
                    this.enumList.setModel(this.cyclicModel);
                    this.enumTextField.setText("");
                    this.cyclicRemoveButton.setEnabled(true);
                }
            }
            this.enumTextField.requestFocusInWindow();
        });
        Dimension buttonSize = new Dimension(100, 30);
        this.enumAddButton.setMaximumSize(buttonSize);
        this.enumAddButton.setMinimumSize(buttonSize);
        this.enumAddButton.setPreferredSize(buttonSize);
        this.enumAddButton.setMnemonic(65);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        secondRow.add((Component)this.enumAddButton, gbc);
        this.cyclicRemoveButton = new JButton("Remove");
        this.cyclicRemoveButton.setEnabled(false);
        this.cyclicRemoveButton.addActionListener(actionEvent -> this.removeColors());
        this.cyclicRemoveButton.setPreferredSize(buttonSize);
        this.cyclicRemoveButton.setMinimumSize(buttonSize);
        this.cyclicRemoveButton.setMaximumSize(buttonSize);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        secondRow.add((Component)this.cyclicRemoveButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        cyclicAndFiniteEnumeration.add((Component)secondRow, gbc);
        JPanel thirdRow = new JPanel();
        thirdRow.setLayout(new GridBagLayout());
        this.cyclicModel = new DefaultListModel();
        this.enumList = new JList();
        this.enumList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                JList source = (JList)e.getSource();
                if (source.getSelectedIndex() == -1) {
                    this.cyclicRemoveButton.setEnabled(false);
                    moveUpButton.setEnabled(false);
                    moveDownButton.setEnabled(false);
                } else {
                    this.cyclicRemoveButton.setEnabled(true);
                    if (source.getSelectedIndex() > 0) {
                        moveUpButton.setEnabled(true);
                    } else {
                        moveUpButton.setEnabled(false);
                    }
                    if (source.getSelectedIndex() < source.getModel().getSize() - 1) {
                        moveDownButton.setEnabled(true);
                    } else {
                        moveDownButton.setEnabled(false);
                    }
                }
            }
        });
        JScrollPane cyclicListScrollPane = new JScrollPane(this.enumList);
        cyclicListScrollPane.setViewportView(this.enumList);
        cyclicListScrollPane.setVerticalScrollBarPolicy(20);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        cyclicListScrollPane.setVisible(true);
        cyclicListScrollPane.setBorder(new LineBorder(java.awt.Color.GRAY));
        gbc.anchor = 17;
        gbc.fill = 1;
        thirdRow.add((Component)cyclicListScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 3, 3, 3);
        thirdRow.add((Component)moveUpButton, gbc);
        moveUpButton.addActionListener(e -> {
            int index = this.enumList.getSelectedIndex();
            if (index > 0) {
                this.enumList.setSelectedIndex(index - 1);
                this.swapColors(this.cyclicModel, index, index - 1);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 3, 3, 3);
        thirdRow.add((Component)moveDownButton, gbc);
        moveDownButton.addActionListener(e -> {
            int index = this.enumList.getSelectedIndex();
            if (index < this.cyclicModel.getSize() - 1) {
                this.enumList.setSelectedIndex(index + 1);
                this.swapColors(this.cyclicModel, index, index + 1);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        cyclicAndFiniteEnumeration.add((Component)thirdRow, gbc);
        if (this.enumList.getSelectedIndex() == -1) {
            moveUpButton.setEnabled(false);
            moveDownButton.setEnabled(false);
        }
        return cyclicAndFiniteEnumeration;
    }

    private void removeColorTypes() {
        ArrayList<String> messages = new ArrayList<String>();
        for (Object value : this.productColorTypeList.getSelectedValuesList()) {
            ArrayList<String> emptyMessages = new ArrayList<String>();
            if (this.oldColorType == null || this.network.canColorTypeBeRemoved(this.oldColorType, emptyMessages)) {
                this.productModel.removeElement(value);
                this.productColorTypeList.setModel(this.productModel);
            } else if (!emptyMessages.isEmpty()) {
                messages.addAll(emptyMessages);
            }
            if (this.productModel.size() != 0) continue;
            this.productRemoveButton.setEnabled(false);
        }
        if (!messages.isEmpty()) {
            Object message = "The color type cannot be modified for the following reasons: \n\n";
            for (String m : messages) {
                if (((String)message).contains(m)) continue;
                message = (String)message + m;
            }
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, "Could not remove color from color type", 2);
        }
    }

    private void removeColors() {
        ArrayList<String> messages = new ArrayList<String>();
        int[] indices = this.enumList.getSelectedIndices();
        int counter = 0;
        for (Object value : this.enumList.getSelectedValuesList()) {
            Color color;
            ArrayList<String> emptyMessages = new ArrayList<String>();
            if (!(value instanceof Color)) {
                ColorType colorType = new ColorType(this.nameTextField.getText());
                color = new Color(colorType, (Integer)indices[counter], value.toString());
            } else {
                color = (Color)value;
            }
            if (this.oldColorType == null || this.network.canColorBeRemoved(color, emptyMessages)) {
                this.cyclicModel.removeElement(value);
                this.enumList.setModel(this.cyclicModel);
            } else if (!emptyMessages.isEmpty()) {
                messages.addAll(emptyMessages);
            }
            ++counter;
        }
        if (!messages.isEmpty()) {
            Object message = "Color(s) cannot be removed for the following reasons: \n\n";
            for (String m : messages) {
                if (((String)message).contains(m)) continue;
                message = (String)message + m;
            }
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, "Could not remove color from color type", 2);
        }
    }

    private JPanel createProductTypePanel() {
        JPanel productTypePanel = new JPanel();
        productTypePanel.setLayout(new GridBagLayout());
        productTypePanel.setBorder(BorderFactory.createTitledBorder("Product Type/ Domain"));
        GridBagConstraints gbc = new GridBagConstraints();
        JButton moveUpButton = new JButton(new ImageIcon(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("Images/Up.png"))));
        JButton moveDownButton = new JButton(new ImageIcon(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("Images/Down.png"))));
        moveUpButton.setEnabled(false);
        moveDownButton.setEnabled(false);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        JLabel productLabel = new JLabel("Color types: ");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.insets = new Insets(3, 3, 3, 3);
        topPanel.add((Component)productLabel, gbc);
        this.productModel = new DefaultListModel();
        this.colorTypes = new ArrayList<ColorType>();
        this.colorTypes = this.network.colorTypes();
        this.productTypeComboBox = new JComboBox();
        this.productTypeComboBox.setRenderer(new ColortypeListCellRenderer());
        for (ColorType element : this.colorTypes) {
            if (element instanceof ProductType || element == ColorType.COLORTYPE_DOT) continue;
            this.productTypeComboBox.addItem(element);
        }
        if (this.productTypeComboBox.getItemCount() == 0) {
            this.colorTypeComboBox.removeItem(productColor);
        }
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.productTypeComboBox.setBackground(java.awt.Color.white);
        gbc.anchor = 13;
        gbc.fill = 2;
        topPanel.add((Component)this.productTypeComboBox, gbc);
        JPanel productButtonPanel = this.createProductButtonsPanel();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(3, 3, 3, 3);
        topPanel.add((Component)productButtonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        productTypePanel.add((Component)topPanel, gbc);
        JPanel scrollPanePanel = new JPanel();
        scrollPanePanel.setLayout(new GridBagLayout());
        this.productColorTypeList = new JList();
        this.productColorTypeList.setCellRenderer(new ColortypeListCellRenderer());
        this.productColorTypeList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                JList source = (JList)e.getSource();
                if (source.getSelectedIndex() == -1) {
                    this.productRemoveButton.setEnabled(false);
                    moveUpButton.setEnabled(false);
                    moveDownButton.setEnabled(false);
                } else {
                    if (source.getSelectedIndex() > 0) {
                        moveUpButton.setEnabled(true);
                    } else {
                        moveUpButton.setEnabled(false);
                    }
                    int selectedLength = source.getSelectedIndices().length - 1;
                    if (source.getSelectedIndices()[selectedLength] < source.getModel().getSize() - 1) {
                        moveDownButton.setEnabled(true);
                    } else {
                        moveDownButton.setEnabled(false);
                    }
                    this.productRemoveButton.setEnabled(true);
                }
            }
        });
        JScrollPane productColorsListScrollPane = new JScrollPane(this.productColorTypeList);
        productColorsListScrollPane.setViewportView(this.productColorTypeList);
        productColorsListScrollPane.setVerticalScrollBarPolicy(20);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.anchor = 13;
        scrollPanePanel.add((Component)productColorsListScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 3, 3, 3);
        gbc.anchor = 18;
        scrollPanePanel.add((Component)moveUpButton, gbc);
        moveUpButton.addActionListener(e -> this.moveColors(true));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 18;
        scrollPanePanel.add((Component)moveDownButton, gbc);
        moveDownButton.addActionListener(e -> this.moveColors(false));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(3, 3, 3, 3);
        productTypePanel.add((Component)scrollPanePanel, gbc);
        return productTypePanel;
    }

    private void moveColors(boolean moveUp) {
        ArrayList<String> messages = new ArrayList<String>();
        int selectedIndicesLength = this.productColorTypeList.getSelectedIndices().length == 1 ? 1 : this.productColorTypeList.getSelectedIndices().length - 1;
        int firstIndex = this.productColorTypeList.getSelectedIndex();
        for (int index : this.productColorTypeList.getSelectedIndices()) {
            ArrayList<String> emptyMessages = new ArrayList<String>();
            if (this.oldColorType == null || this.network.canColorTypeBeRemoved(this.oldColorType, emptyMessages)) {
                if (moveUp && index > 0) {
                    this.swapColors(this.productModel, index, index - 1);
                    continue;
                }
                if (moveUp || index >= this.productModel.getSize() - selectedIndicesLength) continue;
                this.swapColors(this.productModel, firstIndex, index + selectedIndicesLength);
                continue;
            }
            if (emptyMessages.isEmpty()) continue;
            messages.addAll(emptyMessages);
        }
        if (!messages.isEmpty()) {
            Object message = "The color type cannot be modified for the following reasons: \n\n";
            for (String m : messages) {
                if (((String)message).contains(m)) continue;
                message = (String)message + m;
            }
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, "Could not remove color from color type", 2);
        } else {
            int[] indices = moveUp ? Arrays.stream(this.productColorTypeList.getSelectedIndices()).map(i -> i - 1).toArray() : Arrays.stream(this.productColorTypeList.getSelectedIndices()).map(i -> i + selectedIndicesLength).toArray();
            this.productColorTypeList.setSelectedIndices(indices);
        }
    }

    private JPanel createProductButtonsPanel() {
        Dimension buttonSize = new Dimension(100, 30);
        JPanel productButtonPanel = new JPanel();
        productButtonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JButton productAddButton = new JButton("Add");
        productAddButton.setMnemonic(65);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 13;
        productAddButton.setPreferredSize(buttonSize);
        productButtonPanel.add((Component)productAddButton, gbc);
        productAddButton.addActionListener(e -> {
            ArrayList<String> messages = new ArrayList<String>();
            if (this.oldColorType == null || this.network.canColorTypeBeRemoved(this.oldColorType, messages)) {
                this.productModel.addElement(this.productTypeComboBox.getSelectedItem());
                this.productColorTypeList.setModel(this.productModel);
                this.productRemoveButton.setEnabled(true);
            } else {
                Object message = "The color type cannot be modified for the following reasons: \n\n";
                message = (String)message + String.join((CharSequence)"", messages);
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, "Could not add color from color type", 2);
            }
        });
        this.productRemoveButton = new JButton("Remove");
        this.productRemoveButton.setEnabled(false);
        this.productRemoveButton.setMnemonic(82);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 13;
        this.productRemoveButton.setPreferredSize(buttonSize);
        productButtonPanel.add((Component)this.productRemoveButton, gbc);
        this.productRemoveButton.addActionListener(e -> this.removeColorTypes());
        return productButtonPanel;
    }

    private void exit() {
        this.dialog.setVisible(false);
    }

    private void onOK() {
        int i;
        String name = this.nameTextField.getText();
        String lowerbound = this.lowerBoundTextField.getText();
        String upperbound = this.upperBoundTextField.getText();
        if (name == null || name.trim().isEmpty()) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You have to enter a name for the color", "Error", 0);
            return;
        }
        if (!Pattern.matches("[a-zA-Z]([\\_a-zA-Z0-9])*", name)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Acceptable names for color types are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*", "Error", 0);
            return;
        }
        if (this.network.isNameUsedForColorType(name) && this.oldColorType == null) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already another color type with the same name.\n\nChoose a different name for the color type.", "Error", 0);
            return;
        }
        if (this.network.isNameUsedForVariable(name)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already variable with the same name.\n\nChoose a different name for the color type.", "Error", 0);
            return;
        }
        if (this.network.isNameUsedForConstant(name)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already a constant with the same name.\n\nChoose a different name for the color type.", "Error", 0);
            return;
        }
        if (this.network.isNameUsedForColor(name, null)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already a color with the same name.\n\nChoose a different name for the color type.", "Error", 0);
            return;
        }
        if (!this.oldName.equals("") && !this.oldName.equals(name) && this.network.isNameUsedForColorType(name)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There is already another color type with the same name.\n\nChoose a different name for the color type.", "Error", 0);
            return;
        }
        if (!Pattern.matches("[0-9]+", lowerbound) && this.rangeOfIntegersPanelEnabled) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Lower bound must be a nonnegative number", "Error", 0);
            return;
        }
        if (!Pattern.matches("[0-9]+", upperbound) && this.rangeOfIntegersPanelEnabled) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Upper bound must be a number", "Error", 0);
            return;
        }
        try {
            if (this.rangeOfIntegersPanelEnabled && Integer.parseInt(this.lowerBoundTextField.getText()) > Integer.parseInt(this.upperBoundTextField.getText())) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Lower bound must be smaller or equal than upper bound.", "Error", 0);
                return;
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Input could not be parsed as integers", "Error", 0);
            return;
        }
        if (this.rangeOfIntegersPanelEnabled && Integer.parseInt(this.upperBoundTextField.getText()) - Integer.parseInt(this.lowerBoundTextField.getText()) > 10000) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "We do not allow integer ranges with more than 10000 elements", "Error", 0);
            return;
        }
        if (this.rangeOfIntegersPanelEnabled && this.oldColorType != null && (Integer.parseInt(this.upperBoundTextField.getText()) < Integer.parseInt(this.oldColorType.getColors().lastElement().getColorName()) || Integer.parseInt(this.lowerBoundTextField.getText()) > Integer.parseInt(this.oldColorType.getColors().firstElement().getColorName()))) {
            ArrayList removedColors = new ArrayList();
            Object messages = new ArrayList();
            for (Color c : this.oldColorType.getColors()) {
                if (Integer.parseInt(c.getName()) <= Integer.parseInt(this.upperBoundTextField.getText()) && Integer.parseInt(c.getName()) >= Integer.parseInt(this.lowerBoundTextField.getText())) continue;
                this.network.canColorBeRemoved(c, (List<String>)messages);
            }
            if (!((ArrayList)messages).isEmpty()) {
                Object message = "The color type cannot be modified for the following reasons: \n\n";
                message = (String)message + String.join((CharSequence)"", (Iterable<? extends CharSequence>)messages);
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, "Could not remove color from color type", 2);
                return;
            }
        }
        if ((lowerbound.trim().isEmpty() || upperbound.trim().isEmpty()) && this.rangeOfIntegersPanelEnabled) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You must specify both a lower and upper bound", "Error", 0);
            return;
        }
        String selectedColorType = this.colorTypeComboBox.getSelectedItem().toString();
        switch (selectedColorType) {
            case "Finite Enumeration": 
            case "Cyclic Enumeration": {
                ArrayList<String> overlaps = new ArrayList<String>();
                for (i = 0; i < this.enumList.getModel().getSize(); ++i) {
                    String e = this.enumList.getModel().getElementAt(i).toString();
                    if (!this.network.isNameUsedForVariable(e) && !this.network.isNameUsedForColor(e, this.oldColorType) && !this.network.isNameUsedForColorType(e) && !this.network.isNameUsedForConstant(e) && !name.equals(e)) continue;
                    overlaps.add(e);
                }
                if (overlaps.size() <= 0) break;
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Color names must not overlap with variable names or other color names: \nRemove or rename the following: \n" + String.join((CharSequence)", ", overlaps), "Error", 0);
                return;
            }
        }
        ColorType newColorType = new ColorType(name);
        switch (selectedColorType) {
            case "Finite Enumeration": 
            case "Cyclic Enumeration": {
                for (i = 0; i < this.enumList.getModel().getSize(); ++i) {
                    newColorType.addColor(this.enumList.getModel().getElementAt(i).toString());
                }
                if (newColorType.size() <= 0) {
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You must specify at least one enumeration name", "Error", 0);
                    return;
                }
                if (this.oldColorType != null) {
                    if (this.oldColorType.equals(newColorType)) {
                        this.exit();
                        return;
                    }
                    boolean showDialog = false;
                    for (Color c : this.oldColorType.getColors()) {
                        if (newColorType.contains(c)) continue;
                        showDialog = true;
                    }
                    if (showDialog) {
                        this.network.updateColorType(this.oldColorType, newColorType, this.colorTypesListModel, this.undoManager);
                        break;
                    }
                    this.undoManager.newEdit();
                    this.network.renameColorType(this.oldColorType, newColorType, this.colorTypesListModel, this.undoManager);
                    this.colorTypesListModel.updateName();
                    break;
                }
                AddColorTypeCommand cmd = new AddColorTypeCommand(newColorType, this.network, this.colorTypesListModel, this.network.colorTypes().size());
                this.undoManager.addNewEdit(cmd);
                cmd.redo();
                break;
            }
            case "Range of Integers": {
                int lowerboundNumber = Integer.parseInt(lowerbound);
                int upperboundNumber = Integer.parseInt(upperbound);
                for (int i2 = lowerboundNumber; i2 < upperboundNumber + 1; ++i2) {
                    newColorType.addColor(String.valueOf(i2));
                }
                if (this.network.isIndeticalToExisting(newColorType)) {
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Color type with identical range already exists!", "Error", 0);
                    return;
                }
                if (this.oldColorType != null) {
                    if (this.oldColorType.equals(newColorType)) {
                        this.exit();
                        return;
                    }
                    boolean showDialog = false;
                    for (Color c : this.oldColorType.getColors()) {
                        if (newColorType.getColors().contains(c)) continue;
                        showDialog = true;
                        break;
                    }
                    if (showDialog) {
                        this.network.updateColorType(this.oldColorType, newColorType, this.colorTypesListModel, this.undoManager);
                        break;
                    }
                    this.undoManager.newEdit();
                    this.network.renameColorType(this.oldColorType, newColorType, this.colorTypesListModel, this.undoManager);
                    this.colorTypesListModel.updateName();
                    break;
                }
                AddColorTypeCommand cmd = new AddColorTypeCommand(newColorType, this.network, this.colorTypesListModel, this.network.colorTypes().size());
                this.undoManager.addNewEdit(cmd);
                cmd.redo();
                break;
            }
            case "Product Color": {
                ProductType productType = new ProductType(name);
                ArrayList<ColorType> availableColorTypes = new ArrayList<ColorType>();
                for (ColorType type : this.colorTypes) {
                    if (type.getName().equals(name)) continue;
                    availableColorTypes.add(type);
                }
                int size = this.productColorTypeList.getModel().getSize();
                for (int i3 = 0; i3 < size; ++i3) {
                    String colorTypeName = this.productColorTypeList.getModel().getElementAt(i3).toString();
                    int size2 = this.productTypeComboBox.getItemCount();
                    for (int j = 0; j < size2; ++j) {
                        if (!colorTypeName.equals(this.productTypeComboBox.getItemAt(j).toString())) continue;
                        productType.addType((ColorType)this.productTypeComboBox.getItemAt(j));
                    }
                }
                if (productType.size() <= 1) {
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "An product type must contain at least two components", "Error", 0);
                    return;
                }
                if (this.oldColorType != null) {
                    if (this.oldColorType.equals(productType)) {
                        this.exit();
                        return;
                    }
                    boolean showDialog = false;
                    for (ColorType ct : ((ProductType)this.oldColorType).getColorTypes()) {
                        if (productType.getColorTypes().contains(ct)) continue;
                        showDialog = true;
                        break;
                    }
                    if (!showDialog && ((ProductType)this.oldColorType).getColorTypes().size() != productType.getColorTypes().size()) {
                        showDialog = true;
                    }
                    if (showDialog) {
                        this.network.updateColorType(this.oldColorType, productType, this.colorTypesListModel, this.undoManager);
                        break;
                    }
                    this.undoManager.newEdit();
                    this.network.renameColorType(this.oldColorType, productType, this.colorTypesListModel, this.undoManager);
                    this.colorTypesListModel.updateName();
                    break;
                }
                AddColorTypeCommand cmd = new AddColorTypeCommand(productType, this.network, this.colorTypesListModel, this.network.colorTypes().size());
                this.undoManager.addNewEdit(cmd);
                cmd.redo();
            }
        }
        this.exit();
    }

    public void swapColors(DefaultListModel model, int selectedIndex, int newIndex) {
        Object temp = model.get(newIndex);
        model.set(newIndex, model.get(selectedIndex));
        model.set(selectedIndex, temp);
    }
}

