/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAtomicPropositionNode;
import dk.aau.cs.TCTL.TCTLConstNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.TCTL.TCTLTrueNode;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTraceStep;
import dk.aau.cs.model.tapn.simulation.TimedTAPNNetworkTrace;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.util.MemoryMonitor;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.VerificationCallback;
import dk.aau.cs.verification.TraceConverter;
import dk.aau.cs.verification.VerificationResult;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.verification.Verifier;
import net.tapaal.swinghelpers.CustomJSpinner;
import pipe.gui.Constants;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;

public class WorkflowDialog
extends JDialog {
    private final TAPNLens lens;
    private final PetriNetTab tab;
    private static final String TOOLTIP_SOUNDNESS = "Soundness (option for proper termination).";
    private static final String TOOLTIP_MIN = "Calculate the minimum duration of the workflow.";
    private static final String TOOLTIP_STRONGSOUNDNESS = "Strong soundness (proper termination within a bounded time).";
    private static final String TOOLTIP_MAX = "Calculate the maximum duration of the workflow.";
    private static final String DISCRETE_SEMANTICS_WARNING = "<html>Because the workflow contains age invariants and/or urgent transitions,<br /> this result is only valid for the discrete semantics (integer delays).</html>";
    private static final String LABEL_TYPE_OF_WORKFLOW = "Type of the workflow:";
    private static final String LABEL_INPUT_PLACE = "Input place:";
    private static final String LABEL_OUTPUT_PLACE = "Output place:";
    private static final String LABEL_INHIBITOR_ARCS = "Inhibitor arcs:";
    private static final String LABEL_URGENT_TRANSITIONS = "Urgent transitions:";
    private static final String LABEL_INVARIANTS = "Age invariants:";
    private static final String LABEL_RESULT_SOUND = "Soundness:";
    private static final String LABEL_RESULT_MIN = "Minimum duration:";
    private static final String LABEL_RESULT_STRONG_SOUND = "Strong soundness:";
    private static final String LABEL_RESULT_MAX = "Maximum duration:";
    private static final String RESULT_STRING_SATISFIED = "Satisfied";
    private static final String RESULT_STRING_NOT_SATISFIED = "Not satisfied";
    private static final String RESULT_STRING_INCONCLUSIVE = "Inconclusive";
    private static final String RESULT_NOT_DEFINED = "Undefined";
    private static final String ERROR_INCREASE_BOUND = "Try to increase the number of extra tokens.";
    private static final String RESULT_ERROR_NONFINAL_REACHED = "A non-final marking with a token in the output place is reachable.";
    private static final String RESULT_ERROR_NO_TRACE_TO_FINAL = "A marking is reachable from which a final marking cannot be reached.";
    private static final String LABEL_UNUSED_TRANSITIONS = "The workflow contains the following redundant transitions that are never enabled:";
    private static final String RESULT_ERROR_CYCLE = "The workflow has an infinite time-divergent execution.";
    private static final String RESULT_ERROR_TIME = "A time divergent marking is reachable.";
    private static final String ERROR_MULTIPLE_IN = "Multiple input places found";
    private static final String ERROR_MULTIPLE_OUT = "Multiple output places found";
    private JPanel panel;
    private JCheckBox soundness = null;
    private JCheckBox strongSoundness = null;
    private JCheckBox min = null;
    private JCheckBox max = null;
    private JLabel soundnessResult;
    private JLabel strongSoundnessResult;
    private JLabel soundnessResultExplanation;
    private JLabel strongSoundnessResultExplanation;
    private JButton soundnessResultTraceButton;
    private TAPNNetworkTrace soundnessResultTrace = null;
    private JLabel minResult;
    private JButton minResultTraceButton;
    private TAPNNetworkTrace minResultTrace = null;
    private JLabel maxResult;
    private TAPNNetworkTrace maxResultTrace = null;
    private JButton maxResultTraceButton;
    private TAPNNetworkTrace strongSoundnessResultTrace = null;
    private JButton strongSoundnessResultTraceButton;
    private JLabel soundnessVerificationStats;
    private JLabel strongSoundnessVerificationStats;
    private JLabel unusedTransitionsLabel;
    private JLabel unusedTransitions;
    private JLabel soundnessResultLabel;
    private JLabel minResultLabel;
    private JLabel strongSoundnessResultLabel;
    private JLabel maxResultLabel;
    private JPanel resultPanel = null;
    private CustomJSpinner numberOfExtraTokensInNet = null;
    private ArrayList<String> errorMsgs = new ArrayList();
    private int errors = 0;
    private final LinkedList<Runnable> verificationQueue = new LinkedList();
    private final ArrayList<SharedPlace> unusedSharedPlaces = new ArrayList();
    private TimedPlace in;
    private TimedPlace out;
    private TimedArcPetriNet out_template;
    private boolean isSound = false;
    private boolean isConclusive = true;
    private long m;
    private int B;
    private static final int maxStringLength = "The workflow contains the following redundant transitions that are never enabled:".length();
    private final TimedArcPetriNetNetwork model;
    private boolean isInTraceMode = false;
    TAWFNTypes netType;

    private static String getHelpMessage() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html>");
        buffer.append("<b>Workflow Net</b><br/>");
        buffer.append("A workflow net must contain exactly one <em>input</em> place with no incoming arcs,\n");
        buffer.append("exactly one <em>output</em> place with no outgoing arcs and every other place has\n");
        buffer.append("at least one incoming and one outgoing arc. Every transition must have\n");
        buffer.append("at least one incoming arc (inhibitor arcs do not count). Strict time intervals are not allowed.<br/><br/>");
        buffer.append("Workflow nets that contain inhibitor arcs, age invariants or urgent transitions\n");
        buffer.append("are called <em>extended</em> workflow nets. Nets without these features are\n");
        buffer.append("called <em>monotonic</em>.\n");
        buffer.append("<br/><br/>");
        buffer.append("<b>Initial Marking, Final Markings</b><br/>");
        buffer.append("The <em>initial marking</em> has just one token of age 0 in the input place.\n");
        buffer.append("A <em>final marking</em> has one token in the output place and no other tokens\n");
        buffer.append("anywhere else in the workflow net.");
        buffer.append("<br/><br/>");
        buffer.append("<b>Soundness of Workflow Net</b><br/>");
        buffer.append("A workflow net is <em>sound</em> if we can reach a final marking from\n");
        buffer.append("any marking reachable from the initial marking and all markings that place\n");
        buffer.append("a token to the output place are final markings. For sound nets\n");
        buffer.append("we can compute the <em>minimum time duration</em> to move a token\n");
        buffer.append("from the input place to the output place.\n");
        buffer.append("<br/><br/>");
        buffer.append("<b>Strong Soundness of Workflow Net</b><br/>");
        buffer.append("A workflow net is <em>strongly sound</em> if it is sound and any computation\n");
        buffer.append("of the net is time-bounded (time cannot diverge for ever).\n");
        buffer.append("For strongly sound nets we can compute the <em>maximum time duration</em>\n");
        buffer.append("to move a token from the input place to the output place.\n");
        buffer.append("<br/><br/>");
        buffer.append("<b>Extra Number of Tokens</b><br/>");
        buffer.append("The user can set up the extra number of tokens in order to limit\n");
        buffer.append("the state-space during the verification. This is necessary for extended\n");
        buffer.append("workflow nets as soundness is otherwise undecidable. For monotonic nets\n");
        buffer.append("the tool provides conclusive answers also for unbounded nets but increasing\n");
        buffer.append("the number of extra tokens can speedup the verification and help with trace generation.\n");
        buffer.append("<br/><br/>");
        buffer.append("<b>Typical Reasons for Breaking Soundness</b><br/>");
        buffer.append("<ul><li>A reachable deadlock marking (no available transition firing after any delay).</li>\n");
        buffer.append("<li>A reachable marking from which there is no computation to any final marking.</li>\n");
        buffer.append("<li>The output place can be marked with a token while there are some other tokens left in the net.</li></ul>\n");
        buffer.append("<br/><br/>");
        buffer.append("<b>Typical Reasons for Breaking Strong Soundness</b><br/>");
        buffer.append("<ul><li>The net is not sound.</li>\n");
        buffer.append("<li>There is a reachable marking where we can delay for ever (time-divergent marking).</li>\n");
        buffer.append("<li>There is an infinite execution where the accumulated time diverges to infinity.</li></ul>\n");
        buffer.append("</html>");
        return buffer.toString();
    }

    public static void showDialog(PetriNetTab tab) {
        if (tab.getWorkflowDialog() == null) {
            tab.setWorkflowDialog(new WorkflowDialog((Frame)TAPAALGUI.getApp(), "Workflow Analysis", true, tab));
        } else if (!tab.getWorkflowDialog().isInTraceMode) {
            WorkflowDialog oldDialog = tab.getWorkflowDialog();
            tab.setWorkflowDialog(new WorkflowDialog((Frame)TAPAALGUI.getApp(), "Workflow Analysis", true, tab));
            WorkflowDialog newDialog = tab.getWorkflowDialog();
            newDialog.soundness.setSelected(oldDialog.soundness.isSelected());
            newDialog.min.setSelected(oldDialog.min.isSelected());
            newDialog.strongSoundness.setSelected(oldDialog.strongSoundness.isSelected());
            newDialog.max.setSelected(oldDialog.max.isSelected());
            newDialog.max.setEnabled(oldDialog.max.isEnabled());
        }
        tab.getWorkflowDialog().isInTraceMode = false;
        tab.getWorkflowDialog().setVisible(true);
    }

    public boolean restoreWindow() {
        return this.isInTraceMode;
    }

    private void switchToTrace(TAPNNetworkTrace trace) {
        this.isInTraceMode = true;
        this.setVisible(false);
        this.tab.getAnimator().setTrace(trace);
    }

    private WorkflowDialog(Frame frame, String title, boolean modal, PetriNetTab tab) {
        super(frame, title, modal);
        this.tab = tab;
        this.model = tab.network().copy();
        this.lens = tab.lens;
        this.unusedSharedPlaces.clear();
        for (SharedPlace p : this.model.sharedPlaces()) {
            if (!p.getComponentsUsingThisPlace().isEmpty()) continue;
            this.unusedSharedPlaces.add(p);
        }
        for (SharedPlace p : this.unusedSharedPlaces) {
            this.model.remove(p);
        }
        this.initComponents();
        this.setContentPane(this.panel);
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (int)((double)((screenSize.height - this.getHeight()) / 2) * 0.5);
        this.setLocation(x, y);
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
    }

    private void initComponents() {
        this.panel = new JPanel(new GridBagLayout());
        this.netType = this.getWorkflowType();
        JPanel informationPanel = new JPanel();
        informationPanel.setBorder(BorderFactory.createTitledBorder("About the Workflow"));
        informationPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        this.panel.add((Component)informationPanel, gbc);
        gbc.gridwidth = 1;
        JLabel workflowType = new JLabel(LABEL_TYPE_OF_WORKFLOW, 4);
        informationPanel.add((Component)workflowType, gbc);
        gbc.gridx = 1;
        JLabel workflowTypeLabel = new JLabel("");
        informationPanel.add((Component)workflowTypeLabel, gbc);
        JLabel workflowTypeError = new JLabel("");
        workflowTypeError.setVisible(false);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        informationPanel.add((Component)workflowTypeError, gbc);
        gbc.gridwidth = 1;
        switch (this.netType.ordinal()) {
            case 1: {
                workflowTypeLabel.setText("Monotonic workflow net");
                break;
            }
            case 0: {
                workflowTypeLabel.setText("Extended workflow net");
                break;
            }
            case 2: {
                workflowType.setVisible(false);
                workflowTypeLabel.setVisible(false);
                StringBuilder sb = new StringBuilder();
                String sep = "<br>";
                for (String e2 : this.errorMsgs) {
                    sb.append(sep).append("- ").append(e2);
                }
                workflowTypeError.setText("<html>This net is not a workflow net for the following reason" + (this.errorMsgs.size() > 1 ? "s" : "") + ":" + String.valueOf(sb) + "</html>");
                workflowTypeError.setVisible(true);
            }
        }
        if (this.soundness == null) {
            this.soundness = new JCheckBox("Check soundness.");
        }
        if (this.min == null) {
            this.min = new JCheckBox("Calculate minimum duration.");
            this.min.setSelected(true);
            this.min.setToolTipText(TOOLTIP_MIN);
        }
        if (this.strongSoundness == null) {
            this.strongSoundness = new JCheckBox("Check strong soundness.");
        }
        if (this.max == null) {
            this.max = new JCheckBox("Calculate maximum duration.");
        }
        if (this.netType != TAWFNTypes.NOTTAWFN) {
            gbc.gridy = 1;
            gbc.gridx = 0;
            informationPanel.add((Component)new JLabel(LABEL_INPUT_PLACE, 4), gbc);
            JLabel inPlaceLabel = new JLabel(this.in.toString());
            gbc.gridx = 1;
            informationPanel.add((Component)inPlaceLabel, gbc);
            gbc.gridy = 2;
            gbc.gridx = 0;
            informationPanel.add((Component)new JLabel(LABEL_OUTPUT_PLACE, 4), gbc);
            JLabel outPlaceLabel = new JLabel(this.out.toString());
            gbc.gridx = 1;
            informationPanel.add((Component)outPlaceLabel, gbc);
            gbc.gridy = 0;
            gbc.gridx = 3;
            informationPanel.add((Component)new JLabel(LABEL_INHIBITOR_ARCS, 4), gbc);
            gbc.gridx = 4;
            informationPanel.add((Component)new JLabel(this.model.hasInhibitorArcs() ? "Yes" : "No"), gbc);
            gbc.gridy = 1;
            gbc.gridx = 3;
            informationPanel.add((Component)new JLabel(LABEL_URGENT_TRANSITIONS, 4), gbc);
            gbc.gridx = 4;
            informationPanel.add((Component)new JLabel(this.model.hasUrgentTransitions() ? "Yes" : "No"), gbc);
            gbc.gridy = 2;
            gbc.gridx = 3;
            informationPanel.add((Component)new JLabel(LABEL_INVARIANTS, 4), gbc);
            gbc.gridx = 4;
            informationPanel.add((Component)new JLabel(this.model.hasInvariants() ? "Yes" : "No"), gbc);
            this.initValidationPanel();
        }
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.anchor = 17;
        gbc.fill = 0;
        JButton help_button = new JButton("Help");
        help_button.addActionListener(e -> JOptionPane.showMessageDialog(TAPAALGUI.getApp(), this.getMessageComponent(), "Help", 1));
        this.panel.add((Component)help_button, gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        JButton close_button = new JButton("Close");
        close_button.addActionListener(e -> this.setVisible(false));
        this.panel.add((Component)close_button, gbc);
    }

    private Object getMessageComponent() {
        JTextPane pane = new JTextPane();
        pane.setContentType("text/html");
        pane.setText(WorkflowDialog.getHelpMessage());
        pane.setEditable(false);
        pane.setCaretPosition(0);
        for (MouseListener listener : pane.getMouseListeners()) {
            pane.removeMouseListener(listener);
        }
        Dimension dim = new Dimension(500, 400);
        pane.setPreferredSize(dim);
        pane.setMargin(new Insets(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(pane);
        scrollPane.setPreferredSize(dim);
        return scrollPane;
    }

    private void initValidationPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        JPanel soundnessPanel = new JPanel();
        soundnessPanel.setBorder(BorderFactory.createTitledBorder("Workflow Properties"));
        soundnessPanel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        this.panel.add((Component)soundnessPanel, gbc);
        gbc.gridwidth = 1;
        this.soundness.setToolTipText(TOOLTIP_SOUNDNESS);
        this.soundness.setSelected(true);
        this.soundness.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = 1;
        soundnessPanel.add((Component)this.soundness, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        soundnessPanel.add((Component)this.min, gbc);
        this.strongSoundness.setToolTipText(TOOLTIP_STRONGSOUNDNESS);
        this.strongSoundness.setSelected(true);
        gbc.gridx = 0;
        gbc.gridy = 2;
        soundnessPanel.add((Component)this.strongSoundness, gbc);
        this.max.setToolTipText(TOOLTIP_MAX);
        this.max.setSelected(true);
        gbc.gridx = 1;
        gbc.gridy = 2;
        soundnessPanel.add((Component)this.max, gbc);
        this.strongSoundness.addActionListener(e -> {
            this.max.setEnabled(this.strongSoundness.isSelected());
            if (!this.strongSoundness.isSelected()) {
                this.max.setSelected(false);
            } else {
                this.max.setSelected(true);
            }
        });
        this.max.setEnabled(this.strongSoundness.isSelected());
        if (!this.strongSoundness.isSelected()) {
            this.max.setSelected(false);
        }
        if (this.resultPanel == null) {
            this.resultPanel = new JPanel();
            this.resultPanel.setBorder(BorderFactory.createTitledBorder("Analysis Results"));
            this.resultPanel.setLayout(new GridBagLayout());
            this.resultPanel.setVisible(false);
        }
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        this.panel.add((Component)this.resultPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 5, 0, 5);
        if (this.soundnessResultLabel == null) {
            this.soundnessResultLabel = new JLabel(LABEL_RESULT_SOUND);
            this.soundnessResultLabel.setHorizontalAlignment(4);
            this.resultPanel.add((Component)this.soundnessResultLabel, gbc);
            this.soundnessResultLabel.setVisible(false);
            this.soundnessResult = new JLabel();
            gbc.gridx = 1;
            this.resultPanel.add((Component)this.soundnessResult, gbc);
            this.soundnessResult.setVisible(false);
            gbc.gridx = 2;
            this.soundnessVerificationStats = new JLabel();
            this.soundnessVerificationStats.setVisible(false);
            this.resultPanel.add((Component)this.soundnessVerificationStats, gbc);
            this.soundnessResultExplanation = new JLabel();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.soundnessResultExplanation.setVisible(false);
            this.soundnessResultExplanation.setEnabled(false);
            this.resultPanel.add((Component)this.soundnessResultExplanation, gbc);
            gbc.gridwidth = 1;
            this.soundnessResultTraceButton = new JButton("Show trace");
            gbc.gridx = 2;
            this.soundnessResultTraceButton.setVisible(false);
            this.soundnessResultTraceButton.addActionListener(e -> this.switchToTrace(this.soundnessResultTrace));
            this.resultPanel.add((Component)this.soundnessResultTraceButton, gbc);
            gbc.gridy = 2;
            gbc.gridx = 0;
            gbc.insets = new Insets(10, 5, 5, 5);
            this.minResultLabel = new JLabel(LABEL_RESULT_MIN);
            this.minResultLabel.setHorizontalAlignment(4);
            this.resultPanel.add((Component)this.minResultLabel, gbc);
            this.minResultLabel.setVisible(false);
            this.minResult = new JLabel();
            gbc.gridx = 1;
            this.resultPanel.add((Component)this.minResult, gbc);
            this.minResult.setVisible(false);
            this.minResultTraceButton = new JButton("Show trace");
            gbc.gridx = 2;
            this.minResultTraceButton.setVisible(false);
            this.minResultTraceButton.addActionListener(e -> this.switchToTrace(this.minResultTrace));
            this.resultPanel.add((Component)this.minResultTraceButton, gbc);
            gbc.gridwidth = 1;
            gbc.gridy = 3;
            gbc.gridx = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.strongSoundnessResultLabel = new JLabel(LABEL_RESULT_STRONG_SOUND);
            this.strongSoundnessResultLabel.setHorizontalAlignment(4);
            this.resultPanel.add((Component)this.strongSoundnessResultLabel, gbc);
            this.strongSoundnessResultLabel.setVisible(false);
            this.strongSoundnessResult = new JLabel();
            gbc.gridx = 1;
            this.resultPanel.add((Component)this.strongSoundnessResult, gbc);
            this.strongSoundnessResult.setVisible(false);
            this.strongSoundnessVerificationStats = new JLabel();
            gbc.gridx = 2;
            this.strongSoundnessVerificationStats.setVisible(false);
            this.resultPanel.add((Component)this.strongSoundnessVerificationStats, gbc);
            this.strongSoundnessResultExplanation = new JLabel();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.strongSoundnessResultExplanation.setVisible(false);
            this.strongSoundnessResultExplanation.setEnabled(false);
            this.resultPanel.add((Component)this.strongSoundnessResultExplanation, gbc);
            gbc.gridwidth = 1;
            this.strongSoundnessResultTraceButton = new JButton("Show trace");
            gbc.gridx = 2;
            this.strongSoundnessResultTraceButton.setVisible(false);
            this.strongSoundnessResultTraceButton.addActionListener(e -> this.switchToTrace(this.strongSoundnessResultTrace));
            this.resultPanel.add((Component)this.strongSoundnessResultTraceButton, gbc);
            gbc.gridy = 5;
            gbc.gridx = 0;
            gbc.insets = new Insets(10, 5, 5, 5);
            this.maxResultLabel = new JLabel(LABEL_RESULT_MAX);
            this.maxResultLabel.setHorizontalAlignment(4);
            this.resultPanel.add((Component)this.maxResultLabel, gbc);
            this.maxResultLabel.setVisible(false);
            this.maxResult = new JLabel();
            gbc.gridx = 1;
            this.resultPanel.add((Component)this.maxResult, gbc);
            this.maxResult.setVisible(false);
            this.maxResultTraceButton = new JButton("Show trace");
            gbc.gridx = 2;
            this.maxResultTraceButton.setVisible(false);
            this.maxResultTraceButton.addActionListener(e -> this.switchToTrace(this.maxResultTrace));
            this.resultPanel.add((Component)this.maxResultTraceButton, gbc);
            this.unusedTransitionsLabel = new JLabel();
            gbc.gridy = 6;
            gbc.gridx = 0;
            gbc.gridwidth = 3;
            gbc.insets = new Insets(10, 5, 0, 5);
            this.unusedTransitionsLabel.setText(LABEL_UNUSED_TRANSITIONS);
            this.unusedTransitionsLabel.setVisible(false);
            this.resultPanel.add((Component)this.unusedTransitionsLabel, gbc);
            this.unusedTransitions = new JLabel();
            gbc.gridy = 7;
            gbc.insets = new Insets(0, 5, 5, 5);
            this.unusedTransitions.setVisible(false);
            this.unusedTransitions.setEnabled(false);
            this.resultPanel.add((Component)this.unusedTransitions, gbc);
        }
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        this.panel.add((Component)new JLabel(" Number of extra tokens:  "), gbc);
        if (this.numberOfExtraTokensInNet == null) {
            this.numberOfExtraTokensInNet = new CustomJSpinner(this.model.getDefaultBound(), 0, 100000);
        } else {
            this.numberOfExtraTokensInNet.setValue(this.model.getDefaultBound());
        }
        this.numberOfExtraTokensInNet.setMaximumSize(new Dimension(55, 30));
        this.numberOfExtraTokensInNet.setMinimumSize(new Dimension(55, 30));
        this.numberOfExtraTokensInNet.setPreferredSize(new Dimension(55, 30));
        gbc.gridx = 1;
        gbc.gridy = 6;
        this.panel.add((Component)this.numberOfExtraTokensInNet, gbc);
        this.numberOfExtraTokensInNet.addChangeListener(e -> {
            this.model.setDefaultBound((Integer)this.numberOfExtraTokensInNet.getValue());
            this.tab.network().setDefaultBound((Integer)this.numberOfExtraTokensInNet.getValue());
            this.tab.setNetChanged(true);
        });
        gbc.gridwidth = 1;
        JButton checkBound = new JButton("Check boundedness");
        gbc.gridx = 2;
        this.panel.add((Component)checkBound, gbc);
        checkBound.addActionListener(e -> this.checkBound());
        JButton checkIfSound = new JButton("Analyse the workflow");
        this.getRootPane().setDefaultButton(checkIfSound);
        checkIfSound.addActionListener(e -> this.checkProperties());
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.anchor = 13;
        this.panel.add((Component)checkIfSound, gbc);
    }

    private TAWFNTypes getWorkflowType() {
        Object errorString;
        TimedPlace p;
        List<TimedArcPetriNet> tapns = this.model.activeTemplates();
        ArrayList<TimedPlace> sharedInPlaces = new ArrayList<TimedPlace>();
        ArrayList<TimedPlace> sharedOutPlaces = new ArrayList<TimedPlace>();
        ArrayList<TimedPlace> sharedAcceptedPlaces = new ArrayList<TimedPlace>();
        ArrayList<TimedPlace> sharedOrphanedPlaces = new ArrayList<TimedPlace>();
        ArrayList<SharedTransition> sharedTransitions = new ArrayList<SharedTransition>();
        this.in = null;
        this.out = null;
        ArrayList<TimedPlace> inCandidates = new ArrayList<TimedPlace>();
        ArrayList<TimedPlace> outCandidates = new ArrayList<TimedPlace>();
        this.errorMsgs = new ArrayList();
        this.errors = 0;
        if (!this.model.isNonStrict()) {
            this.errorMsgs.add("The net contains strict intervals.");
        }
        boolean isMonotonic = true;
        int numberOfTokensInNet = 0;
        ArrayList<TimedPlace> countedSharedPlaces = new ArrayList<TimedPlace>();
        for (TimedArcPetriNet timedArcPetriNet : tapns) {
            for (TimedPlace p2 : timedArcPetriNet.places()) {
                boolean isin = true;
                boolean isout = true;
                p2.invariant().asIterval();
                if (isMonotonic && !p2.invariant().asIterval().equals(TimeInterval.ZERO_INF)) {
                    isMonotonic = false;
                }
                for (TimedOutputArc timedOutputArc : timedArcPetriNet.outputArcs()) {
                    if (!timedOutputArc.destination().equals(p2)) continue;
                    isin = false;
                    break;
                }
                for (TimedInputArc timedInputArc : timedArcPetriNet.inputArcs()) {
                    if (!timedInputArc.source().equals(p2)) continue;
                    isout = false;
                    break;
                }
                for (TransportArc transportArc : timedArcPetriNet.transportArcs()) {
                    if (transportArc.destination().equals(p2)) {
                        isin = false;
                    }
                    if (transportArc.source().equals(p2)) {
                        isout = false;
                    }
                    if (isin || isout) continue;
                    break;
                }
                if (p2.isShared()) {
                    if (isin && isout) {
                        sharedOrphanedPlaces.add(p2);
                    } else {
                        if (isin) {
                            sharedInPlaces.add(p2);
                        } else if (isout) {
                            sharedOutPlaces.add(p2);
                        } else if (!isin && !isout) {
                            sharedAcceptedPlaces.add(p2);
                        }
                        sharedOrphanedPlaces.remove(p2);
                    }
                } else if (isin && isout) {
                    if (this.errorMsgs.size() > 5) {
                        ++this.errors;
                    } else {
                        this.errorMsgs.add("Place " + String.valueOf(p2) + " has no incoming or outgoing arcs.");
                    }
                } else if (isin) {
                    inCandidates.add(p2);
                } else if (isout) {
                    outCandidates.add(p2);
                }
                if (p2.isShared() && !countedSharedPlaces.contains(p2)) {
                    numberOfTokensInNet += p2.numberOfTokens();
                    countedSharedPlaces.add(p2);
                    continue;
                }
                if (p2.isShared()) continue;
                numberOfTokensInNet += p2.numberOfTokens();
            }
            for (TimedTransition t : timedArcPetriNet.transitions()) {
                if (t.isShared()) {
                    sharedTransitions.add(t.sharedTransition());
                } else if (t.getInputArcs().isEmpty() && t.getTransportArcsGoingThrough().isEmpty()) {
                    if (this.errorMsgs.size() > 5) {
                        ++this.errors;
                    } else {
                        this.errorMsgs.add("Transition " + t.name() + " has no incoming arcs.");
                    }
                }
                if (!isMonotonic || !t.isUrgent() && t.getInhibitorArcs().isEmpty()) continue;
                isMonotonic = false;
            }
        }
        block6: while (sharedTransitions.size() > 0) {
            SharedTransition st = (SharedTransition)sharedTransitions.get(0);
            for (TimedTransition timedTransition : st.transitions()) {
                if (timedTransition.getTransportArcsGoingThrough().isEmpty() && timedTransition.getInputArcs().isEmpty()) continue;
                while (sharedTransitions.remove(st)) {
                }
                continue block6;
            }
            if (this.errorMsgs.size() > 5) {
                ++this.errors;
            } else {
                this.errorMsgs.add("Transition " + st.name() + " has no incoming arcs.");
            }
            while (sharedTransitions.remove(st)) {
            }
        }
        for (TimedPlace timedPlace : sharedAcceptedPlaces) {
            while (sharedInPlaces.remove(timedPlace)) {
            }
            while (sharedOutPlaces.remove(timedPlace)) {
            }
            while (sharedOrphanedPlaces.remove(timedPlace)) {
            }
        }
        while (sharedInPlaces.size() != 0) {
            p = (TimedPlace)sharedInPlaces.get(0);
            while (sharedInPlaces.remove(p)) {
            }
            if (!sharedOutPlaces.remove(p)) {
                inCandidates.add(p);
            }
            while (sharedOutPlaces.remove(p)) {
            }
            while (sharedOrphanedPlaces.remove(p)) {
            }
        }
        while (sharedOutPlaces.size() > 0) {
            p = (TimedPlace)sharedOutPlaces.get(0);
            outCandidates.add(p);
            while (sharedOutPlaces.remove(p)) {
            }
            while (sharedOrphanedPlaces.remove(p)) {
            }
        }
        if (inCandidates.isEmpty()) {
            if (this.errorMsgs.size() > 5) {
                ++this.errors;
            } else {
                this.errorMsgs.add("No input place found.");
            }
        } else if (inCandidates.size() > 1) {
            if (this.errorMsgs.size() > 5) {
                ++this.errors;
            } else {
                errorString = new StringBuilder("Multiple input places found (");
                int n = ((StringBuilder)errorString).length();
                for (TimedPlace p2 : inCandidates) {
                    int n2;
                    if (n2 + p2.toString().length() > maxStringLength) {
                        ((StringBuilder)errorString).append("<br>");
                        n2 = 0;
                    }
                    ((StringBuilder)errorString).append(String.valueOf(p2) + ", ");
                    n2 += p2.toString().length() + 2;
                }
                ((StringBuilder)errorString).delete(((StringBuilder)errorString).length() - 2, ((StringBuilder)errorString).length());
                ((StringBuilder)errorString).append(").");
                this.errorMsgs.add(((StringBuilder)errorString).toString());
            }
        } else {
            this.in = (TimedPlace)inCandidates.get(0);
        }
        if (outCandidates.isEmpty()) {
            if (this.errorMsgs.size() > 5) {
                ++this.errors;
            } else {
                this.errorMsgs.add("No output place found.");
            }
        } else if (outCandidates.size() > 1) {
            if (this.errorMsgs.size() > 5) {
                ++this.errors;
            } else {
                errorString = new StringBuilder("Multiple output places found (");
                int n = ((StringBuilder)errorString).length();
                for (TimedPlace p2 : outCandidates) {
                    int n3;
                    if (n3 + p2.toString().length() > maxStringLength) {
                        ((StringBuilder)errorString).append("<br>");
                        n3 = 0;
                    }
                    ((StringBuilder)errorString).append(String.valueOf(p2) + ", ");
                    n3 += p2.toString().length() + 2;
                }
                ((StringBuilder)errorString).delete(((StringBuilder)errorString).length() - 2, ((StringBuilder)errorString).length());
                ((StringBuilder)errorString).append(").");
                this.errorMsgs.add(((StringBuilder)errorString).toString());
            }
        } else {
            this.out = (TimedPlace)outCandidates.get(0);
        }
        if (numberOfTokensInNet > 1 || this.in != null && this.in.tokens().size() != 1) {
            if (this.errorMsgs.size() > 5) {
                ++this.errors;
            } else {
                this.errorMsgs.add("The current marking is not a valid initial marking.");
            }
        }
        for (TimedPlace timedPlace : sharedOrphanedPlaces) {
            this.errorMsgs.add("The shared place \"" + timedPlace.name() + "\" has no incoming or outgoing arcs.");
        }
        if (!this.errorMsgs.isEmpty()) {
            if (this.errors > 0) {
                this.errorMsgs.add("and " + this.errors + " other problems.");
            }
            return TAWFNTypes.NOTTAWFN;
        }
        int i = 0;
        block24: for (TimedArcPetriNet timedArcPetriNet : this.model.activeTemplates()) {
            for (TimedPlace p5 : timedArcPetriNet.places()) {
                if (!p5.equals(this.out)) continue;
                break block24;
            }
            ++i;
        }
        this.out_template = this.model.activeTemplates().get(i);
        return isMonotonic ? TAWFNTypes.MTAWFN : TAWFNTypes.ETAWFN;
    }

    private void checkProperties() {
        this.soundnessResult.setText("");
        this.soundnessResult.setVisible(false);
        this.soundnessResultLabel.setVisible(false);
        this.soundnessResultTraceButton.setVisible(false);
        this.minResult.setText("");
        this.minResult.setVisible(false);
        this.minResultLabel.setVisible(false);
        this.minResultTraceButton.setVisible(false);
        this.strongSoundnessResult.setText("");
        this.strongSoundnessResult.setVisible(false);
        this.strongSoundnessResultLabel.setVisible(false);
        this.strongSoundnessResultTraceButton.setVisible(false);
        this.maxResult.setText("");
        this.maxResult.setVisible(false);
        this.maxResultLabel.setVisible(false);
        this.maxResultTraceButton.setVisible(false);
        this.soundnessResultExplanation.setVisible(false);
        this.soundnessVerificationStats.setVisible(false);
        this.strongSoundnessResultExplanation.setVisible(false);
        this.strongSoundnessVerificationStats.setVisible(false);
        this.unusedTransitionsLabel.setVisible(false);
        this.unusedTransitions.setVisible(false);
        this.unusedTransitions.setText("");
        this.resultPanel.setVisible(true);
        this.pack();
        this.verificationQueue.clear();
        this.isSound = false;
        this.isConclusive = true;
        this.verificationQueue.add(this.getSoundnessRunnable());
        if (this.strongSoundness.isSelected()) {
            this.verificationQueue.add(this.getStrongSoundnessRunnable());
        }
        while (!this.verificationQueue.isEmpty()) {
            this.verificationQueue.get(0).run();
            this.verificationQueue.remove(0);
        }
    }

    private Runnable getStrongSoundnessRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                if (!WorkflowDialog.this.isSound) {
                    WorkflowDialog.this.setStrongSoundnessResult(false, WorkflowDialog.this.isConclusive ? "The workflow is not sound." : "The soundness check was inconclusive.", WorkflowDialog.this.isConclusive);
                    return;
                }
                WorkflowDialog.this.B = 0;
                for (TimedArcPetriNet t : WorkflowDialog.this.model.activeTemplates()) {
                    for (TimedPlace p : t.places()) {
                        if (p.invariant().upperBound().equals(Bound.Infinity)) continue;
                        WorkflowDialog.this.B = Math.max(WorkflowDialog.this.B, p.invariant().upperBound().value());
                    }
                }
                long c = WorkflowDialog.this.m * (long)WorkflowDialog.this.B + 1L;
                TAPNQuery q = new TAPNQuery("Workflow strong soundness checking", WorkflowDialog.this.numberOfExtraTokensInNet == null ? 0 : (Integer)WorkflowDialog.this.numberOfExtraTokensInNet.getValue(), (TCTLAbstractProperty)new TCTLEGNode(new TCTLTrueNode()), TAPNQuery.TraceOption.SOME, TAPNQuery.SearchOption.DEFAULT, ReductionOption.VerifyDTAPN, true, true, false, true, false, null, TAPNQuery.ExtrapolationOption.AUTOMATIC, TAPNQuery.WorkflowMode.WORKFLOW_STRONG_SOUNDNESS, c, WorkflowDialog.this.model.isColored());
                Verifier.runVerifyTAPNVerification(WorkflowDialog.this.model, q, result -> {
                    if (result.isQuerySatisfied()) {
                        switch (((TimedTAPNNetworkTrace)result.getTrace()).getTraceType()) {
                            case EG_LOOP: {
                                WorkflowDialog.this.setStrongSoundnessResult(false, WorkflowDialog.RESULT_ERROR_CYCLE);
                                break;
                            }
                            case EG_DELAY_FOREVER: {
                                WorkflowDialog.this.setStrongSoundnessResult(false, WorkflowDialog.RESULT_ERROR_TIME);
                                break;
                            }
                            default: {
                                assert (false);
                                break;
                            }
                        }
                        WorkflowDialog.this.strongSoundnessResultTrace = WorkflowDialog.this.mapTraceToRealModel((TAPNNetworkTrace)result.getTrace());
                        WorkflowDialog.this.strongSoundnessResultTraceButton.setVisible(true);
                        if (WorkflowDialog.this.max.isSelected()) {
                            WorkflowDialog.this.maxResult.setText(WorkflowDialog.RESULT_NOT_DEFINED);
                            WorkflowDialog.this.maxResult.setForeground(Constants.QUERY_NOT_SATISFIED_COLOR);
                            WorkflowDialog.this.maxResult.setVisible(true);
                        }
                    } else {
                        WorkflowDialog.this.setStrongSoundnessResult(true, null);
                        if (WorkflowDialog.this.max.isSelected()) {
                            WorkflowDialog.this.setMaxResult(WorkflowDialog.this.model, result.stats().maximumExecutionTime());
                            WorkflowDialog.this.maxResultTrace = WorkflowDialog.this.mapTraceToRealModel((TAPNNetworkTrace)result.getTrace());
                            WorkflowDialog.this.maxResultTraceButton.setVisible(true);
                        }
                    }
                    WorkflowDialog.this.strongSoundnessVerificationStats.setText(result.getVerificationTimeString().replace("Estimated verification time", "Est. time") + ", memory: " + MemoryMonitor.getPeakMemory());
                    WorkflowDialog.this.strongSoundnessVerificationStats.setVisible(true);
                    WorkflowDialog.this.pack();
                });
            }
        };
    }

    private void setMaxResult(TimedArcPetriNetNetwork model, int value) {
        this.maxResult.setText(value + " time units.");
        this.maxResult.setForeground(Constants.QUERY_SATISFIED_COLOR);
        this.maxResult.setVisible(true);
        this.maxResultLabel.setVisible(true);
        this.pack();
    }

    private void setStrongSoundnessResult(boolean satisfied, String explanation) {
        this.setStrongSoundnessResult(satisfied, explanation, true);
    }

    private void setStrongSoundnessResult(boolean satisfied, String explanation, boolean conclusive) {
        if (satisfied) {
            this.strongSoundnessResult.setText(RESULT_STRING_SATISFIED);
            this.strongSoundnessResult.setForeground(Constants.QUERY_SATISFIED_COLOR);
        } else {
            if (conclusive) {
                this.strongSoundnessResult.setText(RESULT_STRING_NOT_SATISFIED);
                this.strongSoundnessResult.setForeground(Constants.QUERY_NOT_SATISFIED_COLOR);
            } else {
                this.strongSoundnessResult.setText(RESULT_STRING_INCONCLUSIVE);
                this.strongSoundnessResult.setForeground(Constants.QUERY_INCONCLUSIVE_COLOR);
            }
            if (this.max.isSelected()) {
                this.maxResult.setText(RESULT_NOT_DEFINED);
                this.maxResult.setForeground(Constants.QUERY_NOT_SATISFIED_COLOR);
                this.maxResultLabel.setVisible(true);
                this.maxResult.setVisible(true);
            }
        }
        if (explanation != null) {
            this.strongSoundnessResultExplanation.setText(explanation);
            this.strongSoundnessResultExplanation.setVisible(true);
        }
        this.strongSoundnessResultLabel.setVisible(true);
        this.strongSoundnessResult.setVisible(true);
        this.pack();
    }

    private Runnable getSoundnessRunnable() {
        return () -> {
            TAPNQuery q = new TAPNQuery("Workflow soundness checking", this.numberOfExtraTokensInNet == null ? 0 : (Integer)this.numberOfExtraTokensInNet.getValue(), new TCTLEFNode(new TCTLTrueNode()), TAPNQuery.TraceOption.SOME, TAPNQuery.SearchOption.DEFAULT, ReductionOption.VerifyDTAPN, true, true, false, true, false, null, TAPNQuery.ExtrapolationOption.AUTOMATIC, TAPNQuery.WorkflowMode.WORKFLOW_SOUNDNESS, this.model.isColored());
            Verifier.runVerifyTAPNVerification(this.model, q, new VerificationCallback(){

                @Override
                public void run(VerificationResult<TAPNNetworkTrace> result) {
                    if (result.isQuerySatisfied()) {
                        WorkflowDialog.this.soundnessResult.setText(WorkflowDialog.RESULT_STRING_SATISFIED);
                        WorkflowDialog.this.soundnessResult.setForeground(Constants.QUERY_SATISFIED_COLOR);
                        if (WorkflowDialog.this.model.hasUrgentTransitions() || WorkflowDialog.this.model.hasInvariants()) {
                            WorkflowDialog.this.soundnessResultExplanation.setText(WorkflowDialog.DISCRETE_SEMANTICS_WARNING);
                            WorkflowDialog.this.soundnessResultExplanation.setVisible(true);
                        }
                        WorkflowDialog.this.isSound = true;
                        boolean hasUnusedTransitions = false;
                        StringBuilder sb = new StringBuilder();
                        int lineLength = 0;
                        sb.append("<html>");
                        for (Tuple<String, Number> stat : result.getTransitionStatistics()) {
                            if (stat.value2().doubleValue() != 0.0) continue;
                            if (!hasUnusedTransitions) {
                                hasUnusedTransitions = true;
                            } else {
                                sb.append(", ");
                                if ((lineLength += 2) > maxStringLength - stat.value1().length()) {
                                    sb.append("<br />");
                                    lineLength = 0;
                                }
                            }
                            sb.append(stat.value1());
                            lineLength += stat.value1().length();
                        }
                        sb.append("</html>");
                        if (hasUnusedTransitions) {
                            WorkflowDialog.this.unusedTransitionsLabel.setVisible(true);
                            WorkflowDialog.this.unusedTransitions.setText(sb.toString());
                            WorkflowDialog.this.unusedTransitions.setVisible(true);
                        }
                    } else if (WorkflowDialog.this.netType == TAWFNTypes.ETAWFN && !result.isBounded()) {
                        WorkflowDialog.this.soundnessResult.setText(WorkflowDialog.RESULT_STRING_INCONCLUSIVE);
                        WorkflowDialog.this.soundnessResult.setForeground(Constants.QUERY_INCONCLUSIVE_COLOR);
                        WorkflowDialog.this.isConclusive = false;
                        WorkflowDialog.this.soundnessResultExplanation.setText(WorkflowDialog.ERROR_INCREASE_BOUND);
                        WorkflowDialog.this.soundnessResultExplanation.setVisible(true);
                    } else {
                        WorkflowDialog.this.soundnessResult.setText(WorkflowDialog.RESULT_STRING_NOT_SATISFIED);
                        WorkflowDialog.this.soundnessResult.setForeground(Constants.QUERY_NOT_SATISFIED_COLOR);
                        WorkflowDialog.this.soundnessResultTrace = WorkflowDialog.this.mapTraceToRealModel(result.getTrace());
                        WorkflowDialog.this.soundnessResultTraceButton.setVisible(true);
                        WorkflowDialog.this.soundnessResultExplanation.setText(this.determineSoundnessError(result.getTrace()));
                        WorkflowDialog.this.soundnessResultExplanation.setVisible(true);
                        NetworkMarking coveredMarking = result.getCoveredMarking(WorkflowDialog.this.model);
                        if (coveredMarking != null) {
                            this.completeSoundnessTrace(result, coveredMarking);
                        }
                    }
                    WorkflowDialog.this.soundnessResult.setVisible(true);
                    WorkflowDialog.this.soundnessResultLabel.setVisible(true);
                    if (WorkflowDialog.this.min.isSelected()) {
                        if (result.isQuerySatisfied()) {
                            WorkflowDialog.this.minResult.setText(result.stats().minimumExecutionTime() + " time units.");
                            WorkflowDialog.this.minResult.setForeground(Constants.QUERY_SATISFIED_COLOR);
                            WorkflowDialog.this.minResultTrace = WorkflowDialog.this.mapTraceToRealModel(result.getTrace());
                            WorkflowDialog.this.minResultTraceButton.setVisible(true);
                        } else {
                            WorkflowDialog.this.minResult.setText(WorkflowDialog.RESULT_NOT_DEFINED);
                            WorkflowDialog.this.minResult.setForeground(Constants.QUERY_NOT_SATISFIED_COLOR);
                        }
                        WorkflowDialog.this.minResultLabel.setVisible(true);
                        WorkflowDialog.this.minResult.setVisible(true);
                    }
                    WorkflowDialog.this.soundnessVerificationStats.setText(result.getVerificationTimeString().replace("Estimated verification time", "Est. time") + ", memory: " + MemoryMonitor.getPeakMemory());
                    WorkflowDialog.this.soundnessVerificationStats.setVisible(true);
                    WorkflowDialog.this.m = result.stats().exploredStates();
                    WorkflowDialog.this.pack();
                }

                private void completeSoundnessTrace(final VerificationResult<TAPNNetworkTrace> soundnessResult1, NetworkMarking coveredMarking) {
                    final String explanationText = WorkflowDialog.this.soundnessResultExplanation.getText();
                    WorkflowDialog.this.soundnessResultExplanation.setText(explanationText + " Computing trace.");
                    WorkflowDialog.this.soundnessResultTraceButton.setVisible(false);
                    final NetworkMarking oldMarking = WorkflowDialog.this.model.marking();
                    WorkflowDialog.this.model.setMarking(coveredMarking);
                    TAPNQuery q = new TAPNQuery("Workflow computing trace", WorkflowDialog.this.numberOfExtraTokensInNet == null ? 0 : (Integer)WorkflowDialog.this.numberOfExtraTokensInNet.getValue(), new TCTLEFNode(new TCTLAtomicPropositionNode(new TCTLPlaceNode(WorkflowDialog.this.out.isShared() ? "" : WorkflowDialog.this.out_template.name(), WorkflowDialog.this.out.name()), ">=", new TCTLConstNode(1))), TAPNQuery.TraceOption.SOME, TAPNQuery.SearchOption.DEFAULT, ReductionOption.VerifyDTAPN, true, true, true, true, null, TAPNQuery.ExtrapolationOption.AUTOMATIC, WorkflowDialog.this.model.isColored());
                    Verifier.runVerifyTAPNVerification(WorkflowDialog.this.model, q, new VerificationCallback(){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run(VerificationResult<TAPNNetworkTrace> result) {
                            this.this$1.WorkflowDialog.this.model.setMarking(oldMarking);
                            this.this$1.WorkflowDialog.this.soundnessResultExplanation.setText(explanationText);
                            if (result.isQuerySatisfied()) {
                                this.appendTrace(this.this$1.WorkflowDialog.this.mapTraceToRealModel(result.getTrace()));
                                this.this$1.WorkflowDialog.this.soundnessResultExplanation.setText(WorkflowDialog.RESULT_ERROR_NONFINAL_REACHED);
                                this.this$1.WorkflowDialog.this.soundnessResultTraceButton.setVisible(true);
                            } else if (result.isBounded()) {
                                this.this$1.WorkflowDialog.this.soundnessResultTrace = this.this$1.WorkflowDialog.this.mapTraceToRealModel((TAPNNetworkTrace)soundnessResult1.getSecondaryTrace());
                                this.this$1.WorkflowDialog.this.soundnessResultTraceButton.setVisible(true);
                            } else {
                                this.this$1.WorkflowDialog.this.soundnessResultExplanation.setText("<html>The monotonic workflow net has a reachable marking covering another one.<br/>Try to increase the number of extra tokens so that a trace can be generated.</html>");
                            }
                        }

                        private void appendTrace(TAPNNetworkTrace trace) {
                            for (TAPNNetworkTraceStep step : trace) {
                                ((TimedTAPNNetworkTrace)this.this$1.WorkflowDialog.this.soundnessResultTrace).add(step);
                            }
                        }
                    });
                }

                private String determineSoundnessError(TAPNNetworkTrace trace) {
                    Iterator iter = trace.iterator();
                    NetworkMarking final_marking = WorkflowDialog.this.model.marking().clone();
                    while (iter.hasNext()) {
                        final_marking = ((TAPNNetworkTraceStep)iter.next()).performStepFrom(final_marking);
                    }
                    int out_size = final_marking.getTokensFor(WorkflowDialog.this.out).size();
                    if (out_size > 0 && final_marking.size() != 1) {
                        return WorkflowDialog.RESULT_ERROR_NONFINAL_REACHED;
                    }
                    String output = "A deadlock marking is reachable.";
                    NetworkMarking oldMarking = WorkflowDialog.this.model.marking();
                    WorkflowDialog.this.model.setMarking(final_marking);
                    block1: for (TimedArcPetriNet temp : WorkflowDialog.this.model.activeTemplates()) {
                        for (TimedTransition tempTransition : temp.transitions()) {
                            if (!tempTransition.isDEnabled()) continue;
                            output = WorkflowDialog.RESULT_ERROR_NO_TRACE_TO_FINAL;
                            break block1;
                        }
                    }
                    WorkflowDialog.this.model.setMarking(oldMarking);
                    return output;
                }
            });
        };
    }

    private void checkBound() {
        Verifier.analyzeKBound(this.model, this.lens, null, (Integer)this.numberOfExtraTokensInNet.getValue(), this.numberOfExtraTokensInNet, null);
    }

    private TAPNNetworkTrace mapTraceToRealModel(TAPNNetworkTrace tapnNetworkTrace) {
        TraceConverter converter = new TraceConverter(tapnNetworkTrace, this.tab.network());
        return converter.convert();
    }

    private static enum TAWFNTypes {
        ETAWFN,
        MTAWFN,
        NOTTAWFN;

    }
}

