/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import dk.aau.cs.TCTL.CTLParsing.TAPAALCTLQueryParser;
import dk.aau.cs.TCTL.HyperLTLParsing.TAPAALHyperLTLQueryParser;
import dk.aau.cs.TCTL.HyperLTLPathScopeNode;
import dk.aau.cs.TCTL.LTLANode;
import dk.aau.cs.TCTL.LTLENode;
import dk.aau.cs.TCTL.LTLFNode;
import dk.aau.cs.TCTL.LTLGNode;
import dk.aau.cs.TCTL.LTLParsing.TAPAALLTLQueryParser;
import dk.aau.cs.TCTL.LTLUNode;
import dk.aau.cs.TCTL.LTLXNode;
import dk.aau.cs.TCTL.Parsing.TAPAALQueryParser;
import dk.aau.cs.TCTL.SMCParsing.TAPAALSMCQueryParser;
import dk.aau.cs.TCTL.StringPosition;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLAUNode;
import dk.aau.cs.TCTL.TCTLAXNode;
import dk.aau.cs.TCTL.TCTLAbstractPathProperty;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.TCTLAndListNode;
import dk.aau.cs.TCTL.TCTLAtomicPropositionNode;
import dk.aau.cs.TCTL.TCTLConstNode;
import dk.aau.cs.TCTL.TCTLDeadlockNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.TCTL.TCTLEUNode;
import dk.aau.cs.TCTL.TCTLEXNode;
import dk.aau.cs.TCTL.TCTLFalseNode;
import dk.aau.cs.TCTL.TCTLNotNode;
import dk.aau.cs.TCTL.TCTLOrListNode;
import dk.aau.cs.TCTL.TCTLPathPlaceHolder;
import dk.aau.cs.TCTL.TCTLPathToStateConverter;
import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.TCTL.TCTLStatePlaceHolder;
import dk.aau.cs.TCTL.TCTLStateToPathConverter;
import dk.aau.cs.TCTL.TCTLTransitionNode;
import dk.aau.cs.TCTL.TCTLTrueNode;
import dk.aau.cs.TCTL.visitors.FixAbbrivPlaceNames;
import dk.aau.cs.TCTL.visitors.FixAbbrivTransitionNames;
import dk.aau.cs.TCTL.visitors.HasDeadlockVisitor;
import dk.aau.cs.TCTL.visitors.HyperLTLTraceNameVisitor;
import dk.aau.cs.TCTL.visitors.IsReachabilityVisitor;
import dk.aau.cs.TCTL.visitors.RenameAllPlacesVisitor;
import dk.aau.cs.TCTL.visitors.RenameAllTransitionsVisitor;
import dk.aau.cs.TCTL.visitors.VerifyPlaceNamesVisitor;
import dk.aau.cs.TCTL.visitors.VerifyTransitionNamesVisitor;
import dk.aau.cs.approximation.OverApproximation;
import dk.aau.cs.approximation.UnderApproximation;
import dk.aau.cs.io.TimedArcPetriNetNetworkWriter;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.UnsupportedModelException;
import dk.aau.cs.util.UnsupportedQueryException;
import dk.aau.cs.util.VerificationCallback;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.SMCSettings;
import dk.aau.cs.verification.SMCStats;
import dk.aau.cs.verification.SMCTraceType;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.UPPAAL.UppaalExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyCPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOptions;
import dk.aau.cs.verification.observations.Observation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.dialog.DocumentFilters;
import net.tapaal.gui.petrinet.dialog.ObservationListDialog;
import net.tapaal.gui.petrinet.dialog.QuerySlider;
import net.tapaal.gui.petrinet.undo.AddQueryCommand;
import net.tapaal.gui.petrinet.verification.ChooseInclusionPlacesDialog;
import net.tapaal.gui.petrinet.verification.EngineSupportOptions;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.RunVerificationBase;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.verification.UPPAALBroadcastDegree2Options;
import net.tapaal.gui.petrinet.verification.UPPAALBroadcastOptions;
import net.tapaal.gui.petrinet.verification.UPPAALCombiOptions;
import net.tapaal.gui.petrinet.verification.UPPAALOptimizedStandardOptions;
import net.tapaal.gui.petrinet.verification.UPPAALStandardOptions;
import net.tapaal.gui.petrinet.verification.Verifier;
import net.tapaal.gui.petrinet.verification.VerifyDTAPNEngineOptions;
import net.tapaal.gui.petrinet.verification.VerifyPNEngineOptions;
import net.tapaal.gui.petrinet.verification.VerifyTAPNEngineOptions;
import net.tapaal.gui.petrinet.widgets.QueryPane;
import net.tapaal.helpers.Enabler;
import net.tapaal.swinghelpers.CustomJSpinner;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.SearchBar;
import pipe.gui.petrinet.Searcher;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.swingcomponents.EscapableDialog;
import pipe.gui.swingcomponents.filebrowser.FileBrowser;

public class QueryDialog
extends JPanel {
    private static final String NO_UPPAAL_XML_FILE_SAVED = "No Uppaal XML file saved.";
    private static final String NO_VERIFYTAPN_XML_FILE_SAVED = "No verifytapn XML file saved.";
    private static final String UNSUPPORTED_MODEL_TEXT = "The model is not supported by the chosen reduction.";
    private static final String UNSUPPORTED_QUERY_TEXT = "The query is not supported by the chosen reduction.";
    private static final String EXPORT_UPPAAL_BTN_TEXT = "Export UPPAAL XML";
    private static final String EXPORT_VERIFYTAPN_BTN_TEXT = "Export TAPAAL XML";
    private static final String EXPORT_VERIFYPN_BTN_TEXT = "Export PN XML";
    private static final String EXPORT_COMPOSED_BTN_TEXT = "Merge net components";
    private static final String OPEN_REDUCED_BTN_TEXT = "Open reduced net";
    public static final String UPDATE_VERIFICATION_TIME_BTN_TEXT = "Compute estimated verification time";
    public static final String UPDATE_PRECISION_BTN_TEXT = "Compute precision for the given verification time";
    private static final String UPPAAL_SOME_TRACE_STRING = "Some trace       ";
    private static final String SHARED = "Shared";
    private boolean querySaved = false;
    private final JRootPane rootPane;
    private static EscapableDialog guiDialog;
    private JPanel namePanel;
    private JComboBox queryType;
    private JButton advancedButton;
    private JPanel boundednessCheckPanel;
    private CustomJSpinner numberOfExtraTokensInNet;
    private JButton kbounded;
    private JPanel queryPanel;
    private JPanel quantificationPanel;
    private ButtonGroup quantificationButtonGroup;
    private JButton existsDiamond;
    private JButton existsBox;
    private JButton existsNext;
    private JButton existsUntil;
    private JButton forAllDiamond;
    private JButton forAllBox;
    private JButton forAllNext;
    private JButton forAllUntil;
    private JButton globallyButton;
    private JButton finallyButton;
    private JButton nextButton;
    private JButton untilButton;
    private JButton aButton;
    private JButton eButton;
    private JTextPane queryField;
    private JPanel logicButtonPanel;
    private ButtonGroup logicButtonGroup;
    private JButton conjunctionButton;
    private JButton disjunctionButton;
    private JButton negationButton;
    private JPanel editingButtonPanel;
    private ButtonGroup editingButtonsGroup;
    private JButton deleteButton;
    private JButton resetButton;
    private JButton undoButton;
    private JButton redoButton;
    private JButton editQueryButton;
    private JPanel predicatePanel;
    private JButton addPredicateButton;
    private SearchBar searchBar;
    private Searcher<Tuple<?, String>> searcher;
    private JComboBox templateBox;
    private JComboBox traceBox;
    private JComboBox traceBoxQuantification;
    private JComboBox<String> placeTransitionBox;
    private JComboBox<String> relationalOperatorBox;
    private JLabel transitionIsEnabledLabel;
    private CustomJSpinner placeMarking;
    private JButton addTraceButton;
    private JButton truePredicateButton;
    private JButton falsePredicateButton;
    private JButton deadLockPredicateButton;
    private JPanel searchOptionsPanel;
    private JPanel uppaalOptionsPanel;
    private ButtonGroup searchRadioButtonGroup;
    private JRadioButton breadthFirstSearch;
    private JRadioButton depthFirstSearch;
    private JRadioButton randomSearch;
    private JRadioButton heuristicSearch;
    private JTextField traceTextField;
    private JButton addTracePanelButton;
    private JTextField traceNameTextField;
    private DefaultListModel traceModel;
    private DefaultListModel tempTraceModel;
    private JButton traceRemoveButton;
    private JList traceList;
    private JList tempTraceList;
    private JButton okButton;
    private EscapableDialog traceDialog;
    private JPanel traceRow;
    private JPanel traceOptionsPanel;
    private ButtonGroup traceRadioButtonGroup;
    private JRadioButton noTraceRadioButton;
    private JRadioButton someTraceRadioButton;
    private JRadioButton fastestTraceRadioButton;
    private JPanel verificationPanel;
    private JPanel unfoldingOptionsPanel;
    private JCheckBox usePartitioning;
    private JCheckBox useSymmetricvars;
    private JCheckBox useColorFixpoint;
    private JPanel reductionOptionsPanel;
    private JComboBox<String> reductionOption;
    private JCheckBox symmetryReduction;
    private JCheckBox discreteInclusion;
    private JButton selectInclusionPlacesButton;
    private JCheckBox useTimeDarts;
    private JCheckBox usePTrie;
    private JCheckBox useGCD;
    private JCheckBox skeletonAnalysis;
    private JCheckBox useSiphonTrap;
    private JCheckBox useQueryReduction;
    private JCheckBox useReduction;
    private JCheckBox useColoredReduction;
    private JCheckBox useStubbornReduction;
    private JCheckBox useTraceRefinement;
    private JCheckBox useTarjan;
    private JCheckBox useExplicitSearch;
    private JPanel rawVerificationOptionsPanel;
    private JTextArea rawVerificationOptionsTextArea;
    private JCheckBox rawVerificationOptionsEnabled;
    private JButton rawVerificationOptionsHelpButton;
    private JPanel overApproximationOptionsPanel;
    private ButtonGroup approximationRadioButtonGroup;
    private JRadioButton noApproximationEnable;
    private JRadioButton overApproximationEnable;
    private JRadioButton underApproximationEnable;
    private CustomJSpinner overApproximationDenominator;
    private JPanel smcSettingsPanel;
    private JComboBox<String> smcVerificationType;
    private JLabel smcVerificationTypeLabel;
    private JTextField smcTimeBoundValue;
    private JCheckBox smcTimeBoundInfinite;
    private JTextField smcStepBoundValue;
    private JCheckBox smcStepBoundInfinite;
    private JLabel smcNumericPrecisionLabel;
    private CustomJSpinner smcNumericPrecision;
    private JPanel quantitativePanel;
    private JLabel smcParallelLabel;
    private JCheckBox smcParallel;
    private JTextField smcConfidence;
    private QuerySlider smcConfidenceSlider;
    private QuerySlider smcPrecisionSlider;
    private QuerySlider smcEstimatedTimeSlider;
    private JTextField smcEstimationIntervalWidth;
    private JTextField smcTimeExpected;
    private JButton smcTimeEstimationButton;
    private JPanel qualitativePanel;
    private JTextField smcFalsePositives;
    private JTextField smcFalseNegatives;
    private JTextField smcIndifference;
    private JTextField smcComparisonFloat;
    private QuerySlider smcFalsePositivesSlider;
    private QuerySlider smcFalseNegativesSlider;
    private QuerySlider smcIndifferenceSlider;
    private QuerySlider smcComparisonFloatSlider;
    private JPanel smcTracePanel;
    private CustomJSpinner smcNumberOfTraces;
    private JComboBox<SMCTraceType> smcTraceType;
    private SMCSettings smcSettings;
    private boolean updatingSmcSettings = false;
    private boolean smcMustUpdateTime = true;
    private boolean doingBenchmark = false;
    private RunVerificationBase benchmarkThread = null;
    private List<Observation> smcObservations;
    private JTextField smcGranularityField;
    private JCheckBox smcMaxGranularityCheckbox;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton saveButton;
    private JButton saveAndVerifyButton;
    private JButton saveUppaalXMLButton;
    private JButton mergeNetComponentsButton;
    private JButton openReducedNetButton;
    private StringPosition currentSelection = null;
    private final TimedArcPetriNetNetwork tapnNetwork;
    private final HashMap<TimedArcPetriNet, DataLayer> guiModels;
    private QueryConstructionUndoManager undoManager;
    private UndoableEditSupport undoSupport;
    private final boolean isNetDegree2;
    private final int highestNetDegree;
    private final boolean hasInhibitorArcs;
    private InclusionPlaces inclusionPlaces;
    private final TAPNLens lens;
    private final PetriNetTab tab;
    private static final String name_verifyTAPN = "TAPAAL: Continuous Engine (verifytapn)";
    private static final String name_COMBI = "UPPAAL: Optimized Broadcast Reduction";
    private static final String name_OPTIMIZEDSTANDARD = "UPPAAL: Optimized Standard Reduction";
    private static final String name_STANDARD = "UPPAAL: Standard Reduction";
    private static final String name_BROADCAST = "UPPAAL: Broadcast Reduction";
    private static final String name_BROADCASTDEG2 = "UPPAAL: Broadcast Degree 2 Reduction";
    private static final String name_DISCRETE = "TAPAAL: Discrete Engine (verifydtapn)";
    private static final String name_UNTIMED = "TAPAAL: Untimed Engine (verifypn)";
    private boolean userChangedAtomicPropSelection = true;
    private static final EngineSupportOptions verifyTAPNOptions;
    private static final EngineSupportOptions UPPAALCombiOptions;
    private static final EngineSupportOptions UPPAALOptimizedStandardOptions;
    private static final EngineSupportOptions UPPAALStandardOptions;
    private static final EngineSupportOptions UPPAALBroadcastOptions;
    private static final EngineSupportOptions UPPAALBroadcastDegree2Options;
    private static final EngineSupportOptions verifyDTAPNOptions;
    private static final EngineSupportOptions verifyPNOptions;
    private static final EngineSupportOptions[] engineSupportOptions;
    private TCTLAbstractProperty newProperty;
    private TCTLAbstractProperty previousProp;
    private JTextField queryName;
    private static Boolean advancedView;
    private static boolean hasForcedDisabledTimeDarts;
    private static boolean hasForcedDisabledStubbornReduction;
    private static boolean hasForcedDisabledGCD;
    private static boolean disableSymmetryUpdate;
    private boolean wasCTLType = true;
    private boolean wasLTLType = true;
    private boolean wasHyperLTLType = true;
    private boolean isAllPath = false;
    private boolean isExistsPath = false;
    private boolean updateTraceBox = true;
    private boolean updateTraceBoxQuantification = true;
    private static final String TOOL_TIP_QUERYNAME = "Enter the name of the query.";
    private static final String TOOL_TIP_INFO_BUTTON = "Get help on the different verification options.";
    private static final String TOOL_TIP_QUERY_TYPE = "Choose the type of query.";
    private static final String TOOL_TIP_ADVANCED_VIEW_BUTTON = "Switch to the advanced view.";
    private static final String TOOL_TIP_SIMPLE_VIEW_BUTTON = "Switch to the simple view.";
    private static final String TOOL_TIP_QUERY_FIELD = "<html>Click on a part of the query you want to edit.<br />(Queries can also be edited manually by pressing the \"Edit Query\" button.)</html>";
    private static final String TOOL_TIP_EXISTS_DIAMOND = "Check if the given marking is reachable in the net.";
    private static final String TOOL_TIP_EXISTS_BOX = "Check if there is a trace on which all markings satisfy the given property. (Only available for some verification engines.)";
    private static final String TOOL_TIP_FORALL_DIAMOND = "Check if on any maximal trace there is a marking that satisfies the given property. (Only available for some verification engines.)";
    private static final String TOOL_TIP_FORALL_BOX = "Check if every reachable marking in the net satisfies the given property.";
    private static final String TOOL_TIP_EXISTS_UNTIL = "There is a computation where the first formula holds until the second one holds.";
    private static final String TOOL_TIP_EXISTS_NEXT = "There is a transition firing after which the reached marking satisfies the given property.";
    private static final String TOOL_TIP_FORALL_UNTIL = "On every computation the first formula holds until the second one holds";
    private static final String TOOL_TIP_FORALL_NEXT = "After any transition firing the reached marking satisfies the given property.";
    private static final String TOOL_TIP_G = "Globally";
    private static final String TOOL_TIP_F = "Eventually";
    private static final String TOOL_TIP_U = "Until";
    private static final String TOOL_TIP_X = "Next";
    private static final String TOOL_TIP_E = "Switch to check if there exists a computation where the formula holds.";
    private static final String TOOL_TIP_A = "Switch to check if the formula holds for every computation.";
    private static final String TOOL_TIP_CONJUNCTIONBUTTON = "Expand the currently selected part of the query with a conjunction.";
    private static final String TOOL_TIP_DISJUNCTIONBUTTON = "Expand the currently selected part of the query with a disjunction.";
    private static final String TOOL_TIP_NEGATIONBUTTON = "Negate the currently selected part of the query.";
    private static final String TOOL_TIP_PLACESBOX = "Choose a place for the predicate.";
    private static final String TOOL_TIP_TEMPLATEBOX = "Choose a component considered for this predicate.";
    private static final String TOOL_TIP_RELATIONALOPERATORBOX = "Choose a relational operator comparing the number of tokens in the chosen place.";
    private static final String TOOL_TIP_PLACEMARKING = "Choose a number of tokens.";
    private static final String TOOL_TIP_ADDPREDICATEBUTTON = "Add the predicate specified above to the query.";
    private static final String TOOL_TIP_TRUEPREDICATEBUTTON = "Add the value true to the query.";
    private static final String TOOL_TIP_FALSEPREDICATEBUTTON = "Add the value false to the query.";
    private static final String TOOL_TIP_DEADLOCKPREDICATEBUTTON = "<html>Add the deadlock predicate to the query.<br /><br />A marking is a deadlock if there is no delay<br /> after which at least one transition gets enabled.</html>";
    private static final String TOOL_TIP_TRACEBOX = "Choose a trace for this predicate.";
    private static final String TOOL_TIP_TRACEBOX_QUANTIFICATION = "Choose a trace for quantification.";
    private static final String TOOL_TIP_ADDTRACEBUTTON = "Add or remove new traces";
    private static final String TOOL_TIP_DELETEBUTTON = "Delete the currently selected part of the query.";
    private static final String TOOL_TIP_RESETBUTTON = "Completely reset the query.";
    private static final String TOOL_TIP_UNDOBUTTON = "Undo the last action.";
    private static final String TOOL_TIP_REDOBUTTON = "Redo the last undone action.";
    private static final String TOOL_TIP_EDITQUERYBUTTON = "Edit the query manually.";
    private static final String TOOL_TIP_PARSE_QUERY = "Parse the manually edited query.";
    private static final String TOOL_TIP_CANCEL_QUERY = "Cancel manual query creating.";
    private static final String TOOL_TIP_NUMBEROFEXTRATOKENSINNET = "A number of extra tokens allowed in the net.";
    private static final String TOOL_TIP_KBOUNDED = "Check whether the net is bounded for the given number of extra tokens.";
    private static final String TOOL_TIP_REDUCTION_OPTION = "Choose a verification engine.";
    private static final String TOOL_TIP_SYMMETRY_REDUCTION = "Apply automatic symmetry reduction.";
    private static final String TOOL_TIP_DISCRETE_INCLUSION = "<html>This optimization will perform a more advanced inclusion check.";
    private static final String TOOL_TIP_SELECT_INCLUSION_PLACES = "Manually select places considered for the inclusion check.";
    private static final String TOOL_TIP_TIME_DARTS = "Use the time dart optimization";
    private static final String TOOL_TIP_PTRIE = "Use the PTrie memory optimization";
    private static final String TOOL_TIP_STUBBORN_REDUCTION = "Apply partial order reduction (only for EF and AG queries and when Time Darts are disabled).";
    private static final String TOOL_TIP_GCD = "Calculate greatest common divisor to minimize constants in the model";
    private static final String TOOL_TIP_OVERAPPROX = "Run linear over-approximation check for EF and AG queries";
    private static final String TOOL_TIP_USE_STRUCTURALREDUCTION = "Apply structural reductions to reduce the size of the net.";
    private static final String TOOL_TIP_USE_COLORED_STRUCTURALREDUCTION = "Apply colored structural reductions to reduce the size of the net.";
    private static final String TOOL_TIP_USE_SIPHONTRAP = "For a deadlock query, attempt to prove deadlock-freedom by using siphon-trap analysis via linear programming.";
    private static final String TOOL_TIP_USE_QUERY_REDUCTION = "Use query rewriting rules and linear programming (state equations) to reduce the size of the query.";
    private static final String TOOL_TIP_USE_TRACE_REFINEMENT = "Enables Trace Abstraction Refinement for reachability properties";
    private static final String TOOL_TIP_USE_TARJAN = "Uses the Tarjan algorithm when verifying. If not selected it will verify using the nested DFS algorithm.";
    private static final String TOOL_TIP_USE_EXPLICIT_SEARCH = "Use explicit search engine";
    private static final String TOOL_TIP_RAW_VERIFICATION_ENABLED_CHECKBOX = "Enable verification options for the engine.";
    private static final String TOOL_TIP_RAW_VERIFICATION_TEXT_FIELD = "Enter verification options for the engine.";
    private static final String TOOL_TIP_RAW_VERIFICATION_HELP_BUTTON = "Show engine options.";
    private static final String TOOL_TIP_PARTITIONING = "Partitions the colors into logically equivalent groups before unfolding";
    private static final String TOOL_TIP_COLOR_FIXPOINT = "Explores the possible colored markings and only unfolds for those";
    private static final String TOOL_TIP_SYMMETRIC_VARIABLES = "Finds variables with equivalent behavior and treats them as the same variable";
    private static final String TOOL_TIP_HEURISTIC_SEARCH = "<html>Uses a heuristic method in state space exploration.<br />If heuristic search is not applicable, BFS is used instead.<br/>For reachability queries, uses an improved heuristic search with randomness.<br/>Click the button <em>Help on the query options</em> to get more info.</html>";
    private static final String TOOL_TIP_BREADTH_FIRST_SEARCH = "Explores markings in a breadth first manner.";
    private static final String TOOL_TIP_DEPTH_FIRST_SEARCH = "Explores markings in a depth first manner.";
    private static final String TOOL_TIP_RANDOM_SEARCH = "Performs a random exploration of the state space.";
    private static final String TOOL_TIP_FASTEST_TRACE = "Show a fastest concrete trace if applicable (verification can be slower with this trace option).";
    private static final String TOOL_TIP_SOME_TRACE = "Show a concrete trace whenever applicable.";
    private static final String TOOL_TIP_NO_TRACE = "Do not display any trace information.";
    private static final String TOOL_TIP_SAVE_BUTTON = "Save the query.";
    private static final String TOOL_TIP_SAVE_AND_VERIFY_BUTTON = "Save and verify the query.";
    private static final String TOOL_TIP_CANCEL_BUTTON = "Cancel the changes made in this dialog.";
    private static final String TOOL_TIP_SAVE_UPPAAL_BUTTON = "Export an xml file that can be opened in UPPAAL GUI.";
    private static final String TOOL_TIP_SAVE_COMPOSED_BUTTON = "Open a composed net in a new tab and use approximated net if enabled";
    private static final String TOOL_TIP_OPEN_REDUCED_BUTTON = "Open the net produced after applying structural reduction rules";
    private static final String TOOL_TIP_SAVE_TAPAAL_BUTTON = "Export an xml file that can be used as input for the TAPAAL engine.";
    private static final String TOOL_TIP_SAVE_PN_BUTTON = "Export an xml file that can be used as input for the untimed Petri net engine.";
    private static final String TOOL_TIP_APPROXIMATION_METHOD_NONE = "No approximation method is used.";
    private static final String TOOL_TIP_APPROXIMATION_METHOD_OVER = "Approximate by dividing all intervals with the approximation constant and enlarging the intervals.";
    private static final String TOOL_TIP_APPROXIMATION_METHOD_UNDER = "Approximate by dividing all intervals with the approximation constant and shrinking the intervals.";
    private static final String TOOL_TIP_APPROXIMATION_CONSTANT = "Choose approximation constant";
    private static final String TOOL_TIP_ANALYSIS_TYPE = "Choose between probability quantitative estimation, qualitative hypothesis testing against a fixed probability, or trace generation.";
    private static final String TOOL_TIP_TIME_BOUND = "Bound each run by a maximum accumulated delay";
    private static final String TOOL_TIP_STEP_BOUND = "Bound each run by a maximum number of transition firings";
    private static final String TOOL_TIP_NUMERIC_PRECISION = "The number of digits (from 1 to 18) after the decimal point used in sampling from distributions.";
    private static final String TOOL_TIP_CONFIDENCE = "Between 0 and 1, confidence that the probability is indeed in the computed interval";
    private static final String TOOL_TIP_INTERVAL_WIDTH = "Between 0 and 1, error E of the computed probability (P\u00b1E)";
    private static final String TOOL_TIP_FALSE_POSITIVES = "Probability to accept the hypothesis if it is false";
    private static final String TOOL_TIP_FALSE_NEGATIVES = "Probability to reject the hypothesis if it is true";
    private static final String TOOL_TIP_INDIFFERENCE = "Width of the indifference region used as a threshold by the algorithm";
    private static final String TOOL_TIP_VERIFICATION_TIME = "Total estimated time (in seconds) to run the verification with the given confidence and precision";
    private static final String TOOL_TIP_QUALITATIVE_TEST = "Probability threshold to be tested";
    private static final String TOOL_TIP_N_TRACES = "Number of traces to be shown";
    private static final String TOOL_TIP_TRACE_TYPE = "Specifies the type of traces to be shown";
    private static final String TOOL_TIP_GRANULARITY = "Uses the given granularity for observations";
    private boolean oldExplicitSearchState;

    private QueryDialog(EscapableDialog me, QueryDialogueOption option, net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom, TimedArcPetriNetNetwork tapnNetwork, HashMap<TimedArcPetriNet, DataLayer> guiModels, TAPNLens lens, PetriNetTab tab) {
        this.tapnNetwork = tapnNetwork;
        this.guiModels = guiModels;
        this.lens = lens;
        this.tab = tab;
        this.inclusionPlaces = queryToCreateFrom == null ? new InclusionPlaces() : queryToCreateFrom.inclusionPlaces();
        this.newProperty = queryToCreateFrom == null ? new TCTLPathPlaceHolder() : queryToCreateFrom.getProperty();
        this.rootPane = me.getRootPane();
        this.isNetDegree2 = tapnNetwork.isDegree2();
        this.highestNetDegree = tapnNetwork.getHighestNetDegree();
        this.hasInhibitorArcs = tapnNetwork.hasInhibitorArcs();
        this.setLayout(new GridBagLayout());
        this.init(option, queryToCreateFrom);
        this.makeShortcuts();
        this.toggleAdvancedSimpleView(false);
        if (lens.isStochastic()) {
            this.toggleSmc();
        }
    }

    private boolean checkIfSomeReductionOption() {
        if (this.reductionOption.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "No verification engine supports the combination of this query and the current model", "No verification engine", 0);
            return false;
        }
        return true;
    }

    private void setQueryFieldEditable(boolean isEditable) {
        this.queryField.setEditable(isEditable);
        this.queryField.setToolTipText(isEditable ? null : TOOL_TIP_QUERY_FIELD);
        this.queryField.setFocusable(false);
        this.queryField.setFocusable(true);
        this.queryField.requestFocus(true);
    }

    public net.tapaal.gui.petrinet.verification.TAPNQuery getQuery() {
        int oldCapacity;
        if (!this.querySaved) {
            return null;
        }
        String name = this.getQueryComment();
        int capacity = oldCapacity = this.getCapacity();
        if (this.rawVerificationOptionsEnabled.isSelected()) {
            TAPNComposer composer = new TAPNComposer(new MessengerImpl(), false);
            Tuple<TimedArcPetriNet, NameMapping> transformedModel = composer.transformModel(this.tapnNetwork);
            int tokensInModel = transformedModel.value1().getNumberOfTokensInNet();
            String rawOptions = this.rawVerificationOptionsTextArea.getText();
            Pattern pattern = Pattern.compile("(--k-bound|-k)\\s+(\\d+)");
            Matcher matcher = pattern.matcher(rawOptions);
            if (matcher.find()) {
                int totalTokens = Integer.parseInt(matcher.group(2));
                capacity = totalTokens - tokensInModel;
            }
        }
        TAPNQuery.TraceOption traceOption = this.getTraceOption();
        TAPNQuery.SearchOption searchOption = this.getSearchOption();
        ReductionOption reductionOptionToSet = this.getReductionOption();
        ArrayList<String> traceList = new ArrayList<String>();
        if (this.queryType.getSelectedIndex() == 2) {
            for (int i = 0; i < this.traceModel.getSize(); ++i) {
                traceList.add(this.traceModel.get(i).toString());
            }
        }
        if (!this.lens.isTimed()) {
            return this.getUntimedQuery(name, traceList, capacity, oldCapacity, traceOption, searchOption, reductionOptionToSet);
        }
        return this.getTimedQuery(name, capacity, oldCapacity, traceOption, searchOption, reductionOptionToSet);
    }

    private net.tapaal.gui.petrinet.verification.TAPNQuery getTimedQuery(String name, int capacity, int oldCapacity, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption searchOption, ReductionOption reductionOptionToSet) {
        boolean symmetry = this.getSymmetry();
        boolean timeDarts = this.useTimeDarts.isSelected();
        boolean pTrie = this.usePTrie.isSelected();
        boolean gcd = this.useGCD.isSelected() && !this.lens.isStochastic();
        boolean overApproximation = this.skeletonAnalysis.isSelected() && !this.lens.isStochastic();
        boolean reduction = this.useReduction.isSelected();
        net.tapaal.gui.petrinet.verification.TAPNQuery query = new net.tapaal.gui.petrinet.verification.TAPNQuery(name, capacity, this.newProperty.copy(), traceOption, searchOption, reductionOptionToSet, symmetry, gcd, timeDarts, pTrie, overApproximation, reduction, null, null, this.inclusionPlaces, this.overApproximationEnable.isSelected(), this.underApproximationEnable.isSelected(), (Integer)this.overApproximationDenominator.getValue(), false, false, false, this.lens.isColored(), false, this.rawVerificationOptionsEnabled.isSelected(), this.rawVerificationOptionsTextArea.getText());
        query.setOldCapacity(oldCapacity);
        query.setUseStubbornReduction(this.useStubbornReduction.isSelected());
        if (reductionOptionToSet != null && reductionOptionToSet.equals((Object)ReductionOption.VerifyTAPN)) {
            query.setDiscreteInclusion(this.discreteInclusion.isSelected());
        }
        if (this.lens.isStochastic()) {
            query.setCategory(TAPNQuery.QueryCategory.SMC);
            query.setParallel(this.smcParallel.isSelected());
            TAPNQuery.VerificationType verificationType = TAPNQuery.VerificationType.fromOrdinal(this.smcVerificationType.getSelectedIndex());
            if (verificationType.equals((Object)TAPNQuery.VerificationType.SIMULATE)) {
                SMCSettings newSettings = SMCSettings.Default();
                SMCSettings oldSettings = this.getSMCSettings();
                newSettings.setStepBound(oldSettings.getStepBound());
                newSettings.setTimeBound(oldSettings.getTimeBound());
                newSettings.setObservations(oldSettings.getObservations());
                newSettings.setNumericPrecision(oldSettings.getNumericPrecision());
                query.setSmcSettings(newSettings);
            } else {
                query.setSmcSettings(this.getSMCSettings());
            }
            query.setVerificationType(verificationType);
            query.setNumberOfTraces((Integer)this.smcNumberOfTraces.getValue());
            query.setSmcTraceType((SMCTraceType)this.smcTraceType.getSelectedItem());
            try {
                query.setGranularity(Integer.parseInt(this.smcGranularityField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            query.setMaxGranularity(this.smcMaxGranularityCheckbox.isSelected());
        }
        return query;
    }

    private net.tapaal.gui.petrinet.verification.TAPNQuery getUntimedQuery(String name, ArrayList<String> traceList, int capacity, int oldCapacity, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption searchOption, ReductionOption reductionOptionToSet) {
        boolean reduction = this.useReduction.isSelected();
        boolean coloredReduction = this.useColoredReduction.isSelected();
        net.tapaal.gui.petrinet.verification.TAPNQuery query = new net.tapaal.gui.petrinet.verification.TAPNQuery(name, capacity, this.newProperty.copy(), traceOption, searchOption, reductionOptionToSet, false, false, false, false, false, reduction, null, null, this.inclusionPlaces, false, false, 0, this.lens.isColored() ? this.usePartitioning.isSelected() : false, this.lens.isColored() ? this.useColorFixpoint.isSelected() : false, this.lens.isColored() ? this.useSymmetricvars.isSelected() : false, this.lens.isColored(), coloredReduction, this.rawVerificationOptionsEnabled.isSelected(), this.rawVerificationOptionsTextArea.getText());
        if (this.queryType.getSelectedIndex() == 1) {
            query.setCategory(TAPNQuery.QueryCategory.LTL);
        } else if (this.queryType.getSelectedIndex() == 2) {
            query.setCategory(TAPNQuery.QueryCategory.HyperLTL);
            query.setTraceList(traceList);
        } else {
            query.setCategory(TAPNQuery.QueryCategory.CTL);
        }
        query.setUseSiphontrap(this.useSiphonTrap.isSelected());
        query.setUseQueryReduction(this.useQueryReduction.isSelected());
        query.setUseStubbornReduction(this.useStubbornReduction.isSelected());
        query.setUseTarOption(this.useTraceRefinement.isSelected());
        query.setUseTarjan(this.useTarjan.isSelected());
        query.setUseExplicitSearch(this.useExplicitSearch.isSelected());
        return query;
    }

    private boolean getSymmetry() {
        return this.symmetryReduction.isSelected();
    }

    private int getCapacity() {
        return (Integer)((JSpinner)this.boundednessCheckPanel.getComponent(1)).getValue();
    }

    private String getQueryComment() {
        return ((JTextField)this.namePanel.getComponent(1)).getText();
    }

    private TAPNQuery.TraceOption getTraceOption() {
        if (this.someTraceRadioButton.isSelected()) {
            return TAPNQuery.TraceOption.SOME;
        }
        if (this.fastestTraceRadioButton.isSelected()) {
            return TAPNQuery.TraceOption.FASTEST;
        }
        return TAPNQuery.TraceOption.NONE;
    }

    private TAPNQuery.SearchOption getSearchOption() {
        if (this.fastestTraceRadioButton.isSelected()) {
            return TAPNQuery.SearchOption.DEFAULT;
        }
        if (this.depthFirstSearch.isSelected()) {
            return TAPNQuery.SearchOption.DFS;
        }
        if (this.randomSearch.isSelected()) {
            return TAPNQuery.SearchOption.RANDOM;
        }
        if (this.heuristicSearch.isSelected()) {
            if (!this.lens.isTimed() && !this.lens.isGame() && this.isReachabilityQuery() && !this.useExplicitSearch.isSelected()) {
                return TAPNQuery.SearchOption.RANDOMHEURISTIC;
            }
            return TAPNQuery.SearchOption.HEURISTIC;
        }
        if (this.breadthFirstSearch.isSelected()) {
            return TAPNQuery.SearchOption.BFS;
        }
        return TAPNQuery.SearchOption.DEFAULT;
    }

    private ReductionOption getReductionOption() {
        String reductionOptionString = this.getReductionOptionAsString();
        if (reductionOptionString == null) {
            return null;
        }
        if (reductionOptionString.equals(name_STANDARD)) {
            return ReductionOption.STANDARD;
        }
        if (reductionOptionString.equals(name_COMBI)) {
            return ReductionOption.COMBI;
        }
        if (reductionOptionString.equals(name_OPTIMIZEDSTANDARD)) {
            return ReductionOption.OPTIMIZEDSTANDARD;
        }
        if (reductionOptionString.equals(name_BROADCASTDEG2)) {
            return ReductionOption.DEGREE2BROADCAST;
        }
        if (reductionOptionString.equals(name_verifyTAPN)) {
            return ReductionOption.VerifyTAPN;
        }
        if (reductionOptionString.equals(name_DISCRETE)) {
            return ReductionOption.VerifyDTAPN;
        }
        if (reductionOptionString.equals(name_UNTIMED)) {
            return ReductionOption.VerifyPN;
        }
        return ReductionOption.BROADCAST;
    }

    private String getReductionOptionAsString() {
        return (String)this.reductionOption.getSelectedItem();
    }

    private void refreshTraceOptions() {
        if (this.reductionOption.getSelectedItem() == null || this.rawVerificationOptionsEnabled.isSelected()) {
            return;
        }
        if (this.lens.isGame()) {
            this.fastestTraceRadioButton.setEnabled(false);
            this.someTraceRadioButton.setEnabled(false);
            this.noTraceRadioButton.setEnabled(true);
        } else if (this.lens.isTimed()) {
            this.fastestTraceRadioButton.setEnabled(this.tapnNetwork.isNonStrict() && !this.queryHasDeadlock() && !(this.newProperty instanceof TCTLEGNode) && !(this.newProperty instanceof TCTLAFNode));
            this.someTraceRadioButton.setEnabled(true);
            this.noTraceRadioButton.setEnabled(true);
        } else if (this.queryIsReachability() || this.queryType.getSelectedIndex() == 1 || this.queryType.getSelectedIndex() == 2) {
            this.fastestTraceRadioButton.setEnabled(false);
            this.someTraceRadioButton.setEnabled(true);
            this.noTraceRadioButton.setEnabled(true);
        } else {
            this.fastestTraceRadioButton.setEnabled(false);
            this.someTraceRadioButton.setEnabled(false);
            this.noTraceRadioButton.setEnabled(false);
            this.noTraceRadioButton.setSelected(true);
        }
        if (this.getTraceOption() == TAPNQuery.TraceOption.FASTEST) {
            if (this.fastestTraceRadioButton.isEnabled()) {
                this.fastestTraceRadioButton.setSelected(true);
            } else if (this.someTraceRadioButton.isEnabled()) {
                this.someTraceRadioButton.setSelected(true);
            } else {
                this.noTraceRadioButton.setSelected(true);
            }
        }
    }

    private void updateSMCSettings() {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat precisionFormat = new DecimalFormat("#.#####", decimalFormatSymbols);
        this.smcSettings.compareToFloat = this.smcVerificationType.getSelectedIndex() == 1;
        try {
            this.smcSettings.timeBound = this.smcTimeBoundInfinite.isSelected() ? Integer.MAX_VALUE : Integer.parseInt(this.smcTimeBoundValue.getText());
        }
        catch (NumberFormatException e) {
            this.smcSettings.timeBound = 1000;
            this.smcTimeBoundValue.setText("1000");
        }
        this.smcTimeBoundValue.setEnabled(!this.smcTimeBoundInfinite.isSelected() && !this.doingBenchmark);
        try {
            this.smcSettings.stepBound = this.smcStepBoundInfinite.isSelected() ? Integer.MAX_VALUE : Integer.parseInt(this.smcStepBoundValue.getText());
        }
        catch (NumberFormatException e) {
            this.smcSettings.stepBound = 1000;
            this.smcStepBoundValue.setText("1000");
        }
        this.smcStepBoundValue.setEnabled(!this.smcStepBoundInfinite.isSelected());
        this.smcTimeBoundInfinite.setEnabled(!this.smcStepBoundInfinite.isSelected());
        this.smcStepBoundInfinite.setEnabled(!this.smcTimeBoundInfinite.isSelected());
        this.smcSettings.setNumericPrecision(((Integer)this.smcNumericPrecision.getValue()).longValue());
        try {
            this.smcSettings.confidence = Float.parseFloat(this.smcConfidence.getText());
        }
        catch (NumberFormatException e) {
            this.smcConfidence.setText(String.valueOf(this.smcSettings.confidence));
        }
        try {
            this.smcSettings.estimationIntervalWidth = this.doingBenchmark && !this.smcMustUpdateTime ? 0.01f : Float.parseFloat(this.smcEstimationIntervalWidth.getText());
        }
        catch (NumberFormatException e) {
            this.smcEstimationIntervalWidth.setText(precisionFormat.format(this.smcSettings.estimationIntervalWidth));
        }
        try {
            this.smcSettings.falsePositives = Float.parseFloat(this.smcFalsePositives.getText());
        }
        catch (NumberFormatException e) {
            this.smcFalsePositives.setText(String.valueOf(this.smcSettings.falsePositives));
        }
        try {
            this.smcSettings.falseNegatives = Float.parseFloat(this.smcFalseNegatives.getText());
        }
        catch (NumberFormatException e) {
            this.smcFalseNegatives.setText(String.valueOf(this.smcSettings.falseNegatives));
        }
        try {
            this.smcSettings.indifferenceWidth = Float.parseFloat(this.smcIndifference.getText());
        }
        catch (NumberFormatException e) {
            this.smcIndifference.setText(String.valueOf(this.smcSettings.indifferenceWidth));
        }
        try {
            this.smcSettings.geqThan = Float.parseFloat(this.smcComparisonFloat.getText());
        }
        catch (NumberFormatException e) {
            this.smcComparisonFloat.setText(String.valueOf(this.smcSettings.geqThan));
        }
    }

    private SMCSettings getSMCSettings() {
        this.updateSMCSettings();
        return this.smcSettings;
    }

    private void setSMCSettings(SMCSettings settings) {
        this.updatingSmcSettings = true;
        this.smcSettings = settings;
        double desiredMinConfidence = this.smcConfidenceSlider.getDesiredMin();
        double desiredMaxConfidence = this.smcConfidenceSlider.getDesiredMax();
        double initialProportionConfidence = ((double)settings.confidence - desiredMinConfidence) / (desiredMaxConfidence - desiredMinConfidence);
        int initialValueConfidence = (int)(initialProportionConfidence * (double)this.smcConfidenceSlider.getMaximum());
        this.smcConfidenceSlider.setValue(Math.max(this.smcConfidenceSlider.getMinimum(), Math.min(initialValueConfidence, this.smcConfidenceSlider.getMaximum())));
        double desiredMinPrecision = this.smcPrecisionSlider.getDesiredMin();
        double desiredMaxPrecision = this.smcPrecisionSlider.getDesiredMax();
        double logMin = Math.log(desiredMinPrecision);
        double logMax = Math.log(desiredMaxPrecision);
        double initialProportionPrecision = (Math.log(settings.estimationIntervalWidth) - logMin) / (logMax - logMin);
        int initialValuePrecision = (int)(initialProportionPrecision * (double)this.smcPrecisionSlider.getMaximum());
        this.smcPrecisionSlider.setValue(Math.max(this.smcPrecisionSlider.getMinimum(), Math.min(initialValuePrecision, this.smcPrecisionSlider.getMaximum())));
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat precisionFormat = new DecimalFormat("#.#####", decimalFormatSymbols);
        this.smcVerificationType.setSelectedIndex(settings.compareToFloat ? 1 : 0);
        this.smcTimeBoundValue.setText(this.smcSettings.timeBound < Integer.MAX_VALUE ? String.valueOf(this.smcSettings.timeBound) : "");
        this.smcTimeBoundInfinite.setSelected(this.smcSettings.timeBound == Integer.MAX_VALUE);
        this.smcTimeBoundValue.setEnabled(!this.smcTimeBoundInfinite.isSelected() && !this.doingBenchmark);
        this.smcStepBoundValue.setText(this.smcSettings.stepBound < Integer.MAX_VALUE ? String.valueOf(this.smcSettings.stepBound) : "");
        this.smcStepBoundInfinite.setSelected(this.smcSettings.stepBound == Integer.MAX_VALUE);
        this.smcStepBoundValue.setEnabled(!this.smcStepBoundInfinite.isSelected());
        this.smcTimeBoundInfinite.setEnabled(!this.smcStepBoundInfinite.isSelected());
        this.smcStepBoundInfinite.setEnabled(!this.smcTimeBoundInfinite.isSelected());
        this.smcNumericPrecision.setValue((int)settings.getNumericPrecision());
        this.smcObservations = settings.getObservations();
        this.smcConfidence.setText(String.valueOf(settings.confidence));
        this.smcConfidenceSlider.setToolTipText(String.format("Value: %.2f", Float.valueOf(settings.confidence)));
        if (!this.doingBenchmark) {
            String formattedIntervalWidth = precisionFormat.format(settings.estimationIntervalWidth);
            this.smcEstimationIntervalWidth.setText(formattedIntervalWidth);
            this.smcPrecisionSlider.setToolTipText(String.format("Value: %s", formattedIntervalWidth));
        }
        double desiredMinFalsePositives = this.smcFalsePositivesSlider.getDesiredMin();
        double desiredMaxFalsePositives = this.smcFalsePositivesSlider.getDesiredMax();
        double initialProportionFalsePositives = ((double)settings.falsePositives - desiredMinFalsePositives) / (desiredMaxFalsePositives - desiredMinFalsePositives);
        int initialValueFalsePositives = (int)(initialProportionFalsePositives * (double)this.smcFalsePositivesSlider.getMaximum());
        this.smcFalsePositivesSlider.setValue(Math.max(this.smcFalsePositivesSlider.getMinimum(), Math.min(initialValueFalsePositives, this.smcFalsePositivesSlider.getMaximum())));
        this.smcFalsePositives.setText(String.valueOf(settings.falsePositives));
        this.smcFalsePositivesSlider.setToolTipText(String.format("Value: %.3f", Float.valueOf(settings.falsePositives)));
        double desiredMinFalseNegatives = this.smcFalseNegativesSlider.getDesiredMin();
        double desiredMaxFalseNegatives = this.smcFalseNegativesSlider.getDesiredMax();
        double initialProportionFalseNegatives = ((double)settings.falseNegatives - desiredMinFalseNegatives) / (desiredMaxFalseNegatives - desiredMinFalseNegatives);
        int initialValueFalseNegatives = (int)(initialProportionFalseNegatives * (double)this.smcFalseNegativesSlider.getMaximum());
        this.smcFalseNegativesSlider.setValue(Math.max(this.smcFalseNegativesSlider.getMinimum(), Math.min(initialValueFalseNegatives, this.smcFalseNegativesSlider.getMaximum())));
        this.smcFalseNegatives.setText(String.valueOf(settings.falseNegatives));
        this.smcFalseNegativesSlider.setToolTipText(String.format("Value: %.3f", Float.valueOf(settings.falseNegatives)));
        double desiredMinIndifference = this.smcIndifferenceSlider.getDesiredMin();
        double desiredMaxIndifference = this.smcIndifferenceSlider.getDesiredMax();
        double initialProportionIndifference = ((double)settings.indifferenceWidth - desiredMinIndifference) / (desiredMaxIndifference - desiredMinIndifference);
        int initialValueIndifference = (int)(initialProportionIndifference * (double)this.smcIndifferenceSlider.getMaximum());
        this.smcIndifferenceSlider.setValue(Math.max(this.smcIndifferenceSlider.getMinimum(), Math.min(initialValueIndifference, this.smcIndifferenceSlider.getMaximum())));
        this.smcIndifference.setText(String.valueOf(settings.indifferenceWidth));
        this.smcIndifferenceSlider.setToolTipText(String.format("Value: %.3f", Float.valueOf(settings.indifferenceWidth)));
        double desiredMinComparison = this.smcComparisonFloatSlider.getDesiredMin();
        double desiredMaxComparison = this.smcComparisonFloatSlider.getDesiredMax();
        double initialProportionComparison = ((double)settings.geqThan - desiredMinComparison) / (desiredMaxComparison - desiredMinComparison);
        int initialValueComparison = (int)(initialProportionComparison * (double)this.smcComparisonFloatSlider.getMaximum());
        this.smcComparisonFloatSlider.setValue(Math.max(this.smcComparisonFloatSlider.getMinimum(), Math.min(initialValueComparison, this.smcComparisonFloatSlider.getMaximum())));
        this.smcComparisonFloat.setText(String.valueOf(settings.geqThan));
        this.smcComparisonFloatSlider.setToolTipText(String.format("Value: %.2f", Float.valueOf(settings.geqThan)));
        this.updatingSmcSettings = false;
    }

    private boolean queryIsReachability() {
        return new IsReachabilityVisitor().isReachability(this.newProperty);
    }

    private void resetQuantifierSelectionButtons() {
        this.quantificationButtonGroup.clearSelection();
    }

    private void exit() {
        this.rootPane.getParent().setVisible(false);
    }

    public boolean queryHasDeadlock() {
        return new HasDeadlockVisitor().hasDeadLock(this.newProperty);
    }

    public static net.tapaal.gui.petrinet.verification.TAPNQuery showQueryDialogue(QueryDialogueOption option, net.tapaal.gui.petrinet.verification.TAPNQuery queryToRepresent, TimedArcPetriNetNetwork tapnNetwork, HashMap<TimedArcPetriNet, DataLayer> guiModels, TAPNLens lens, PetriNetTab tab) {
        if (tapnNetwork.hasWeights() && !tapnNetwork.isNonStrict()) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "No reduction option supports both strict intervals and weighted arcs", "No reduction option", 0);
            return null;
        }
        guiDialog = new EscapableDialog(TAPAALGUI.getApp(), "Edit Query", true);
        Container contentPane = guiDialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        QueryDialog queryDialogue = new QueryDialog(guiDialog, option, queryToRepresent, tapnNetwork, guiModels, lens, tab);
        guiDialog.setResizable(false);
        JScrollPane scrollPane = new JScrollPane(queryDialogue);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setBorder(null);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        contentPane.add((Component)scrollPane, gbc);
        guiDialog.pack();
        if (queryToRepresent != null && queryToRepresent.getCategory() == TAPNQuery.QueryCategory.HyperLTL) {
            queryDialogue.showHyperLTL(true);
            guiDialog.pack();
        } else {
            queryDialogue.showHyperLTL(false);
            guiDialog.pack();
        }
        guiDialog.setLocationRelativeTo(null);
        guiDialog.setVisible(true);
        return queryDialogue.getQuery();
    }

    private TCTLAbstractStateProperty getStateProperty(TCTLAbstractProperty property) {
        if (property instanceof TCTLAbstractStateProperty) {
            return (TCTLAbstractStateProperty)property.copy();
        }
        return new TCTLStatePlaceHolder();
    }

    private TCTLAbstractPathProperty getPathProperty(TCTLAbstractProperty property) {
        if (property instanceof TCTLAbstractPathProperty) {
            return (TCTLAbstractPathProperty)property.copy();
        }
        return new TCTLPathPlaceHolder();
    }

    private TCTLAbstractStateProperty getSpecificChildOfProperty(int number, TCTLAbstractProperty property) {
        StringPosition[] children = property.getChildren();
        int count = 0;
        for (int i = 0; i < children.length; ++i) {
            TCTLAbstractProperty child = children[i].getObject();
            if (!(child instanceof TCTLAbstractStateProperty) || ++count != number) continue;
            return (TCTLAbstractStateProperty)child;
        }
        return new TCTLStatePlaceHolder();
    }

    private void updateSelection() {
        int index = this.queryField.getCaretPosition();
        StringPosition position = this.newProperty.objectAt(index);
        if (position == null) {
            return;
        }
        this.queryField.select(position.getStart(), position.getEnd());
        this.currentSelection = position;
        this.refreshQueryEditingButtons();
    }

    private void updateSelection(TCTLAbstractProperty newSelection) {
        StringPosition position;
        this.queryField.setText(this.newProperty.toString());
        if (this.newProperty.containsPlaceHolder()) {
            TCTLAbstractProperty ph = this.newProperty.findFirstPlaceHolder();
            position = this.newProperty.indexOf(ph);
        } else {
            position = this.newProperty.indexOf(newSelection);
        }
        this.queryField.select(position.getStart(), position.getEnd());
        this.currentSelection = position;
        this.updateQueryButtonsAccordingToSelection();
        if (this.currentSelection != null) {
            this.setEnabledOptionsAccordingToCurrentReduction();
        } else {
            this.disableAllQueryButtons();
        }
    }

    private void updateQueryButtonsAccordingToSelection() {
        TCTLAbstractProperty current = this.currentSelection.getObject();
        if (current instanceof TCTLStateToPathConverter && !this.lens.isTimed()) {
            current = ((TCTLStateToPathConverter)current).getProperty();
        }
        this.updatePredicatesAccordingToSelection(current);
        if (!this.lens.isTimed()) {
            this.setEnablednessOfOperatorAndMarkingBoxes();
        }
        if (this.lens.isGame() && this.newProperty instanceof TCTLAbstractPathProperty && !(this.newProperty instanceof TCTLPathPlaceHolder)) {
            this.enableOnlyStateButtons();
        }
        if ((this.lens.isGame() || this.lens.isTimed() || this.queryType.getSelectedIndex() != 0) && (current instanceof TCTLAbstractPathProperty || this.newProperty instanceof TCTLPathPlaceHolder)) {
            boolean enableBooleanOperators = !(current instanceof LTLANode) && !(current instanceof LTLENode) && this.queryType.getSelectedIndex() != 0 && this.isValidLTL();
            this.disjunctionButton.setEnabled(enableBooleanOperators);
            this.conjunctionButton.setEnabled(enableBooleanOperators);
            this.negationButton.setEnabled(enableBooleanOperators);
        } else if (this.queryType.getSelectedIndex() == 0) {
            this.disjunctionButton.setEnabled(true);
            this.conjunctionButton.setEnabled(true);
            this.negationButton.setEnabled(true);
        }
    }

    private void updateSelectionPlaceNode(TCTLPlaceNode node) {
        if (node == null) {
            return;
        }
        if (node.getTemplate().equals("")) {
            this.templateBox.setSelectedItem(SHARED);
        } else {
            this.templateBox.setSelectedItem(this.tapnNetwork.getTAPNByName(node.getTemplate()));
        }
    }

    private void updatePredicatesAccordingToSelection(TCTLAbstractProperty current) {
        if (this.queryType.getSelectedIndex() == 2) {
            this.updateTraceBox();
        }
        if (current instanceof TCTLAtomicPropositionNode) {
            TCTLAtomicPropositionNode node = (TCTLAtomicPropositionNode)current;
            this.userChangedAtomicPropSelection = false;
            if (node.getLeft() instanceof TCTLPlaceNode) {
                this.updateSelectionPlaceNode((TCTLPlaceNode)node.getLeft());
            } else if (node.getLeft() instanceof HyperLTLPathScopeNode) {
                HyperLTLPathScopeNode scopeNode = (HyperLTLPathScopeNode)node.getLeft();
                this.updateTraceBox = false;
                this.traceBox.setSelectedItem(scopeNode.getTrace());
                this.updateTraceBox = true;
                if (scopeNode.getProperty() instanceof TCTLPlaceNode) {
                    this.updateSelectionPlaceNode((TCTLPlaceNode)scopeNode.getProperty());
                }
            }
            if (!this.lens.isTimed()) {
                this.updateUntimedQueryButtons(node);
            } else {
                this.updateTimedQueryButtons(node);
            }
        } else if (current instanceof TCTLTransitionNode) {
            TCTLTransitionNode transitionNode = (TCTLTransitionNode)current;
            this.userChangedAtomicPropSelection = false;
            if (transitionNode.getTemplate().equals("")) {
                this.templateBox.setSelectedItem(SHARED);
            } else {
                this.templateBox.setSelectedItem(this.tapnNetwork.getTAPNByName(transitionNode.getTemplate()));
            }
            if (!transitionNode.getTrace().equals("")) {
                this.traceBox.setSelectedItem(transitionNode.getTrace());
            }
            this.placeTransitionBox.setSelectedItem(transitionNode.getTransition());
            this.userChangedAtomicPropSelection = true;
        }
    }

    private void updateTimedQueryButtons(TCTLAtomicPropositionNode node) {
        if (!(node.getLeft() instanceof TCTLPlaceNode && node.getRight() instanceof TCTLConstNode || node.getLeft() instanceof HyperLTLPathScopeNode)) {
            return;
        }
        TCTLPlaceNode placeNode = null;
        TCTLConstNode placeMarkingNode = (TCTLConstNode)node.getRight();
        placeNode = this.queryType.getSelectedIndex() == 2 ? (TCTLPlaceNode)((HyperLTLPathScopeNode)node.getLeft()).getProperty() : (TCTLPlaceNode)node.getLeft();
        this.placeTransitionBox.setSelectedItem(placeNode.getPlace());
        this.relationalOperatorBox.setSelectedItem(node.getOp());
        this.placeMarking.setValue(placeMarkingNode.getConstant());
        this.userChangedAtomicPropSelection = true;
    }

    private void updateUntimedQueryButtons(TCTLAtomicPropositionNode node) {
        this.userChangedAtomicPropSelection = false;
        if (node.getLeft() instanceof TCTLPlaceNode || node.getLeft() instanceof HyperLTLPathScopeNode) {
            TCTLPlaceNode placeNode = null;
            placeNode = this.queryType.getSelectedIndex() == 2 ? (TCTLPlaceNode)((HyperLTLPathScopeNode)node.getLeft()).getProperty() : (TCTLPlaceNode)node.getLeft();
            this.placeTransitionBox.setSelectedItem(placeNode.getPlace());
        } else if (this.placeTransitionBox.getItemCount() > 0) {
            this.placeTransitionBox.setSelectedIndex(0);
        }
        this.relationalOperatorBox.setSelectedItem(node.getOp());
        if (node.getRight() instanceof TCTLConstNode) {
            TCTLConstNode placeMarkingNode = (TCTLConstNode)node.getRight();
            this.placeMarking.setValue(placeMarkingNode.getConstant());
        }
        this.userChangedAtomicPropSelection = true;
    }

    private void setEnablednessOfOperatorAndMarkingBoxes() {
        if (this.transitionIsSelected()) {
            this.placeMarking.setVisible(false);
            this.relationalOperatorBox.setVisible(false);
            this.transitionIsEnabledLabel.setVisible(true);
        } else {
            this.transitionIsEnabledLabel.setVisible(false);
            this.placeMarking.setVisible(true);
            this.relationalOperatorBox.setVisible(true);
        }
    }

    private boolean transitionIsSelected() {
        String itemName = (String)this.placeTransitionBox.getSelectedItem();
        if (itemName == null) {
            return false;
        }
        boolean transitionSelected = false;
        boolean sharedTransitionSelected = false;
        for (TimedArcPetriNet tapn : this.tapnNetwork.activeTemplates()) {
            if (tapn.getTransitionByName(itemName) == null) continue;
            transitionSelected = true;
            break;
        }
        if (!transitionSelected) {
            sharedTransitionSelected = this.tapnNetwork.getSharedTransitionByName(itemName) != null;
        }
        return transitionSelected || sharedTransitionSelected;
    }

    private void deleteSelection() {
        if (this.currentSelection != null) {
            TCTLAbstractProperty replacement = null;
            TCTLAbstractProperty selection = this.currentSelection.getObject();
            if (selection instanceof TCTLAbstractStateProperty) {
                replacement = new TCTLStatePlaceHolder();
            } else if (selection instanceof TCTLAbstractPathProperty) {
                replacement = new TCTLPathPlaceHolder();
            }
            if (replacement != null) {
                this.newProperty = this.newProperty.replace(selection, replacement);
            } else if (selection instanceof TCTLAbstractPathProperty) {
                replacement = new TCTLPathPlaceHolder();
            }
            if (replacement != null) {
                if ((selection instanceof LTLANode || selection instanceof LTLENode) && ((TCTLAbstractPathProperty)selection).getParent() != null) {
                    ((TCTLAbstractPathProperty)replacement).setParent(((TCTLAbstractPathProperty)selection).getParent());
                }
                QueryConstructionEdit edit = new QueryConstructionEdit(selection, replacement);
                if (selection instanceof TCTLAbstractPathProperty) {
                    this.resetQuantifierSelectionButtons();
                }
                this.updateSelection(replacement);
                this.undoSupport.postEdit(edit);
                this.queryChanged();
            }
        }
    }

    private void clearSelection() {
        this.queryField.select(0, 0);
        this.currentSelection = null;
        this.disableAllQueryButtons();
    }

    private void setSaveButtonsEnabled() {
        if (!this.queryField.isEditable()) {
            boolean isQueryOk = this.getQueryComment().length() > 0 && !this.newProperty.containsPlaceHolder();
            this.saveButton.setEnabled(isQueryOk);
            this.saveAndVerifyButton.setEnabled(isQueryOk);
            this.saveUppaalXMLButton.setEnabled(isQueryOk);
            this.mergeNetComponentsButton.setEnabled(isQueryOk);
            this.openReducedNetButton.setEnabled(isQueryOk && this.useReduction.isSelected());
            this.smcTimeEstimationButton.setEnabled(isQueryOk);
        } else {
            this.saveButton.setEnabled(false);
            this.saveAndVerifyButton.setEnabled(false);
            this.saveUppaalXMLButton.setEnabled(false);
            this.mergeNetComponentsButton.setEnabled(false);
            this.openReducedNetButton.setEnabled(false);
            this.smcTimeEstimationButton.setEnabled(false);
        }
    }

    private void setEnabledReductionOptions() {
        if (this.rawVerificationOptionsEnabled.isSelected()) {
            return;
        }
        String reductionOptionString = this.getReductionOptionAsString();
        ArrayList<String> options = new ArrayList<String>();
        disableSymmetryUpdate = true;
        boolean[] queryOptions = new boolean[]{this.fastestTraceRadioButton.isSelected(), this.queryHasDeadlock() && (this.newProperty.toString().contains("EF") || this.newProperty.toString().contains("AG")) && this.highestNetDegree <= 2, this.queryHasDeadlock() && (this.newProperty.toString().contains("EG") || this.newProperty.toString().contains("AF")), this.queryHasDeadlock() && this.hasInhibitorArcs, this.tapnNetwork.hasWeights(), this.hasInhibitorArcs, this.tapnNetwork.hasUrgentTransitions(), this.newProperty.toString().contains("EG") || this.newProperty.toString().contains("AF"), !this.tapnNetwork.isNonStrict(), this.lens.isTimed(), this.queryHasDeadlock() && this.highestNetDegree > 2, this.lens.isGame(), (this.newProperty.toString().contains("EG") || this.newProperty.toString().contains("AF")) && this.highestNetDegree > 2, this.newProperty.hasNestedPathQuantifiers(), this.lens.isColored(), this.lens.isColored() && !this.lens.isTimed(), this.lens.isStochastic()};
        if (this.useTimeDarts != null) {
            if (hasForcedDisabledTimeDarts) {
                hasForcedDisabledTimeDarts = false;
                this.useTimeDarts.setSelected(true);
            }
            this.useTimeDarts.setEnabled(true);
        }
        if (this.useStubbornReduction != null) {
            if (hasForcedDisabledStubbornReduction) {
                hasForcedDisabledStubbornReduction = false;
                this.useStubbornReduction.setSelected(true);
            }
            if (this.queryType.getSelectedIndex() == 2) {
                this.useStubbornReduction.setEnabled(false);
            } else {
                this.useStubbornReduction.setEnabled(true);
            }
        }
        if (this.useGCD != null) {
            if (hasForcedDisabledGCD) {
                hasForcedDisabledGCD = false;
                this.useGCD.setSelected(true);
            }
            this.useGCD.setEnabled(true);
        }
        if (this.tapnNetwork.isNonStrict() && (this.newProperty.toString().contains("EG") || this.newProperty.toString().contains("AF")) && this.useTimeDarts != null) {
            if (this.useTimeDarts.isSelected()) {
                hasForcedDisabledTimeDarts = true;
            }
            this.useTimeDarts.setEnabled(false);
            this.useTimeDarts.setSelected(false);
        }
        if (this.lens.isTimed()) {
            for (EngineSupportOptions engine : engineSupportOptions) {
                if (!engine.areOptionsSupported(queryOptions) || engine.getNameString().equals(name_verifyTAPN) && this.lens.isStochastic()) continue;
                options.add(engine.getNameString());
            }
        } else {
            options.add(name_UNTIMED);
        }
        this.reductionOption.removeAllItems();
        boolean selectedOptionStillAvailable = false;
        TAPNQuery.TraceOption trace = this.getTraceOption();
        for (String s : options) {
            this.reductionOption.addItem(s);
            if (!s.equals(reductionOptionString)) continue;
            selectedOptionStillAvailable = true;
        }
        if (selectedOptionStillAvailable) {
            this.reductionOption.setSelectedItem(reductionOptionString);
            if (trace == TAPNQuery.TraceOption.SOME && this.someTraceRadioButton.isEnabled()) {
                this.someTraceRadioButton.setSelected(true);
            } else if (trace == TAPNQuery.TraceOption.FASTEST && this.fastestTraceRadioButton.isEnabled()) {
                this.fastestTraceRadioButton.setSelected(true);
            }
        }
        disableSymmetryUpdate = false;
    }

    private void updateSearchStrategies() {
        if (this.reductionOption.getSelectedItem() == null) {
            return;
        }
        JRadioButton currentSelected = this.heuristicSearch.isSelected() ? this.heuristicSearch : (this.breadthFirstSearch.isSelected() ? this.breadthFirstSearch : (this.depthFirstSearch.isSelected() ? this.depthFirstSearch : this.randomSearch));
        if (this.queryType.getSelectedIndex() == 2) {
            this.breadthFirstSearch.setEnabled(false);
            this.heuristicSearch.setEnabled(false);
            this.randomSearch.setEnabled(false);
        } else {
            if (this.fastestTraceRadioButton.isSelected()) {
                this.breadthFirstSearch.setEnabled(false);
                this.depthFirstSearch.setEnabled(false);
                this.heuristicSearch.setEnabled(false);
                this.randomSearch.setEnabled(false);
                return;
            }
            if (this.queryType.getSelectedIndex() == 1) {
                this.breadthFirstSearch.setEnabled(false);
                this.heuristicSearch.setEnabled(true);
                this.depthFirstSearch.setEnabled(true);
                this.randomSearch.setEnabled(true);
                if (!this.useTarjan.isSelected() && this.someTraceRadioButton.isSelected()) {
                    this.randomSearch.setEnabled(false);
                }
            } else {
                this.breadthFirstSearch.setEnabled(true);
                this.depthFirstSearch.setEnabled(true);
                this.heuristicSearch.setEnabled(true);
                this.randomSearch.setEnabled(true);
            }
        }
        String reductionOptionString = this.getReductionOptionAsString();
        if (this.lens.isGame()) {
            this.heuristicSearch.setEnabled(false);
        } else if (this.lens.isTimed() && (this.newProperty.toString().contains("EG") || this.newProperty.toString().contains("AF"))) {
            this.breadthFirstSearch.setEnabled(false);
            if (!reductionOptionString.equals(name_verifyTAPN) && !reductionOptionString.equals(name_DISCRETE)) {
                this.heuristicSearch.setEnabled(false);
            }
        }
        if (!currentSelected.isEnabled()) {
            if (this.heuristicSearch.isEnabled()) {
                this.heuristicSearch.setSelected(true);
            } else {
                this.depthFirstSearch.setSelected(true);
            }
        }
        this.refreshHeuristicButtonText();
    }

    private void refreshHeuristicButtonText() {
        if (!this.lens.isTimed() && !this.lens.isGame() && this.isReachabilityQuery() && !this.useExplicitSearch.isSelected()) {
            this.heuristicSearch.setText("Random heuristic    ");
        } else {
            this.heuristicSearch.setText("Heuristic    ");
        }
    }

    private boolean isReachabilityQuery() {
        return !this.newProperty.hasNestedPathQuantifiers() && (this.newProperty instanceof TCTLAGNode || this.newProperty instanceof TCTLEFNode);
    }

    private void disableAllQueryButtons() {
        this.existsBox.setEnabled(false);
        this.existsDiamond.setEnabled(false);
        this.forAllBox.setEnabled(false);
        this.forAllDiamond.setEnabled(false);
        this.existsUntil.setEnabled(false);
        this.existsNext.setEnabled(false);
        this.forAllUntil.setEnabled(false);
        this.forAllNext.setEnabled(false);
        this.globallyButton.setEnabled(false);
        this.finallyButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.untilButton.setEnabled(false);
        this.aButton.setEnabled(false);
        this.eButton.setEnabled(false);
        this.conjunctionButton.setEnabled(false);
        this.disjunctionButton.setEnabled(false);
        this.negationButton.setEnabled(false);
        this.searchBar.setEnabled(false);
        this.templateBox.setEnabled(false);
        this.placeTransitionBox.setEnabled(false);
        this.relationalOperatorBox.setEnabled(false);
        this.placeMarking.setEnabled(false);
        this.addPredicateButton.setEnabled(false);
        this.truePredicateButton.setEnabled(false);
        this.falsePredicateButton.setEnabled(false);
        this.deadLockPredicateButton.setEnabled(false);
        this.traceBox.setEnabled(false);
        this.traceBoxQuantification.setEnabled(false);
    }

    private void disableAllLTLButtons() {
        this.globallyButton.setEnabled(false);
        this.finallyButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.untilButton.setEnabled(false);
        this.aButton.setEnabled(false);
        this.eButton.setEnabled(false);
        this.conjunctionButton.setEnabled(false);
        this.disjunctionButton.setEnabled(false);
        this.negationButton.setEnabled(false);
        this.searchBar.setEnabled(false);
        this.templateBox.setEnabled(false);
        this.placeTransitionBox.setEnabled(false);
        this.relationalOperatorBox.setEnabled(false);
        this.placeMarking.setEnabled(false);
        this.addPredicateButton.setEnabled(false);
        this.truePredicateButton.setEnabled(false);
        this.falsePredicateButton.setEnabled(false);
        if (this.queryType.getSelectedIndex() == 2) {
            this.traceBox.setEnabled(false);
        }
    }

    private void enableOnlyPathButtons() {
        this.existsBox.setEnabled(true);
        this.existsDiamond.setEnabled(true);
        this.forAllBox.setEnabled(true);
        this.forAllDiamond.setEnabled(true);
        if (!this.lens.isTimed()) {
            this.existsUntil.setEnabled(true);
            this.existsNext.setEnabled(true);
            this.forAllUntil.setEnabled(true);
            this.forAllNext.setEnabled(true);
        }
        this.conjunctionButton.setEnabled(false);
        this.disjunctionButton.setEnabled(false);
        this.negationButton.setEnabled(false);
        this.searchBar.setEnabled(false);
        this.templateBox.setEnabled(false);
        this.placeTransitionBox.setEnabled(false);
        this.relationalOperatorBox.setEnabled(false);
        this.placeMarking.setEnabled(false);
        this.addPredicateButton.setEnabled(false);
        this.truePredicateButton.setEnabled(false);
        this.falsePredicateButton.setEnabled(false);
        this.deadLockPredicateButton.setEnabled(false);
        if (this.queryType.getSelectedIndex() == 2) {
            this.traceBox.setEnabled(false);
        }
    }

    private void enableOnlyStateButtons() {
        this.existsBox.setEnabled(false);
        this.existsDiamond.setEnabled(false);
        this.forAllBox.setEnabled(false);
        this.forAllDiamond.setEnabled(false);
        this.existsUntil.setEnabled(false);
        this.existsNext.setEnabled(false);
        this.forAllUntil.setEnabled(false);
        this.forAllNext.setEnabled(false);
        this.conjunctionButton.setEnabled(true);
        this.disjunctionButton.setEnabled(true);
        this.negationButton.setEnabled(true);
        this.searchBar.setEnabled(true);
        this.templateBox.setEnabled(true);
        this.placeTransitionBox.setEnabled(true);
        this.relationalOperatorBox.setEnabled(true);
        this.placeMarking.setEnabled(true);
        this.truePredicateButton.setEnabled(true);
        this.falsePredicateButton.setEnabled(true);
        this.deadLockPredicateButton.setEnabled(true);
        this.setEnablednessOfAddPredicateButton();
        if (this.queryType.getSelectedIndex() == 2) {
            this.traceBox.setEnabled(this.traceBox.getModel().getSize() > 0);
        }
    }

    private void enableOnlySMCButtons() {
        this.finallyButton.setEnabled(true);
        this.globallyButton.setEnabled(true);
        if (this.lens.isStochastic()) {
            this.updateSMCButtons();
        }
    }

    private void enableOnlyUntimedStateButtons() {
        this.existsBox.setEnabled(true);
        this.existsDiamond.setEnabled(true);
        this.forAllBox.setEnabled(true);
        this.forAllDiamond.setEnabled(true);
        this.existsUntil.setEnabled(true);
        this.existsNext.setEnabled(true);
        this.forAllUntil.setEnabled(true);
        this.forAllNext.setEnabled(true);
        this.conjunctionButton.setEnabled(true);
        this.disjunctionButton.setEnabled(true);
        this.negationButton.setEnabled(true);
        this.searchBar.setEnabled(true);
        this.templateBox.setEnabled(true);
        this.placeTransitionBox.setEnabled(true);
        this.relationalOperatorBox.setEnabled(true);
        this.placeMarking.setEnabled(true);
        this.truePredicateButton.setEnabled(true);
        this.falsePredicateButton.setEnabled(true);
        this.deadLockPredicateButton.setEnabled(true);
        if (this.queryType.getSelectedIndex() == 1) {
            this.updateLTLButtons();
        } else if (this.queryType.getSelectedIndex() == 2) {
            this.traceBox.setEnabled(this.traceBox.getModel().getSize() > 0);
            this.updateHyperLTLButtons();
        }
        this.setEnablednessOfAddPredicateButton();
    }

    private void enableOnlyForAll() {
        this.existsBox.setEnabled(false);
        this.existsDiamond.setEnabled(false);
        this.forAllBox.setEnabled(true);
        this.forAllDiamond.setEnabled(true);
        if (!this.lens.isTimed()) {
            this.existsUntil.setEnabled(false);
            this.existsNext.setEnabled(false);
            this.forAllUntil.setEnabled(false);
            this.forAllNext.setEnabled(false);
        }
        this.conjunctionButton.setEnabled(false);
        this.disjunctionButton.setEnabled(false);
        this.negationButton.setEnabled(false);
        this.searchBar.setEnabled(false);
        this.templateBox.setEnabled(false);
        this.placeTransitionBox.setEnabled(false);
        this.relationalOperatorBox.setEnabled(false);
        this.placeMarking.setEnabled(false);
        this.addPredicateButton.setEnabled(false);
        this.truePredicateButton.setEnabled(false);
        this.falsePredicateButton.setEnabled(false);
        this.deadLockPredicateButton.setEnabled(false);
    }

    private void setEnablednessOfAddPredicateButton() {
        int selectedIndex = this.queryType.getSelectedIndex();
        if (this.placeTransitionBox.getSelectedItem() == null || (selectedIndex == 1 || selectedIndex == 2) && this.currentSelection.getObject() == this.newProperty) {
            this.addPredicateButton.setEnabled(false);
        } else {
            this.addPredicateButton.setEnabled(true);
        }
    }

    private void disableEditingButtons() {
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    private void enableEditingButtons() {
        this.refreshUndoRedo();
        if (this.currentSelection != null) {
            this.deleteButton.setEnabled(this.currentSelection != null);
        }
    }

    private void returnFromManualEdit(TCTLAbstractProperty newQuery) {
        this.setQueryFieldEditable(false);
        if (newQuery != null) {
            this.newProperty = newQuery;
        }
        this.updateSelection(this.newProperty);
        this.resetButton.setText("Reset Query");
        this.editQueryButton.setText("Edit Query");
        this.resetButton.setToolTipText(TOOL_TIP_RESETBUTTON);
        this.editQueryButton.setToolTipText(TOOL_TIP_EDITQUERYBUTTON);
        this.enableEditingButtons();
        this.queryChanged();
    }

    private void changeToEditMode() {
        this.setQueryFieldEditable(true);
        this.resetButton.setText("Parse query");
        this.editQueryButton.setText("Cancel");
        this.resetButton.setToolTipText(TOOL_TIP_PARSE_QUERY);
        this.editQueryButton.setToolTipText(TOOL_TIP_CANCEL_QUERY);
        this.clearSelection();
        this.disableAllQueryButtons();
        this.disableEditingButtons();
        this.setSaveButtonsEnabled();
        this.queryField.setCaretPosition(this.queryField.getText().length());
    }

    private void updateQueryOnAtomicPropositionChange() {
        String selectedTrace = "";
        boolean isHyperLTL = false;
        if (this.queryType.getSelectedIndex() == 2) {
            isHyperLTL = true;
            selectedTrace = this.traceBox.getSelectedItem().toString();
        }
        if (this.currentSelection != null && (this.currentSelection.getObject() instanceof TCTLAtomicPropositionNode || !this.lens.isTimed() && this.currentSelection.getObject() instanceof TCTLTransitionNode)) {
            TCTLAbstractStateProperty property;
            String template;
            Object item = this.templateBox.getSelectedItem();
            String string = template = item.equals(SHARED) ? "" : item.toString();
            if (!this.lens.isTimed() && this.transitionIsSelected()) {
                property = isHyperLTL ? new TCTLTransitionNode(template, (String)this.placeTransitionBox.getSelectedItem(), selectedTrace) : new TCTLTransitionNode(template, (String)this.placeTransitionBox.getSelectedItem());
            } else if (isHyperLTL) {
                HyperLTLPathScopeNode pathScope = new HyperLTLPathScopeNode(new TCTLPlaceNode(template, (String)this.placeTransitionBox.getSelectedItem()), selectedTrace);
                property = new TCTLAtomicPropositionNode(pathScope, (String)this.relationalOperatorBox.getSelectedItem(), new TCTLConstNode((Integer)this.placeMarking.getValue()));
            } else {
                property = new TCTLAtomicPropositionNode(new TCTLPlaceNode(template, (String)this.placeTransitionBox.getSelectedItem()), (String)this.relationalOperatorBox.getSelectedItem(), new TCTLConstNode((Integer)this.placeMarking.getValue()));
            }
            if (!property.equals(this.currentSelection.getObject())) {
                QueryConstructionEdit edit = new QueryConstructionEdit(this.currentSelection.getObject(), property);
                this.newProperty = this.newProperty.replace(this.currentSelection.getObject(), property);
                this.updateSelection(property);
                this.undoSupport.postEdit(edit);
            }
            this.queryChanged();
        }
    }

    private void updateQueryOnQuantificationChange() {
        String selectedTrace = "";
        if (this.queryType.getSelectedIndex() == 2 && this.traceBoxQuantification.getSelectedItem() != null) {
            selectedTrace = this.traceBoxQuantification.getSelectedItem().toString();
        }
        if (this.currentSelection != null && this.queryType.getSelectedIndex() == 2 && (this.currentSelection.getObject() instanceof LTLANode || this.currentSelection.getObject() instanceof LTLENode)) {
            TCTLAbstractPathProperty currentProp = (TCTLAbstractPathProperty)this.currentSelection.getObject();
            TCTLAbstractPathProperty property = this.currentSelection.getObject() instanceof LTLANode ? new LTLANode(((LTLANode)currentProp).getProperty(), selectedTrace) : new LTLENode(((LTLENode)currentProp).getProperty(), selectedTrace);
            if (!property.equals(this.currentSelection.getObject())) {
                QueryConstructionEdit edit = new QueryConstructionEdit(currentProp, property);
                this.newProperty = this.newProperty.replace(currentProp, property);
                this.updateSelection(property);
                this.updateTraceBox(property);
                this.undoSupport.postEdit(edit);
            }
            this.queryChanged();
        }
    }

    private void updateTraceBox(TCTLAbstractPathProperty node) {
        if (node instanceof LTLANode) {
            this.traceBoxQuantification.setSelectedItem(((LTLANode)node).getTrace());
        } else {
            this.traceBoxQuantification.setSelectedItem(((LTLENode)node).getTrace());
        }
    }

    private void init(QueryDialogueOption option, net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        this.initQueryNamePanel();
        this.initQueryPanel();
        this.initUppaalOptionsPanel();
        this.initVerificationPanel();
        this.initOverApproximationPanel();
        this.initSmcSettingsPanel();
        this.initRawVerificationOptionsPanel();
        this.initButtonPanel(option, queryToCreateFrom == null);
        if (this.lens.isStochastic()) {
            this.setSMCSettings(SMCSettings.Default());
        }
        if (queryToCreateFrom != null) {
            this.setupFromQuery(queryToCreateFrom);
        }
        this.refreshTraceOptions();
        this.setEnabledReductionOptions();
        this.rootPane.setDefaultButton(this.saveAndVerifyButton);
        this.disableAllQueryButtons();
        this.setSaveButtonsEnabled();
        this.undoManager = new QueryConstructionUndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(new UndoAdapter());
        this.refreshUndoRedo();
        this.setEnabledOptionsAccordingToCurrentReduction();
        this.makeShortcuts();
        if (this.lens.isGame() && !this.lens.isTimed()) {
            this.useReduction.setSelected(false);
            this.useReduction.setEnabled(false);
            this.useSiphonTrap.setSelected(false);
            this.useSiphonTrap.setEnabled(false);
        }
        if (queryToCreateFrom != null) {
            this.setupRawVerificationOptionsFromQuery(queryToCreateFrom);
        } else {
            this.setupRawVerificationOptions();
        }
    }

    private void setupFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        this.queryName.setText(queryToCreateFrom.getName());
        if (queryToCreateFrom.getOldCapacity() == null) {
            this.numberOfExtraTokensInNet.setValue(queryToCreateFrom.getCapacity());
        } else {
            this.numberOfExtraTokensInNet.setValue(queryToCreateFrom.getOldCapacity());
        }
        if (this.lens.isTimed()) {
            this.setupApproximationOptionsFromQuery(queryToCreateFrom);
            this.setupQuantificationFromQuery(queryToCreateFrom);
        } else if (this.lens.isColored()) {
            this.setupUnfoldingOptionsFromQuery(queryToCreateFrom);
        }
        if (queryToCreateFrom.getCategory() == TAPNQuery.QueryCategory.SMC) {
            this.setSMCSettings(queryToCreateFrom.getSmcSettings());
            this.smcParallel.setSelected(queryToCreateFrom.isParallel());
            this.smcVerificationType.setSelectedIndex(queryToCreateFrom.getVerificationType().ordinal());
            this.smcNumberOfTraces.setValue(queryToCreateFrom.getNumberOfTraces());
            this.smcTraceType.setSelectedItem(queryToCreateFrom.getSmcTraceType());
            this.smcGranularityField.setText(String.valueOf(queryToCreateFrom.getGranularity()));
            this.smcGranularityField.setEnabled(!queryToCreateFrom.isMaxGranularity());
            this.smcMaxGranularityCheckbox.setSelected(queryToCreateFrom.isMaxGranularity());
        }
        this.setupQueryCategoryFromQuery(queryToCreateFrom);
        this.setupSearchOptionsFromQuery(queryToCreateFrom);
        this.setupReductionOptionsFromQuery(queryToCreateFrom);
        this.setupTraceOptionsFromQuery(queryToCreateFrom);
        this.setupTarOptionsFromQuery(queryToCreateFrom);
        this.setupTarjanOptionsFromQuery(queryToCreateFrom);
        this.setupExplicitSearch(queryToCreateFrom.useExplicitSearch());
        if (queryToCreateFrom.getCategory() == TAPNQuery.QueryCategory.HyperLTL) {
            this.setupTraceListFromQuery(queryToCreateFrom);
        }
    }

    private void setupExplicitSearch(boolean selectExplicitSearch) {
        if (this.lens.isColored() && !this.lens.isGame() && !this.lens.isStochastic() && !this.lens.isTimed()) {
            this.useExplicitSearch.setSelected(selectExplicitSearch);
            this.setComponentEnabledRecursively(this.unfoldingOptionsPanel, !selectExplicitSearch);
            this.oldExplicitSearchState = selectExplicitSearch;
        }
    }

    private void setupRawVerificationOptionsFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        this.rawVerificationOptionsTextArea.setText(queryToCreateFrom.getRawVerificationPrompt());
        this.setupRawVerificationOptions(queryToCreateFrom.getRawVerification());
        if (this.rawVerificationOptionsEnabled.isSelected() && !advancedView.booleanValue()) {
            this.toggleAdvancedSimpleView(true);
        }
    }

    private void setupRawVerificationOptions() {
        this.setupRawVerificationOptions(false);
    }

    private void setupRawVerificationOptions(boolean isSelected) {
        this.rawVerificationOptionsEnabled.setSelected(isSelected);
        this.addItemListeners(this.searchOptionsPanel);
        this.addItemListeners(this.unfoldingOptionsPanel);
        this.addItemListeners(this.traceOptionsPanel);
        this.addItemListeners(this.reductionOptionsPanel);
        this.numberOfExtraTokensInNet.addChangeListener(e -> this.updateRawVerificationOptions());
        this.reductionOption.addActionListener(e -> this.updateRawVerificationOptions());
        this.smcVerificationType.addActionListener(e -> {
            if (!this.updatingSmcSettings) {
                this.updateRawVerificationOptions();
            }
        });
        this.smcNumberOfTraces.addChangeListener(e -> {
            if (!this.updatingSmcSettings) {
                this.updateRawVerificationOptions();
            }
        });
        this.smcParallel.addActionListener(e -> {
            if (!this.updatingSmcSettings) {
                this.updateRawVerificationOptions();
            }
        });
        final JFormattedTextField smcNumTracesTextField = ((JSpinner.DefaultEditor)this.smcNumberOfTraces.getEditor()).getTextField();
        smcNumTracesTextField.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ QueryDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String text = smcNumTracesTextField.getText().replace(",", "");
                int oldCaretPos = smcNumTracesTextField.getCaretPosition();
                try {
                    Integer newValue = Integer.valueOf(text);
                    this.this$0.smcNumberOfTraces.setValue(newValue);
                    smcNumTracesTextField.setCaretPosition(oldCaretPos);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.smcTraceType.addActionListener(e -> {
            if (!this.updatingSmcSettings) {
                this.updateRawVerificationOptions();
            }
        });
        if (this.reductionOption.getSelectedItem() != null) {
            this.updateRawVerificationOptions();
        }
    }

    private void addItemListeners(JPanel panel) {
        if (panel != null) {
            for (Component component : panel.getComponents()) {
                if (!(component instanceof JRadioButton) && !(component instanceof JCheckBox)) continue;
                AbstractButton button = (AbstractButton)component;
                button.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        QueryDialog.this.updateRawVerificationOptions();
                    }
                });
            }
        }
    }

    private void setupTraceListFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        this.traceModel.removeAllElements();
        HashSet<String> traces = new HashSet<String>(queryToCreateFrom.getTraceList());
        Pattern pattern = Pattern.compile("\\s([a-zA-Z]\\w*)\\.");
        Matcher matcher = pattern.matcher(queryToCreateFrom.getProperty().toString());
        while (matcher.find()) {
            traces.add(matcher.group(1));
        }
        for (String trace : traces) {
            this.traceModel.addElement(trace);
        }
        this.traceList.setModel(this.traceModel);
        this.updateTraceBox();
    }

    private void setupTarOptionsFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        if (queryToCreateFrom.isTarOptionEnabled()) {
            this.useTraceRefinement.setSelected(true);
        }
    }

    private void setupTarjanOptionsFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        this.useTarjan.setSelected(queryToCreateFrom.isTarjan());
    }

    private void setupApproximationOptionsFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        if (queryToCreateFrom.isOverApproximationEnabled()) {
            this.overApproximationEnable.setSelected(true);
        } else if (queryToCreateFrom.isUnderApproximationEnabled()) {
            this.underApproximationEnable.setSelected(true);
        } else {
            this.noApproximationEnable.setSelected(true);
        }
        if (queryToCreateFrom.approximationDenominator() > 0) {
            this.overApproximationDenominator.setValue(queryToCreateFrom.approximationDenominator());
        }
    }

    private void setupReductionOptionsFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        String reduction = "";
        if (queryToCreateFrom.getReductionOption() == ReductionOption.BROADCAST) {
            reduction = name_BROADCAST;
        } else if (queryToCreateFrom.getReductionOption() == ReductionOption.DEGREE2BROADCAST) {
            reduction = name_BROADCASTDEG2;
        } else if (queryToCreateFrom.getReductionOption() == ReductionOption.VerifyDTAPN) {
            reduction = name_DISCRETE;
        } else if (queryToCreateFrom.getReductionOption() == ReductionOption.VerifyPN) {
            reduction = name_UNTIMED;
        } else if (queryToCreateFrom.getReductionOption() == ReductionOption.COMBI) {
            reduction = name_COMBI;
        } else if (this.newProperty.toString().contains("EF") || this.newProperty.toString().contains("AG")) {
            if (queryToCreateFrom.getReductionOption() == ReductionOption.STANDARD) {
                reduction = name_STANDARD;
            } else if (queryToCreateFrom.getReductionOption() == ReductionOption.OPTIMIZEDSTANDARD) {
                reduction = name_OPTIMIZEDSTANDARD;
            } else if (queryToCreateFrom.getReductionOption() == ReductionOption.VerifyTAPN) {
                reduction = name_verifyTAPN;
            }
        } else if (queryToCreateFrom.getReductionOption() == ReductionOption.OPTIMIZEDSTANDARD) {
            reduction = name_OPTIMIZEDSTANDARD;
        }
        this.reductionOption.addItem(reduction);
        this.reductionOption.setSelectedItem(reduction);
        if (this.lens.isTimed()) {
            this.setupTimedReductionOptions(queryToCreateFrom);
        } else {
            this.setupUntimedReductionOptions(queryToCreateFrom);
        }
    }

    private void setupTimedReductionOptions(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        this.symmetryReduction.setSelected(queryToCreateFrom.useSymmetry());
        this.useTimeDarts.setSelected(queryToCreateFrom.useTimeDarts());
        this.usePTrie.setSelected(queryToCreateFrom.usePTrie());
        this.useStubbornReduction.setSelected(queryToCreateFrom.isStubbornReductionEnabled());
        this.useGCD.setSelected(queryToCreateFrom.useGCD());
        this.skeletonAnalysis.setSelected(queryToCreateFrom.useOverApproximation());
        this.useReduction.setSelected(queryToCreateFrom.useReduction());
        this.discreteInclusion.setSelected(queryToCreateFrom.discreteInclusion());
        if (queryToCreateFrom.discreteInclusion()) {
            this.selectInclusionPlacesButton.setEnabled(true);
        }
    }

    private void setupUntimedReductionOptions(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        this.useSiphonTrap.setSelected(queryToCreateFrom.isSiphontrapEnabled());
        this.useQueryReduction.setSelected(queryToCreateFrom.isQueryReductionEnabled());
        this.useStubbornReduction.setSelected(queryToCreateFrom.isStubbornReductionEnabled());
        this.useReduction.setSelected(queryToCreateFrom.useReduction());
        this.useTraceRefinement.setSelected(queryToCreateFrom.isTarOptionEnabled());
        this.useTarjan.setSelected(queryToCreateFrom.isTarjan());
        this.setupExplicitSearch(queryToCreateFrom.useExplicitSearch());
        this.useColoredReduction.setSelected(queryToCreateFrom.useColoredReduction());
    }

    private void setupUnfoldingOptionsFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        this.usePartitioning.setSelected(queryToCreateFrom.usePartitioning());
        this.useColorFixpoint.setSelected(queryToCreateFrom.useColorFixpoint());
        this.useSymmetricvars.setSelected(queryToCreateFrom.useSymmetricVars());
    }

    private void setupTraceOptionsFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        if (queryToCreateFrom.getTraceOption() == TAPNQuery.TraceOption.SOME) {
            this.someTraceRadioButton.setSelected(true);
        } else if (queryToCreateFrom.getTraceOption() == TAPNQuery.TraceOption.FASTEST) {
            this.fastestTraceRadioButton.setSelected(true);
        } else if (queryToCreateFrom.getTraceOption() == TAPNQuery.TraceOption.NONE) {
            this.noTraceRadioButton.setSelected(true);
        }
    }

    private void setupSearchOptionsFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        if (queryToCreateFrom.getSearchOption() == TAPNQuery.SearchOption.BFS) {
            this.breadthFirstSearch.setSelected(true);
        } else if (queryToCreateFrom.getSearchOption() == TAPNQuery.SearchOption.DFS) {
            this.depthFirstSearch.setSelected(true);
        } else if (queryToCreateFrom.getSearchOption() == TAPNQuery.SearchOption.RANDOM) {
            this.randomSearch.setSelected(true);
        } else if (queryToCreateFrom.getSearchOption() == TAPNQuery.SearchOption.HEURISTIC) {
            this.heuristicSearch.setSelected(true);
        }
    }

    private void setupQuantificationFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        if (queryToCreateFrom.getProperty() instanceof TCTLEFNode) {
            this.existsDiamond.setSelected(true);
        } else if (queryToCreateFrom.getProperty() instanceof TCTLEGNode) {
            this.existsBox.setSelected(true);
        } else if (queryToCreateFrom.getProperty() instanceof TCTLAFNode) {
            this.forAllDiamond.setSelected(true);
        } else if (queryToCreateFrom.getProperty() instanceof TCTLAGNode) {
            this.forAllBox.setSelected(true);
        }
    }

    private void setupQueryCategoryFromQuery(net.tapaal.gui.petrinet.verification.TAPNQuery queryToCreateFrom) {
        if (!this.lens.isTimed()) {
            TAPNQuery.QueryCategory category = queryToCreateFrom.getCategory();
            if (category.equals((Object)TAPNQuery.QueryCategory.CTL)) {
                this.queryType.setSelectedIndex(0);
            } else if (category.equals((Object)TAPNQuery.QueryCategory.LTL)) {
                this.queryType.setSelectedIndex(1);
            } else if (category.equals((Object)TAPNQuery.QueryCategory.HyperLTL)) {
                this.queryType.setSelectedIndex(2);
            }
        }
    }

    private void initQueryNamePanel() {
        JPanel splitter = new JPanel(new BorderLayout());
        this.namePanel = new JPanel(new FlowLayout());
        this.namePanel.add(new JLabel("Query name: "));
        this.queryName = new JTextField("Query Comment/Name Here", 25);
        this.queryName.setToolTipText(TOOL_TIP_QUERYNAME);
        this.namePanel.add(this.queryName);
        this.queryName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                QueryDialog.this.setSaveButtonsEnabled();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                QueryDialog.this.setSaveButtonsEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                QueryDialog.this.setSaveButtonsEnabled();
            }
        });
        this.queryType = new JComboBox<String>(new String[]{"CTL/Reachability", "LTL", "HyperLTL"});
        this.queryType.setToolTipText(TOOL_TIP_QUERY_TYPE);
        this.queryType.addActionListener(arg0 -> this.toggleDialogType());
        this.advancedButton = new JButton("Advanced view");
        this.advancedButton.setToolTipText(TOOL_TIP_ADVANCED_VIEW_BUTTON);
        this.advancedButton.addActionListener(arg0 -> this.toggleAdvancedSimpleView(true));
        JButton infoButton = new JButton("Help on the query options");
        infoButton.setToolTipText(TOOL_TIP_INFO_BUTTON);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(QueryDialog.this, this.getMessageComponent(), "Help", 1);
            }

            private Object getMessageComponent() {
                JTextPane pane = new JTextPane();
                pane.setContentType("text/html");
                pane.setText(this.getHelpMessage());
                pane.setEditable(false);
                pane.setCaretPosition(0);
                for (MouseListener listener : pane.getMouseListeners()) {
                    pane.removeMouseListener(listener);
                }
                Dimension dim = new Dimension(500, 400);
                pane.setPreferredSize(dim);
                pane.setMargin(new Insets(5, 5, 5, 5));
                JScrollPane scrollPane = new JScrollPane(pane);
                scrollPane.setPreferredSize(dim);
                return scrollPane;
            }

            private String getHelpMessage() {
                return "<html><b>Boundedness Options</b><br/>The query dialog allows you to specify the extra number of tokens that TAPAAL is allowed to use during the verification. Because TAPAAL models can produce additional tokens by firing transitions (e.g. a transition that has a single input place and two output places) you may need to use additional tokens compared to those that are already in the net. By specifying an extra number of tokens you can ask TAPAAL to check if your net is bounded for this number of extra tokens (i.e. whether there is no reachable marking in the net that would exceed the predefined number of tokens. <br/><br/><b>Search Strategy Options</b><br/>A search strategy determines how the chosen verification engine performs the search. The possible search strategies are: <ul><li>Heuristic Search<br/> If available, the search is guided according to the query so that the most likely places where the query is satisfied are visited first. If discrete inclusion optimization is not enabled or the heuristic search is not available, this strategy performs a breadth first search. If discrete inclusion is enabled, the search attempts to maximize the number of tokens in places where the engine checks for discrete inclusion.</li><li>Breadth First Search<br/>Explores markings in a breadth first manner.</li><li>Depth First Search<br/>Explores markings in a depth first manner.</li><li>Random Search<br/>Performs a random exploration of the state space.</li></ul><br/><b>Verification Options</b><br/>TAPAAL supports verification via its own included engines verifytapn and verifydtapn or via a translation to networks of timed automata and then using the tool UPPAAL (requires a separate installation). If you work with an untimed net, we recommend that you use the CTL query creation dialog and use the untimed verifypn engine.The TAPAAL engine verifytapn supports also the discrete inclusion optimization. On some models this technique gives a considerable speedup. The user selected set of places that are considered for the discrete inclusion can further fine-tune the performance of the engine. Try to include places where you expect to see many tokens during the execution. The discrete verification engine verifydtapn performs a point-wise exploration of the state space but can be used only for models that do not contain strict intervals as in this situation it is guaranteed to give the same answers as the continuous time engine verifytapn. This discrete engine has options to handle delays in semi-symbolic way (time darts) recommended for models with larger constants and it has a memory optimization option feature (PTrie) that preserves lots of memory at the expense of a slightly longer verification time.The different UPPAAL verification methods perform reductions to networks of timed automata. The broadcast reductions supports all query types, while standard and optimized standard support only EF and AG queries but can be sometimes faster.<br/><b>Approximation Options</b><br/>TAPAAL allows to approximate the time intervals on edges by dividing them by the given approximation constant and either enlarging the resulting intervals (over-approximation) or shrinking them (under-approximation). The larger the constant is, the faster is the verification but the more often the user can get an inconclusive answer.<br/><b>SMC Options</b><br/>Statistical model-checking simulates random runs in order to verify how often a property is satisfied. It explores random runs that do not exceed the given time and step bound. There are three types of SMC queries :<ul><li>The quantitative probability estimation performs a Monte-Carlo algorithm to produce an estimation of the probability of an event happening. The number of runs to execute is defined by the desired confidence and precision, which are the confidence that the real probability is in an interval of \u00b1 the precision around the estimation.</li><li>The qualitative probability testing performs a SPRT test, to produce an estimation whether the probability of an event happening is greater than a real constant C. According to the result of each run, a ratio is updated and a result is decided once it reaches a bound. The false-positives parameter is the probability of estimating the test to be true when it isn't, the false-negatives parameter is the opposite, and the indifference region is the zone C \u00b1 width, which bounds are used as thresholds.</li><li>The simulate mode generates an arbitrary number of random traces, that can then be explored in the simulator. The traces could be restricted to : any trace, only traces satisfying the property, or only traces violating the property. This mode must be used carefully, because in some cases it may not terminate : if asking for 5 traces satisfying the property, but no runs ever satisfy the property, then the algorithm will run forever.</li><ul/><br/></html>";
            }
        });
        JPanel topButtonPanel = new JPanel(new FlowLayout());
        topButtonPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        if (!this.lens.isTimed() && !this.lens.isGame()) {
            topButtonPanel.add(this.queryType);
        }
        topButtonPanel.add(this.advancedButton);
        topButtonPanel.add(infoButton);
        splitter.add((Component)this.namePanel, "Before");
        splitter.add((Component)topButtonPanel, "After");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.anchor = 17;
        this.add((Component)splitter, gridBagConstraints);
    }

    public static void setAdvancedView(boolean advanced) {
        advancedView = advanced;
    }

    public static boolean getAdvancedView() {
        return advancedView;
    }

    private void toggleAdvancedSimpleView(boolean changeState) {
        if (changeState) {
            QueryDialog.setAdvancedView(advancedView == false);
        }
        boolean isSmc = this.lens.isStochastic();
        Point location = guiDialog.getLocation();
        this.searchOptionsPanel.setVisible(advancedView != false && !isSmc);
        if (this.lens.isColored() && !this.lens.isTimed()) {
            this.unfoldingOptionsPanel.setVisible(advancedView);
        }
        this.reductionOptionsPanel.setVisible(advancedView != false && !isSmc);
        if (this.lens.isTimed()) {
            this.saveUppaalXMLButton.setVisible(advancedView != false && !isSmc);
            this.overApproximationOptionsPanel.setVisible(advancedView != false && !isSmc);
        } else if (!this.lens.isGame()) {
            this.openReducedNetButton.setVisible(advancedView);
        }
        this.mergeNetComponentsButton.setVisible(advancedView);
        this.showRawVerificationOptions(advancedView);
        if (advancedView.booleanValue()) {
            this.advancedButton.setText("Simple view");
            this.advancedButton.setToolTipText(TOOL_TIP_SIMPLE_VIEW_BUTTON);
        } else {
            this.advancedButton.setText("Advanced view");
            this.advancedButton.setToolTipText(TOOL_TIP_ADVANCED_VIEW_BUTTON);
        }
        guiDialog.pack();
        guiDialog.setLocation(location);
    }

    private boolean isHyperLTL(TCTLAbstractProperty property) {
        if (property instanceof LTLENode) {
            return !((LTLENode)property).getTrace().equals("");
        }
        if (property instanceof LTLANode) {
            return !((LTLANode)property).getTrace().equals("");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void toggleDialogType() {
        if (this.queryType.getSelectedIndex() == 2 && (this.wasCTLType || this.wasLTLType)) {
            if (!this.isHyperLTL(this.newProperty) && !(this.newProperty instanceof TCTLPathPlaceHolder) || !this.isValidLTL() && !this.queryField.getText().trim().equals(new TCTLPathPlaceHolder().toString())) {
                if (this.showWarningMessage() == 0) {
                    this.newProperty = new TCTLPathPlaceHolder();
                    this.deleteProperty();
                } else {
                    int changeTo = this.wasCTLType ? 0 : 1;
                    this.queryType.setSelectedIndex(changeTo);
                    return;
                }
            }
            this.showLTLButtons(true);
            this.showHyperLTL(true);
            this.updateSiphonTrap(true);
            this.queryChanged();
            this.wasCTLType = false;
            this.wasLTLType = false;
            this.wasHyperLTLType = true;
        } else if (this.queryType.getSelectedIndex() == 1 && (this.wasCTLType || this.wasHyperLTLType)) {
            block23: {
                String ltlType = this.checkLTLType();
                boolean isA = ltlType.equals("A");
                if (this.isHyperLTL(this.newProperty) || this.convertPropertyType(false, this.newProperty, true, isA) == null && !(this.newProperty instanceof TCTLStatePlaceHolder)) {
                    if (this.showWarningMessage() == 0) {
                        this.deleteProperty();
                        break block23;
                    } else {
                        int changeTo = this.wasCTLType ? 0 : 2;
                        this.queryType.setSelectedIndex(changeTo);
                        return;
                    }
                }
                if (isA) {
                    this.addAllPathsToProperty(this.newProperty, null);
                } else if (ltlType.equals("E")) {
                    this.addExistsPathsToProperty(this.newProperty, null);
                }
            }
            if (!this.isValidLTL() && !this.queryField.getText().trim().equals(new TCTLPathPlaceHolder().toString())) {
                if (this.showWarningMessage() == 0) {
                    this.deleteProperty();
                } else {
                    int changeTo = this.wasCTLType ? 0 : 2;
                    this.queryType.setSelectedIndex(changeTo);
                    return;
                }
            }
            this.showLTLButtons(true);
            this.updateSiphonTrap(true);
            this.showHyperLTL(false);
            this.queryChanged();
            this.wasHyperLTLType = false;
            this.wasCTLType = false;
            this.wasLTLType = true;
        } else if (this.queryType.getSelectedIndex() == 0 && !this.wasCTLType) {
            if (this.isHyperLTL(this.newProperty) || this.convertPropertyType(true, this.newProperty, true, this.newProperty instanceof LTLANode) == null && !(this.newProperty instanceof TCTLStatePlaceHolder)) {
                if (this.showWarningMessage() == 0) {
                    this.deleteProperty();
                    this.newProperty = this.removeExistsAllPathsFromProperty(this.newProperty);
                } else {
                    int changeTo = this.wasLTLType ? 1 : 2;
                    this.queryType.setSelectedIndex(changeTo);
                    return;
                }
            }
            this.showLTLButtons(false);
            this.showHyperLTL(false);
            this.updateSiphonTrap(false);
            this.wasCTLType = true;
            this.wasLTLType = false;
            this.wasHyperLTLType = false;
        }
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
        if (this.undoButton != null) {
            this.undoButton.setEnabled(false);
        }
        if (this.redoButton != null) {
            this.redoButton.setEnabled(false);
        }
        this.setEnabledOptionsAccordingToCurrentReduction();
        this.updateRawVerificationOptions();
    }

    private void toggleSmc() {
        if (this.lens.isStochastic()) {
            this.showSMCButtons(true);
            this.reductionOption.setSelectedItem(name_DISCRETE);
            this.useGCD.setSelected(false);
            this.reductionOption.setEnabled(false);
            this.traceOptionsPanel.setVisible(false);
            this.boundednessCheckPanel.setVisible(false);
            this.smcSettingsPanel.setVisible(true);
            this.toggleAdvancedSimpleView(false);
            this.queryChanged();
        } else {
            this.showSMCButtons(false);
            this.reductionOption.setEnabled(true);
            this.traceOptionsPanel.setVisible(true);
            this.boundednessCheckPanel.setVisible(true);
            this.smcSettingsPanel.setVisible(false);
            this.toggleAdvancedSimpleView(false);
            this.queryChanged();
        }
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
        if (this.undoButton != null) {
            this.undoButton.setEnabled(false);
        }
        if (this.redoButton != null) {
            this.redoButton.setEnabled(false);
        }
    }

    private boolean isValidLTL() {
        String queryText = this.queryField.getText().trim();
        return queryText.startsWith("A") || queryText.startsWith("E");
    }

    private String checkLTLType() {
        if (this.newProperty.toString().equals("<*>")) {
            return "placeholder";
        }
        if (this.newProperty.toString().startsWith("A")) {
            return "A";
        }
        if (this.newProperty.toString().startsWith("E")) {
            return "E";
        }
        if (this.newProperty.toString().startsWith("A", 2)) {
            return "A";
        }
        if (this.newProperty.toString().startsWith("E", 2)) {
            return "E";
        }
        if (this.newProperty.toString().startsWith("A", 3)) {
            return "A";
        }
        if (this.newProperty.toString().startsWith("E", 3)) {
            return "E";
        }
        return "placeholder";
    }

    private TCTLAbstractProperty convertPropertyType(boolean toCTL, TCTLAbstractProperty property, boolean isFirst, boolean isA) {
        if (property != null) {
            property = this.removeExistsAllPathsFromProperty(this.removeConverter(property));
            if (!(toCTL || !(property instanceof TCTLDeadlockNode) && this.canBeConverted(property, isA))) {
                return null;
            }
            if (property.isSimpleProperty() && !(property instanceof TCTLNotNode)) {
                if (!isFirst) {
                    return property;
                }
                if (property instanceof TCTLTrueNode || property instanceof TCTLFalseNode || property instanceof TCTLAtomicPropositionNode || property instanceof TCTLTransitionNode) {
                    property = this.ConvertToPathProperty((TCTLAbstractStateProperty)property);
                    return this.replaceProperty(property);
                }
            }
            TCTLAbstractProperty replacement = this.getReplacement(toCTL, property, isA);
            if (!isFirst) {
                return replacement;
            }
            return this.replaceProperty(replacement);
        }
        return null;
    }

    private boolean canBeConverted(TCTLAbstractProperty property, boolean isA) {
        if (isA && property.toString().startsWith("E")) {
            return false;
        }
        return isA || !property.toString().startsWith("A");
    }

    private TCTLAbstractProperty removeConverter(TCTLAbstractProperty property) {
        while (property instanceof TCTLPathToStateConverter || property instanceof TCTLStateToPathConverter) {
            if (property instanceof TCTLStateToPathConverter) {
                property = this.ConvertToStateProperty((TCTLStateToPathConverter)property);
                continue;
            }
            property = this.ConvertToPathProperty((TCTLPathToStateConverter)property);
        }
        return property;
    }

    private TCTLAbstractProperty getReplacement(boolean toCTL, TCTLAbstractProperty property, boolean isA) {
        TCTLAbstractStateProperty firstChild;
        TCTLAbstractProperty replacement = null;
        property = this.removeConverter(property);
        if (toCTL) {
            firstChild = this.getChild(toCTL, property, 1, isA);
            if (firstChild == null) {
                return null;
            }
            if (property instanceof LTLGNode) {
                replacement = isA ? new TCTLAGNode(firstChild) : new TCTLEGNode(firstChild);
            } else if (property instanceof LTLFNode) {
                replacement = isA ? new TCTLAFNode(firstChild) : new TCTLEFNode(firstChild);
            } else if (property instanceof LTLXNode) {
                replacement = isA ? new TCTLAXNode(firstChild) : new TCTLEXNode(firstChild);
            } else if (property instanceof LTLUNode) {
                TCTLAbstractStateProperty secondChild = this.getChild(toCTL, property, 2, isA);
                if (secondChild == null) {
                    return null;
                }
                replacement = isA ? new TCTLAUNode(firstChild, secondChild) : new TCTLEUNode(firstChild, secondChild);
            }
        } else {
            firstChild = this.getChild(toCTL, property, 1, isA);
            if (firstChild == null) {
                return null;
            }
            if (property instanceof TCTLAGNode || property instanceof TCTLEGNode) {
                replacement = new LTLGNode(firstChild);
            } else if (property instanceof TCTLAFNode || property instanceof TCTLEFNode) {
                replacement = new LTLFNode(firstChild);
            } else if (property instanceof TCTLAXNode || property instanceof TCTLEXNode) {
                replacement = new LTLXNode(firstChild);
            } else if (property instanceof TCTLAUNode || property instanceof TCTLEUNode) {
                TCTLAbstractStateProperty secondChild = this.getChild(toCTL, property, 2, isA);
                if (secondChild == null) {
                    return null;
                }
                replacement = new LTLUNode(firstChild, secondChild);
            }
        }
        if (replacement == null) {
            if (property instanceof TCTLStatePlaceHolder || property instanceof TCTLPathPlaceHolder) {
                return property;
            }
            if (property instanceof TCTLNotNode) {
                firstChild = this.getChild(toCTL, property, 1, isA);
                if (firstChild == null) {
                    return null;
                }
                return new TCTLNotNode(firstChild);
            }
            if (property instanceof TCTLAndListNode) {
                return this.convertListNode((TCTLAndListNode)property, toCTL, isA, true);
            }
            if (property instanceof TCTLOrListNode) {
                return this.convertListNode((TCTLOrListNode)property, toCTL, isA, false);
            }
            replacement = property;
        }
        return replacement;
    }

    private TCTLAbstractProperty convertListNode(Object listNode, boolean toCTL, boolean isA, boolean isAndNode) {
        StringPosition[] children = isAndNode ? ((TCTLAndListNode)listNode).getChildren() : ((TCTLOrListNode)listNode).getChildren();
        ArrayList<TCTLAbstractStateProperty> convertedChildren = new ArrayList<TCTLAbstractStateProperty>();
        for (StringPosition childPos : children) {
            TCTLAbstractProperty child = childPos.getObject();
            TCTLAbstractProperty convertedChild = this.convertPropertyType(toCTL, child, false, isA);
            if (convertedChild == null) {
                return null;
            }
            if (convertedChild instanceof TCTLAbstractStateProperty) {
                convertedChildren.add((TCTLAbstractStateProperty)convertedChild);
                continue;
            }
            if (!(convertedChild instanceof TCTLAbstractPathProperty)) continue;
            convertedChildren.add(this.ConvertToStateProperty((TCTLAbstractPathProperty)convertedChild));
        }
        if (convertedChildren.isEmpty()) {
            return null;
        }
        return isAndNode ? new TCTLAndListNode(convertedChildren) : new TCTLOrListNode(convertedChildren);
    }

    private TCTLAbstractStateProperty getChild(boolean toCTL, TCTLAbstractProperty property, int childNumber, boolean isA) {
        property = this.removeConverter(property);
        TCTLAbstractProperty child = this.getSpecificChildOfProperty(childNumber, property);
        if (!((child = this.removeConverter(child)) instanceof TCTLStatePlaceHolder) && !(child instanceof TCTLPathPlaceHolder)) {
            if (!child.isSimpleProperty() || child instanceof TCTLNotNode) {
                TCTLAbstractProperty replacement = this.convertPropertyType(toCTL, child, false, isA);
                if (replacement == null) {
                    return null;
                }
                replacement = this.removeConverter(replacement);
                child = child.replace(child, replacement);
            } else if (child instanceof TCTLDeadlockNode) {
                return null;
            }
        }
        if (child instanceof TCTLAbstractPathProperty) {
            return this.ConvertToStateProperty((TCTLAbstractPathProperty)child);
        }
        return (TCTLAbstractStateProperty)child;
    }

    private TCTLAbstractProperty replaceProperty(TCTLAbstractProperty replacement) {
        if (replacement != null) {
            this.newProperty = this.removeConverter(this.newProperty);
            if ((this.newProperty instanceof LTLANode || this.newProperty instanceof LTLENode) && !(replacement instanceof TCTLAbstractPathProperty)) {
                replacement = this.ConvertToPathProperty((TCTLAbstractStateProperty)replacement);
            }
            this.newProperty = this.newProperty.replace(this.newProperty, replacement);
            replacement = this.removeConverter(replacement);
            if (this.newProperty instanceof TCTLAbstractPathProperty) {
                this.resetQuantifierSelectionButtons();
            }
            this.updateSelection(replacement);
            this.queryChanged();
            return this.newProperty;
        }
        return null;
    }

    private void deleteProperty() {
        if (this.newProperty != null) {
            TCTLAbstractProperty replacement = null;
            this.newProperty = this.removeConverter(this.newProperty);
            if (this.newProperty instanceof TCTLAbstractStateProperty) {
                replacement = new TCTLStatePlaceHolder();
            } else if (this.newProperty instanceof TCTLAbstractPathProperty) {
                replacement = new TCTLPathPlaceHolder();
            }
            this.replaceProperty(replacement);
        }
    }

    private int showWarningMessage() {
        String message = "The query will be deleted, because it is incompatible with the selected query type.\nAre you sure you want to change query category?";
        String title = "Incompatible query";
        return JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), message, title, 0, 2);
    }

    private TCTLAbstractPathProperty getParentForHyperLTLAllPath(TCTLAbstractProperty property) {
        if (property instanceof TCTLStatePlaceHolder) {
            return this.getParentForHyperLTLAllPath(((TCTLStatePlaceHolder)property).getParent());
        }
        if (property instanceof TCTLPathToStateConverter) {
            return this.getParentForHyperLTLAllPath(((TCTLPathToStateConverter)property).getParent());
        }
        if (property instanceof TCTLPathPlaceHolder) {
            return this.getParentForHyperLTLAllPath(((TCTLPathPlaceHolder)property).getParent());
        }
        if (!(((TCTLAbstractPathProperty)property).getParent() instanceof LTLANode) && !(property instanceof LTLANode)) {
            return this.getParentForHyperLTLAllPath(((TCTLAbstractPathProperty)property).getParent());
        }
        if (property instanceof LTLANode) {
            return (TCTLAbstractPathProperty)property;
        }
        return (TCTLAbstractPathProperty)((TCTLAbstractPathProperty)property).getParent();
    }

    private void addAllPathsHyperLTL(TCTLAbstractProperty oldProperty, TCTLAbstractProperty selection, String trace) {
        if (!(selection instanceof TCTLStatePlaceHolder) && !(selection instanceof TCTLPathPlaceHolder)) {
            if (selection instanceof TCTLPathToStateConverter) {
                TCTLAbstractPathProperty child = ((TCTLPathToStateConverter)selection).getProperty();
                this.addAllPathsHyperLTL(oldProperty, child, trace);
            } else {
                this.addAllPathsHyperLTL(oldProperty, ((LTLANode)selection).getProperty(), trace);
            }
        } else {
            LTLANode parent = null;
            LTLANode child = null;
            parent = (LTLANode)this.getParentForHyperLTLAllPath(selection);
            TCTLPathPlaceHolder placeHolder = new TCTLPathPlaceHolder();
            child = new LTLANode(this.ConvertToStateProperty(placeHolder), trace);
            if (parent != null) {
                parent.setProperty(this.ConvertToStateProperty(child));
            }
        }
    }

    private void addAllPathsToProperty(TCTLAbstractProperty oldProperty, TCTLAbstractProperty selection) {
        String trace;
        TCTLAbstractProperty property = null;
        int selectedIndex = this.queryType.getSelectedIndex();
        boolean isHyperLTL = selectedIndex == 2;
        String string = trace = isHyperLTL ? this.traceBoxQuantification.getSelectedItem().toString() : "";
        if (oldProperty instanceof LTLANode) {
            if (selectedIndex != 2) {
                property = oldProperty;
            } else {
                if (this.currentSelection.getObject().toString().equals("<*>") && isHyperLTL) {
                    oldProperty = oldProperty.copy();
                    selection = selection.copy();
                    this.addAllPathsHyperLTL(oldProperty, selection, trace);
                    this.newProperty = selection;
                    this.updateSelection(selection);
                    return;
                }
                property = isHyperLTL ? new LTLANode(this.ConvertToStateProperty((TCTLAbstractPathProperty)selection), trace) : new LTLANode();
            }
        } else if (oldProperty instanceof TCTLPathPlaceHolder) {
            property = isHyperLTL ? new LTLANode(trace) : new LTLANode();
        } else if (oldProperty instanceof TCTLAbstractPathProperty) {
            property = isHyperLTL ? new LTLANode(this.ConvertToStateProperty((TCTLAbstractPathProperty)oldProperty), trace) : new LTLANode(this.ConvertToStateProperty((TCTLAbstractPathProperty)oldProperty));
        } else if (oldProperty instanceof TCTLNotNode) {
            property = isHyperLTL ? new LTLANode((TCTLNotNode)oldProperty, trace) : new LTLANode((TCTLNotNode)oldProperty);
            property = this.ConvertToStateProperty((TCTLAbstractPathProperty)property);
        } else if (oldProperty instanceof TCTLAbstractStateProperty && (selection == null || selection instanceof LTLANode)) {
            TCTLAbstractProperty tCTLAbstractProperty = property = isHyperLTL ? new LTLANode((TCTLAbstractStateProperty)oldProperty, trace) : new LTLANode((TCTLAbstractStateProperty)oldProperty);
            if (!(this.newProperty instanceof TCTLAbstractPathProperty)) {
                this.newProperty = this.ConvertToPathProperty((TCTLAbstractStateProperty)this.newProperty);
            }
        }
        if (property != null && selection != null) {
            QueryConstructionEdit edit = new QueryConstructionEdit(selection, property);
            this.newProperty = selectedIndex != 2 ? this.newProperty.replace(this.newProperty, property) : property;
            this.updateSelection(property);
            this.undoSupport.postEdit(edit);
            this.queryChanged();
        } else if (property != null) {
            this.newProperty = this.newProperty.replace(this.newProperty, property);
            this.updateSelection(property);
            this.queryChanged();
        }
    }

    private void addExistsPathsToProperty(TCTLAbstractProperty oldProperty, TCTLAbstractProperty selection) {
        String trace;
        TCTLAbstractProperty property = null;
        int selectedIndex = this.queryType.getSelectedIndex();
        boolean isHyperLTL = selectedIndex == 2;
        String string = trace = isHyperLTL ? this.traceBoxQuantification.getSelectedItem().toString() : "";
        if (oldProperty instanceof LTLENode) {
            if (selectedIndex != 2) {
                property = oldProperty;
            } else {
                if (this.currentSelection.getObject().toString().equals("<*>") && isHyperLTL) {
                    oldProperty = oldProperty.copy();
                    selection = selection.copy();
                    this.addExistsPathsHyperLTL(oldProperty, selection, trace);
                    this.newProperty = selection;
                    this.updateSelection(selection);
                    return;
                }
                property = isHyperLTL ? new LTLENode(this.ConvertToStateProperty((TCTLAbstractPathProperty)oldProperty), trace) : new LTLENode();
            }
        } else if (oldProperty instanceof TCTLPathPlaceHolder) {
            property = isHyperLTL ? new LTLENode(trace) : new LTLENode();
        } else if (oldProperty instanceof TCTLAbstractPathProperty) {
            property = isHyperLTL ? new LTLENode(this.ConvertToStateProperty((TCTLAbstractPathProperty)oldProperty), trace) : new LTLENode(this.ConvertToStateProperty((TCTLAbstractPathProperty)oldProperty));
        } else if (oldProperty instanceof TCTLNotNode) {
            property = isHyperLTL ? new LTLENode((TCTLNotNode)oldProperty, trace) : new LTLENode((TCTLNotNode)oldProperty);
            property = this.ConvertToStateProperty((TCTLAbstractPathProperty)property);
        } else if (oldProperty instanceof TCTLAbstractStateProperty && (selection == null || selection instanceof LTLENode)) {
            TCTLAbstractProperty tCTLAbstractProperty = property = isHyperLTL ? new LTLENode((TCTLAbstractStateProperty)oldProperty, trace) : new LTLENode((TCTLAbstractStateProperty)oldProperty);
            if (!(this.newProperty instanceof TCTLAbstractPathProperty)) {
                this.newProperty = this.ConvertToPathProperty((TCTLAbstractStateProperty)this.newProperty);
            }
        }
        if (property != null && selection != null) {
            QueryConstructionEdit edit = new QueryConstructionEdit(selection, property);
            this.newProperty = selectedIndex != 2 ? this.newProperty.replace(this.newProperty, property) : property;
            this.updateSelection(property);
            this.undoSupport.postEdit(edit);
            this.queryChanged();
        } else if (property != null) {
            this.newProperty = this.newProperty.replace(this.newProperty, property);
            this.updateSelection(property);
            this.queryChanged();
        }
    }

    private void addExistsPathsHyperLTL(TCTLAbstractProperty oldProperty, TCTLAbstractProperty selection, String trace) {
        if (!(selection instanceof TCTLStatePlaceHolder) && !(selection instanceof TCTLPathPlaceHolder)) {
            if (selection instanceof TCTLPathToStateConverter) {
                TCTLAbstractPathProperty child = ((TCTLPathToStateConverter)selection).getProperty();
                this.addExistsPathsHyperLTL(oldProperty, child, trace);
            } else {
                this.addExistsPathsHyperLTL(oldProperty, ((LTLENode)selection).getProperty(), trace);
            }
        } else {
            LTLENode parent = null;
            LTLENode child = null;
            parent = (LTLENode)this.getParentForHyperLTLExistsPath(selection);
            TCTLPathPlaceHolder placeHolder = new TCTLPathPlaceHolder();
            child = new LTLENode(this.ConvertToStateProperty(placeHolder), trace);
            if (parent != null) {
                parent.setProperty(this.ConvertToStateProperty(child));
            }
        }
    }

    private TCTLAbstractPathProperty getParentForHyperLTLExistsPath(TCTLAbstractProperty property) {
        if (property instanceof TCTLStatePlaceHolder) {
            return this.getParentForHyperLTLExistsPath(((TCTLStatePlaceHolder)property).getParent());
        }
        if (property instanceof TCTLPathToStateConverter) {
            return this.getParentForHyperLTLExistsPath(((TCTLPathToStateConverter)property).getParent());
        }
        if (property instanceof TCTLPathPlaceHolder) {
            return this.getParentForHyperLTLExistsPath(((TCTLPathPlaceHolder)property).getParent());
        }
        if (!(((TCTLAbstractPathProperty)property).getParent() instanceof LTLENode) && !(property instanceof LTLENode)) {
            return this.getParentForHyperLTLExistsPath(((TCTLAbstractPathProperty)property).getParent());
        }
        if (property instanceof LTLENode) {
            return (TCTLAbstractPathProperty)property;
        }
        return (TCTLAbstractPathProperty)((TCTLAbstractPathProperty)property).getParent();
    }

    private TCTLAbstractProperty removeExistsAllPathsFromProperty(TCTLAbstractProperty oldProperty) {
        TCTLAbstractPathProperty child;
        TCTLAbstractProperty property = oldProperty;
        TCTLAbstractStateProperty firstChild = this.getSpecificChildOfProperty(1, oldProperty);
        if (oldProperty instanceof TCTLPathToStateConverter) {
            oldProperty = ((TCTLPathToStateConverter)oldProperty).getProperty();
            firstChild = this.getSpecificChildOfProperty(1, oldProperty);
        }
        if (oldProperty instanceof LTLANode) {
            child = this.ConvertToPathProperty(firstChild);
            property = oldProperty.replace(oldProperty, child);
        }
        if (oldProperty instanceof LTLENode) {
            child = this.ConvertToPathProperty(firstChild);
            property = oldProperty.replace(oldProperty, child);
        }
        return property;
    }

    private void initBoundednessCheckPanel() {
        this.boundednessCheckPanel = new JPanel();
        this.boundednessCheckPanel.setBorder(BorderFactory.createTitledBorder("Boundedness Options"));
        this.boundednessCheckPanel.setLayout(new BoxLayout(this.boundednessCheckPanel, 0));
        this.boundednessCheckPanel.add(new JLabel(" Number of extra tokens:  "));
        this.numberOfExtraTokensInNet = new CustomJSpinner(4, 0, Integer.MAX_VALUE);
        this.numberOfExtraTokensInNet.setMaximumSize(new Dimension(65, 30));
        this.numberOfExtraTokensInNet.setMinimumSize(new Dimension(65, 30));
        this.numberOfExtraTokensInNet.setPreferredSize(new Dimension(65, 30));
        this.numberOfExtraTokensInNet.setToolTipText(TOOL_TIP_NUMBEROFEXTRATOKENSINNET);
        this.boundednessCheckPanel.add(this.numberOfExtraTokensInNet);
        this.boundednessCheckPanel.add(new JLabel("  "));
        this.kbounded = new JButton("Check boundedness");
        this.kbounded.setToolTipText(TOOL_TIP_KBOUNDED);
        this.kbounded.addActionListener(evt -> {
            this.querySaved = true;
            Verifier.analyzeKBound(this.tapnNetwork, this.lens, this.guiModels, this.getCapacity(), this.numberOfExtraTokensInNet, this.getQuery());
            this.querySaved = false;
        });
        this.boundednessCheckPanel.add(this.kbounded);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        this.uppaalOptionsPanel.add((Component)this.boundednessCheckPanel, gridBagConstraints);
    }

    private void initSmcSettingsPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 5, 0, 5);
        GridBagConstraints subPanelGbc = new GridBagConstraints();
        subPanelGbc.anchor = 17;
        subPanelGbc.insets = new Insets(0, 5, 0, 5);
        FocusListener updater = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                QueryDialog.this.updateSMCSettings();
            }
        };
        this.smcSettingsPanel = new JPanel();
        this.smcSettingsPanel.setLayout(new GridBagLayout());
        this.smcSettingsPanel.setVisible(false);
        this.smcSettingsPanel.setBorder(BorderFactory.createTitledBorder("SMC Options"));
        gbc.gridy = 0;
        gbc.gridx = 0;
        JPanel smcEngineOptions = new JPanel();
        smcEngineOptions.setLayout(new GridBagLayout());
        smcEngineOptions.setBorder(BorderFactory.createTitledBorder("SMC engine options"));
        subPanelGbc.gridy = 0;
        subPanelGbc.gridx = 0;
        this.smcVerificationTypeLabel = new JLabel("Verification type : ");
        smcEngineOptions.add((Component)this.smcVerificationTypeLabel, subPanelGbc);
        subPanelGbc.gridx = 1;
        subPanelGbc.fill = 2;
        subPanelGbc.gridwidth = 2;
        this.smcVerificationType = new JComboBox<String>(new String[]{"Quantitative", "Qualitative", "Simulate"});
        this.smcVerificationType.setToolTipText(TOOL_TIP_ANALYSIS_TYPE);
        smcEngineOptions.add(this.smcVerificationType, subPanelGbc);
        subPanelGbc.fill = 0;
        subPanelGbc.gridwidth = 1;
        subPanelGbc.gridy = 1;
        subPanelGbc.gridx = 0;
        JLabel timeBoundLabel = new JLabel("Time bound : ");
        timeBoundLabel.setToolTipText(TOOL_TIP_TIME_BOUND);
        smcEngineOptions.add((Component)timeBoundLabel, subPanelGbc);
        subPanelGbc.gridx = 1;
        subPanelGbc.fill = 2;
        this.smcTimeBoundValue = new JTextField(7);
        DocumentFilters.applyIntegerFilter(this.smcTimeBoundValue);
        this.smcTimeBoundValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                int endIdx = QueryDialog.this.smcTimeBoundValue.getText().length();
                QueryDialog.this.smcTimeBoundValue.setSelectionStart(endIdx);
                QueryDialog.this.smcTimeBoundValue.setSelectionEnd(endIdx);
            }
        });
        this.smcTimeBoundValue.setToolTipText(TOOL_TIP_TIME_BOUND);
        smcEngineOptions.add((Component)this.smcTimeBoundValue, subPanelGbc);
        this.smcTimeBoundValue.addFocusListener(updater);
        subPanelGbc.fill = 0;
        subPanelGbc.gridx = 2;
        this.smcTimeBoundInfinite = new JCheckBox(Character.toString('\u221e'));
        this.smcTimeBoundInfinite.addActionListener(evt -> {
            if (!this.updatingSmcSettings) {
                this.updateSMCSettings();
            }
        });
        smcEngineOptions.add((Component)this.smcTimeBoundInfinite, subPanelGbc);
        subPanelGbc.gridy = 2;
        subPanelGbc.gridx = 0;
        JLabel stepBoundLabel = new JLabel("Step bound : ");
        stepBoundLabel.setToolTipText(TOOL_TIP_STEP_BOUND);
        smcEngineOptions.add((Component)stepBoundLabel, subPanelGbc);
        subPanelGbc.gridx = 1;
        subPanelGbc.fill = 2;
        this.smcStepBoundValue = new JTextField(7);
        this.smcStepBoundValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                int endIdx = QueryDialog.this.smcStepBoundValue.getText().length();
                QueryDialog.this.smcStepBoundValue.setSelectionStart(endIdx);
                QueryDialog.this.smcStepBoundValue.setSelectionEnd(endIdx);
            }
        });
        DocumentFilters.applyIntegerFilter(this.smcStepBoundValue);
        this.smcStepBoundValue.setToolTipText(TOOL_TIP_STEP_BOUND);
        smcEngineOptions.add((Component)this.smcStepBoundValue, subPanelGbc);
        this.smcStepBoundValue.addFocusListener(updater);
        subPanelGbc.fill = 0;
        subPanelGbc.gridx = 2;
        this.smcStepBoundInfinite = new JCheckBox(Character.toString('\u221e'));
        this.smcStepBoundInfinite.addActionListener(evt -> {
            if (!this.updatingSmcSettings) {
                this.updateSMCSettings();
            }
        });
        smcEngineOptions.add((Component)this.smcStepBoundInfinite, subPanelGbc);
        subPanelGbc.gridy = 3;
        subPanelGbc.gridx = 0;
        this.smcNumericPrecisionLabel = new JLabel("Numeric precision : ");
        this.smcNumericPrecisionLabel.setToolTipText(TOOL_TIP_NUMERIC_PRECISION);
        smcEngineOptions.add((Component)this.smcNumericPrecisionLabel, subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcNumericPrecision = new CustomJSpinner(1, 1, 18);
        this.smcNumericPrecision.addChangeListener(e -> {
            if (!this.updatingSmcSettings) {
                this.updateRawVerificationOptions();
            }
        });
        this.smcNumericPrecision.setToolTipText(TOOL_TIP_NUMERIC_PRECISION);
        this.smcNumericPrecision.addFocusListener(updater);
        smcEngineOptions.add((Component)this.smcNumericPrecision, subPanelGbc);
        subPanelGbc.gridy = 4;
        subPanelGbc.gridx = 0;
        this.smcParallelLabel = new JLabel("Use all available cores : ");
        smcEngineOptions.add((Component)this.smcParallelLabel, subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcParallel = new JCheckBox();
        this.smcParallel.setSelected(true);
        smcEngineOptions.add((Component)this.smcParallel, subPanelGbc);
        this.smcSettingsPanel.add((Component)smcEngineOptions, gbc);
        gbc.gridx = 1;
        subPanelGbc.gridx = 0;
        subPanelGbc.gridy = 0;
        subPanelGbc.gridwidth = 1;
        this.quantitativePanel = new JPanel();
        this.quantitativePanel.setLayout(new GridBagLayout());
        this.quantitativePanel.setBorder(BorderFactory.createTitledBorder("Quantitative estimation options"));
        subPanelGbc.gridy = 0;
        subPanelGbc.gridx = 0;
        this.quantitativePanel.add((Component)new JLabel("Confidence : "), subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcConfidence = new JTextField(7);
        this.smcConfidence.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                int endIdx = QueryDialog.this.smcConfidence.getText().length();
                QueryDialog.this.smcConfidence.setSelectionStart(endIdx);
                QueryDialog.this.smcConfidence.setSelectionEnd(endIdx);
            }
        });
        DocumentFilters.applyDoubleFilter(this.smcConfidence);
        this.smcConfidence.addFocusListener(updater);
        this.smcConfidence.setToolTipText(TOOL_TIP_CONFIDENCE);
        this.quantitativePanel.add((Component)this.smcConfidence, subPanelGbc);
        subPanelGbc.gridx = 2;
        this.smcConfidenceSlider = new QuerySlider(95, 0.8, 0.99);
        this.smcConfidenceSlider.setToolTipText("Value: 0.95");
        this.smcConfidenceSlider.addChangeListener(e -> {
            if (this.updatingSmcSettings) {
                return;
            }
            int value = this.smcConfidenceSlider.getValue();
            double desiredMin = this.smcConfidenceSlider.getDesiredMin();
            double desiredMax = this.smcConfidenceSlider.getDesiredMax();
            double proportion = (double)value / (double)this.smcConfidenceSlider.getMaximum();
            double interpretedValue = desiredMin + proportion * (desiredMax - desiredMin);
            double roundedValue = (double)Math.round(interpretedValue * 100.0) / 100.0;
            this.smcConfidence.setText("" + roundedValue);
            this.smcConfidenceSlider.setRealValue(roundedValue);
            this.smcConfidenceSlider.setToolTipText(String.format("Value: %.2f", roundedValue));
            this.smcMustUpdateTime = true;
        });
        this.quantitativePanel.add((Component)this.smcConfidenceSlider, subPanelGbc);
        subPanelGbc.gridy = 1;
        subPanelGbc.gridx = 0;
        this.quantitativePanel.add((Component)new JLabel("Precision : "), subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcEstimationIntervalWidth = new JTextField(7);
        this.smcEstimationIntervalWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                int endIdx = QueryDialog.this.smcEstimationIntervalWidth.getText().length();
                QueryDialog.this.smcEstimationIntervalWidth.setSelectionStart(endIdx);
                QueryDialog.this.smcEstimationIntervalWidth.setSelectionEnd(endIdx);
            }
        });
        DocumentFilters.applyDoubleFilter(this.smcEstimationIntervalWidth);
        this.smcEstimationIntervalWidth.addFocusListener(updater);
        this.smcEstimationIntervalWidth.setToolTipText(TOOL_TIP_INTERVAL_WIDTH);
        this.quantitativePanel.add((Component)this.smcEstimationIntervalWidth, subPanelGbc);
        subPanelGbc.gridx = 2;
        this.smcPrecisionSlider = new QuerySlider(0, 0.5, 1.0E-4);
        this.smcPrecisionSlider.setToolTipText("Value: 0.5000");
        this.smcPrecisionSlider.addChangeListener(e -> {
            if (this.updatingSmcSettings) {
                return;
            }
            int value = this.smcPrecisionSlider.getValue();
            double desiredMin = this.smcPrecisionSlider.getDesiredMin();
            double desiredMax = this.smcPrecisionSlider.getDesiredMax();
            double logMin = Math.log(desiredMin);
            double logMax = Math.log(desiredMax);
            double proportion = (double)value / (double)this.smcPrecisionSlider.getMaximum();
            double logValue = logMin + proportion * (logMax - logMin);
            double interpretedValue = Math.exp(logValue);
            this.smcPrecisionSlider.setRealValue(interpretedValue);
            double roundedValue = (double)Math.round(interpretedValue * 10000.0) / 10000.0;
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
            decimalFormatSymbols.setDecimalSeparator('.');
            DecimalFormat df = new DecimalFormat("#.####", decimalFormatSymbols);
            String formattedValue = df.format(roundedValue);
            this.smcEstimationIntervalWidth.setText(formattedValue);
            this.smcPrecisionSlider.setToolTipText(String.format("Value: %s", formattedValue));
            this.smcMustUpdateTime = true;
            this.smcTimeExpected.setText("");
            this.smcTimeEstimationButton.setText(UPDATE_VERIFICATION_TIME_BTN_TEXT);
        });
        this.quantitativePanel.add((Component)this.smcPrecisionSlider, subPanelGbc);
        subPanelGbc.gridy = 2;
        subPanelGbc.gridx = 0;
        JLabel verifTimeLabel = new JLabel("Estimated verification time (seconds) : ");
        verifTimeLabel.setToolTipText(TOOL_TIP_VERIFICATION_TIME);
        this.quantitativePanel.add((Component)verifTimeLabel, subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcTimeExpected = new JTextField(7);
        this.smcTimeExpected.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                int endIdx = QueryDialog.this.smcTimeExpected.getText().length();
                QueryDialog.this.smcTimeExpected.setSelectionStart(endIdx);
                QueryDialog.this.smcTimeExpected.setSelectionEnd(endIdx);
            }
        });
        DocumentFilters.applyDoubleFilter(this.smcTimeExpected);
        this.smcTimeExpected.setToolTipText(TOOL_TIP_VERIFICATION_TIME);
        this.quantitativePanel.add((Component)this.smcTimeExpected, subPanelGbc);
        this.smcEstimatedTimeSlider = new QuerySlider(0, 1.0, 100.0, 99);
        this.smcEstimatedTimeSlider.setToolTipText("Value: 1.0");
        this.smcEstimatedTimeSlider.addChangeListener(e -> {
            if (this.updatingSmcSettings) {
                return;
            }
            int value = this.smcEstimatedTimeSlider.getValue();
            double desiredMin = this.smcEstimatedTimeSlider.getDesiredMin();
            double desiredMax = this.smcEstimatedTimeSlider.getDesiredMax();
            double proportion = (double)value / (double)this.smcEstimatedTimeSlider.getMaximum();
            double interpretedValue = desiredMin + proportion * (desiredMax - desiredMin);
            double roundedValue = Math.round(interpretedValue);
            this.smcTimeExpected.setText("" + roundedValue);
            this.smcEstimatedTimeSlider.setRealValue(roundedValue);
            this.smcEstimatedTimeSlider.setToolTipText(String.format("Value: %.1f", roundedValue));
            this.smcMustUpdateTime = false;
            this.smcEstimationIntervalWidth.setText("");
            this.smcTimeEstimationButton.setText(UPDATE_PRECISION_BTN_TEXT);
        });
        subPanelGbc.gridx = 2;
        this.quantitativePanel.add((Component)this.smcEstimatedTimeSlider, subPanelGbc);
        subPanelGbc.gridy = 3;
        subPanelGbc.gridx = 0;
        subPanelGbc.gridwidth = 2;
        subPanelGbc.fill = 2;
        this.smcTimeEstimationButton = new JButton(UPDATE_VERIFICATION_TIME_BTN_TEXT);
        this.smcTimeEstimationButton.setPreferredSize(new Dimension(378, 25));
        this.smcTimeEstimationButton.addActionListener(evt -> this.runBenchmark());
        this.quantitativePanel.add((Component)this.smcTimeEstimationButton, subPanelGbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.smcSettingsPanel.add((Component)this.quantitativePanel, gbc);
        subPanelGbc.gridwidth = 1;
        subPanelGbc.anchor = 17;
        this.qualitativePanel = new JPanel();
        this.qualitativePanel.setLayout(new GridBagLayout());
        this.qualitativePanel.setBorder(BorderFactory.createTitledBorder("Qualitative estimation options"));
        this.qualitativePanel.setVisible(false);
        subPanelGbc.gridy = 0;
        subPanelGbc.gridx = 0;
        this.qualitativePanel.add((Component)new JLabel("False positives : "), subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcFalsePositives = new JTextField(7);
        DocumentFilters.applyDoubleFilter(this.smcFalsePositives);
        this.smcFalsePositives.addFocusListener(updater);
        this.smcFalsePositives.setToolTipText(TOOL_TIP_FALSE_POSITIVES);
        this.qualitativePanel.add((Component)this.smcFalsePositives, subPanelGbc);
        subPanelGbc.gridx = 2;
        this.smcFalsePositivesSlider = new QuerySlider(0, 0.001, 0.5);
        this.smcFalsePositivesSlider.setToolTipText("Value: 0.001");
        this.smcFalsePositivesSlider.addChangeListener(e -> {
            if (!this.updatingSmcSettings) {
                this.smcFalsePositivesSlider.updateValue(this.smcFalsePositives, 3);
            }
        });
        this.qualitativePanel.add((Component)this.smcFalsePositivesSlider, subPanelGbc);
        subPanelGbc.gridy = 1;
        subPanelGbc.gridx = 0;
        this.qualitativePanel.add((Component)new JLabel("False negatives : "), subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcFalseNegatives = new JTextField(7);
        DocumentFilters.applyDoubleFilter(this.smcFalseNegatives);
        this.smcFalseNegatives.addFocusListener(updater);
        this.smcFalseNegatives.setToolTipText(TOOL_TIP_FALSE_NEGATIVES);
        this.qualitativePanel.add((Component)this.smcFalseNegatives, subPanelGbc);
        subPanelGbc.gridx = 2;
        this.smcFalseNegativesSlider = new QuerySlider(0, 0.001, 0.5);
        this.smcFalseNegativesSlider.setToolTipText("Value: 0.001");
        this.smcFalseNegativesSlider.addChangeListener(e -> {
            if (!this.updatingSmcSettings) {
                this.smcFalseNegativesSlider.updateValue(this.smcFalseNegatives, 3);
            }
        });
        this.qualitativePanel.add((Component)this.smcFalseNegativesSlider, subPanelGbc);
        subPanelGbc.gridy = 2;
        subPanelGbc.gridx = 0;
        this.qualitativePanel.add((Component)new JLabel("Indifference region width : "), subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcIndifference = new JTextField(7);
        DocumentFilters.applyDoubleFilter(this.smcIndifference);
        this.smcIndifference.addFocusListener(updater);
        this.smcIndifference.setToolTipText(TOOL_TIP_INDIFFERENCE);
        this.qualitativePanel.add((Component)this.smcIndifference, subPanelGbc);
        subPanelGbc.gridx = 2;
        this.smcIndifferenceSlider = new QuerySlider(100, 0.001, 0.5);
        this.smcIndifferenceSlider.setToolTipText("Value: 0.500");
        this.smcIndifferenceSlider.addChangeListener(e -> {
            if (!this.updatingSmcSettings) {
                this.smcIndifferenceSlider.updateValue(this.smcIndifference, 3);
            }
        });
        this.qualitativePanel.add((Component)this.smcIndifferenceSlider, subPanelGbc);
        subPanelGbc.gridy = 3;
        subPanelGbc.gridx = 0;
        JLabel testLabel = new JLabel("Property hold with probability >= ");
        testLabel.setToolTipText(TOOL_TIP_QUALITATIVE_TEST);
        this.qualitativePanel.add((Component)testLabel, subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcComparisonFloat = new JTextField(7);
        DocumentFilters.applyDoubleFilter(this.smcComparisonFloat);
        this.smcComparisonFloat.setToolTipText(TOOL_TIP_QUALITATIVE_TEST);
        this.smcComparisonFloat.addFocusListener(updater);
        this.qualitativePanel.add((Component)this.smcComparisonFloat, subPanelGbc);
        subPanelGbc.gridx = 2;
        this.smcComparisonFloatSlider = new QuerySlider(50, 0.01, 0.99, 98);
        this.smcComparisonFloatSlider.setToolTipText("Value: 0.50");
        this.smcComparisonFloatSlider.addChangeListener(e -> {
            if (!this.updatingSmcSettings) {
                this.smcComparisonFloatSlider.updateValue(this.smcComparisonFloat, 2);
            }
        });
        this.qualitativePanel.add((Component)this.smcComparisonFloatSlider, subPanelGbc);
        this.smcSettingsPanel.add((Component)this.qualitativePanel, gbc);
        this.smcTracePanel = new JPanel();
        this.smcTracePanel.setLayout(new GridBagLayout());
        this.smcTracePanel.setBorder(BorderFactory.createTitledBorder("Trace options"));
        this.smcTracePanel.setVisible(false);
        subPanelGbc.gridy = 0;
        subPanelGbc.gridx = 0;
        JLabel numberOfTracesLabel = new JLabel("Number of traces : ");
        numberOfTracesLabel.setToolTipText(TOOL_TIP_N_TRACES);
        this.smcTracePanel.add((Component)numberOfTracesLabel, subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcNumberOfTraces = new CustomJSpinner(1, 1, Integer.MAX_VALUE);
        this.smcNumberOfTraces.addFocusListener(updater);
        this.smcNumberOfTraces.setToolTipText(TOOL_TIP_N_TRACES);
        this.smcTracePanel.add((Component)this.smcNumberOfTraces, subPanelGbc);
        subPanelGbc.gridy = 1;
        this.smcTracePanel.add(Box.createVerticalStrut(5), subPanelGbc);
        JLabel traceTypeLabel = new JLabel("Trace type : ");
        traceTypeLabel.setToolTipText(TOOL_TIP_TRACE_TYPE);
        subPanelGbc.gridx = 0;
        subPanelGbc.gridy = 2;
        this.smcTracePanel.add((Component)traceTypeLabel, subPanelGbc);
        subPanelGbc.gridx = 1;
        this.smcTraceType = new JComboBox<SMCTraceType>(new SMCTraceType[]{new SMCTraceType("Any"), new SMCTraceType("Satisfied"), new SMCTraceType("Not satisfied")});
        this.smcTraceType.setToolTipText(TOOL_TIP_TRACE_TYPE);
        this.smcTracePanel.add(this.smcTraceType, subPanelGbc);
        this.smcSettingsPanel.add((Component)this.smcTracePanel, gbc);
        this.smcVerificationType.addActionListener(evt -> {
            boolean quantitative = this.smcVerificationType.getSelectedIndex() == 0;
            boolean qualitative = this.smcVerificationType.getSelectedIndex() == 1;
            boolean simulate = this.smcVerificationType.getSelectedIndex() == 2;
            this.quantitativePanel.setVisible(quantitative);
            this.qualitativePanel.setVisible(qualitative);
            this.smcTracePanel.setVisible(simulate);
            guiDialog.pack();
        });
        JLabel granualityLabel = new JLabel("Granularity : ");
        this.smcGranularityField = new JTextField(7);
        DocumentFilters.applyIntegerFilter(this.smcGranularityField);
        this.smcGranularityField.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                QueryDialog.this.updateRawVerificationOptions();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }
        });
        granualityLabel.setToolTipText(TOOL_TIP_GRANULARITY);
        this.smcGranularityField.setToolTipText(TOOL_TIP_GRANULARITY);
        this.smcMaxGranularityCheckbox = new JCheckBox(Character.toString('\u221e'));
        this.smcMaxGranularityCheckbox.addActionListener(e -> {
            this.smcGranularityField.setEnabled(!this.smcMaxGranularityCheckbox.isSelected());
            this.updateRawVerificationOptions();
        });
        JButton smcObservationsButton = new JButton("Edit observations");
        smcObservationsButton.addActionListener(evt -> {
            ObservationListDialog dialog = new ObservationListDialog(this.tapnNetwork, this.smcObservations);
            dialog.setLocationRelativeTo(guiDialog);
            dialog.setVisible(true);
        });
        JPanel smcObservationsPanel = new JPanel();
        smcObservationsPanel.setLayout(new GridBagLayout());
        smcObservationsPanel.setBorder(BorderFactory.createTitledBorder("SMC Observations"));
        subPanelGbc.gridx = 0;
        subPanelGbc.gridy = 0;
        subPanelGbc.anchor = 17;
        subPanelGbc.weightx = 0.0;
        smcObservationsPanel.add((Component)smcObservationsButton, subPanelGbc);
        subPanelGbc.gridx = 1;
        smcObservationsPanel.add((Component)granualityLabel, subPanelGbc);
        subPanelGbc.gridx = 2;
        smcObservationsPanel.add((Component)this.smcGranularityField, subPanelGbc);
        subPanelGbc.gridx = 3;
        smcObservationsPanel.add((Component)this.smcMaxGranularityCheckbox, subPanelGbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        this.smcSettingsPanel.add((Component)smcObservationsPanel, gbc);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.smcSettingsPanel, gridBagConstraints);
        Dimension quantitativeSize = this.quantitativePanel.getPreferredSize();
        Dimension qualitativeSize = this.qualitativePanel.getPreferredSize();
        Dimension smcTraceSize = this.smcTracePanel.getPreferredSize();
        int maxWidth = Math.max(quantitativeSize.width, Math.max(qualitativeSize.width, smcTraceSize.width));
        int maxHeight = Math.max(quantitativeSize.height, Math.max(qualitativeSize.height, smcTraceSize.height));
        Dimension largestSize = new Dimension(maxWidth, maxHeight);
        this.quantitativePanel.setPreferredSize(largestSize);
        this.qualitativePanel.setPreferredSize(largestSize);
        this.smcTracePanel.setPreferredSize(largestSize);
        this.setupEstimationListeners();
    }

    private void initQueryPanel() {
        this.queryPanel = new JPanel(new GridBagLayout());
        this.queryPanel.setBorder(BorderFactory.createTitledBorder("Query (click on the part of the query you want to change)"));
        this.initQueryField();
        this.initQuantificationPanel();
        this.initLogicPanel();
        this.initPredicationConstructionPanel();
        this.initQueryEditingPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.fill = 1;
        gbc.anchor = 17;
        this.add((Component)this.queryPanel, gbc);
    }

    private void initQueryField() {
        this.queryField = new JTextPane();
        StyledDocument doc = this.queryField.getStyledDocument();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 1);
        StyleConstants.setFontSize(standard, 14);
        doc.setParagraphAttributes(0, 0, standard, true);
        this.queryField.setBackground(Color.white);
        this.queryField.setEditable(false);
        this.queryField.setText(this.newProperty.toString());
        this.queryField.setToolTipText(TOOL_TIP_QUERY_FIELD);
        JScrollPane queryScrollPane = new JScrollPane(this.queryField);
        queryScrollPane.setVerticalScrollBarPolicy(20);
        Dimension d = new Dimension(900, 80);
        queryScrollPane.setPreferredSize(d);
        queryScrollPane.setMinimumSize(d);
        this.queryField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!QueryDialog.this.queryField.isEditable()) {
                    QueryDialog.this.updateSelection();
                }
            }
        });
        this.queryField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                QueryDialog.this.setSaveButtonsEnabled();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                QueryDialog.this.setSaveButtonsEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                QueryDialog.this.setSaveButtonsEnabled();
            }
        });
        this.queryField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!QueryDialog.this.queryField.isEditable()) {
                    if (e.getKeyChar() == '\u007f' || e.getKeyChar() == '\b') {
                        QueryDialog.this.deleteSelection();
                    } else if (e.getKeyCode() == 39 || e.getKeyCode() == 37) {
                        e.consume();
                        int position = QueryDialog.this.queryField.getSelectionEnd();
                        if (e.getKeyCode() == 37) {
                            position = QueryDialog.this.queryField.getSelectionStart();
                        }
                        QueryDialog.this.changeToEditMode();
                        QueryDialog.this.queryField.setCaretPosition(position);
                    }
                } else if (e.getKeyChar() == '\n') {
                    QueryDialog.this.resetButton.doClick();
                    e.consume();
                }
            }
        });
        if (this.lens.isGame()) {
            queryScrollPane.setColumnHeaderView(new JLabel("control: ", 0));
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.gridwidth = 4;
        this.queryPanel.add((Component)queryScrollPane, gbc);
    }

    private void initQuantificationPanel() {
        this.quantificationPanel = new JPanel(new GridBagLayout());
        this.quantificationPanel.setBorder(BorderFactory.createTitledBorder("Quantification"));
        this.quantificationButtonGroup = new ButtonGroup();
        this.approximationRadioButtonGroup = new ButtonGroup();
        this.existsDiamond = new JButton("EF");
        this.existsBox = new JButton("EG");
        this.forAllDiamond = new JButton("AF");
        this.forAllBox = new JButton("AG");
        this.existsUntil = new JButton("EU");
        this.existsNext = new JButton("EX");
        this.forAllUntil = new JButton("AU");
        this.forAllNext = new JButton("AX");
        this.globallyButton = new JButton("G");
        this.finallyButton = new JButton("F");
        this.nextButton = new JButton("X");
        this.untilButton = new JButton("U");
        this.aButton = new JButton("A");
        this.eButton = new JButton("E");
        this.addTraceButton = new JButton("Edit traces");
        this.existsDiamond.setToolTipText(TOOL_TIP_EXISTS_DIAMOND);
        this.existsBox.setToolTipText(TOOL_TIP_EXISTS_BOX);
        this.forAllDiamond.setToolTipText(TOOL_TIP_FORALL_DIAMOND);
        this.forAllBox.setToolTipText(TOOL_TIP_FORALL_BOX);
        this.existsUntil.setToolTipText(TOOL_TIP_EXISTS_UNTIL);
        this.existsNext.setToolTipText(TOOL_TIP_EXISTS_NEXT);
        this.forAllUntil.setToolTipText(TOOL_TIP_FORALL_UNTIL);
        this.forAllNext.setToolTipText(TOOL_TIP_FORALL_NEXT);
        this.globallyButton.setToolTipText(TOOL_TIP_G);
        this.finallyButton.setToolTipText(TOOL_TIP_F);
        this.nextButton.setToolTipText(TOOL_TIP_X);
        this.untilButton.setToolTipText(TOOL_TIP_U);
        this.aButton.setToolTipText(TOOL_TIP_A);
        this.eButton.setToolTipText(TOOL_TIP_E);
        this.addTraceButton.setToolTipText(TOOL_TIP_ADDTRACEBUTTON);
        this.quantificationButtonGroup.add(this.existsDiamond);
        this.quantificationButtonGroup.add(this.existsBox);
        this.quantificationButtonGroup.add(this.forAllDiamond);
        this.quantificationButtonGroup.add(this.forAllBox);
        this.quantificationButtonGroup.add(this.existsUntil);
        this.quantificationButtonGroup.add(this.existsNext);
        this.quantificationButtonGroup.add(this.forAllUntil);
        this.quantificationButtonGroup.add(this.forAllNext);
        this.quantificationButtonGroup.add(this.globallyButton);
        this.quantificationButtonGroup.add(this.finallyButton);
        this.quantificationButtonGroup.add(this.nextButton);
        this.quantificationButtonGroup.add(this.untilButton);
        this.quantificationButtonGroup.add(this.aButton);
        this.quantificationButtonGroup.add(this.eButton);
        this.quantificationButtonGroup.add(this.addTraceButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 10;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.quantificationPanel.add((Component)this.existsDiamond, gbc);
        this.quantificationPanel.add((Component)this.globallyButton, gbc);
        gbc.gridy = 1;
        this.quantificationPanel.add((Component)this.existsBox, gbc);
        this.quantificationPanel.add((Component)this.finallyButton, gbc);
        gbc.gridy = 2;
        this.quantificationPanel.add((Component)this.existsUntil, gbc);
        gbc.gridy = 3;
        this.quantificationPanel.add((Component)this.existsNext, gbc);
        gbc.gridy = 4;
        this.quantificationPanel.add((Component)this.aButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.quantificationPanel.add((Component)this.forAllDiamond, gbc);
        this.quantificationPanel.add((Component)this.nextButton, gbc);
        gbc.gridy = 1;
        this.quantificationPanel.add((Component)this.forAllBox, gbc);
        this.quantificationPanel.add((Component)this.untilButton, gbc);
        gbc.gridy = 2;
        this.quantificationPanel.add((Component)this.forAllUntil, gbc);
        gbc.gridy = 3;
        this.quantificationPanel.add((Component)this.forAllNext, gbc);
        gbc.gridy = 4;
        this.quantificationPanel.add((Component)this.eButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 10;
        this.addTraceButton.setPreferredSize(new Dimension(78, 27));
        this.quantificationPanel.add((Component)this.addTraceButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 3;
        this.queryPanel.add((Component)this.quantificationPanel, gbc);
        if (this.lens.isTimed() || this.lens.isGame()) {
            this.addTimedQuantificationListeners();
            if (this.lens.isStochastic()) {
                this.addSmcQuantificationListerners();
            }
            this.showLTLButtons(false);
            this.showHyperLTLButtons(false);
        } else {
            this.addUntimedQuantificationListeners();
            this.showLTLButtons(false);
            this.showHyperLTLButtons(false);
        }
    }

    private void addTimedQuantificationListeners() {
        this.existsBox.addActionListener(e -> {
            TCTLEGNode property = new TCTLEGNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()));
            this.existsBox.setSelected(true);
            this.addPropertyToQuery(property);
            this.unselectButtons();
        });
        this.existsDiamond.addActionListener(e -> {
            TCTLEFNode property = new TCTLEFNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()));
            this.existsDiamond.setSelected(true);
            this.setupExplicitSearch(true);
            this.depthFirstSearch.setSelected(true);
            this.addPropertyToQuery(property);
            this.unselectButtons();
        });
        this.forAllBox.addActionListener(e -> {
            TCTLAGNode property = new TCTLAGNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()));
            this.forAllBox.setSelected(true);
            this.setupExplicitSearch(true);
            this.depthFirstSearch.setSelected(true);
            this.addPropertyToQuery(property);
            this.unselectButtons();
        });
        this.forAllDiamond.addActionListener(e -> {
            TCTLAFNode property = new TCTLAFNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()));
            this.forAllDiamond.setSelected(true);
            this.addPropertyToQuery(property);
            this.unselectButtons();
        });
    }

    private void addSmcQuantificationListerners() {
        this.finallyButton.addActionListener(e -> {
            LTLFNode property = new LTLFNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()));
            this.addPropertyToQuery(property);
        });
        this.globallyButton.addActionListener(e -> {
            LTLGNode property = new LTLGNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()));
            this.addPropertyToQuery(property);
        });
    }

    private void unselectButtons() {
        this.existsDiamond.setSelected(false);
        this.existsBox.setSelected(false);
        this.forAllBox.setSelected(false);
        this.forAllDiamond.setSelected(false);
    }

    private void addUntimedQuantificationListeners() {
        this.addTimedQuantificationListeners();
        this.existsNext.addActionListener(e -> {
            TCTLEXNode property = this.currentSelection.getObject() instanceof TCTLAbstractStateProperty ? new TCTLEXNode((TCTLAbstractStateProperty)this.currentSelection.getObject()) : new TCTLEXNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()));
            this.addPropertyToQuery(property);
        });
        this.existsUntil.addActionListener(e -> {
            TCTLEUNode property = this.currentSelection.getObject() instanceof TCTLAbstractStateProperty ? new TCTLEUNode((TCTLAbstractStateProperty)this.currentSelection.getObject(), new TCTLStatePlaceHolder()) : new TCTLEUNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()), this.getSpecificChildOfProperty(2, this.currentSelection.getObject()));
            this.addPropertyToQuery(property);
        });
        this.globallyButton.addActionListener(e -> {
            LTLGNode property = this.currentSelection.getObject() instanceof LTLANode || this.currentSelection.getObject() instanceof LTLENode ? new LTLGNode() : new LTLGNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()));
            this.addPropertyToQuery(property);
            this.unselectButtons();
        });
        this.finallyButton.addActionListener(e -> {
            LTLFNode property = this.currentSelection.getObject() instanceof LTLANode || this.currentSelection.getObject() instanceof LTLENode ? new LTLFNode() : new LTLFNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()));
            this.addPropertyToQuery(property);
            this.unselectButtons();
        });
        this.forAllNext.addActionListener(e -> {
            TCTLAXNode property = this.currentSelection.getObject() instanceof TCTLAbstractStateProperty ? new TCTLAXNode((TCTLAbstractStateProperty)this.currentSelection.getObject()) : new TCTLAXNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()));
            this.addPropertyToQuery(property);
        });
        this.forAllUntil.addActionListener(e -> {
            TCTLAUNode property = this.currentSelection.getObject() instanceof TCTLAbstractStateProperty ? new TCTLAUNode((TCTLAbstractStateProperty)this.currentSelection.getObject(), new TCTLStatePlaceHolder()) : new TCTLAUNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()), this.getSpecificChildOfProperty(2, this.currentSelection.getObject()));
            this.addPropertyToQuery(property);
        });
        this.nextButton.addActionListener(e -> {
            LTLXNode property = this.currentSelection.getObject() instanceof LTLANode || this.currentSelection.getObject() instanceof LTLENode ? new LTLXNode() : (this.currentSelection.getObject() instanceof TCTLAbstractStateProperty ? new LTLXNode((TCTLAbstractStateProperty)this.currentSelection.getObject()) : new LTLXNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject())));
            this.addPropertyToQuery(property);
        });
        this.untilButton.addActionListener(e -> {
            LTLUNode property = this.currentSelection.getObject() instanceof LTLANode || this.currentSelection.getObject() instanceof LTLENode ? new LTLUNode() : (this.currentSelection.getObject() instanceof TCTLAbstractStateProperty ? new LTLUNode((TCTLAbstractStateProperty)this.currentSelection.getObject(), new TCTLStatePlaceHolder()) : new LTLUNode(this.getSpecificChildOfProperty(1, this.currentSelection.getObject()), this.getSpecificChildOfProperty(2, this.currentSelection.getObject())));
            this.addPropertyToQuery(property);
        });
        this.aButton.addActionListener(e -> {
            TCTLAbstractProperty oldProperty = this.newProperty;
            if (this.queryType.getSelectedIndex() != 2) {
                this.newProperty = this.removeExistsAllPathsFromProperty(this.newProperty);
                this.addAllPathsToProperty(this.newProperty, null);
            } else {
                String selectedTrace = this.traceBoxQuantification.getSelectedItem().toString();
                if (oldProperty.toString().contains("A " + selectedTrace)) {
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "An all-path with trace \"" + selectedTrace + "\" already exists. Please chose a different trace.", "Error", 0);
                    this.isAllPath = true;
                    this.isExistsPath = false;
                } else {
                    this.addAllPathsToProperty(this.newProperty, oldProperty);
                    this.isAllPath = true;
                    this.isExistsPath = false;
                }
            }
            QueryConstructionEdit edit = new QueryConstructionEdit(oldProperty, this.newProperty);
            this.undoSupport.postEdit(edit);
            this.queryChanged();
        });
        this.eButton.addActionListener(e -> {
            TCTLAbstractProperty oldProperty = this.newProperty;
            if (this.queryType.getSelectedIndex() != 2) {
                this.newProperty = this.removeExistsAllPathsFromProperty(this.newProperty);
                this.addExistsPathsToProperty(this.newProperty, null);
            } else if (this.traceBoxQuantification.getSelectedItem() != null) {
                String selectedTrace = this.traceBoxQuantification.getSelectedItem().toString();
                if (oldProperty.toString().contains("E " + selectedTrace)) {
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "An exists-path with trace \"" + selectedTrace + "\" already exists. Please chose a different trace.", "Error", 0);
                    this.isAllPath = false;
                    this.isExistsPath = true;
                } else {
                    this.addExistsPathsToProperty(this.newProperty, oldProperty);
                    this.isAllPath = false;
                    this.isExistsPath = true;
                }
            }
            QueryConstructionEdit edit = new QueryConstructionEdit(oldProperty, this.newProperty);
            this.undoSupport.postEdit(edit);
            this.queryChanged();
        });
        this.addTraceButton.addActionListener(e -> this.initTraceBoxDialogComponents());
    }

    private void showLTLButtons(boolean isVisible) {
        this.globallyButton.setVisible(isVisible);
        this.finallyButton.setVisible(isVisible);
        this.nextButton.setVisible(isVisible);
        this.untilButton.setVisible(isVisible);
        this.aButton.setVisible(isVisible);
        this.eButton.setVisible(isVisible);
        if (this.deadLockPredicateButton != null) {
            this.deadLockPredicateButton.setVisible(!isVisible);
        }
        this.showCTLButtons(!isVisible);
    }

    private void showHyperLTL(boolean isVisble) {
        this.traceRow.setVisible(isVisble);
        this.addTraceButton.setVisible(isVisble);
        this.traceBoxQuantification.setVisible(isVisble);
        guiDialog.pack();
    }

    private void showHyperLTLButtons(boolean isVisble) {
        this.addTraceButton.setVisible(isVisble);
    }

    private void showCTLButtons(boolean isVisible) {
        this.forAllBox.setVisible(isVisible);
        this.forAllDiamond.setVisible(isVisible);
        this.forAllNext.setVisible(isVisible);
        this.forAllUntil.setVisible(isVisible);
        this.existsBox.setVisible(isVisible);
        this.existsDiamond.setVisible(isVisible);
        this.existsNext.setVisible(isVisible);
        this.existsUntil.setVisible(isVisible);
    }

    private void showSMCButtons(boolean isVisible) {
        this.showCTLButtons(!isVisible);
        this.globallyButton.setVisible(isVisible);
        this.finallyButton.setVisible(isVisible);
        this.deadLockPredicateButton.setVisible(isVisible);
    }

    private void updateSiphonTrap(boolean isCTL) {
        this.useSiphonTrap.setEnabled(isCTL);
    }

    private void addPropertyToQuery(TCTLAbstractPathProperty property) {
        TCTLAbstractProperty selection = this.currentSelection.getObject();
        if (selection instanceof TCTLAbstractStateProperty) {
            this.addPropertyToQuery(this.ConvertToStateProperty(property));
            return;
        }
        if (selection instanceof LTLANode) {
            if (this.queryType.getSelectedIndex() == 2 && property instanceof LTLANode) {
                this.addAllPathsToProperty(this.newProperty, selection);
                return;
            }
            this.newProperty = this.newProperty.replace(selection, property);
            if (property instanceof LTLANode) {
                this.addAllPathsToProperty(this.newProperty, selection);
            }
            return;
        }
        if (selection instanceof LTLENode) {
            if (this.queryType.getSelectedIndex() == 2 && property instanceof LTLENode) {
                this.addExistsPathsToProperty(this.newProperty, selection);
                return;
            }
            this.newProperty = this.newProperty.replace(selection, property);
            if (property instanceof LTLENode) {
                this.addExistsPathsToProperty(this.newProperty, selection);
            } else {
                QueryConstructionEdit edit = new QueryConstructionEdit(selection, property);
                this.updateSelection(property);
                this.undoSupport.postEdit(edit);
                this.queryChanged();
            }
            return;
        }
        QueryConstructionEdit edit = new QueryConstructionEdit(selection, property);
        this.newProperty = this.newProperty.replace(selection, property);
        this.updateSelection(property);
        this.undoSupport.postEdit(edit);
        this.queryChanged();
    }

    private void addPropertyToQuery(TCTLAbstractStateProperty property) {
        if (this.currentSelection.getObject() instanceof TCTLAbstractPathProperty) {
            this.addPropertyToQuery(this.ConvertToPathProperty(property));
            return;
        }
        QueryConstructionEdit edit = new QueryConstructionEdit(this.currentSelection.getObject(), property);
        this.newProperty = this.newProperty.replace(this.currentSelection.getObject(), property);
        this.updateSelection(property);
        this.undoSupport.postEdit(edit);
        this.queryChanged();
    }

    private TCTLAbstractStateProperty ConvertToStateProperty(TCTLAbstractPathProperty p) {
        if (p instanceof TCTLStateToPathConverter) {
            return ((TCTLStateToPathConverter)p).getProperty();
        }
        return new TCTLPathToStateConverter(p);
    }

    private TCTLAbstractPathProperty ConvertToPathProperty(TCTLAbstractStateProperty p) {
        if (p instanceof TCTLPathToStateConverter) {
            return ((TCTLPathToStateConverter)p).getProperty();
        }
        return new TCTLStateToPathConverter(p);
    }

    private void initLogicPanel() {
        this.logicButtonPanel = new JPanel(new GridBagLayout());
        this.logicButtonPanel.setBorder(BorderFactory.createTitledBorder("Logic"));
        this.logicButtonGroup = new ButtonGroup();
        this.conjunctionButton = new JButton("and");
        this.disjunctionButton = new JButton("or");
        this.negationButton = new JButton("not");
        this.conjunctionButton.setToolTipText(TOOL_TIP_CONJUNCTIONBUTTON);
        this.disjunctionButton.setToolTipText(TOOL_TIP_DISJUNCTIONBUTTON);
        this.negationButton.setToolTipText(TOOL_TIP_NEGATIONBUTTON);
        this.logicButtonGroup.add(this.conjunctionButton);
        this.logicButtonGroup.add(this.disjunctionButton);
        this.logicButtonGroup.add(this.negationButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.logicButtonPanel.add((Component)this.conjunctionButton, gbc);
        gbc.gridy = 1;
        this.logicButtonPanel.add((Component)this.disjunctionButton, gbc);
        gbc.gridy = 2;
        this.logicButtonPanel.add((Component)this.negationButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 3;
        this.queryPanel.add((Component)this.logicButtonPanel, gbc);
        this.conjunctionButton.addActionListener(evt -> {
            TCTLAndListNode andListNode = null;
            if (this.currentSelection.getObject() instanceof TCTLAndListNode) {
                andListNode = new TCTLAndListNode((TCTLAndListNode)this.currentSelection.getObject());
                andListNode.setSimpleProperty(true);
                andListNode.addConjunct(new TCTLStatePlaceHolder());
                this.addPropertyToQuery(andListNode);
            } else if (this.currentSelection.getObject() instanceof TCTLOrListNode) {
                andListNode = new TCTLAndListNode(((TCTLOrListNode)this.currentSelection.getObject()).getProperties());
                this.addPropertyToQuery(andListNode);
            } else if (this.currentSelection.getObject() instanceof TCTLAbstractStateProperty) {
                TCTLAbstractStateProperty prop = (TCTLAbstractStateProperty)this.currentSelection.getObject();
                TCTLAbstractProperty parentNode = prop.getParent();
                if (parentNode instanceof TCTLAndListNode) {
                    andListNode = new TCTLAndListNode((TCTLAndListNode)parentNode);
                    andListNode.addConjunct(new TCTLStatePlaceHolder());
                    QueryConstructionEdit edit = new QueryConstructionEdit(parentNode, andListNode);
                    this.newProperty = this.newProperty.replace(parentNode, andListNode);
                    this.updateSelection(andListNode);
                    this.undoSupport.postEdit(edit);
                    this.queryChanged();
                } else {
                    TCTLStatePlaceHolder ph = new TCTLStatePlaceHolder();
                    andListNode = new TCTLAndListNode(this.getStateProperty(this.currentSelection.getObject()), ph);
                    this.addPropertyToQuery(andListNode);
                }
            } else if (!this.lens.isTimed()) {
                this.checkUntimedAndNode();
            }
        });
        this.disjunctionButton.addActionListener(e -> {
            if (this.currentSelection.getObject() instanceof TCTLOrListNode) {
                TCTLOrListNode orListNode = new TCTLOrListNode((TCTLOrListNode)this.currentSelection.getObject());
                orListNode.setSimpleProperty(true);
                orListNode.addDisjunct(new TCTLStatePlaceHolder());
                this.addPropertyToQuery(orListNode);
            } else if (this.currentSelection.getObject() instanceof TCTLAndListNode) {
                TCTLOrListNode orListNode = new TCTLOrListNode(((TCTLAndListNode)this.currentSelection.getObject()).getProperties());
                this.addPropertyToQuery(orListNode);
            } else if (this.currentSelection.getObject() instanceof TCTLAbstractStateProperty) {
                TCTLAbstractStateProperty prop = (TCTLAbstractStateProperty)this.currentSelection.getObject();
                TCTLAbstractProperty parentNode = prop.getParent();
                if (parentNode instanceof TCTLOrListNode) {
                    TCTLOrListNode orListNode = new TCTLOrListNode((TCTLOrListNode)parentNode);
                    orListNode.addDisjunct(new TCTLStatePlaceHolder());
                    QueryConstructionEdit edit = new QueryConstructionEdit(parentNode, orListNode);
                    this.newProperty = this.newProperty.replace(parentNode, orListNode);
                    this.updateSelection(orListNode);
                    this.undoSupport.postEdit(edit);
                    this.queryChanged();
                } else {
                    TCTLStatePlaceHolder ph = new TCTLStatePlaceHolder();
                    TCTLOrListNode orListNode = new TCTLOrListNode(this.getStateProperty(this.currentSelection.getObject()), ph);
                    this.addPropertyToQuery(orListNode);
                }
            } else if (!this.lens.isTimed()) {
                this.checkUntimedOrNode();
            }
        });
        this.negationButton.addActionListener(e -> {
            if (this.lens.isTimed()) {
                TCTLNotNode property = new TCTLNotNode(this.getStateProperty(this.currentSelection.getObject()));
                this.addPropertyToQuery(property);
            } else {
                TCTLAbstractStateProperty root = this.currentSelection.getObject() instanceof TCTLAbstractPathProperty ? this.ConvertToStateProperty(this.getPathProperty(this.currentSelection.getObject())) : this.getStateProperty(this.currentSelection.getObject());
                TCTLNotNode property = new TCTLNotNode(root);
                this.addPropertyToQuery(property);
            }
        });
    }

    private void checkUntimedAndNode() {
        if (this.currentSelection.getObject() instanceof TCTLStateToPathConverter) {
            TCTLAndListNode andListNode;
            TCTLStatePlaceHolder ph = new TCTLStatePlaceHolder();
            TCTLAbstractStateProperty prop = ((TCTLStateToPathConverter)this.currentSelection.getObject()).getProperty();
            if (prop instanceof TCTLAndListNode) {
                andListNode = new TCTLAndListNode((TCTLAndListNode)prop);
                andListNode.addConjunct(new TCTLStatePlaceHolder());
            } else {
                andListNode = prop instanceof TCTLOrListNode ? new TCTLAndListNode(((TCTLOrListNode)prop).getProperties()) : new TCTLAndListNode(this.getStateProperty(prop), ph);
            }
            andListNode.setSimpleProperty(true);
            TCTLStateToPathConverter property = new TCTLStateToPathConverter(andListNode);
            this.addPropertyToQuery(property);
        } else if (this.currentSelection.getObject() instanceof TCTLAbstractPathProperty) {
            TCTLStatePlaceHolder ph = new TCTLStatePlaceHolder();
            TCTLAbstractProperty oldProperty = this.removeExistsAllPathsFromProperty(this.currentSelection.getObject());
            TCTLAndListNode andListNode = new TCTLAndListNode(this.getStateProperty(new TCTLPathToStateConverter((TCTLAbstractPathProperty)oldProperty)), ph);
            if (this.previousProp instanceof TCTLAndListNode) {
                andListNode.setSimpleProperty(true);
            }
            this.previousProp = andListNode;
            TCTLStateToPathConverter property = new TCTLStateToPathConverter(andListNode);
            this.addPropertyToQuery(property);
        }
    }

    private void checkUntimedOrNode() {
        if (this.currentSelection.getObject() instanceof TCTLStateToPathConverter) {
            TCTLOrListNode orListNode;
            TCTLStatePlaceHolder ph = new TCTLStatePlaceHolder();
            TCTLAbstractStateProperty prop = ((TCTLStateToPathConverter)this.currentSelection.getObject()).getProperty();
            if (prop instanceof TCTLOrListNode) {
                orListNode = new TCTLOrListNode((TCTLOrListNode)prop);
                orListNode.addDisjunct(new TCTLStatePlaceHolder());
            } else {
                orListNode = prop instanceof TCTLAndListNode ? new TCTLOrListNode(((TCTLAndListNode)prop).getProperties()) : new TCTLOrListNode(this.getStateProperty(prop), ph);
            }
            orListNode.setSimpleProperty(true);
            TCTLStateToPathConverter property = new TCTLStateToPathConverter(orListNode);
            this.addPropertyToQuery(property);
        } else if (this.currentSelection.getObject() instanceof TCTLAbstractPathProperty) {
            TCTLStatePlaceHolder ph = new TCTLStatePlaceHolder();
            TCTLAbstractProperty oldProperty = this.removeExistsAllPathsFromProperty(this.currentSelection.getObject());
            TCTLOrListNode orListNode = new TCTLOrListNode(this.getStateProperty(new TCTLPathToStateConverter((TCTLAbstractPathProperty)oldProperty)), ph);
            if (this.previousProp instanceof TCTLOrListNode) {
                orListNode.setSimpleProperty(true);
            }
            this.previousProp = orListNode;
            TCTLStateToPathConverter property = new TCTLStateToPathConverter(orListNode);
            this.addPropertyToQuery(property);
        }
    }

    private void updateTraceBox() {
        ArrayList<String> traceList = this.getUsedTraces(this.newProperty);
        Vector traceBoxVector = new Vector();
        Vector traceBoxQuantificationVector = new Vector();
        for (int i = 0; i < this.traceModel.getSize(); ++i) {
            if (traceList.contains(this.traceModel.get(i).toString())) {
                traceBoxVector.add(this.traceModel.get(i));
                continue;
            }
            traceBoxQuantificationVector.add(this.traceModel.get(i));
        }
        this.traceBox.setModel(new DefaultComboBoxModel(traceBoxVector));
        this.traceBoxQuantification.setModel(new DefaultComboBoxModel(traceBoxQuantificationVector));
        this.updateHyperLTLButtons();
    }

    private ArrayList<String> getUsedTraces(TCTLAbstractProperty current) {
        ArrayList<String> usedTraces = new ArrayList<String>();
        if (current instanceof LTLANode) {
            usedTraces.add(((LTLANode)current).getTrace());
        } else if (current instanceof LTLENode) {
            usedTraces.add(((LTLENode)current).getTrace());
        }
        for (StringPosition child : current.getChildren()) {
            usedTraces.addAll(this.getUsedTraces(child.getObject()));
        }
        return usedTraces;
    }

    private void initTracePanels() {
        this.traceList = new JList();
        this.traceModel = new DefaultListModel();
        this.traceModel.addElement("T1");
        this.traceModel.addElement("T2");
        for (int i = 0; i < this.traceList.getModel().getSize(); ++i) {
            this.traceModel.addElement(this.traceList.getModel().getElementAt(i));
        }
        this.traceList.setModel(this.traceModel);
        this.tempTraceModel = new DefaultListModel();
        this.tempTraceList = new JList();
        this.traceNameTextField = new JTextField();
        this.traceNameTextField.setText("");
        Vector tracesVector = new Vector();
        for (int i = 0; i < this.traceModel.getSize(); ++i) {
            tracesVector.add(this.traceModel.get(i));
        }
        this.traceBox = new JComboBox(new DefaultComboBoxModel());
        this.traceBoxQuantification = new JComboBox(new DefaultComboBoxModel(tracesVector));
        this.traceBox.addActionListener(e -> {
            if (this.updateTraceBox) {
                this.updateQueryOnAtomicPropositionChange();
            }
        });
        this.traceBoxQuantification.addActionListener(e -> {
            if (this.checkTraceBoxQuantification() && this.updateTraceBoxQuantification) {
                this.updateQueryOnQuantificationChange();
            }
        });
        this.traceBox.setEnabled(false);
        this.traceBox.setToolTipText(TOOL_TIP_TRACEBOX);
        this.traceBoxQuantification.setToolTipText(TOOL_TIP_TRACEBOX_QUANTIFICATION);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(2, 2, 4, 2);
        ((JLabel)((Object)this.traceBoxQuantification.getRenderer())).setHorizontalAlignment(0);
        this.traceBoxQuantification.setPreferredSize(new Dimension(76, 27));
        this.quantificationPanel.add((Component)this.traceBoxQuantification, gbc);
        Dimension dim = new Dimension(292, 27);
        this.traceBox.setMaximumSize(dim);
        this.traceBox.setMinimumSize(dim);
        this.traceBox.setPreferredSize(dim);
        this.traceBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 0, 1, 0);
        gbc.fill = 2;
        gbc.anchor = 17;
        this.traceRow = new JPanel(new FlowLayout(0, 0, 5));
        this.traceRow.add(this.traceBox);
        gbc.gridy = 1;
        this.predicatePanel.add((Component)this.traceRow, gbc);
        this.traceRow.setVisible(false);
    }

    private boolean checkTraceBoxQuantification() {
        if (this.currentSelection == null || this.currentSelection.getObject() != this.newProperty || this.traceBoxQuantification.getSelectedItem() == null) {
            return false;
        }
        String traceName = this.traceBoxQuantification.getSelectedItem().toString();
        for (int i = 0; i < this.traceBox.getModel().getSize(); ++i) {
            if (!traceName.equals(this.traceBox.getModel().getElementAt(i).toString())) continue;
            return true;
        }
        return false;
    }

    private void initTraceBoxDialogComponents() {
        JPanel container = new JPanel();
        container.setLayout(new GridBagLayout());
        JPanel traceBoxPanel = new JPanel();
        traceBoxPanel.setLayout(new GridBagLayout());
        traceBoxPanel.setBorder(BorderFactory.createTitledBorder("Traces"));
        JButton moveUpButton = new JButton(new ImageIcon(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("Images/Up.png"))));
        JButton moveDownButton = new JButton(new ImageIcon(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("Images/Down.png"))));
        JPanel firstRow = new JPanel();
        firstRow.setLayout(new GridBagLayout());
        JLabel traceNameLabel = new JLabel("Trace name: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        firstRow.add((Component)traceNameLabel, gbc);
        this.traceTextField = new JTextField();
        GridBagConstraints gbcNTF = new GridBagConstraints();
        gbcNTF.gridx = 1;
        gbcNTF.gridy = 0;
        gbcNTF.gridwidth = 1;
        gbcNTF.weightx = 1.0;
        gbcNTF.anchor = 17;
        gbcNTF.fill = 2;
        gbcNTF.insets = new Insets(4, 4, 2, 4);
        this.traceTextField.requestFocusInWindow();
        firstRow.add((Component)this.traceTextField, gbcNTF);
        this.traceTextField.addActionListener(e -> this.addTracePanelButton.doClick());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        traceBoxPanel.add((Component)firstRow, gbc);
        JPanel secondRow = new JPanel();
        secondRow.setLayout(new GridBagLayout());
        this.addTracePanelButton = new JButton("Add trace");
        this.addTracePanelButton.addActionListener(e -> {
            String traceName = this.traceTextField.getText();
            this.addNewTrace(traceName, true);
        });
        Dimension buttonSize = new Dimension(100, 30);
        this.addTracePanelButton.setMaximumSize(buttonSize);
        this.addTracePanelButton.setMinimumSize(buttonSize);
        this.addTracePanelButton.setPreferredSize(buttonSize);
        this.addTracePanelButton.setMnemonic(65);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        secondRow.add((Component)this.addTracePanelButton, gbc);
        this.traceRemoveButton = new JButton("Remove");
        this.traceRemoveButton.setEnabled(false);
        this.traceRemoveButton.addActionListener(actionEvent -> this.removeTraces());
        this.traceRemoveButton.setPreferredSize(buttonSize);
        this.traceRemoveButton.setMinimumSize(buttonSize);
        this.traceRemoveButton.setMaximumSize(buttonSize);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        secondRow.add((Component)this.traceRemoveButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        traceBoxPanel.add((Component)secondRow, gbc);
        JPanel thirdRow = new JPanel();
        thirdRow.setLayout(new GridBagLayout());
        this.traceList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                JList source = (JList)e.getSource();
                if (source.getSelectedIndex() == -1) {
                    this.traceRemoveButton.setEnabled(false);
                    moveUpButton.setEnabled(false);
                    moveDownButton.setEnabled(false);
                } else {
                    this.traceRemoveButton.setEnabled(true);
                    if (source.getSelectedIndex() > 0) {
                        moveUpButton.setEnabled(true);
                    } else {
                        moveUpButton.setEnabled(false);
                    }
                    if (source.getSelectedIndex() < source.getModel().getSize() - 1) {
                        moveDownButton.setEnabled(true);
                    } else {
                        moveDownButton.setEnabled(false);
                    }
                }
            }
        });
        JScrollPane traceListScrollPane = new JScrollPane(this.traceList);
        traceListScrollPane.setViewportView(this.traceList);
        traceListScrollPane.setVerticalScrollBarPolicy(20);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        traceListScrollPane.setVisible(true);
        traceListScrollPane.setBorder(new LineBorder(Color.GRAY));
        gbc.anchor = 17;
        gbc.fill = 1;
        thirdRow.add((Component)traceListScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 3, 3, 3);
        thirdRow.add((Component)moveUpButton, gbc);
        moveUpButton.addActionListener(e -> {
            int index = this.traceList.getSelectedIndex();
            if (index > 0) {
                this.traceList.setSelectedIndex(index - 1);
                this.swapTraces(this.traceModel, index, index - 1);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 3, 3, 3);
        thirdRow.add((Component)moveDownButton, gbc);
        moveDownButton.addActionListener(e -> {
            int index = this.traceList.getSelectedIndex();
            if (index < this.traceModel.getSize() - 1) {
                this.traceList.setSelectedIndex(index + 1);
                this.swapTraces(this.traceModel, index, index + 1);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        traceBoxPanel.add((Component)thirdRow, gbc);
        this.traceList.clearSelection();
        moveUpButton.setEnabled(false);
        moveDownButton.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 8, 0, 8);
        container.add((Component)traceBoxPanel, gbc);
        JPanel buttonPanel = this.createTraceButtonPanel();
        gbc.insets = new Insets(0, 8, 5, 8);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        container.add((Component)buttonPanel, gbc);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(container);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.traceDialog = new EscapableDialog(TAPAALGUI.getApp(), "Traces", true);
        this.traceDialog.add((Component)scrollPane, "Center");
        this.traceDialog.getRootPane().setDefaultButton(this.okButton);
        this.traceDialog.setResizable(true);
        this.traceDialog.pack();
        this.traceDialog.setMinimumSize(new Dimension(447, 231));
        this.traceDialog.setLocationRelativeTo(null);
        this.UpdateTempTraceList();
        this.traceDialog.setVisible(true);
        this.updateTraceBox();
    }

    private void UpdateTempTraceList() {
        this.tempTraceModel.removeAllElements();
        for (int i = 0; i < this.traceList.getModel().getSize(); ++i) {
            this.tempTraceModel.addElement(this.traceList.getModel().getElementAt(i));
        }
        this.tempTraceList.setModel(this.tempTraceModel);
    }

    private void addNewTrace(String traceName, boolean isFromTraceDialogBox) {
        if (traceName == null || traceName.trim().isEmpty()) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "You have to enter a name for the trace", "Error", 0);
        } else if (!Pattern.matches("[a-zA-Z]([\\_a-zA-Z0-9])*", traceName)) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "Acceptable names for traces are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*", "Error", 0);
        } else if (traceName.equals("all") || traceName.equals("All") || traceName.equals("dot") || traceName.equals(".all") || traceName.equals(".All")) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The trace cannot be named \"" + traceName + "\", as the name is reserved", "Error", 0);
        } else {
            boolean nameIsInUse = this.traceNameTextField.getText().equals(traceName);
            for (int i = 0; i < this.traceModel.getSize(); ++i) {
                String n = this.traceModel.getElementAt(i).toString();
                if (!n.equals(traceName)) continue;
                nameIsInUse = true;
                break;
            }
            if (nameIsInUse && isFromTraceDialogBox) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "A trace with the name \"" + traceName + "\" already exists. Please chose another name.", "Error", 0);
            } else if (!nameIsInUse) {
                this.traceModel.addElement(traceName);
                this.traceList.setModel(this.traceModel);
                if (isFromTraceDialogBox) {
                    this.traceTextField.setText("");
                }
            }
        }
        if (isFromTraceDialogBox) {
            this.traceTextField.requestFocusInWindow();
        }
    }

    private JPanel createTraceButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.okButton = new JButton("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.setMnemonic(79);
        GridBagConstraints gbcOk = new GridBagConstraints();
        gbcOk.gridx = 1;
        gbcOk.gridy = 0;
        gbcOk.anchor = 17;
        gbcOk.insets = new Insets(5, 5, 5, 5);
        this.okButton.addActionListener(actionEvent -> this.exitTraceDialog());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMaximumSize(new Dimension(100, 25));
        cancelButton.setMinimumSize(new Dimension(100, 25));
        cancelButton.setPreferredSize(new Dimension(100, 25));
        cancelButton.setMnemonic(67);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = -1;
        gbc.anchor = 13;
        cancelButton.addActionListener(e -> {
            this.cancelTraceChanges();
            this.exitTraceDialog();
        });
        buttonPanel.add((Component)cancelButton, gbc);
        buttonPanel.add((Component)this.okButton, gbcOk);
        return buttonPanel;
    }

    private void cancelTraceChanges() {
        int tempListSize = this.tempTraceList.getModel().getSize();
        this.traceModel.removeAllElements();
        for (int i = 0; i < tempListSize; ++i) {
            this.traceModel.addElement(this.tempTraceList.getModel().getElementAt(i));
        }
        this.traceList.setModel(this.traceModel);
    }

    private void exitTraceDialog() {
        this.updateTraceBox();
        if (this.traceBox.getSelectedItem() != null) {
            this.traceBox.setSelectedIndex(this.traceBox.getItemCount() - 1);
        }
        this.updateTraceBoxQuantification = false;
        this.traceBoxQuantification.setSelectedIndex(this.traceBoxQuantification.getItemCount() - 1);
        this.updateTraceBoxQuantification = true;
        this.traceDialog.setVisible(false);
    }

    private void swapTraces(DefaultListModel model, int selectedIndex, int newIndex) {
        Object temp = model.get(newIndex);
        model.set(newIndex, model.get(selectedIndex));
        model.set(selectedIndex, temp);
    }

    private void removeTraces() {
        if (this.newProperty.toString().contains(this.traceList.getSelectedValue().toString())) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The selected trace is used in the query.\nIt is not possible to remove this trace.", "Error", 0);
        } else {
            this.traceModel.remove(this.traceList.getSelectedIndex());
            this.traceList.setModel(this.traceModel);
        }
    }

    private void initPredicationConstructionPanel() {
        this.predicatePanel = new JPanel(new GridBagLayout());
        this.predicatePanel.setBorder(BorderFactory.createTitledBorder("Predicates"));
        this.initTracePanels();
        this.placeTransitionBox = new JComboBox();
        Dimension d = new Dimension(125, 27);
        this.placeTransitionBox.setMaximumSize(d);
        this.placeTransitionBox.setPreferredSize(d);
        Vector<Object> items = new Vector<Object>(this.tapnNetwork.activeTemplates().size() + 1);
        items.addAll(this.tapnNetwork.activeTemplates());
        if (this.tapnNetwork.numberOfSharedPlaces() > 0) {
            items.add(SHARED);
        }
        this.templateBox = new JComboBox(new DefaultComboBoxModel(items));
        this.templateBox.addActionListener(new ActionListener(){
            private Object currentlySelected = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!QueryDialog.this.templateBox.getSelectedItem().equals(QueryDialog.SHARED)) {
                    TimedArcPetriNet tapn = (TimedArcPetriNet)QueryDialog.this.templateBox.getSelectedItem();
                    if (!tapn.equals(this.currentlySelected)) {
                        Vector<String> placeNames = new Vector<String>();
                        for (TimedPlace place : tapn.places()) {
                            if (place.isShared()) continue;
                            placeNames.add(place.name());
                        }
                        if (!QueryDialog.this.lens.isTimed()) {
                            for (TimedTransition transition : tapn.transitions()) {
                                if (transition.isShared()) continue;
                                placeNames.add(transition.name());
                            }
                        }
                        placeNames.sort(String::compareToIgnoreCase);
                        QueryDialog.this.placeTransitionBox.setModel(new DefaultComboBoxModel(placeNames));
                        this.currentlySelected = tapn;
                        QueryDialog.this.setEnablednessOfAddPredicateButton();
                        if (QueryDialog.this.userChangedAtomicPropSelection && placeNames.size() > 0) {
                            QueryDialog.this.updateQueryOnAtomicPropositionChange();
                        }
                    }
                } else {
                    Vector<String> placeNames = new Vector<String>();
                    for (SharedPlace place : QueryDialog.this.tapnNetwork.sharedPlaces()) {
                        placeNames.add(place.name());
                    }
                    if (QueryDialog.this.lens.isTimed()) {
                        for (SharedTransition transition : QueryDialog.this.tapnNetwork.sharedTransitions()) {
                            placeNames.add(transition.name());
                        }
                    }
                    placeNames.sort(String::compareToIgnoreCase);
                    QueryDialog.this.placeTransitionBox.setModel(new DefaultComboBoxModel(placeNames));
                    this.currentlySelected = QueryDialog.SHARED;
                    QueryDialog.this.setEnablednessOfAddPredicateButton();
                    if (QueryDialog.this.userChangedAtomicPropSelection && placeNames.size() > 0) {
                        QueryDialog.this.updateQueryOnAtomicPropositionChange();
                    }
                }
                if (!QueryDialog.this.lens.isTimed()) {
                    QueryDialog.this.setEnablednessOfOperatorAndMarkingBoxes();
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.anchor = 17;
        gbc.fill = 2;
        ArrayList<Tuple<Object, String>> searchableItems = new ArrayList<Tuple<Object, String>>();
        for (TimedArcPetriNet timedArcPetriNet : this.tapnNetwork.activeTemplates()) {
            for (TimedPlace place : timedArcPetriNet.places()) {
                if (place.isShared()) continue;
                searchableItems.add(new Tuple<TimedPlace, String>(place, timedArcPetriNet.toString()));
            }
            if (this.lens.isTimed()) continue;
            for (TimedTransition transition : timedArcPetriNet.transitions()) {
                if (transition.isShared()) continue;
                searchableItems.add(new Tuple<TimedTransition, String>(transition, timedArcPetriNet.toString()));
            }
        }
        for (TimedPlace timedPlace : this.tapnNetwork.sharedPlaces()) {
            searchableItems.add(new Tuple<TimedPlace, String>(timedPlace, SHARED.toString()));
        }
        for (SharedTransition sharedTransition : this.tapnNetwork.sharedTransitions()) {
            searchableItems.add(new Tuple<SharedTransition, String>(sharedTransition, SHARED.toString()));
        }
        this.searcher = new Searcher<Tuple>(searchableItems, obj -> {
            Object element = obj.value1();
            String name = element.toString();
            if (name.contains(".")) {
                name = name.split("\\.")[1];
            }
            return name;
        });
        this.searchBar = new SearchBar();
        this.searchBar.useSharedPrefix(false);
        this.searchBar.setMaxVisibleItems(4);
        this.searchBar.setOnSearchTextChanged(query -> {
            if (query == null || query.trim().isEmpty()) {
                this.searchBar.hideResults();
                return;
            }
            List<Tuple<?, String>> matches = this.searcher.findAllMatches((String)query);
            this.searchBar.showResults(matches);
        });
        this.searchBar.setOnResultSelected(result -> {
            if (result == null) {
                return;
            }
            this.searchBar.clear();
            boolean isShared = false;
            if (result.value1() instanceof TimedPlace) {
                isShared = ((TimedPlace)result.value1()).isShared();
            } else if (result.value1() instanceof TimedTransition) {
                isShared = ((TimedTransition)result.value1()).isShared();
            }
            if (isShared) {
                this.templateBox.setSelectedItem(SHARED);
                this.placeTransitionBox.setSelectedItem(result.value1().toString());
            } else {
                this.templateBox.setSelectedItem(this.tapnNetwork.getTAPNByName((String)result.value2()));
                this.placeTransitionBox.setSelectedItem(result.value1().toString().split("\\.")[1]);
            }
        });
        Dimension dim = new Dimension(235, 27);
        this.searchBar.setPreferredSize(dim);
        this.searchBar.setMaximumSize(dim);
        this.searchBar.setMinimumSize(dim);
        this.predicatePanel.add((Component)this.searchBar, gbc);
        gbc.gridy += 2;
        gbc.gridwidth -= 2;
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 5));
        this.predicatePanel.add((Component)jPanel, gbc);
        this.templateBox.setPreferredSize(new Dimension(292, 27));
        this.templateBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jPanel.add(this.templateBox);
        JPanel placeRow = new JPanel(new FlowLayout(0, 0, 5));
        ++gbc.gridy;
        this.predicatePanel.add((Component)placeRow, gbc);
        this.placeTransitionBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        placeRow.add(this.placeTransitionBox);
        String[] relationalSymbols = new String[]{"=", "!=", "<=", "<", ">=", ">"};
        this.relationalOperatorBox = new JComboBox<String>(new DefaultComboBoxModel<String>(relationalSymbols));
        this.relationalOperatorBox.setPreferredSize(new Dimension(80, 27));
        this.relationalOperatorBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        placeRow.add(this.relationalOperatorBox);
        this.placeMarking = new CustomJSpinner(0);
        this.placeMarking.setPreferredSize(new Dimension(80, 27));
        placeRow.add(this.placeMarking);
        this.transitionIsEnabledLabel = new JLabel(" is enabled");
        this.transitionIsEnabledLabel.setPreferredSize(new Dimension(165, 27));
        if (!this.lens.isTimed()) {
            placeRow.add(this.transitionIsEnabledLabel);
        }
        JPanel addPredicateRow = new JPanel(new FlowLayout(0, 0, 5));
        ++gbc.gridy;
        addPredicateRow.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.predicatePanel.add((Component)addPredicateRow, gbc);
        this.addPredicateButton = new JButton("Add predicate to the query");
        this.addPredicateButton.setPreferredSize(new Dimension(292, 27));
        addPredicateRow.add(this.addPredicateButton);
        this.truePredicateButton = new JButton("True");
        this.truePredicateButton.setPreferredSize(new Dimension(103, 27));
        this.falsePredicateButton = new JButton("False");
        this.falsePredicateButton.setPreferredSize(new Dimension(103, 27));
        this.deadLockPredicateButton = new JButton("Deadlock");
        this.deadLockPredicateButton.setPreferredSize(new Dimension(103, 27));
        JSeparator verticalSeparator = new JSeparator(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridheight = 4;
        gbc.fill = 3;
        gbc.insets = new Insets(5, 5, 5, 10);
        gbc.anchor = 10;
        this.predicatePanel.add((Component)verticalSeparator, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = 13;
        this.predicatePanel.add((Component)this.truePredicateButton, gbc);
        ++gbc.gridy;
        this.predicatePanel.add((Component)this.falsePredicateButton, gbc);
        ++gbc.gridy;
        this.predicatePanel.add((Component)this.deadLockPredicateButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 3;
        this.queryPanel.add((Component)this.predicatePanel, gbc);
        this.placeTransitionBox.setToolTipText(TOOL_TIP_PLACESBOX);
        this.templateBox.setToolTipText(TOOL_TIP_TEMPLATEBOX);
        this.relationalOperatorBox.setToolTipText(TOOL_TIP_RELATIONALOPERATORBOX);
        this.placeMarking.setToolTipText(TOOL_TIP_PLACEMARKING);
        this.addPredicateButton.setToolTipText(TOOL_TIP_ADDPREDICATEBUTTON);
        this.truePredicateButton.setToolTipText(TOOL_TIP_TRUEPREDICATEBUTTON);
        this.falsePredicateButton.setToolTipText(TOOL_TIP_FALSEPREDICATEBUTTON);
        this.deadLockPredicateButton.setToolTipText(TOOL_TIP_DEADLOCKPREDICATEBUTTON);
        this.addPredicateButton.addActionListener(e -> {
            String template = this.templateBox.getSelectedItem().toString();
            if (template.equals(SHARED)) {
                template = "";
            }
            if (!this.lens.isTimed() && this.transitionIsSelected()) {
                if (this.queryType.getSelectedIndex() == 2) {
                    String trace = this.traceBox.getSelectedItem().toString();
                    this.addPropertyToQuery(new TCTLTransitionNode(template, (String)this.placeTransitionBox.getSelectedItem(), trace));
                } else {
                    this.addPropertyToQuery(new TCTLTransitionNode(template, (String)this.placeTransitionBox.getSelectedItem()));
                }
            } else if (this.queryType.getSelectedIndex() == 2) {
                TCTLAtomicPropositionNode property = new TCTLAtomicPropositionNode(new HyperLTLPathScopeNode(new TCTLPlaceNode(template, (String)this.placeTransitionBox.getSelectedItem()), this.traceBox.getSelectedItem().toString()), (String)this.relationalOperatorBox.getSelectedItem(), new TCTLConstNode((Integer)this.placeMarking.getValue()));
                this.addPropertyToQuery(property);
            } else {
                TCTLAtomicPropositionNode property = new TCTLAtomicPropositionNode(new TCTLPlaceNode(template, (String)this.placeTransitionBox.getSelectedItem()), (String)this.relationalOperatorBox.getSelectedItem(), new TCTLConstNode((Integer)this.placeMarking.getValue()));
                this.addPropertyToQuery(property);
            }
        });
        this.truePredicateButton.addActionListener(e -> {
            TCTLTrueNode trueNode = new TCTLTrueNode();
            this.addPropertyToQuery(trueNode);
        });
        this.falsePredicateButton.addActionListener(e -> {
            TCTLFalseNode falseNode = new TCTLFalseNode();
            this.addPropertyToQuery(falseNode);
        });
        this.deadLockPredicateButton.addActionListener(e -> {
            TCTLDeadlockNode deadLockNode = new TCTLDeadlockNode();
            this.addPropertyToQuery(deadLockNode);
        });
        this.placeTransitionBox.addActionListener(e -> {
            if (this.userChangedAtomicPropSelection) {
                this.updateQueryOnAtomicPropositionChange();
            }
            if (!this.lens.isTimed()) {
                this.setEnablednessOfOperatorAndMarkingBoxes();
            }
        });
        this.relationalOperatorBox.addActionListener(e -> {
            if (this.userChangedAtomicPropSelection) {
                this.updateQueryOnAtomicPropositionChange();
            }
        });
        this.placeMarking.addChangeListener(arg0 -> {
            if (this.userChangedAtomicPropSelection) {
                this.updateQueryOnAtomicPropositionChange();
            }
        });
        this.templateBox.setSelectedIndex(0);
    }

    private void initQueryEditingPanel() {
        this.editingButtonPanel = new JPanel(new GridBagLayout());
        this.editingButtonPanel.setBorder(BorderFactory.createTitledBorder("Editing"));
        this.editingButtonsGroup = new ButtonGroup();
        this.deleteButton = new JButton("Delete selection");
        this.resetButton = new JButton("Reset query");
        this.undoButton = new JButton("Undo");
        this.redoButton = new JButton("Redo");
        this.editQueryButton = new JButton("Edit query");
        this.deleteButton.setToolTipText(TOOL_TIP_DELETEBUTTON);
        this.resetButton.setToolTipText(TOOL_TIP_RESETBUTTON);
        this.undoButton.setToolTipText(TOOL_TIP_UNDOBUTTON);
        this.redoButton.setToolTipText(TOOL_TIP_REDOBUTTON);
        this.editQueryButton.setToolTipText(TOOL_TIP_EDITQUERYBUTTON);
        this.editingButtonsGroup.add(this.deleteButton);
        this.editingButtonsGroup.add(this.resetButton);
        this.editingButtonsGroup.add(this.undoButton);
        this.editingButtonsGroup.add(this.redoButton);
        this.editingButtonsGroup.add(this.editQueryButton);
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel row = new JPanel(new GridLayout(1, 2));
        row.add(this.undoButton);
        row.add(this.redoButton);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 4.0;
        gbc.fill = 2;
        this.editingButtonPanel.add((Component)row, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 4.0;
        gbc.fill = 2;
        this.editingButtonPanel.add((Component)this.deleteButton, gbc);
        gbc.gridy = 2;
        this.editingButtonPanel.add((Component)this.resetButton, gbc);
        gbc.gridy = 3;
        this.editingButtonPanel.add((Component)this.editQueryButton, gbc);
        this.deleteButton.addActionListener(e -> this.deleteSelection());
        this.resetButton.addActionListener(e -> {
            if (this.queryField.isEditable()) {
                TCTLAbstractProperty newQuery;
                block16: {
                    newQuery = null;
                    try {
                        if (this.queryField.getText().trim().equals("<*>")) {
                            int choice = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), "It is not possible to parse an empty query.\nThe specified query has not been saved. Do you want to edit it again?", "Error Parsing Query", 0, 0);
                            if (choice == 1) {
                                this.returnFromManualEdit(null);
                                break block16;
                            }
                            return;
                        }
                        if (this.lens.isStochastic()) {
                            newQuery = TAPAALSMCQueryParser.parse(this.queryField.getText());
                            break block16;
                        }
                        if (this.lens.isTimed()) {
                            newQuery = TAPAALQueryParser.parse(this.queryField.getText());
                            break block16;
                        }
                        if (this.queryType.getSelectedIndex() == 0) {
                            newQuery = TAPAALCTLQueryParser.parse(this.queryField.getText());
                            break block16;
                        }
                        if (this.queryType.getSelectedIndex() == 1) {
                            newQuery = TAPAALLTLQueryParser.parse(this.queryField.getText());
                            break block16;
                        }
                        if (this.queryType.getSelectedIndex() == 2) {
                            newQuery = TAPAALHyperLTLQueryParser.parse(this.queryField.getText());
                            break block16;
                        }
                        throw new Exception();
                    }
                    catch (Throwable ex) {
                        String message = ex.getMessage() == null ? "TAPAAL encountered an error while trying to parse the specified query\n" : "TAPAAL encountered the following error while trying to parse the specified query:\n\n" + ex.getMessage();
                        int choice = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), message + "\nWe recommend using the query construction buttons unless you are an experienced user.\n\n The specified query has not been saved. Do you want to edit it again?", "Error Parsing Query", 0, 0);
                        if (choice == 1) {
                            this.returnFromManualEdit(null);
                        }
                        return;
                    }
                }
                if (newQuery != null) {
                    if (this.queryType.getSelectedIndex() == 2) {
                        this.checkTraceNamesForManuallyParsedQuery(newQuery);
                    } else {
                        this.checkPlacesAndTransitionsForManuallyParsedQuery(newQuery);
                    }
                } else {
                    this.returnFromManualEdit(null);
                }
                this.setVerificationOptionsEnabled(!this.rawVerificationOptionsEnabled.isSelected());
            } else {
                TCTLPathPlaceHolder ph = new TCTLPathPlaceHolder();
                QueryConstructionEdit edit = new QueryConstructionEdit(this.newProperty, ph);
                this.newProperty = ph;
                this.resetQuantifierSelectionButtons();
                this.updateSelection(this.newProperty);
                this.undoSupport.postEdit(edit);
            }
        });
        this.undoButton.addActionListener(e -> {
            UndoableEdit edit = this.undoManager.GetNextEditToUndo();
            if (edit instanceof QueryConstructionEdit) {
                TCTLAbstractProperty original = ((QueryConstructionEdit)edit).getOriginal();
                this.undoManager.undo();
                this.refreshUndoRedo();
                this.updateSelection(original);
                this.queryChanged();
            }
        });
        this.redoButton.addActionListener(e -> {
            UndoableEdit edit = this.undoManager.GetNextEditToRedo();
            if (edit instanceof QueryConstructionEdit) {
                TCTLAbstractProperty replacement = ((QueryConstructionEdit)edit).getReplacement();
                this.undoManager.redo();
                this.refreshUndoRedo();
                this.updateSelection(replacement);
                this.queryChanged();
            }
        });
        this.editQueryButton.addActionListener(arg0 -> {
            if (this.queryField.isEditable()) {
                this.returnFromManualEdit(null);
            } else {
                this.changeToEditMode();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 17;
        this.queryPanel.add((Component)this.editingButtonPanel, gbc);
    }

    private void checkTraceNamesForManuallyParsedQuery(TCTLAbstractProperty newQuery) {
        HyperLTLTraceNameVisitor traceNameVisitor = new HyperLTLTraceNameVisitor();
        HyperLTLTraceNameVisitor.Context traceContext = traceNameVisitor.getTraceContext(newQuery);
        if (!traceContext.getResult().booleanValue()) {
            StringBuilder message = new StringBuilder("The parsed query does not conform with the syntax supported for Hyper-LTL in TAPAAL.\n\n");
            ArrayList<String> traceList = this.getUsedTraces(newQuery);
            for (String traceName : traceContext.getTraceNames()) {
                if (traceList.contains(traceName)) continue;
                message.append("The specified query contains a trace that is not in either E or A quantification nodes.\n").append("You may only use traces that are present in E or A, i.e.:\n").append("E T1 (T1...)) is legal, whereas \n").append("E T1 (T2...)) is illegal.\n\n");
                break;
            }
            if (message.toString().endsWith("TAPAAL.\n\n")) {
                message.append("The specified query has duplicate traces in either the E or A quantification nodes.\n").append("You may only use different traces for each E or A, i.e.:\n").append("E T1 (E T2 (...)) is legal, whereas \n").append("E T1 (E T1 (...)) is illegal.\n\n");
            }
            message.append("The specified query has not been saved. Do you want to edit it again?");
            int choice = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), message.toString(), "Error Parsing Query", 0, 0);
            if (choice == 1) {
                this.returnFromManualEdit(null);
            }
        } else {
            int i;
            ArrayList<String> tracesFromParsedQuery = traceNameVisitor.getTraceContext(newQuery).getTraceNames();
            ArrayList<String> tracesFromTraceBox = new ArrayList<String>();
            for (i = 0; i < this.traceBox.getModel().getSize(); ++i) {
                tracesFromTraceBox.add(this.traceBox.getItemAt(i).toString());
            }
            for (i = 0; i < tracesFromParsedQuery.size(); ++i) {
                if (tracesFromTraceBox.contains(tracesFromParsedQuery.get(i))) continue;
                this.addNewTrace(tracesFromParsedQuery.get(i), false);
                this.updateTraceBox();
            }
            this.checkPlacesAndTransitionsForManuallyParsedQuery(newQuery);
        }
    }

    private void checkPlacesAndTransitionsForManuallyParsedQuery(TCTLAbstractProperty newQuery) {
        VerifyPlaceNamesVisitor.Context placeContext = this.getPlaceContext(newQuery);
        VerifyTransitionNamesVisitor.Context transitionContext = this.getTransitionContext(newQuery);
        boolean isResultFalse = false;
        if (this.lens.isGame()) {
            boolean bl = isResultFalse = newQuery.hasNestedPathQuantifiers() || newQuery instanceof TCTLNotNode;
        }
        if (this.lens.isTimed()) {
            isResultFalse = isResultFalse || placeContext.getResult() == false;
        } else {
            boolean bl = isResultFalse = isResultFalse || transitionContext.getResult() == false || placeContext.getResult() == false;
        }
        if (isResultFalse) {
            StringBuilder message = new StringBuilder();
            if (this.lens.isGame()) {
                message.append("The parsed query does not conform with the syntax supported for games in TAPAAL.\n");
            } else {
                message.append("The following places").append(this.lens.isTimed() ? "" : " or transitions").append(" were used in the query, but are not present in your model:\n\n");
                for (String placeName : placeContext.getIncorrectPlaceNames()) {
                    message.append(placeName).append('\n');
                }
                for (String transitionName : transitionContext.getIncorrectTransitionNames()) {
                    message.append(transitionName).append('\n');
                }
            }
            message.append("\nThe specified query has not been saved. Do you want to edit it again?");
            int choice = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), message.toString(), "Error Parsing Query", 0, 0);
            if (choice == 1) {
                this.returnFromManualEdit(null);
            }
        } else {
            QueryConstructionEdit edit = new QueryConstructionEdit(this.newProperty, newQuery);
            this.returnFromManualEdit(newQuery);
            this.undoSupport.postEdit(edit);
        }
    }

    private VerifyPlaceNamesVisitor.Context getPlaceContext(TCTLAbstractProperty newQuery) {
        ArrayList<Tuple<String, String>> templatePlaceNames = new ArrayList<Tuple<String, String>>();
        for (TimedArcPetriNet timedArcPetriNet : this.tapnNetwork.activeTemplates()) {
            for (TimedPlace p : timedArcPetriNet.places()) {
                if (!this.lens.isTimed() && p.isShared()) continue;
                templatePlaceNames.add(new Tuple<String, String>(timedArcPetriNet.name(), p.name()));
            }
        }
        for (TimedPlace timedPlace : this.tapnNetwork.sharedPlaces()) {
            templatePlaceNames.add(new Tuple<String, String>("", timedPlace.name()));
        }
        FixAbbrivPlaceNames.fixAbbrivPlaceNames(templatePlaceNames, newQuery);
        VerifyPlaceNamesVisitor nameChecker = new VerifyPlaceNamesVisitor(templatePlaceNames);
        return nameChecker.verifyPlaceNames(newQuery);
    }

    private VerifyTransitionNamesVisitor.Context getTransitionContext(TCTLAbstractProperty newQuery) {
        ArrayList<Tuple<String, String>> templateTransitionNames = new ArrayList<Tuple<String, String>>();
        for (TimedArcPetriNet tapn : this.tapnNetwork.activeTemplates()) {
            for (TimedTransition t : tapn.transitions()) {
                if (!this.lens.isTimed() && t.isShared()) continue;
                templateTransitionNames.add(new Tuple<String, String>(tapn.name(), t.name()));
            }
        }
        for (SharedTransition t : this.tapnNetwork.sharedTransitions()) {
            templateTransitionNames.add(new Tuple<String, String>("", t.name()));
        }
        FixAbbrivTransitionNames.fixAbbrivTransitionNames(templateTransitionNames, newQuery);
        VerifyTransitionNamesVisitor nameChecker = new VerifyTransitionNamesVisitor(templateTransitionNames);
        return nameChecker.verifyTransitionNames(newQuery);
    }

    private void initUppaalOptionsPanel() {
        this.uppaalOptionsPanel = new JPanel(new GridBagLayout());
        this.initSearchOptionsPanel();
        this.initTraceOptionsPanel();
        this.initBoundednessCheckPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.fill = 2;
        this.add((Component)this.uppaalOptionsPanel, gridBagConstraints);
    }

    private void initVerificationPanel() {
        this.verificationPanel = new JPanel(new GridBagLayout());
        this.initReductionOptionsPanel();
        if (this.lens.isColored() && !this.lens.isTimed()) {
            this.initUnfoldingOptionsPanel();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.fill = 2;
        this.add((Component)this.verificationPanel, gridBagConstraints);
    }

    private void initSearchOptionsPanel() {
        this.searchOptionsPanel = new JPanel(new GridBagLayout());
        this.searchOptionsPanel.setVisible(false);
        this.searchOptionsPanel.setBorder(BorderFactory.createTitledBorder("Search Strategy Options"));
        this.searchRadioButtonGroup = new ButtonGroup();
        this.breadthFirstSearch = new JRadioButton("Breadth first    ");
        this.depthFirstSearch = new JRadioButton("Depth first    ");
        this.randomSearch = new JRadioButton("Random    ");
        this.heuristicSearch = new JRadioButton("Heuristic    ");
        this.breadthFirstSearch.setToolTipText(TOOL_TIP_BREADTH_FIRST_SEARCH);
        this.depthFirstSearch.setToolTipText(TOOL_TIP_DEPTH_FIRST_SEARCH);
        this.randomSearch.setToolTipText(TOOL_TIP_RANDOM_SEARCH);
        this.heuristicSearch.setToolTipText(TOOL_TIP_HEURISTIC_SEARCH);
        this.searchRadioButtonGroup.add(this.heuristicSearch);
        this.searchRadioButtonGroup.add(this.breadthFirstSearch);
        this.searchRadioButtonGroup.add(this.depthFirstSearch);
        this.searchRadioButtonGroup.add(this.randomSearch);
        Enumeration<AbstractButton> buttons = this.searchRadioButtonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            button.addActionListener(e -> {
                this.setEnabledReductionOptions();
                this.setEnabledOptionsAccordingToCurrentReduction();
            });
        }
        this.heuristicSearch.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.searchOptionsPanel.add((Component)this.heuristicSearch, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.searchOptionsPanel.add((Component)this.breadthFirstSearch, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.searchOptionsPanel.add((Component)this.depthFirstSearch, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.searchOptionsPanel.add((Component)this.randomSearch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.fill = 1;
        this.uppaalOptionsPanel.add((Component)this.searchOptionsPanel, gridBagConstraints);
    }

    private void initUnfoldingOptionsPanel() {
        this.unfoldingOptionsPanel = new JPanel(new GridBagLayout());
        this.unfoldingOptionsPanel.setVisible(false);
        this.unfoldingOptionsPanel.setBorder(BorderFactory.createTitledBorder("Unfolding Options"));
        this.usePartitioning = new JCheckBox("Use partitioning of the colored net");
        this.useColorFixpoint = new JCheckBox("Use color fixpoint analysis");
        this.useSymmetricvars = new JCheckBox("Use reduction of symmetric variables");
        this.usePartitioning.setToolTipText(TOOL_TIP_PARTITIONING);
        this.useColorFixpoint.setToolTipText(TOOL_TIP_COLOR_FIXPOINT);
        this.useSymmetricvars.setToolTipText(TOOL_TIP_SYMMETRIC_VARIABLES);
        this.usePartitioning.setSelected(true);
        this.useColorFixpoint.setSelected(true);
        this.useSymmetricvars.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.unfoldingOptionsPanel.add((Component)this.usePartitioning, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.unfoldingOptionsPanel.add((Component)this.useColorFixpoint, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.unfoldingOptionsPanel.add((Component)this.useSymmetricvars, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.verificationPanel.add((Component)this.unfoldingOptionsPanel, gridBagConstraints);
    }

    private void initTraceOptionsPanel() {
        this.traceOptionsPanel = new JPanel(new GridBagLayout());
        this.traceOptionsPanel.setBorder(BorderFactory.createTitledBorder("Trace Options"));
        this.traceRadioButtonGroup = new ButtonGroup();
        this.someTraceRadioButton = new JRadioButton(UPPAAL_SOME_TRACE_STRING);
        this.noTraceRadioButton = new JRadioButton("No trace");
        this.fastestTraceRadioButton = new JRadioButton("Fastest trace");
        this.someTraceRadioButton.setToolTipText(TOOL_TIP_SOME_TRACE);
        this.noTraceRadioButton.setToolTipText(TOOL_TIP_NO_TRACE);
        this.fastestTraceRadioButton.setToolTipText(TOOL_TIP_FASTEST_TRACE);
        this.traceRadioButtonGroup.add(this.fastestTraceRadioButton);
        this.traceRadioButtonGroup.add(this.someTraceRadioButton);
        this.traceRadioButtonGroup.add(this.noTraceRadioButton);
        this.fastestTraceRadioButton.setEnabled(false);
        this.someTraceRadioButton.setEnabled(false);
        this.noTraceRadioButton.setSelected(true);
        Enumeration<AbstractButton> buttons = this.traceRadioButtonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            button.addActionListener(e -> {
                this.setEnabledReductionOptions();
                this.setEnabledOptionsAccordingToCurrentReduction();
            });
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.traceOptionsPanel.add((Component)this.noTraceRadioButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.traceOptionsPanel.add((Component)this.someTraceRadioButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.traceOptionsPanel.add((Component)this.fastestTraceRadioButton, gridBagConstraints);
        if (this.lens.isTimed()) {
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            this.traceOptionsPanel.add((Component)this.fastestTraceRadioButton, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.uppaalOptionsPanel.add((Component)this.traceOptionsPanel, gridBagConstraints);
    }

    private void initOverApproximationPanel() {
        this.overApproximationOptionsPanel = new JPanel(new GridBagLayout());
        this.overApproximationOptionsPanel.setVisible(false);
        this.overApproximationOptionsPanel.setBorder(BorderFactory.createTitledBorder("Approximation Options"));
        this.approximationRadioButtonGroup = new ButtonGroup();
        this.noApproximationEnable = new JRadioButton("Exact analysis");
        this.noApproximationEnable.setVisible(true);
        this.noApproximationEnable.setSelected(true);
        this.noApproximationEnable.setToolTipText(TOOL_TIP_APPROXIMATION_METHOD_NONE);
        this.noApproximationEnable.addActionListener(e -> this.updateRawVerificationOptions());
        this.overApproximationEnable = new JRadioButton("Over-approximation");
        this.overApproximationEnable.setVisible(true);
        this.overApproximationEnable.setToolTipText(TOOL_TIP_APPROXIMATION_METHOD_OVER);
        this.overApproximationEnable.addActionListener(e -> this.updateRawVerificationOptions());
        this.underApproximationEnable = new JRadioButton("Under-approximation");
        this.underApproximationEnable.setVisible(true);
        this.underApproximationEnable.setToolTipText(TOOL_TIP_APPROXIMATION_METHOD_UNDER);
        this.underApproximationEnable.addActionListener(e -> this.updateRawVerificationOptions());
        this.approximationRadioButtonGroup.add(this.noApproximationEnable);
        this.approximationRadioButtonGroup.add(this.overApproximationEnable);
        this.approximationRadioButtonGroup.add(this.underApproximationEnable);
        Enumeration<AbstractButton> buttons = this.approximationRadioButtonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            button.addActionListener(e -> this.setEnabledOptionsAccordingToCurrentReduction());
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        JLabel approximationDenominatorLabel = new JLabel("Approximation constant: ");
        this.overApproximationDenominator = new CustomJSpinner(2, 2, Integer.MAX_VALUE);
        this.overApproximationDenominator.setMaximumSize(new Dimension(65, 30));
        this.overApproximationDenominator.setMinimumSize(new Dimension(65, 30));
        this.overApproximationDenominator.setPreferredSize(new Dimension(65, 30));
        this.overApproximationDenominator.setToolTipText(TOOL_TIP_APPROXIMATION_CONSTANT);
        this.overApproximationOptionsPanel.add((Component)this.noApproximationEnable, gridBagConstraints);
        this.overApproximationOptionsPanel.add((Component)this.overApproximationEnable, gridBagConstraints);
        this.overApproximationOptionsPanel.add((Component)this.underApproximationEnable, gridBagConstraints);
        this.overApproximationOptionsPanel.add((Component)approximationDenominatorLabel, gridBagConstraints);
        this.overApproximationOptionsPanel.add(this.overApproximationDenominator);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.fill = 2;
        this.add((Component)this.overApproximationOptionsPanel, gridBagConstraints);
    }

    private void initReductionOptionsPanel() {
        this.reductionOptionsPanel = new JPanel(new GridBagLayout());
        this.reductionOptionsPanel.setVisible(false);
        this.reductionOptionsPanel.setBorder(BorderFactory.createTitledBorder("Verification Options"));
        this.reductionOption = new JComboBox();
        this.reductionOption.setToolTipText(TOOL_TIP_REDUCTION_OPTION);
        this.reductionOption.addActionListener(e -> this.setEnabledOptionsAccordingToCurrentReduction());
        this.reductionOption.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    QueryDialog.this.showRawVerificationOptions(advancedView);
                    guiDialog.pack();
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.reductionOptionsPanel.add((Component)new JLabel("  Verification engine:"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.reductionOptionsPanel.add(this.reductionOption, gbc);
        this.useReduction = new JCheckBox("Use net reductions");
        this.useColoredReduction = new JCheckBox("Use colored net reductions");
        this.useSiphonTrap = new JCheckBox("Use siphon-trap analysis");
        this.useQueryReduction = new JCheckBox("Use query reduction");
        this.useStubbornReduction = new JCheckBox("Use stubborn reduction");
        this.symmetryReduction = new JCheckBox("Use symmetry reduction");
        this.discreteInclusion = new JCheckBox("Use discrete inclusion");
        this.selectInclusionPlacesButton = new JButton("Select Inclusion Places");
        this.useTimeDarts = new JCheckBox("Use Time Darts");
        this.useGCD = new JCheckBox("Use GCD");
        this.usePTrie = new JCheckBox("Use PTrie");
        this.skeletonAnalysis = new JCheckBox("Preprocess using skeleton analysis");
        this.useTraceRefinement = new JCheckBox("Use trace abstraction refinement");
        this.useTarjan = new JCheckBox("Use Tarjan");
        this.useExplicitSearch = new JCheckBox("Use explicit search");
        this.useExplicitSearch.addActionListener(e -> {
            this.refreshHeuristicButtonText();
            this.setComponentEnabledRecursively(this.unfoldingOptionsPanel, !this.useExplicitSearch.isSelected());
            this.oldExplicitSearchState = this.useExplicitSearch.isSelected();
        });
        this.useReduction.setSelected(true);
        this.useColoredReduction.setSelected(true);
        this.useSiphonTrap.setSelected(false);
        this.useQueryReduction.setSelected(true);
        this.useStubbornReduction.setSelected(true);
        this.symmetryReduction.setSelected(true);
        this.discreteInclusion.setVisible(true);
        this.selectInclusionPlacesButton.setEnabled(false);
        this.useTimeDarts.setSelected(false);
        this.useGCD.setSelected(true);
        this.usePTrie.setSelected(true);
        this.skeletonAnalysis.setSelected(true);
        this.useTraceRefinement.setSelected(false);
        this.useTarjan.setSelected(true);
        this.setupExplicitSearch(true);
        this.useReduction.setToolTipText(TOOL_TIP_USE_STRUCTURALREDUCTION);
        this.useColoredReduction.setToolTipText(TOOL_TIP_USE_COLORED_STRUCTURALREDUCTION);
        this.useSiphonTrap.setToolTipText(TOOL_TIP_USE_SIPHONTRAP);
        this.useQueryReduction.setToolTipText(TOOL_TIP_USE_QUERY_REDUCTION);
        this.useStubbornReduction.setToolTipText(TOOL_TIP_STUBBORN_REDUCTION);
        this.symmetryReduction.setToolTipText(TOOL_TIP_SYMMETRY_REDUCTION);
        this.discreteInclusion.setToolTipText(TOOL_TIP_DISCRETE_INCLUSION);
        this.selectInclusionPlacesButton.setToolTipText(TOOL_TIP_SELECT_INCLUSION_PLACES);
        this.useTimeDarts.setToolTipText(TOOL_TIP_TIME_DARTS);
        this.useGCD.setToolTipText(TOOL_TIP_GCD);
        this.usePTrie.setToolTipText(TOOL_TIP_PTRIE);
        this.skeletonAnalysis.setToolTipText(TOOL_TIP_OVERAPPROX);
        this.useTraceRefinement.setToolTipText(TOOL_TIP_USE_TRACE_REFINEMENT);
        this.useTarjan.setToolTipText(TOOL_TIP_USE_TARJAN);
        this.useExplicitSearch.setToolTipText(TOOL_TIP_USE_EXPLICIT_SEARCH);
        this.useTarjan.addActionListener(e -> this.updateSearchStrategies());
        if (this.lens.isTimed()) {
            this.initTimedReductionOptions();
        } else {
            this.useReduction.addActionListener(actionEvent -> this.openReducedNetButton.setEnabled(this.useReduction.isSelected() && this.getQueryComment().length() > 0 && !this.newProperty.containsPlaceHolder()));
            this.initUntimedReductionOptions();
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.verificationPanel.add((Component)this.reductionOptionsPanel, gbc);
    }

    private void initTimedReductionOptions() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.reductionOptionsPanel.add((Component)this.symmetryReduction, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.reductionOptionsPanel.add((Component)this.discreteInclusion, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.reductionOptionsPanel.add((Component)this.useStubbornReduction, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.reductionOptionsPanel.add((Component)this.skeletonAnalysis, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.reductionOptionsPanel.add((Component)this.useTimeDarts, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.reductionOptionsPanel.add((Component)this.useGCD, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.reductionOptionsPanel.add((Component)this.selectInclusionPlacesButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.reductionOptionsPanel.add((Component)this.usePTrie, gbc);
        this.discreteInclusion.addActionListener(e -> this.selectInclusionPlacesButton.setEnabled(this.discreteInclusion.isSelected()));
        this.selectInclusionPlacesButton.addActionListener(e -> {
            this.inclusionPlaces = ChooseInclusionPlacesDialog.showInclusionPlacesDialog(this.tapnNetwork, this.inclusionPlaces);
        });
        this.useTimeDarts.addActionListener(e -> this.setEnabledOptionsAccordingToCurrentReduction());
    }

    private void initUntimedReductionOptions() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.reductionOptionsPanel.add((Component)this.useReduction, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        if (this.lens.isColored()) {
            this.reductionOptionsPanel.add((Component)this.useColoredReduction, gbc);
            ++gbc.gridy;
            if (!this.lens.isGame() && !this.lens.isStochastic()) {
                this.reductionOptionsPanel.add((Component)this.useExplicitSearch, gbc);
                ++gbc.gridy;
            }
        }
        this.reductionOptionsPanel.add((Component)this.useQueryReduction, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.reductionOptionsPanel.add((Component)this.useStubbornReduction, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.reductionOptionsPanel.add((Component)this.useTraceRefinement, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.reductionOptionsPanel.add((Component)this.useSiphonTrap, gbc);
        gbc.gridx = 3;
        gbc.gridy = 1;
        this.reductionOptionsPanel.add((Component)this.useTarjan, gbc);
    }

    private void initRawVerificationOptionsPanel() {
        this.rawVerificationOptionsPanel = new JPanel(new GridBagLayout());
        this.rawVerificationOptionsPanel.setVisible(false);
        this.rawVerificationOptionsPanel.setBorder(BorderFactory.createTitledBorder("Verification Options"));
        this.rawVerificationOptionsEnabled = new JCheckBox("Use");
        this.rawVerificationOptionsEnabled.setToolTipText(TOOL_TIP_RAW_VERIFICATION_ENABLED_CHECKBOX);
        this.rawVerificationOptionsTextArea = new JTextArea();
        this.rawVerificationOptionsTextArea.setEnabled(false);
        this.rawVerificationOptionsTextArea.setToolTipText(TOOL_TIP_RAW_VERIFICATION_TEXT_FIELD);
        this.rawVerificationOptionsTextArea.setLineWrap(true);
        this.rawVerificationOptionsTextArea.setWrapStyleWord(true);
        this.rawVerificationOptionsTextArea.setRows(4);
        JScrollPane rawVerificationOptionsScrollPane = new JScrollPane(this.rawVerificationOptionsTextArea);
        this.rawVerificationOptionsHelpButton = new JButton("Help on options");
        this.rawVerificationOptionsHelpButton.setEnabled(false);
        this.rawVerificationOptionsHelpButton.setToolTipText(TOOL_TIP_RAW_VERIFICATION_HELP_BUTTON);
        this.rawVerificationOptionsHelpButton.addActionListener(e -> this.showEngineHelp());
        this.rawVerificationOptionsEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QueryDialog.this.setVerificationOptionsEnabled(!QueryDialog.this.rawVerificationOptionsEnabled.isSelected());
                QueryDialog.this.rawVerificationOptionsTextArea.setEnabled(QueryDialog.this.rawVerificationOptionsEnabled.isSelected());
                QueryDialog.this.rawVerificationOptionsHelpButton.setEnabled(QueryDialog.this.rawVerificationOptionsEnabled.isSelected());
                QueryDialog.this.updateRawVerificationOptions();
            }
        });
        GridBagConstraints checkBoxGbc = new GridBagConstraints();
        checkBoxGbc.gridx = 0;
        checkBoxGbc.gridy = 0;
        GridBagConstraints textAreaGbc = new GridBagConstraints();
        textAreaGbc.gridx = 1;
        textAreaGbc.gridy = 0;
        textAreaGbc.weightx = 1.0;
        textAreaGbc.gridheight = 2;
        textAreaGbc.fill = 2;
        textAreaGbc.insets = new Insets(0, 10, 0, 10);
        GridBagConstraints buttonGbc = new GridBagConstraints();
        buttonGbc.gridx = 0;
        buttonGbc.gridy = 1;
        buttonGbc.insets = new Insets(0, 5, 0, 0);
        this.rawVerificationOptionsPanel.add((Component)this.rawVerificationOptionsEnabled, checkBoxGbc);
        this.rawVerificationOptionsPanel.add((Component)rawVerificationOptionsScrollPane, textAreaGbc);
        this.rawVerificationOptionsPanel.add((Component)this.rawVerificationOptionsHelpButton, buttonGbc);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.fill = 1;
        this.add((Component)this.rawVerificationOptionsPanel, gbc);
    }

    private void showEngineHelp() {
        this.querySaved = true;
        ModelChecker model = Verifier.getModelChecker(this.getQuery());
        this.querySaved = false;
        JTextArea engineHelp = new JTextArea();
        engineHelp.setEditable(false);
        if (model instanceof VerifyPN) {
            engineHelp.setText(((VerifyPN)model).getHelpOptions());
        } else if (model instanceof VerifyDTAPN) {
            engineHelp.setText(((VerifyDTAPN)model).getHelpOptions());
        } else if (model instanceof VerifyTAPN) {
            engineHelp.setText(((VerifyTAPN)model).getHelpOptions());
        }
        JScrollPane engineHelpScrollPane = new JScrollPane(engineHelp);
        engineHelpScrollPane.setPreferredSize(new Dimension(800, 600));
        if (!engineHelp.getText().isEmpty()) {
            Window ownerWindow = SwingUtilities.windowForComponent(this);
            JDialog engineHelpDialog = new JDialog(ownerWindow, "Engine Options", Dialog.ModalityType.MODELESS);
            engineHelpDialog.add(engineHelpScrollPane);
            engineHelpDialog.pack();
            engineHelpDialog.setResizable(true);
            engineHelpDialog.setLocationByPlatform(true);
            engineHelpDialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "Error getting options for this engine.", "Error", 0);
        }
    }

    private void setVerificationOptionsEnabled(boolean isEnabled) {
        Enabler.setAllEnabled(this.reductionOptionsPanel, isEnabled);
        if (this.unfoldingOptionsPanel != null) {
            Enabler.setAllEnabled(this.unfoldingOptionsPanel, isEnabled);
        }
        Enabler.setAllEnabled(this.traceOptionsPanel, isEnabled);
        Enabler.setAllEnabled(this.boundednessCheckPanel, isEnabled);
        Enabler.setAllEnabled(this.searchOptionsPanel, isEnabled);
        Enabler.setAllEnabled(this.smcTracePanel, isEnabled);
        this.smcVerificationTypeLabel.setEnabled(isEnabled);
        this.smcVerificationType.setEnabled(isEnabled);
        this.smcParallelLabel.setEnabled(isEnabled);
        this.smcParallel.setEnabled(isEnabled);
        this.smcGranularityField.setEnabled(isEnabled);
        this.smcMaxGranularityCheckbox.setEnabled(isEnabled);
        this.smcNumericPrecision.setEnabled(isEnabled);
        this.setEnabledOptionsAccordingToCurrentReduction();
    }

    protected void setEnabledOptionsAccordingToCurrentReduction() {
        this.refreshQueryEditingButtons();
        if (this.rawVerificationOptionsEnabled.isSelected()) {
            return;
        }
        this.refreshTraceOptions();
        if (this.lens.isTimed()) {
            this.refreshSymmetryReduction();
            this.refreshStubbornReduction();
            this.refreshDiscreteOptions();
            this.refreshDiscreteInclusion();
            this.refreshOverApproximationOption();
        } else if (!this.lens.isTimed()) {
            this.refreshTraceRefinement();
            this.refreshTarjan();
            this.refreshExplicitSearch();
            this.refreshColoredReduction();
            if (this.queryType.getSelectedIndex() == 2) {
                this.traceBoxQuantification.setEnabled(this.traceBoxQuantification.getModel().getSize() > 0);
            }
        }
        if (!this.lens.isColored()) {
            this.useColoredReduction.setSelected(false);
            this.useColoredReduction.setEnabled(false);
        }
        boolean isCTL = this.queryType.getSelectedIndex() == 0;
        this.updateSiphonTrap(isCTL);
        this.updateSearchStrategies();
        this.refreshExportButtonText();
        guiDialog.pack();
    }

    private void showRawVerificationOptions(boolean advancedView) {
        this.querySaved = true;
        net.tapaal.gui.petrinet.verification.TAPNQuery query = this.getQuery();
        this.querySaved = false;
        if (query.getReductionOption() != ReductionOption.VerifyTAPN && query.getReductionOption() != ReductionOption.VerifyDTAPN && query.getReductionOption() != ReductionOption.VerifyPN) {
            this.rawVerificationOptionsPanel.setVisible(false);
        } else {
            this.rawVerificationOptionsPanel.setVisible(advancedView);
        }
        guiDialog.pack();
    }

    private void updateRawVerificationOptions() {
        this.querySaved = true;
        net.tapaal.gui.petrinet.verification.TAPNQuery query = this.getQuery();
        this.querySaved = false;
        query = Verifier.convertQuery(query, this.lens);
        Verifier.createTempFile();
        boolean isColored = this.lens != null && this.lens.isColored() || this.tapnNetwork.isColored();
        VerifyTAPNOptions verifytapnOptions = Verifier.getVerificationOptions(query, isColored);
        TAPNComposer composer = new TAPNComposer(new MessengerImpl(), false);
        Tuple<TimedArcPetriNet, NameMapping> transformedModel = composer.transformModel(this.tapnNetwork);
        verifytapnOptions.setTokensInModel(transformedModel.value1().getNumberOfTokensInNet());
        String rawVerificationOptions = verifytapnOptions.toString();
        if (verifytapnOptions.enabledOverApproximation() || verifytapnOptions.enabledUnderApproximation()) {
            if (verifytapnOptions.kBoundPresentInRawVerification() && verifytapnOptions.tracePresentInRawVerification()) {
                JOptionPane.showMessageDialog(this, "Because over/under-approximation is active, the specified k-bound and trace in the custom verification options will be overwritten.", "Warning", 2);
            } else if (verifytapnOptions.kBoundPresentInRawVerification()) {
                JOptionPane.showMessageDialog(this, "Because over/under-approximation is active, the specified k-bound in the custom verification options will be overwritten.", "Warning", 2);
            } else if (verifytapnOptions.tracePresentInRawVerification()) {
                JOptionPane.showMessageDialog(this, "Because over/under-approximation is active, the specified trace in the custom verification options will be overwritten.", "Warning", 2);
            }
            rawVerificationOptions = rawVerificationOptions.replaceAll("(--k-bound|-k|--trace|-t) +\\d*", "");
        }
        this.rawVerificationOptionsTextArea.setText(rawVerificationOptions.trim());
    }

    private void refreshTraceRefinement() {
        ReductionOption reduction = this.getReductionOption();
        if (this.queryType.getSelectedIndex() == 0 && !this.lens.isGame() && reduction != null && reduction.equals((Object)ReductionOption.VerifyPN) && (this.newProperty.toString().startsWith("AG") || this.newProperty.toString().startsWith("EF")) && !this.hasInhibitorArcs && !this.newProperty.hasNestedPathQuantifiers()) {
            this.useTraceRefinement.setEnabled(true);
        } else {
            this.useTraceRefinement.setEnabled(false);
        }
    }

    private void refreshTarjan() {
        int selectedIndex = this.queryType.getSelectedIndex();
        switch (selectedIndex) {
            case 1: {
                this.useTarjan.setVisible(true);
                this.useTarjan.setEnabled(true);
                break;
            }
            case 2: {
                this.useTarjan.setVisible(true);
                this.useTarjan.setEnabled(false);
                this.useTarjan.setSelected(false);
                break;
            }
            default: {
                this.useTarjan.setVisible(false);
                this.useTarjan.setEnabled(false);
            }
        }
    }

    private void refreshExplicitSearch() {
        if (this.canUseExplicitSearch()) {
            this.useExplicitSearch.setSelected(this.oldExplicitSearchState);
            this.useExplicitSearch.setEnabled(true);
        } else {
            if (this.useExplicitSearch.isEnabled()) {
                this.oldExplicitSearchState = this.useExplicitSearch.isSelected();
            }
            this.useExplicitSearch.setSelected(false);
            this.useExplicitSearch.setEnabled(false);
        }
    }

    private void setComponentEnabledRecursively(Component component, boolean enabled) {
        if (component == null) {
            return;
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                this.setComponentEnabledRecursively(child, enabled);
            }
        }
        if (!enabled && component instanceof AbstractButton) {
            ((AbstractButton)component).setSelected(false);
        }
        component.setEnabled(enabled);
    }

    private boolean canUseExplicitSearch() {
        return (this.newProperty.toString().contains("AG") || this.newProperty.toString().contains("EF")) && !this.newProperty.hasNestedPathQuantifiers();
    }

    private void refreshColoredReduction() {
        this.useColoredReduction.setEnabled(this.someTraceRadioButton.isSelected());
        if (this.someTraceRadioButton.isSelected() || this.lens.isGame()) {
            this.useColoredReduction.setEnabled(false);
            this.useColoredReduction.setSelected(false);
        } else {
            this.useColoredReduction.setEnabled(true);
        }
    }

    private void refreshDiscreteInclusion() {
        ReductionOption reduction = this.getReductionOption();
        if (reduction == null) {
            this.discreteInclusion.setVisible(false);
            this.selectInclusionPlacesButton.setVisible(false);
        } else if (reduction.equals((Object)ReductionOption.VerifyTAPN)) {
            this.discreteInclusion.setVisible(true);
            this.selectInclusionPlacesButton.setVisible(true);
        } else {
            this.discreteInclusion.setVisible(false);
            this.selectInclusionPlacesButton.setVisible(false);
        }
    }

    private void refreshExportButtonText() {
        ReductionOption reduction = this.getReductionOption();
        if (reduction == null) {
            this.saveUppaalXMLButton.setEnabled(false);
        } else {
            this.saveUppaalXMLButton.setText(reduction == ReductionOption.VerifyTAPN || reduction == ReductionOption.VerifyDTAPN ? EXPORT_VERIFYTAPN_BTN_TEXT : (reduction == ReductionOption.VerifyPN ? EXPORT_VERIFYPN_BTN_TEXT : EXPORT_UPPAAL_BTN_TEXT));
            this.saveUppaalXMLButton.setToolTipText(reduction == ReductionOption.VerifyTAPN || reduction == ReductionOption.VerifyDTAPN ? TOOL_TIP_SAVE_TAPAAL_BUTTON : (reduction == ReductionOption.VerifyPN ? TOOL_TIP_SAVE_PN_BUTTON : TOOL_TIP_SAVE_UPPAAL_BUTTON));
            this.saveUppaalXMLButton.setEnabled(true);
        }
    }

    private void refreshQueryEditingButtons() {
        boolean isSmc = this.lens.isStochastic();
        if (this.currentSelection != null) {
            if (this.lens.isGame()) {
                if (this.currentSelection.getObject() instanceof TCTLAbstractPathProperty) {
                    this.forAllBox.setSelected(false);
                    this.enableOnlyForAll();
                } else if (this.currentSelection.getObject() instanceof TCTLAbstractStateProperty) {
                    this.enableOnlyStateButtons();
                }
            } else if (this.lens.isTimed() && !isSmc) {
                if (this.currentSelection.getObject() instanceof TCTLAbstractPathProperty) {
                    this.enableOnlyPathButtons();
                } else if (this.currentSelection.getObject() instanceof TCTLAbstractStateProperty) {
                    this.enableOnlyStateButtons();
                }
                this.updateQueryButtonsAccordingToSelection();
            } else if (isSmc) {
                if (this.currentSelection.getObject() instanceof TCTLAbstractPathProperty) {
                    this.enableOnlySMCButtons();
                } else if (this.currentSelection.getObject() instanceof TCTLAbstractStateProperty) {
                    this.enableOnlyStateButtons();
                    this.finallyButton.setEnabled(false);
                    this.globallyButton.setEnabled(false);
                }
                this.updateQueryButtonsAccordingToSelection();
            } else {
                this.enableOnlyUntimedStateButtons();
                this.updateQueryButtonsAccordingToSelection();
            }
        }
    }

    private void refreshSymmetryReduction() {
        if (disableSymmetryUpdate) {
            return;
        }
        if (this.reductionOption.getSelectedItem() == null) {
            this.symmetryReduction.setVisible(false);
        } else if (this.reductionOption.getSelectedItem().equals(name_DISCRETE) || this.reductionOption.getSelectedItem().equals(name_UNTIMED)) {
            this.symmetryReduction.setVisible(true);
            this.symmetryReduction.setEnabled(false);
        } else if ((this.reductionOption.getSelectedItem().equals(name_COMBI) || this.reductionOption.getSelectedItem().equals(name_OPTIMIZEDSTANDARD) || this.reductionOption.getSelectedItem().equals(name_STANDARD) || this.reductionOption.getSelectedItem().equals(name_BROADCAST) || this.reductionOption.getSelectedItem().equals(name_BROADCASTDEG2)) && (!this.noApproximationEnable.isSelected() || this.someTraceRadioButton.isSelected())) {
            this.symmetryReduction.setVisible(true);
            this.symmetryReduction.setSelected(false);
            this.symmetryReduction.setEnabled(false);
        } else {
            this.symmetryReduction.setVisible(true);
            if (!this.symmetryReduction.isEnabled()) {
                this.symmetryReduction.setSelected(true);
            }
            this.symmetryReduction.setEnabled(true);
        }
    }

    private void refreshOverApproximationOption() {
        if (this.rawVerificationOptionsEnabled.isSelected()) {
            return;
        }
        if (this.queryHasDeadlock() || this.newProperty.toString().contains("EG") || this.newProperty.toString().contains("AF")) {
            this.skeletonAnalysis.setSelected(false);
            this.skeletonAnalysis.setEnabled(false);
        } else {
            if (!this.skeletonAnalysis.isEnabled()) {
                this.skeletonAnalysis.setSelected(true);
            }
            this.skeletonAnalysis.setEnabled(true);
        }
        if (this.lens.isGame()) {
            this.noApproximationEnable.setEnabled(true);
            this.overApproximationEnable.setEnabled(false);
            this.underApproximationEnable.setEnabled(false);
            this.overApproximationDenominator.setEnabled(false);
        } else if (this.fastestTraceRadioButton.isSelected()) {
            this.noApproximationEnable.setEnabled(true);
            this.noApproximationEnable.setSelected(true);
            this.overApproximationEnable.setEnabled(false);
            this.underApproximationEnable.setEnabled(false);
            this.overApproximationDenominator.setEnabled(false);
        } else {
            this.noApproximationEnable.setEnabled(true);
            this.overApproximationEnable.setEnabled(true);
            this.underApproximationEnable.setEnabled(true);
            this.overApproximationDenominator.setEnabled(true);
        }
    }

    private void refreshDiscreteOptions() {
        this.useReduction.setVisible(false);
        if (this.reductionOption.getSelectedItem() == null) {
            this.useGCD.setVisible(false);
            this.usePTrie.setVisible(false);
            this.useStubbornReduction.setVisible(false);
            this.useTimeDarts.setVisible(false);
        } else if (this.reductionOption.getSelectedItem().equals(name_DISCRETE)) {
            this.useGCD.setVisible(true);
            this.usePTrie.setVisible(true);
            this.useStubbornReduction.setVisible(true);
            this.useTimeDarts.setVisible(true);
            if (this.tapnNetwork.hasUrgentTransitions() || this.fastestTraceRadioButton.isSelected() || this.lens.isGame()) {
                hasForcedDisabledTimeDarts = this.useTimeDarts.isSelected();
                this.useTimeDarts.setSelected(false);
                this.useTimeDarts.setEnabled(false);
            }
            if (this.queryHasDeadlock() || this.newProperty.toString().contains("EG") || this.newProperty.toString().contains("AF") || this.lens.isGame()) {
                if (this.useGCD.isSelected()) {
                    hasForcedDisabledGCD = true;
                }
                this.useGCD.setSelected(false);
                this.useGCD.setEnabled(false);
            }
            if (this.queryHasDeadlock() && (this.newProperty.toString().contains("EG") || this.newProperty.toString().contains("AF"))) {
                hasForcedDisabledTimeDarts = this.useTimeDarts.isSelected();
                this.useTimeDarts.setSelected(false);
                this.useTimeDarts.setEnabled(false);
                this.symmetryReduction.setSelected(false);
                this.symmetryReduction.setEnabled(false);
            }
            if (this.newProperty.toString().contains("EG") || this.newProperty.toString().contains("AF")) {
                if (this.useStubbornReduction.isSelected()) {
                    hasForcedDisabledStubbornReduction = true;
                }
                this.useStubbornReduction.setSelected(false);
                this.useStubbornReduction.setEnabled(false);
            }
        } else {
            this.useGCD.setVisible(false);
            this.usePTrie.setVisible(false);
            this.useStubbornReduction.setVisible(false);
            this.useTimeDarts.setVisible(false);
        }
    }

    private void refreshStubbornReduction() {
        if (this.queryType.getSelectedIndex() == 2) {
            this.useStubbornReduction.setSelected(false);
            this.useStubbornReduction.setEnabled(false);
        } else if (this.useTimeDarts.isSelected()) {
            this.useStubbornReduction.setSelected(false);
            this.useStubbornReduction.setEnabled(false);
        } else {
            this.useStubbornReduction.setEnabled(true);
        }
    }

    private void updateHyperLTLButtons() {
        boolean enable = this.traceBoxQuantification.getModel().getSize() > 0;
        this.showHyperLTL(true);
        if (this.currentSelection == null || this.currentSelection.getObject() == this.newProperty) {
            String ltlType = this.checkLTLType();
            this.disableAllLTLButtons();
            if (ltlType.equals("placeholder")) {
                this.aButton.setEnabled(enable);
                this.eButton.setEnabled(enable);
            } else if (ltlType.equals("A")) {
                this.aButton.setEnabled(enable);
            } else {
                this.eButton.setEnabled(enable);
            }
        } else if (this.currentSelection.getObject() instanceof LTLANode) {
            this.aButton.setEnabled(enable);
        } else if (this.currentSelection.getObject() instanceof LTLENode) {
            this.eButton.setEnabled(enable);
        } else if (this.containsOnlyPathProperties(this.newProperty)) {
            this.aButton.setEnabled(enable && this.newProperty instanceof LTLANode);
            this.eButton.setEnabled(enable && this.newProperty instanceof LTLENode);
            this.globallyButton.setEnabled(true);
            this.finallyButton.setEnabled(true);
            this.nextButton.setEnabled(true);
            this.untilButton.setEnabled(true);
        } else {
            this.aButton.setEnabled(false);
            this.eButton.setEnabled(false);
            this.traceBoxQuantification.setEnabled(false);
            this.globallyButton.setEnabled(true);
            this.finallyButton.setEnabled(true);
            this.nextButton.setEnabled(true);
            this.untilButton.setEnabled(true);
        }
        if (this.currentSelection == null || this.currentSelection != null && (this.currentSelection.getObject() instanceof LTLENode || this.currentSelection.getObject() instanceof LTLANode || this.currentSelection.getObject() instanceof TCTLPathPlaceHolder)) {
            this.conjunctionButton.setEnabled(false);
            this.disjunctionButton.setEnabled(false);
        } else {
            this.conjunctionButton.setEnabled(true);
            this.disjunctionButton.setEnabled(true);
        }
    }

    private boolean containsOnlyPathProperties(TCTLAbstractProperty property) {
        if (property instanceof LTLANode) {
            return this.containsOnlyPathProperties(((LTLANode)property).getProperty());
        }
        if (property instanceof LTLENode) {
            return this.containsOnlyPathProperties(((LTLENode)property).getProperty());
        }
        if (property instanceof TCTLPathToStateConverter) {
            return this.containsOnlyPathProperties(((TCTLPathToStateConverter)property).getProperty());
        }
        return property instanceof TCTLPathPlaceHolder || property instanceof TCTLStatePlaceHolder;
    }

    private void updateLTLButtons() {
        if (this.currentSelection.getObject() == this.newProperty) {
            String ltlType = this.checkLTLType();
            this.disableAllLTLButtons();
            if (ltlType.equals("placeholder")) {
                this.aButton.setEnabled(true);
                this.eButton.setEnabled(true);
            } else if (ltlType.equals("A")) {
                this.eButton.setEnabled(true);
            } else {
                this.aButton.setEnabled(true);
            }
        } else {
            this.aButton.setEnabled(false);
            this.eButton.setEnabled(false);
            this.globallyButton.setEnabled(true);
            this.finallyButton.setEnabled(true);
            this.nextButton.setEnabled(true);
            this.untilButton.setEnabled(true);
        }
    }

    private void updateSMCButtons() {
        if (this.currentSelection != null && this.currentSelection.getObject() == this.newProperty) {
            String ltlType = this.checkLTLType();
            if (ltlType.equals("placeholder")) {
                this.finallyButton.setEnabled(true);
                this.globallyButton.setEnabled(true);
            }
        } else {
            this.finallyButton.setEnabled(false);
            this.globallyButton.setEnabled(false);
        }
    }

    private void queryChanged() {
        this.setEnabledReductionOptions();
        if (this.lens.isTimed()) {
            this.refreshOverApproximationOption();
        }
        int selectedIndex = this.queryType.getSelectedIndex();
        boolean isSmc = this.lens.isStochastic();
        if (selectedIndex == 1) {
            this.updateLTLButtons();
        } else if (selectedIndex == 2) {
            this.updateHyperLTLButtons();
            this.updateTraceBox();
        } else if (isSmc) {
            this.updateSMCButtons();
        }
    }

    private void cancelAndExit() {
        this.cancelTraceChanges();
        while (this.undoManager.canUndo()) {
            UndoableEdit edit = this.undoManager.GetNextEditToUndo();
            if (edit instanceof QueryConstructionEdit) {
                TCTLAbstractProperty original = ((QueryConstructionEdit)edit).getOriginal();
                this.undoManager.undo();
                this.refreshUndoRedo();
                this.updateSelection(original);
                this.queryChanged();
                continue;
            }
            this.undoManager.undo();
        }
        this.exit();
    }

    private void initButtonPanel(QueryDialogueOption option, final boolean isNewQuery) {
        this.buttonPanel = new JPanel(new BorderLayout());
        if (option == QueryDialogueOption.Save) {
            this.saveButton = new JButton("Save");
            this.saveAndVerifyButton = new JButton("Save and Verify");
            this.cancelButton = new JButton("Cancel");
            this.mergeNetComponentsButton = new JButton(EXPORT_COMPOSED_BTN_TEXT);
            this.mergeNetComponentsButton.setVisible(false);
            this.openReducedNetButton = new JButton(OPEN_REDUCED_BTN_TEXT);
            this.openReducedNetButton.setVisible(false);
            this.saveUppaalXMLButton = new JButton(EXPORT_UPPAAL_BTN_TEXT);
            this.saveUppaalXMLButton.setVisible(false);
            this.saveButton.setToolTipText(TOOL_TIP_SAVE_BUTTON);
            this.saveAndVerifyButton.setToolTipText(TOOL_TIP_SAVE_AND_VERIFY_BUTTON);
            this.cancelButton.setToolTipText(TOOL_TIP_CANCEL_BUTTON);
            this.saveUppaalXMLButton.setToolTipText(TOOL_TIP_SAVE_UPPAAL_BUTTON);
            this.mergeNetComponentsButton.setToolTipText(TOOL_TIP_SAVE_COMPOSED_BUTTON);
            this.openReducedNetButton.setToolTipText(TOOL_TIP_OPEN_REDUCED_BUTTON);
            this.saveButton.addActionListener(new ActionListener(){
                final /* synthetic */ QueryDialog this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (this.this$0.checkIfSomeReductionOption()) {
                        this.this$0.querySaved = true;
                        this.this$0.tab.setNetChanged(true);
                        this.this$0.exit();
                        net.tapaal.gui.petrinet.verification.TAPNQuery query = this.this$0.getQuery();
                        if (isNewQuery) {
                            QueryPane queryPane = this.this$0.tab.getQueryPane();
                            queryPane.getUndoManager().addNewEdit(new AddQueryCommand(query, this.this$0.tab));
                            queryPane.addQuery(query);
                        }
                    }
                }
            });
            this.saveAndVerifyButton.addActionListener(evt -> {
                this.updateRawVerificationOptions();
                if (this.checkIfSomeReductionOption()) {
                    if (this.lens.isStochastic() && !this.tapnNetwork.isNonStrict()) {
                        JOptionPane.showMessageDialog(this, "The model has strict intervals and can therefore not be verified", "Error", 0);
                        return;
                    }
                    this.querySaved = true;
                    this.tab.setNetChanged(true);
                    this.exit();
                    net.tapaal.gui.petrinet.verification.TAPNQuery query = this.getQuery();
                    if (isNewQuery) {
                        QueryPane queryPane = this.tab.getQueryPane();
                        queryPane.getUndoManager().addNewEdit(new AddQueryCommand(query, this.tab));
                        queryPane.addQuery(query);
                    }
                    if (query.getReductionOption() == ReductionOption.VerifyTAPN || query.getReductionOption() == ReductionOption.VerifyDTAPN || query.getReductionOption() == ReductionOption.VerifyPN) {
                        Verifier.runVerifyTAPNVerification(this.tapnNetwork, query, null, this.guiModels, false, this.lens);
                    } else {
                        Verifier.runUppaalVerification(this.tapnNetwork, query);
                    }
                }
            });
            this.cancelButton.addActionListener(evt -> this.cancelAndExit());
            this.saveUppaalXMLButton.addActionListener(e -> {
                this.querySaved = true;
                String xmlFile = null;
                String queryFile = null;
                ReductionOption reduction = this.getReductionOption();
                try {
                    FileBrowser browser = FileBrowser.constructor(reduction == ReductionOption.VerifyTAPN || reduction == ReductionOption.VerifyDTAPN || reduction == ReductionOption.VerifyPN ? "Verifytapn XML" : "Uppaal XML", "xml", xmlFile);
                    xmlFile = browser.saveFile();
                    if (xmlFile != null) {
                        String[] a = xmlFile.split(".xml");
                        queryFile = a[0] + ".q";
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There were errors performing the requested action:\n" + String.valueOf(e), "Error", 0);
                }
                if (xmlFile != null && queryFile != null) {
                    Object exporter;
                    TAPNComposer composer = new TAPNComposer(new MessengerImpl(), false);
                    Tuple<TimedArcPetriNet, NameMapping> transformedModel = composer.transformModel(this.tapnNetwork);
                    if (this.overApproximationEnable.isSelected()) {
                        OverApproximation overaprx = new OverApproximation();
                        overaprx.modifyTAPN(transformedModel.value1(), this.getQuery().approximationDenominator());
                    } else if (this.underApproximationEnable.isSelected()) {
                        UnderApproximation underaprx = new UnderApproximation();
                        underaprx.modifyTAPN(transformedModel.value1(), this.getQuery().approximationDenominator());
                    }
                    net.tapaal.gui.petrinet.verification.TAPNQuery tapnQuery = this.getQuery();
                    TAPNQuery clonedQuery = new TAPNQuery(tapnQuery.getProperty().copy(), tapnQuery.getCapacity());
                    RenameAllPlacesVisitor visitor = new RenameAllPlacesVisitor(transformedModel.value2());
                    clonedQuery.getProperty().accept(visitor, null);
                    if (!this.lens.isTimed()) {
                        RenameAllTransitionsVisitor transitionVisitor = new RenameAllTransitionsVisitor(transformedModel.value2());
                        clonedQuery.getProperty().accept(transitionVisitor, null);
                    }
                    if (this.lens.isColored() && this.lens.isTimed()) {
                        this.exportTACPN(transformedModel, xmlFile);
                    } else if (this.lens.isColored()) {
                        exporter = new VerifyCPNExporter();
                        ((VerifyTAPNExporter)exporter).export(transformedModel.value1(), clonedQuery, new File(xmlFile), new File(queryFile), tapnQuery, this.lens, transformedModel.value2(), composer.getGuiModel());
                    } else if (reduction == ReductionOption.VerifyTAPN || reduction == ReductionOption.VerifyDTAPN) {
                        exporter = new VerifyTAPNExporter();
                        ((VerifyTAPNExporter)exporter).export(transformedModel.value1(), clonedQuery, new File(xmlFile), new File(queryFile), tapnQuery, this.lens, transformedModel.value2(), composer.getGuiModel());
                    } else if (reduction == ReductionOption.VerifyPN) {
                        exporter = new VerifyPNExporter();
                        ((VerifyTAPNExporter)exporter).export(transformedModel.value1(), clonedQuery, new File(xmlFile), new File(queryFile), tapnQuery, this.lens, transformedModel.value2(), composer.getGuiModel());
                    } else {
                        exporter = new UppaalExporter();
                        try {
                            ((UppaalExporter)exporter).export(transformedModel.value1(), clonedQuery, tapnQuery.getReductionOption(), new File(xmlFile), new File(queryFile), tapnQuery.useSymmetry());
                        }
                        catch (Exception exportException) {
                            StringBuilder s = new StringBuilder();
                            if (exportException instanceof UnsupportedModelException) {
                                s.append("The model is not supported by the chosen reduction.\n\n");
                            } else if (exportException instanceof UnsupportedQueryException) {
                                s.append("The query is not supported by the chosen reduction.\n\n");
                            }
                            if (reduction == ReductionOption.VerifyTAPN || reduction == ReductionOption.VerifyDTAPN || reduction == ReductionOption.VerifyPN) {
                                s.append(NO_VERIFYTAPN_XML_FILE_SAVED);
                            } else {
                                s.append(NO_UPPAAL_XML_FILE_SAVED);
                            }
                            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), s.toString());
                        }
                    }
                }
            });
            this.mergeNetComponentsButton.addActionListener(e -> {
                TAPNComposer composer = new TAPNComposer(new MessengerImpl(), this.guiModels, this.lens, true, true);
                Tuple<TimedArcPetriNet, NameMapping> transformedModel = composer.transformModel(this.tapnNetwork);
                ArrayList<Template> templates = new ArrayList<Template>(1);
                this.querySaved = true;
                if (this.overApproximationEnable.isSelected()) {
                    OverApproximation overaprx = new OverApproximation();
                    overaprx.modifyTAPN(transformedModel.value1(), this.getQuery().approximationDenominator());
                } else if (this.underApproximationEnable.isSelected()) {
                    UnderApproximation underaprx = new UnderApproximation();
                    underaprx.modifyTAPN(transformedModel.value1(), this.getQuery().approximationDenominator(), composer.getGuiModel());
                }
                templates.add(new Template(transformedModel.value1(), composer.getGuiModel(), new Zoomer()));
                TimedArcPetriNetNetwork network = new TimedArcPetriNetNetwork();
                network.add(transformedModel.value1());
                network.setColorTypes(this.tapnNetwork.colorTypes());
                network.setConstants(this.tapnNetwork.constants());
                network.setVariables(this.tapnNetwork.variables());
                TimedArcPetriNetNetworkWriter tapnWriter = new TimedArcPetriNetNetworkWriter(network, templates, new ArrayList<net.tapaal.gui.petrinet.verification.TAPNQuery>(0), new ArrayList<Constant>(0), this.lens);
                try {
                    ByteArrayOutputStream outputStream = tapnWriter.savePNML();
                    Object composedName = "composed-" + this.tab.getTabTitle();
                    composedName = ((String)composedName).replace(".tapn", "");
                    TAPAALGUI.openNewTabFromStream(new ByteArrayInputStream(outputStream.toByteArray()), (String)composedName);
                    this.exit();
                }
                catch (Exception e1) {
                    System.console().printf(e1.getMessage(), new Object[0]);
                }
            });
            this.openReducedNetButton.addActionListener(e -> {
                if (this.checkIfSomeReductionOption()) {
                    this.querySaved = true;
                    this.tab.setNetChanged(true);
                    net.tapaal.gui.petrinet.verification.TAPNQuery query = this.getQuery();
                    if (query.getReductionOption() != ReductionOption.VerifyPN) {
                        JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "The selected verification engine does not support application of reduction rules", "Reduction rules unsupported", 0);
                        return;
                    }
                    this.exit();
                    Verifier.runVerifyTAPNVerification(this.tapnNetwork, query, null, this.guiModels, true, null);
                    File reducedNetFile = new File(Verifier.getReducedNetFilePath());
                    if (reducedNetFile.exists() && reducedNetFile.isFile() && reducedNetFile.canRead()) {
                        try {
                            PetriNetTab reducedNetTab = PetriNetTab.createNewTabFromPNMLFile(reducedNetFile);
                            if (reducedNetTab.currentTemplate().guiModel().getPlaces().length > 0 || reducedNetTab.currentTemplate().guiModel().getTransitions().length > 0) {
                                reducedNetTab.setInitialName("reduced-" + this.tab.getTabTitle());
                                net.tapaal.gui.petrinet.verification.TAPNQuery convertedQuery = query.convertPropertyForReducedNet(reducedNetTab.currentTemplate().toString());
                                reducedNetTab.addQuery(convertedQuery);
                                TAPAALGUI.openNewTabFromStream(reducedNetTab);
                            }
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), e1.getMessage(), "Error loading reduced net file", 0);
                        }
                    }
                }
            });
        } else if (option == QueryDialogueOption.Export) {
            this.saveButton = new JButton("export");
            this.cancelButton = new JButton("Cancel");
            this.saveButton.addActionListener(evt -> {
                this.querySaved = true;
                this.exit();
            });
            this.cancelButton.addActionListener(evt -> this.cancelAndExit());
        }
        if (option == QueryDialogueOption.Save) {
            JPanel leftButtomPanel = new JPanel(new FlowLayout());
            JPanel rightButtomPanel = new JPanel(new FlowLayout());
            leftButtomPanel.add((Component)this.mergeNetComponentsButton, 0);
            leftButtomPanel.add((Component)this.openReducedNetButton, 0);
            leftButtomPanel.add((Component)this.saveUppaalXMLButton, 0);
            rightButtomPanel.add(this.cancelButton);
            rightButtomPanel.add(this.saveButton);
            rightButtomPanel.add(this.saveAndVerifyButton);
            this.buttonPanel.add((Component)leftButtomPanel, "Before");
            this.buttonPanel.add((Component)rightButtomPanel, "After");
        } else {
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(this.saveButton);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void exportTACPN(Tuple<TimedArcPetriNet, NameMapping> transformedModel, String xmlFile) {
        TimedArcPetriNetNetwork network = new TimedArcPetriNetNetwork();
        ArrayList<Template> templates = new ArrayList<Template>(1);
        ArrayList<net.tapaal.gui.petrinet.verification.TAPNQuery> queries = new ArrayList<net.tapaal.gui.petrinet.verification.TAPNQuery>(1);
        network.add(transformedModel.value1());
        for (ColorType ct : this.tapnNetwork.colorTypes()) {
            network.add(ct);
        }
        for (Variable variable : this.tapnNetwork.variables()) {
            network.add(variable);
        }
        for (int i = 0; i < this.templateBox.getItemCount(); ++i) {
            TimedArcPetriNet tapn = (TimedArcPetriNet)this.templateBox.getItemAt(i);
            templates.add(new Template(tapn, this.guiModels.get(tapn), new Zoomer()));
        }
        TimedArcPetriNetNetworkWriter writerTACPN = new TimedArcPetriNetNetworkWriter(this.tapnNetwork, templates, queries, this.tapnNetwork.constants(), this.lens);
        try {
            writerTACPN.savePNML(new File(xmlFile));
        }
        catch (IOException | ParserConfigurationException | TransformerException exception) {
            exception.printStackTrace();
        }
    }

    private void refreshUndoRedo() {
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
    }

    private void makeShortcuts() {
        int shortcutkey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ActionMap am = this.getActionMap();
        am.put("undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryDialog.this.undoButton.doClick();
            }
        });
        am.put("redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryDialog.this.redoButton.doClick();
            }
        });
        InputMap im = this.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(90, shortcutkey), "undo");
        im.put(KeyStroke.getKeyStroke(89, shortcutkey), "redo");
    }

    private void setupEstimationListeners() {
        DocumentListener needUpdateTime = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void update() {
                if (!QueryDialog.this.smcEstimationIntervalWidth.hasFocus() && !QueryDialog.this.smcConfidence.hasFocus()) {
                    return;
                }
                QueryDialog.this.smcMustUpdateTime = true;
                QueryDialog.this.smcTimeExpected.setText("");
                QueryDialog.this.smcTimeEstimationButton.setText(QueryDialog.UPDATE_VERIFICATION_TIME_BTN_TEXT);
                try {
                    Float.parseFloat(QueryDialog.this.smcEstimationIntervalWidth.getText());
                    boolean isQueryOk = QueryDialog.this.getQueryComment().length() > 0 && !QueryDialog.this.newProperty.containsPlaceHolder();
                    QueryDialog.this.smcTimeEstimationButton.setEnabled(!QueryDialog.this.queryField.isEditable() && isQueryOk);
                }
                catch (NumberFormatException e) {
                    QueryDialog.this.smcTimeEstimationButton.setEnabled(false);
                }
            }
        };
        this.smcEstimationIntervalWidth.getDocument().addDocumentListener(needUpdateTime);
        this.smcConfidence.getDocument().addDocumentListener(needUpdateTime);
        this.smcTimeExpected.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void update() {
                if (!QueryDialog.this.smcTimeExpected.hasFocus()) {
                    return;
                }
                QueryDialog.this.smcMustUpdateTime = false;
                QueryDialog.this.smcEstimationIntervalWidth.setText("");
                QueryDialog.this.smcTimeEstimationButton.setText(QueryDialog.UPDATE_PRECISION_BTN_TEXT);
                try {
                    Double.parseDouble(QueryDialog.this.smcTimeExpected.getText());
                    boolean isQueryOk = QueryDialog.this.getQueryComment().length() > 0 && !QueryDialog.this.newProperty.containsPlaceHolder();
                    QueryDialog.this.smcTimeEstimationButton.setEnabled(!QueryDialog.this.queryField.isEditable() && isQueryOk);
                }
                catch (NumberFormatException e) {
                    QueryDialog.this.smcTimeEstimationButton.setEnabled(false);
                }
            }
        });
    }

    private void runBenchmark() {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat precisionFormat = new DecimalFormat("#.#####", decimalFormatSymbols);
        DecimalFormat timeFormat = new DecimalFormat("#.##", decimalFormatSymbols);
        if (this.doingBenchmark) {
            if (this.benchmarkThread == null) {
                return;
            }
            this.benchmarkThread.cancel(true);
            this.doingBenchmark = false;
            this.updateFieldsOnBenchmark();
            this.smcTimeEstimationButton.setText(this.smcMustUpdateTime ? UPDATE_VERIFICATION_TIME_BTN_TEXT : UPDATE_PRECISION_BTN_TEXT);
            return;
        }
        this.doingBenchmark = true;
        this.updateFieldsOnBenchmark();
        this.smcTimeEstimationButton.setText("Interrupt estimation");
        boolean saved = this.querySaved;
        this.querySaved = true;
        net.tapaal.gui.petrinet.verification.TAPNQuery query = this.getQuery();
        this.querySaved = saved;
        SMCSettings settings = query.getSmcSettings();
        query.setBenchmarkMode(true);
        query.setBenchmarkRuns(48);
        double timeWanted = 10.0;
        try {
            timeWanted = Double.parseDouble(this.smcTimeExpected.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.smcTimeExpected.setText("");
        this.smcEstimationIntervalWidth.setText("");
        double finalTimeWanted = timeWanted;
        VerificationCallback callback1 = result1 -> {
            query.setBenchmarkRuns(128);
            SMCStats stats1 = (SMCStats)result1.stats();
            float runsDone1 = stats1.getExecutedRuns();
            float time1 = stats1.getVerificationTime();
            VerificationCallback callback2 = result2 -> {
                this.doingBenchmark = false;
                this.updateFieldsOnBenchmark();
                SMCStats stats2 = (SMCStats)result2.stats();
                float runsDone2 = stats2.getExecutedRuns();
                float time2 = stats2.getVerificationTime();
                float coeff = (time2 - time1) / (runsDone2 - runsDone1);
                float stat_err = time1 - coeff * runsDone1;
                if (this.smcMustUpdateTime) {
                    double runsNeeded = settings.chernoffHoeffdingBound();
                    double estimation = (double)coeff * runsNeeded + (double)stat_err;
                    if (estimation < 0.0) {
                        estimation = 0.01;
                    }
                    this.smcTimeExpected.setText(timeFormat.format(estimation));
                    this.smcEstimationIntervalWidth.setText(precisionFormat.format(this.smcSettings.estimationIntervalWidth));
                    this.smcTimeEstimationButton.setText(UPDATE_VERIFICATION_TIME_BTN_TEXT);
                    double desiredMin = this.smcEstimatedTimeSlider.getDesiredMin();
                    double desiredMax = this.smcEstimatedTimeSlider.getDesiredMax();
                    double proportion = (estimation - desiredMin) / (desiredMax - desiredMin);
                    int initialValue = (int)(proportion * (double)this.smcEstimatedTimeSlider.getMaximum());
                    this.updatingSmcSettings = true;
                    this.smcEstimatedTimeSlider.setValue(Math.max(this.smcEstimatedTimeSlider.getMinimum(), Math.min(initialValue, this.smcEstimatedTimeSlider.getMaximum())));
                    this.smcEstimatedTimeSlider.setToolTipText(String.format("Value: %.1f", estimation));
                    this.updatingSmcSettings = false;
                } else {
                    int runsNeeded = (int)Math.ceil((finalTimeWanted - (double)stat_err) / (double)coeff);
                    float precision = settings.precisionFromRuns(runsNeeded);
                    this.smcEstimationIntervalWidth.setText(precisionFormat.format(precision));
                    this.smcTimeExpected.setText(String.valueOf(finalTimeWanted));
                    this.smcTimeEstimationButton.setText(UPDATE_PRECISION_BTN_TEXT);
                    this.updateSMCSettings();
                    this.setSMCSettings(this.smcSettings);
                    double desiredMin = this.smcEstimatedTimeSlider.getDesiredMin();
                    double desiredMax = this.smcEstimatedTimeSlider.getDesiredMax();
                    double proportion = (finalTimeWanted - desiredMin) / (desiredMax - desiredMin);
                    int initialValue = (int)(proportion * (double)this.smcEstimatedTimeSlider.getMaximum());
                    this.updatingSmcSettings = true;
                    this.smcEstimatedTimeSlider.setValue(Math.max(this.smcEstimatedTimeSlider.getMinimum(), Math.min(initialValue, this.smcEstimatedTimeSlider.getMaximum())));
                    this.smcEstimatedTimeSlider.setToolTipText(String.format("Value: %.1f", finalTimeWanted));
                    this.updatingSmcSettings = false;
                }
            };
            this.benchmarkThread = Verifier.runVerifyTAPNSilent(this.tapnNetwork, query, callback2, this.guiModels, false, this.lens);
        };
        this.benchmarkThread = Verifier.runVerifyTAPNSilent(this.tapnNetwork, query, callback1, this.guiModels, false, this.lens);
    }

    private void updateFieldsOnBenchmark() {
        this.smcConfidence.setEnabled(!this.doingBenchmark);
        this.smcEstimationIntervalWidth.setEnabled(!this.doingBenchmark);
        this.smcTimeExpected.setEnabled(!this.doingBenchmark);
        this.smcParallel.setEnabled(!this.doingBenchmark);
        this.smcVerificationType.setEnabled(!this.doingBenchmark);
        this.smcStepBoundValue.setEnabled(!this.doingBenchmark && !this.smcStepBoundInfinite.isSelected());
        this.smcStepBoundInfinite.setEnabled(!this.doingBenchmark && !this.smcTimeBoundInfinite.isSelected());
        this.smcTimeBoundValue.setEnabled(!this.doingBenchmark && !this.smcTimeBoundInfinite.isSelected());
        this.smcTimeBoundInfinite.setEnabled(!this.doingBenchmark && !this.smcStepBoundInfinite.isSelected());
        this.smcNumericPrecision.setEnabled(!this.doingBenchmark);
    }

    static {
        verifyTAPNOptions = new VerifyTAPNEngineOptions();
        UPPAALCombiOptions = new UPPAALCombiOptions();
        UPPAALOptimizedStandardOptions = new UPPAALOptimizedStandardOptions();
        UPPAALStandardOptions = new UPPAALStandardOptions();
        UPPAALBroadcastOptions = new UPPAALBroadcastOptions();
        UPPAALBroadcastDegree2Options = new UPPAALBroadcastDegree2Options();
        verifyDTAPNOptions = new VerifyDTAPNEngineOptions();
        verifyPNOptions = new VerifyPNEngineOptions();
        engineSupportOptions = new EngineSupportOptions[]{verifyDTAPNOptions, verifyTAPNOptions, UPPAALCombiOptions, UPPAALOptimizedStandardOptions, UPPAALStandardOptions, UPPAALBroadcastOptions, UPPAALBroadcastDegree2Options, verifyPNOptions};
        advancedView = false;
        hasForcedDisabledTimeDarts = false;
        hasForcedDisabledStubbornReduction = false;
        hasForcedDisabledGCD = false;
        disableSymmetryUpdate = false;
    }

    public static enum QueryDialogueOption {
        VerifyNow,
        Save,
        Export;

    }

    public class QueryConstructionEdit
    extends AbstractUndoableEdit {
        private final TCTLAbstractProperty original;
        private final TCTLAbstractProperty replacement;

        public TCTLAbstractProperty getOriginal() {
            return this.original;
        }

        public TCTLAbstractProperty getReplacement() {
            return this.replacement;
        }

        public QueryConstructionEdit(TCTLAbstractProperty original, TCTLAbstractProperty replacement) {
            this.original = original;
            this.replacement = replacement;
        }

        @Override
        public void undo() throws CannotUndoException {
            QueryDialog.this.newProperty = QueryDialog.this.newProperty.replace(this.replacement, this.original);
        }

        @Override
        public void redo() throws CannotRedoException {
            QueryDialog.this.newProperty = QueryDialog.this.newProperty.replace(this.original, this.replacement);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }
    }

    private static class QueryConstructionUndoManager
    extends UndoManager {
        private QueryConstructionUndoManager() {
        }

        public UndoableEdit GetNextEditToUndo() {
            return this.editToBeUndone();
        }

        public UndoableEdit GetNextEditToRedo() {
            return this.editToBeRedone();
        }
    }

    private class UndoAdapter
    implements UndoableEditListener {
        private UndoAdapter() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent arg0) {
            UndoableEdit edit = arg0.getEdit();
            QueryDialog.this.undoManager.addEdit(edit);
            QueryDialog.this.refreshUndoRedo();
        }
    }
}

