/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.verification.observations.Observation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.tapaal.gui.petrinet.dialog.ObservationDialog;
import pipe.gui.TAPAALGUI;
import pipe.gui.swingcomponents.EscapableDialog;

public class ObservationListDialog
extends EscapableDialog {
    private final TimedArcPetriNetNetwork tapnNetwork;
    private final List<Observation> observations;

    public ObservationListDialog(TimedArcPetriNetNetwork tapnNetwork, List<Observation> observations) {
        super(TAPAALGUI.getApp(), "Observations", true);
        this.tapnNetwork = tapnNetwork;
        this.observations = observations;
        this.init();
    }

    private void init() {
        this.setSize(500, 350);
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
        JPanel observationPanel = new JPanel();
        observationPanel.setLayout(new GridBagLayout());
        final CheckboxListModel listModel = new CheckboxListModel();
        for (Observation observation : this.observations) {
            listModel.addElement(observation);
        }
        listModel.addListDataListener(new ListDataListener(){
            final /* synthetic */ ObservationListDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                    this.this$0.observations.add(i, (Observation)listModel.getElementAt(i));
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                    this.this$0.observations.remove(i);
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                    this.this$0.observations.set(i, (Observation)listModel.getElementAt(i));
                }
            }
        });
        final JList<Observation> observationList = new JList<Observation>(listModel);
        observationList.setCellRenderer(new CheckboxListRenderer());
        JScrollPane observationScrollPane = new JScrollPane(observationList);
        observationScrollPane.setHorizontalScrollBarPolicy(31);
        observationScrollPane.setPreferredSize(new Dimension(500, observationScrollPane.getPreferredSize().height));
        JButton editButton = new JButton("Edit");
        editButton.setEnabled(false);
        editButton.addActionListener(e -> this.showEditObservationDialog(observationList.getSelectedIndex(), listModel));
        observationList.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ObservationListDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = observationList.locationToIndex(e.getPoint());
                if (index >= 0) {
                    Rectangle bounds = observationList.getCellBounds(index, index);
                    if (bounds != null && e.getX() < bounds.x + 20) {
                        Observation observation = (Observation)listModel.getElementAt(index);
                        listModel.toggleChecked(observation);
                        observationList.repaint();
                    } else if (e.getClickCount() == 2) {
                        this.this$0.showEditObservationDialog(observationList.getSelectedIndex(), listModel);
                    }
                }
            }
        });
        JButton removeButton = new JButton("Remove");
        removeButton.setEnabled(false);
        removeButton.addActionListener(e -> {
            for (Observation observation : observationList.getSelectedValuesList()) {
                listModel.removeElement(observation);
            }
        });
        JButton newButton = new JButton("New");
        newButton.addActionListener(e -> {
            ObservationDialog observationDialog = new ObservationDialog(this.tapnNetwork, listModel);
            observationDialog.setLocationRelativeTo(this);
            observationDialog.setVisible(true);
        });
        observationList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                boolean elemIsSelected = observationList.getSelectedIndex() != -1;
                editButton.setEnabled(elemIsSelected);
                removeButton.setEnabled(elemIsSelected);
            }
        });
        GridBagConstraints observationGbc = new GridBagConstraints();
        observationGbc.gridx = 0;
        observationGbc.gridy = 0;
        observationGbc.weightx = 1.0;
        observationGbc.weighty = 1.0;
        observationGbc.fill = 1;
        observationGbc.gridwidth = 3;
        observationPanel.add((Component)observationScrollPane, observationGbc);
        ++observationGbc.gridy;
        observationGbc.gridwidth = 1;
        observationGbc.fill = 2;
        observationPanel.add((Component)editButton, observationGbc);
        ++observationGbc.gridx;
        observationPanel.add((Component)removeButton, observationGbc);
        ++observationGbc.gridx;
        observationPanel.add((Component)newButton, observationGbc);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.add((Component)observationPanel, gbc);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> this.dispose());
        GridBagConstraints buttonGbc = new GridBagConstraints();
        buttonGbc.gridx = 0;
        buttonGbc.gridy = 0;
        buttonGbc.anchor = 13;
        buttonPanel.add((Component)okButton, buttonGbc);
        ++gbc.gridy;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)buttonPanel, gbc);
        this.pack();
    }

    private void showEditObservationDialog(int selectedIndex, DefaultListModel<Observation> listModel) {
        if (selectedIndex != -1) {
            ObservationDialog observationDialog = new ObservationDialog(this.tapnNetwork, listModel, listModel.get(selectedIndex));
            observationDialog.setLocationRelativeTo(this);
            observationDialog.setVisible(true);
        }
    }

    private static class CheckboxListModel
    extends DefaultListModel<Observation> {
        private final Map<Observation, Boolean> checkMap = new HashMap<Observation, Boolean>();

        private CheckboxListModel() {
        }

        public boolean isChecked(Observation observation) {
            return this.checkMap.getOrDefault(observation, observation.isEnabled());
        }

        public void toggleChecked(Observation observation) {
            boolean currentState = this.isChecked(observation);
            boolean newState = !currentState;
            this.checkMap.put(observation, newState);
            observation.setEnabled(newState);
            int index = this.indexOf(observation);
            if (index >= 0) {
                this.fireContentsChanged(this, index, index);
            }
        }

        @Override
        public void addElement(Observation observation) {
            super.addElement(observation);
            this.checkMap.put(observation, observation.isEnabled());
        }

        @Override
        public boolean removeElement(Object observation) {
            boolean removed = super.removeElement(observation);
            this.checkMap.remove(observation);
            return removed;
        }
    }

    private static class CheckboxListRenderer
    extends JPanel
    implements ListCellRenderer<Observation> {
        private final JCheckBox checkBox;
        private final JLabel label;
        private final EllipsisListCellRenderer ellipsisRenderer;

        public CheckboxListRenderer() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            this.label = new JLabel();
            this.ellipsisRenderer = new EllipsisListCellRenderer();
            this.add((Component)this.checkBox, "West");
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Observation> list, Observation value, int index, boolean isSelected, boolean cellHasFocus) {
            this.ellipsisRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            boolean checked = ((CheckboxListModel)list.getModel()).isChecked(value);
            this.checkBox.setSelected(checked);
            this.setToolTipText("Select the observation to be monitored during SMC execution");
            this.label.setText(value.toString());
            this.label.setToolTipText(this.ellipsisRenderer.getToolTipText());
            this.label.setEnabled(checked);
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.checkBox.setBackground(this.getBackground());
            this.label.setBackground(this.getBackground());
            return this;
        }
    }

    private static class EllipsisListCellRenderer
    extends DefaultListCellRenderer {
        private EllipsisListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int availableWidth;
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            int n = availableWidth = list.getParent() instanceof JViewport ? ((JViewport)list.getParent()).getWidth() - 10 : list.getWidth();
            if (availableWidth <= 0) {
                return this;
            }
            String text = this.getText();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int textWidth = fm.stringWidth(text);
            if (textWidth > availableWidth) {
                String dots = "...";
                int dotsWidth = fm.stringWidth(dots);
                for (int maxChars = text.length(); maxChars > 0; --maxChars) {
                    String truncated = text.substring(0, maxChars);
                    if (fm.stringWidth(truncated) + dotsWidth > availableWidth) continue;
                    this.setText(truncated + dots);
                    this.setToolTipText(text);
                    break;
                }
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

