/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import dk.aau.cs.model.SMC.ObservationParser;
import dk.aau.cs.model.SMC.ParseException;
import dk.aau.cs.model.SMC.TokenMgrError;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.verification.observations.Observation;
import dk.aau.cs.verification.observations.expressions.ObsAdd;
import dk.aau.cs.verification.observations.expressions.ObsConstant;
import dk.aau.cs.verification.observations.expressions.ObsExprPosition;
import dk.aau.cs.verification.observations.expressions.ObsExpression;
import dk.aau.cs.verification.observations.expressions.ObsMultiply;
import dk.aau.cs.verification.observations.expressions.ObsOperator;
import dk.aau.cs.verification.observations.expressions.ObsPlace;
import dk.aau.cs.verification.observations.expressions.ObsPlaceHolder;
import dk.aau.cs.verification.observations.expressions.ObsSubtract;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import net.tapaal.helpers.Enabler;
import net.tapaal.swinghelpers.CustomJSpinner;
import pipe.gui.TAPAALGUI;
import pipe.gui.swingcomponents.EscapableDialog;

public class ObservationDialog
extends EscapableDialog {
    private static final String SHARED = "Shared";
    private static final Pattern namePattern = Pattern.compile("\\w+(?: \\w+)*");
    private final DefaultListModel<Observation> observationModel;
    private final Observation observation;
    private final TimedArcPetriNetNetwork tapnNetwork;
    private final JTextPane expressionField = new JTextPane();
    private final UndoManager undoManager = new UndoManager();
    private JComboBox<Object> templateComboBox;
    private JComboBox<TimedPlace> placeComboBox;
    private JPanel placesPanel;
    private JPanel constantsPanel;
    private JPanel operationsPanel;
    private JButton saveButton;
    private JButton undoButton;
    private JButton redoButton;
    private JButton resetExpression;
    private JButton editExpression;
    private ObsExpression currentExpr;
    private ObsExpression selectedExpr;
    private ObsExpression previousExpr;
    private boolean isNewObservation;
    private boolean isEditing;

    public ObservationDialog(TimedArcPetriNetNetwork tapnNetwork, DefaultListModel<Observation> observationModel, Observation observation) {
        super(TAPAALGUI.getApp(), observation.getName(), true);
        this.tapnNetwork = tapnNetwork;
        this.observationModel = observationModel;
        this.observation = observation;
        this.currentExpr = observation.getExpression();
        this.init();
    }

    public ObservationDialog(TimedArcPetriNetNetwork tapnNetwork, DefaultListModel<Observation> observationModel) {
        this(tapnNetwork, observationModel, new Observation("New Observation"));
        this.isNewObservation = true;
    }

    private void init() {
        this.setSize(1200, 425);
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = 17;
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel("Observation name:");
        JTextField nameField = new JTextField(this.observation.getName(), 25);
        GridBagConstraints nameGbc = new GridBagConstraints();
        nameGbc.gridx = 0;
        nameGbc.gridy = 0;
        nameGbc.anchor = 17;
        nameGbc.insets = new Insets(0, 0, 0, 5);
        namePanel.add((Component)nameLabel, nameGbc);
        ++nameGbc.gridx;
        nameGbc.insets = new Insets(0, 0, 0, 0);
        namePanel.add((Component)nameField, nameGbc);
        this.add((Component)namePanel, gbc);
        StyledDocument doc = this.expressionField.getStyledDocument();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 1);
        StyleConstants.setFontSize(standard, 14);
        doc.setParagraphAttributes(0, 0, standard, true);
        this.expressionField.setText(this.currentExpr.toString());
        this.expressionField.setEditable(false);
        this.expressionField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ObservationDialog.this.updateSelected();
            }
        });
        JScrollPane expressionScrollPane = new JScrollPane(this.expressionField);
        expressionScrollPane.setVerticalScrollBarPolicy(20);
        Dimension d = new Dimension(900, 80);
        expressionScrollPane.setPreferredSize(d);
        expressionScrollPane.setMinimumSize(d);
        this.operationsPanel = new JPanel();
        this.operationsPanel.setLayout(new GridBagLayout());
        this.operationsPanel.setBorder(BorderFactory.createTitledBorder("Operations"));
        JButton plusButton = new JButton("+");
        JButton minusButton = new JButton("-");
        JButton multiplyButton = new JButton("*");
        JButton divideButton = new JButton("/");
        divideButton.setVisible(false);
        plusButton.addActionListener(e -> this.updateExpression(new ObsAdd()));
        minusButton.addActionListener(e -> this.updateExpression(new ObsSubtract()));
        multiplyButton.addActionListener(e -> this.updateExpression(new ObsMultiply()));
        GridBagConstraints operationsGbc = new GridBagConstraints();
        operationsGbc.gridx = 0;
        operationsGbc.gridy = 0;
        operationsGbc.weightx = 1.0;
        operationsGbc.fill = 2;
        operationsGbc.insets = new Insets(0, 10, 0, 10);
        this.operationsPanel.add((Component)plusButton, operationsGbc);
        ++operationsGbc.gridy;
        operationsGbc.insets = new Insets(5, 10, 0, 10);
        this.operationsPanel.add((Component)minusButton, operationsGbc);
        ++operationsGbc.gridy;
        this.operationsPanel.add((Component)multiplyButton, operationsGbc);
        ++operationsGbc.gridy;
        this.operationsPanel.add((Component)divideButton, operationsGbc);
        this.placesPanel = new JPanel();
        this.placesPanel.setLayout(new GridBagLayout());
        this.placesPanel.setBorder(BorderFactory.createTitledBorder("Places"));
        this.templateComboBox = new JComboBox();
        this.tapnNetwork.activeTemplates().forEach(template -> {
            List<TimedPlace> places = template.places();
            long sharedPlaces = places.stream().filter(TimedPlace::isShared).count();
            if (sharedPlaces != (long)places.size() && !template.name().equals(SHARED)) {
                this.templateComboBox.addItem(template);
            }
        });
        if (this.tapnNetwork.sharedPlaces().size() > 0) {
            this.templateComboBox.addItem(SHARED);
        }
        this.placeComboBox = new JComboBox();
        this.templateComboBox.addActionListener(e -> {
            this.placeComboBox.removeAllItems();
            if (this.templateComboBox.getSelectedItem().equals(SHARED)) {
                this.tapnNetwork.sharedPlaces().forEach(place -> this.placeComboBox.addItem((TimedPlace)place));
            } else {
                TimedArcPetriNet template = (TimedArcPetriNet)this.templateComboBox.getSelectedItem();
                template.places().forEach(place -> {
                    if (!place.isShared()) {
                        this.placeComboBox.addItem((TimedPlace)place);
                    }
                });
            }
        });
        if (this.templateComboBox.getItemCount() > 0) {
            this.templateComboBox.setSelectedIndex(0);
        }
        JButton addPlaceButton = new JButton("Add place");
        addPlaceButton.addActionListener(e -> {
            Object template = this.templateComboBox.getSelectedItem();
            TimedPlace place = (TimedPlace)this.placeComboBox.getSelectedItem();
            ObsPlace placeExpr = new ObsPlace(template, place);
            this.updateExpression(placeExpr);
        });
        GridBagConstraints placesGbc = new GridBagConstraints();
        placesGbc.gridx = 0;
        placesGbc.gridy = 0;
        placesGbc.weightx = 1.0;
        placesGbc.fill = 2;
        placesGbc.insets = new Insets(0, 10, 0, 10);
        this.placesPanel.add(this.templateComboBox, placesGbc);
        ++placesGbc.gridy;
        placesGbc.insets = new Insets(5, 10, 0, 10);
        this.placesPanel.add(this.placeComboBox, placesGbc);
        ++placesGbc.gridy;
        this.placesPanel.add((Component)addPlaceButton, placesGbc);
        Enabler.setAllEnabled(this.placesPanel, false);
        this.constantsPanel = new JPanel();
        this.constantsPanel.setLayout(new GridBagLayout());
        this.constantsPanel.setBorder(BorderFactory.createTitledBorder("Constants"));
        CustomJSpinner constantSpinner = new CustomJSpinner(1, 1, Integer.MAX_VALUE);
        JButton addConstantButton = new JButton("Add constant");
        addConstantButton.addActionListener(e -> {
            int value = (Integer)constantSpinner.getValue();
            ObsConstant constantExpr = new ObsConstant(value);
            this.updateExpression(constantExpr);
        });
        GridBagConstraints constantsGbc = new GridBagConstraints();
        constantsGbc.gridx = 0;
        constantsGbc.gridy = 0;
        constantsGbc.weightx = 1.0;
        constantsGbc.fill = 2;
        constantsGbc.insets = new Insets(0, 10, 0, 10);
        this.constantsPanel.add((Component)constantSpinner, constantsGbc);
        ++constantsGbc.gridy;
        constantsGbc.insets = new Insets(5, 10, 0, 10);
        this.constantsPanel.add((Component)addConstantButton, constantsGbc);
        Enabler.setAllEnabled(this.constantsPanel, false);
        JPanel editingPanel = new JPanel();
        editingPanel.setLayout(new GridBagLayout());
        editingPanel.setBorder(BorderFactory.createTitledBorder("Editing"));
        this.undoButton = new JButton("Undo");
        this.redoButton = new JButton("Redo");
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.undoButton.addActionListener(e -> {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
            this.refreshSaveButton();
        });
        this.redoButton.addActionListener(e -> {
            if (this.undoManager.canRedo()) {
                this.undoManager.redo();
            }
            this.refreshSaveButton();
        });
        final JButton deleteSelection = new JButton("Delete Selection");
        deleteSelection.setEnabled(false);
        deleteSelection.addActionListener(e -> {
            String fullText = this.expressionField.getText();
            String selectedText = this.expressionField.getSelectedText();
            if (this.currentExpr.isOperator() && !fullText.equals(selectedText)) {
                ((ObsOperator)this.currentExpr).replace(this.selectedExpr, new ObsPlaceHolder());
            } else {
                this.currentExpr = new ObsPlaceHolder();
            }
            this.expressionField.setText(this.currentExpr.toString());
            this.refreshSaveButton();
        });
        this.expressionField.addCaretListener(new CaretListener(){
            final /* synthetic */ ObservationDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void caretUpdate(CaretEvent e) {
                deleteSelection.setEnabled(this.this$0.expressionField.getSelectedText() != null);
            }
        });
        this.resetExpression = new JButton("Reset Expression");
        this.resetExpression.addActionListener(e -> {
            if (this.isEditing) {
                try {
                    ObsExpression parsedExpr = ObservationParser.parse(this.expressionField.getText(), this.tapnNetwork);
                    this.toggleManualEditing();
                    this.currentExpr = parsedExpr;
                    this.expressionField.setText(this.currentExpr.toString());
                    this.undoManager.addEdit(new ExpressionEdit(new ObsPlaceHolder(), this.currentExpr.deepCopy()));
                    this.refreshUndoRedoButtons();
                    this.refreshSaveButton();
                }
                catch (ParseException | TokenMgrError ex) {
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), ex.getMessage(), "Error during parsing", 0);
                }
            } else {
                ObsExpression oldExpr = this.currentExpr.deepCopy();
                this.currentExpr = new ObsPlaceHolder();
                this.expressionField.setText(this.currentExpr.toString());
                if (!oldExpr.isPlaceHolder()) {
                    this.undoManager.addEdit(new ExpressionEdit(oldExpr, this.currentExpr.deepCopy()));
                    this.refreshUndoRedoButtons();
                }
                this.refreshSaveButton();
            }
        });
        this.editExpression = new JButton("Edit Expression");
        this.editExpression.addActionListener(e -> this.toggleManualEditing());
        GridBagConstraints editingGbc = new GridBagConstraints();
        editingGbc.gridx = 0;
        editingGbc.gridy = 0;
        editingGbc.weightx = 1.0;
        editingGbc.fill = 2;
        editingGbc.insets = new Insets(0, 10, 0, 5);
        editingPanel.add((Component)this.undoButton, editingGbc);
        ++editingGbc.gridx;
        editingGbc.insets = new Insets(0, 0, 0, 10);
        editingPanel.add((Component)this.redoButton, editingGbc);
        editingGbc.gridx = 0;
        ++editingGbc.gridy;
        editingGbc.gridwidth = 2;
        editingGbc.insets = new Insets(5, 10, 0, 10);
        editingPanel.add((Component)deleteSelection, editingGbc);
        ++editingGbc.gridy;
        editingPanel.add((Component)this.resetExpression, editingGbc);
        ++editingGbc.gridy;
        editingPanel.add((Component)this.editExpression, editingGbc);
        JPanel expressionPanel = new JPanel();
        expressionPanel.setLayout(new GridBagLayout());
        expressionPanel.setBorder(BorderFactory.createTitledBorder("Observation Expression"));
        GridBagConstraints expressionGbc = new GridBagConstraints();
        expressionGbc.gridx = 0;
        expressionGbc.gridy = 0;
        expressionGbc.weightx = 1.0;
        expressionGbc.weighty = 1.0;
        expressionGbc.fill = 1;
        expressionGbc.insets = new Insets(0, 30, 0, 30);
        expressionGbc.gridwidth = 4;
        expressionPanel.add((Component)expressionScrollPane, expressionGbc);
        expressionGbc.gridwidth = 1;
        ++expressionGbc.gridy;
        expressionGbc.insets = new Insets(0, 30, 0, 0);
        expressionPanel.add((Component)this.operationsPanel, expressionGbc);
        ++expressionGbc.gridx;
        expressionGbc.insets = new Insets(0, 0, 0, 0);
        expressionPanel.add((Component)this.placesPanel, expressionGbc);
        ++expressionGbc.gridx;
        expressionPanel.add((Component)this.constantsPanel, expressionGbc);
        ++expressionGbc.gridx;
        expressionGbc.insets = new Insets(0, 0, 0, 30);
        expressionPanel.add((Component)editingPanel, expressionGbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        this.add((Component)expressionPanel, gbc);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        JButton cancelButton = new JButton("Cancel");
        this.saveButton = new JButton("Save");
        this.refreshSaveButton();
        cancelButton.addActionListener(e -> this.dispose());
        this.saveButton.addActionListener(e -> {
            nameField.setText(nameField.getText().trim());
            if (!namePattern.matcher(nameField.getText()).matches()) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "\"The specified name is invalid.\nAcceptable names are defined by the regular expression:\n" + String.valueOf(namePattern), "Error", 0);
                nameField.requestFocusInWindow();
                return;
            }
            boolean nameExists = false;
            for (int i = 0; i < this.observationModel.getSize(); ++i) {
                Observation obs = this.observationModel.getElementAt(i);
                if (!obs.getName().equals(nameField.getText()) || obs.equals(this.observation)) continue;
                nameExists = true;
                break;
            }
            if (nameExists) {
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "An observation with the name \"" + this.observation.getName() + "\" already exists.", "Error", 0);
            } else {
                this.observation.setName(nameField.getText());
                this.observation.setExpression(this.currentExpr);
                if (this.isNewObservation) {
                    this.observationModel.addElement(this.observation);
                } else {
                    this.observationModel.setElementAt(this.observation, this.observationModel.indexOf(this.observation));
                }
                this.dispose();
            }
        });
        GridBagConstraints buttonGbc = new GridBagConstraints();
        buttonGbc.gridx = 0;
        buttonGbc.gridy = 0;
        buttonGbc.weightx = 1.0;
        buttonGbc.anchor = 13;
        buttonGbc.insets = new Insets(0, 0, 0, 5);
        buttonPanel.add((Component)cancelButton, buttonGbc);
        buttonGbc.insets = new Insets(0, 0, 0, 0);
        ++buttonGbc.gridx;
        buttonPanel.add((Component)this.saveButton, buttonGbc);
        ++gbc.gridy;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)buttonPanel, gbc);
        this.pack();
        this.updateSelected();
    }

    private void toggleManualEditing() {
        this.isEditing = !this.isEditing;
        Enabler.setAllEnabled(this.operationsPanel, !this.isEditing);
        Enabler.setAllEnabled(this.placesPanel, !this.isEditing);
        Enabler.setAllEnabled(this.constantsPanel, !this.isEditing);
        if (this.isEditing) {
            this.saveButton.setEnabled(false);
            this.previousExpr = this.currentExpr.deepCopy();
            this.resetExpression.setText("Parse Expression");
            this.editExpression.setText("Cancel");
        } else {
            this.refreshSaveButton();
            this.currentExpr = this.previousExpr;
            this.expressionField.setText(this.currentExpr.toString());
            this.resetExpression.setText("Reset Expression");
            this.editExpression.setText("Edit Expression");
        }
        this.expressionField.setEditable(this.isEditing);
    }

    private void updateSelected() {
        if (this.isEditing) {
            return;
        }
        this.expressionField.requestFocusInWindow();
        int pos = this.expressionField.getCaretPosition();
        ObsExprPosition exprPos = this.currentExpr.getObjectPosition(pos - 1);
        this.expressionField.select(exprPos.getStart(), exprPos.getEnd());
        this.selectedExpr = exprPos.getObject();
        if (this.selectedExpr.isPlace()) {
            String[] placeParts = this.selectedExpr.toString().split("\\.");
            String templateName = placeParts[0];
            String placeName = placeParts[1];
            Optional<Object> selectedTemplateOpt = this.tapnNetwork.activeTemplates().stream().filter(t -> t.name().equals(templateName)).findFirst();
            if (!selectedTemplateOpt.isPresent()) {
                selectedTemplateOpt = Optional.of(SHARED);
            }
            TimedArcPetriNet selectedTemplate = selectedTemplateOpt.get();
            this.templateComboBox.setSelectedItem(selectedTemplate);
            if (selectedTemplate.equals(SHARED)) {
                this.placeComboBox.setSelectedItem(this.tapnNetwork.getSharedPlaceByName(placeName));
            } else {
                this.placeComboBox.setSelectedItem(selectedTemplate.getPlaceByName(placeName));
            }
        }
        Enabler.setAllEnabled(this.placesPanel, this.selectedExpr.isLeaf());
        Enabler.setAllEnabled(this.constantsPanel, this.selectedExpr.isLeaf());
    }

    private void updateExpression(ObsExpression newExpr) {
        String fullText = this.expressionField.getText();
        String selectedText = this.expressionField.getSelectedText();
        ObsExpression oldExpr = this.currentExpr.deepCopy();
        if (selectedText != null && this.currentExpr.isOperator() && !fullText.equals(selectedText)) {
            if (newExpr.isOperator()) {
                ((ObsOperator)newExpr).setLeft(this.selectedExpr);
            }
            this.selectedExpr.setParent(newExpr);
            ((ObsOperator)this.currentExpr).replace(this.selectedExpr, newExpr);
        } else {
            if (newExpr.isOperator()) {
                ((ObsOperator)newExpr).setLeft(this.currentExpr);
            }
            this.currentExpr.setParent(newExpr);
            this.currentExpr = newExpr;
        }
        if (!this.currentExpr.toString().equals(oldExpr.toString())) {
            this.expressionField.setText(this.currentExpr.toString());
            this.undoManager.addEdit(new ExpressionEdit(oldExpr, this.currentExpr.deepCopy()));
            this.refreshUndoRedoButtons();
            this.refreshSaveButton();
        }
        ObsExprPosition exprPos = null;
        if (newExpr.isOperator()) {
            ObsOperator newOpLeftOp;
            ObsOperator newOp = (ObsOperator)newExpr;
            ObsExpression newOpLeft = newOp.getLeft();
            ObsExpression newOpRight = newOp.getRight();
            exprPos = newOpLeft.isOperator() ? ((newOpLeftOp = (ObsOperator)newOpLeft).getRight().isPlaceHolder() ? this.currentExpr.getObjectPosition(newOpLeftOp.getRight()) : this.currentExpr.getObjectPosition(newOpRight)) : (newOpLeft.isPlaceHolder() ? this.currentExpr.getObjectPosition(newOpLeft) : this.currentExpr.getObjectPosition(newOpRight));
        } else {
            ObsExpression parentOp = newExpr.getParent();
            if (parentOp != null) {
                ObsExpression rightExpr = ((ObsOperator)parentOp).getRight();
                if (rightExpr.isPlaceHolder()) {
                    exprPos = this.currentExpr.getObjectPosition(rightExpr);
                } else {
                    ObsExpression grandParentOp = parentOp.getParent();
                    if (grandParentOp != null) {
                        rightExpr = ((ObsOperator)grandParentOp).getRight();
                        exprPos = this.currentExpr.getObjectPosition(rightExpr);
                    }
                }
            }
        }
        if (exprPos != null) {
            this.expressionField.requestFocusInWindow();
            this.expressionField.select(exprPos.getStart(), exprPos.getEnd());
            this.updateSelected();
        }
    }

    private void refreshUndoRedoButtons() {
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
    }

    private boolean includesPlaceHolder() {
        return this.currentExpr.toString().contains(new ObsPlaceHolder().toString());
    }

    private void refreshSaveButton() {
        this.saveButton.setEnabled(!this.includesPlaceHolder());
    }

    private class ExpressionEdit
    extends AbstractUndoableEdit {
        private final ObsExpression oldExpr;
        private final ObsExpression newExpr;

        public ExpressionEdit(ObsExpression oldExpr, ObsExpression newExpr) {
            this.oldExpr = oldExpr;
            this.newExpr = newExpr;
        }

        @Override
        public void undo() {
            super.undo();
            ObservationDialog.this.currentExpr = this.oldExpr;
            ObservationDialog.this.expressionField.setText(ObservationDialog.this.currentExpr.toString());
            ObservationDialog.this.refreshUndoRedoButtons();
        }

        @Override
        public void redo() {
            super.redo();
            ObservationDialog.this.currentExpr = this.newExpr;
            ObservationDialog.this.expressionField.setText(ObservationDialog.this.currentExpr.toString());
            ObservationDialog.this.refreshUndoRedoButtons();
        }
    }
}

