/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import dk.aau.cs.io.LoadedModel;
import dk.aau.cs.io.ModelLoader;
import dk.aau.cs.io.PNMLWriter;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.util.StringComparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.dialog.ExportBatchResultTableModel;
import net.tapaal.gui.petrinet.dialog.FileNameCellRenderer;
import net.tapaal.gui.petrinet.undo.AddFileExportBatchCommand;
import net.tapaal.gui.petrinet.undo.RemoveFileExportBatchCommand;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import org.w3c.dom.DOMException;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.Export;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.undo.UndoManager;
import pipe.gui.swingcomponents.filebrowser.FileBrowser;

public class ExportBatchDialog
extends JDialog {
    private static final String TOOL_TIP_AddFilesButton = "Press to add nets to batch export";
    private static final String TOOL_TIP_RemoveFilesButton = "Press to remove the currently selected nets";
    private static final String TOOL_TIP_ClearFilesButton = "Press to remove all nets from list";
    private static final String TOOL_TIP_ExportFilesButton = "Press to export all nets in the selected format";
    private static final String TOOL_TIP_SelectedEngineComboBox = "Select the engine in which the format of the net should be compatible with";
    private static final String TOOL_TIP_UniqueQueryNamesCheckbox = "Give queries unique names when exporting";
    private static final String NAME_SuccesString = "Succeeded";
    private static final String NAME_SuccesStringOrphanTransitionsRemoved = "Succeeded, orphan transitions removed";
    private static final String NAME_FailStringFolderExists = "Failed as the subfolder already exists";
    private static final String NAME_FailStringParseError = "Failed due to net/query parsing error";
    private JPanel filesButtonsPanel;
    private JPanel mainPanel;
    private JButton addFilesButton;
    private JButton clearFilesButton;
    private JButton removeFileButton;
    private JButton exportFilesButton;
    private JPanel chooserPanel;
    private JTextField destinationPathField;
    private JList<File> fileList;
    private DefaultListModel<File> listModel;
    private final List<File> files = new ArrayList<File>();
    private String lastExportPath;
    private String lastSelectPath;
    private JCheckBox uniqueQueryNames;
    private JComboBox selectedEngine;
    private File destinationFile;
    private ExportBatchResultTableModel tableModel;
    private Thread progressBarThread;
    private JProgressBar progressBar;
    private JDialog progressBarContainer;
    static boolean noOrphanTransitions = false;
    private final UndoManager undoManager = new UndoManager(null);
    static ExportBatchDialog exportBatchDialog;
    final ModelLoader loader = new ModelLoader();

    public static boolean isDialogVisible() {
        if (exportBatchDialog != null) {
            return exportBatchDialog.isVisible();
        }
        return false;
    }

    public static void setNoOrphanTransitions(boolean value) {
        noOrphanTransitions = value;
    }

    public static void ShowExportBatchDialog() {
        if (exportBatchDialog == null) {
            exportBatchDialog = new ExportBatchDialog(TAPAALGUI.getApp(), "Batch Export", true);
            exportBatchDialog.pack();
            exportBatchDialog.setPreferredSize(exportBatchDialog.getSize());
            exportBatchDialog.setMinimumSize(new Dimension(exportBatchDialog.getWidth(), exportBatchDialog.getHeight()));
            exportBatchDialog.setLocationRelativeTo(null);
            exportBatchDialog.setResizable(true);
        }
        exportBatchDialog.setVisible(true);
    }

    private ExportBatchDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.initComponents();
        this.makeShortcuts();
    }

    private void initComponents() {
        this.setLayout(new FlowLayout());
        this.mainPanel = new JPanel(new GridBagLayout());
        this.initFileList();
        this.initChooserPanel();
        this.initProgressPanel();
        this.setContentPane(this.mainPanel);
    }

    private void initProgressPanel() {
        JPanel resultPanel = new JPanel(new GridBagLayout());
        resultPanel.setBorder(BorderFactory.createTitledBorder("Exported Files"));
        this.tableModel = new ExportBatchResultTableModel();
        JTable resultTable = new JTable(this.tableModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point point = e.getPoint();
                int rowIndex = this.rowAtPoint(point);
                int colIndex = this.columnAtPoint(point);
                try {
                    tip = this.getValueAt(rowIndex, colIndex).toString();
                }
                catch (RuntimeException e1) {
                    tip = "";
                }
                return tip;
            }
        };
        resultTable.getColumn("Status").setCellRenderer(new ExportResultTableCellRenderer(true));
        resultTable.getColumn("Destination").setCellRenderer(new ExportResultTableCellRenderer(true));
        StringComparator comparator = new StringComparator();
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(resultTable.getModel());
        for (int i = 0; i < resultTable.getColumnCount(); ++i) {
            sorter.setComparator(i, comparator);
        }
        resultTable.setRowSorter(sorter);
        JScrollPane scrollPane = new JScrollPane(resultTable);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        resultPanel.add((Component)scrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 10, 5);
        gbc.anchor = 18;
        this.mainPanel.add((Component)resultPanel, gbc);
    }

    private void initChooserPanel() {
        this.chooserPanel = new JPanel(new GridBagLayout());
        this.chooserPanel.setBorder(BorderFactory.createTitledBorder("Export to destination"));
        this.destinationPathField = new JTextField("", 30);
        this.destinationPathField.setEditable(true);
        this.destinationPathField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportBatchDialog.this.textFieldChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportBatchDialog.this.textFieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportBatchDialog.this.textFieldChanged();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        this.chooserPanel.add((Component)this.destinationPathField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 10, 0, 0);
        JButton destinationPathSelector = new JButton("Select destination folder");
        destinationPathSelector.addActionListener(e -> {
            this.selectDestinationPath();
            if (this.destinationFile != null) {
                this.destinationPathField.setText(this.lastExportPath);
            }
            this.enableButtons();
        });
        this.chooserPanel.add((Component)destinationPathSelector, gbc);
        String[] options = new String[]{"PNML and XML queries (verifypn)", "Continuous Engine model and queries (verifytapn)", "Discrete Engine model and queries (verifydtapn)"};
        this.selectedEngine = new JComboBox<String>(options);
        this.selectedEngine.setToolTipText(TOOL_TIP_SelectedEngineComboBox);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 0, 0, 0);
        this.chooserPanel.add((Component)this.selectedEngine, gbc);
        this.uniqueQueryNames = new JCheckBox("Use unique query names", true);
        this.uniqueQueryNames.setToolTipText(TOOL_TIP_UniqueQueryNamesCheckbox);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 0, 0, 0);
        this.chooserPanel.add((Component)this.uniqueQueryNames, gbc);
        this.exportFilesButton = new JButton("Export All Nets and Queries");
        this.exportFilesButton.setToolTipText(TOOL_TIP_ExportFilesButton);
        this.exportFilesButton.setEnabled(false);
        this.exportFilesButton.addActionListener(e -> {
            this.tableModel.clear();
            this.exportFiles();
            this.enableButtons();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 0, 0);
        this.chooserPanel.add((Component)this.exportFilesButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(10, 0, 10, 5);
        gbc.fill = 2;
        gbc.anchor = 18;
        this.mainPanel.add((Component)this.chooserPanel, gbc);
    }

    private void initFileList() {
        JPanel fileListPanel = new JPanel(new GridBagLayout());
        fileListPanel.setBorder(BorderFactory.createTitledBorder("Files"));
        this.listModel = new DefaultListModel();
        this.fileList = new JList<File>(this.listModel);
        this.fileList.setSelectionMode(2);
        this.fileList.setSelectedIndex(0);
        this.fileList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ExportBatchDialog.this.removeSelectedFiles();
                }
            }
        });
        this.fileList.setCellRenderer(new FileNameCellRenderer());
        GridBagConstraints gbc = new GridBagConstraints();
        JScrollPane scrollpane = new JScrollPane(this.fileList);
        scrollpane.setMinimumSize(new Dimension(175, 375));
        scrollpane.setPreferredSize(new Dimension(250, 375));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 10, 0);
        fileListPanel.add((Component)scrollpane, gbc);
        this.filesButtonsPanel = new JPanel(new GridBagLayout());
        this.addFilesButton = new JButton("Add models");
        this.addFilesButton.setToolTipText(TOOL_TIP_AddFilesButton);
        this.addFilesButton.addActionListener(arg0 -> {
            this.addFiles();
            this.enableButtons();
        });
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.filesButtonsPanel.add((Component)this.addFilesButton, gbc);
        this.removeFileButton = new JButton("Remove models");
        this.removeFileButton.setToolTipText(TOOL_TIP_RemoveFilesButton);
        this.removeFileButton.setEnabled(false);
        this.removeFileButton.addActionListener(arg0 -> {
            this.removeSelectedFiles();
            this.enableButtons();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.filesButtonsPanel.add((Component)this.removeFileButton, gbc);
        this.clearFilesButton = new JButton("Clear");
        this.clearFilesButton.setToolTipText(TOOL_TIP_ClearFilesButton);
        this.clearFilesButton.setEnabled(false);
        this.clearFilesButton.addActionListener(e -> {
            this.clearFiles();
            this.enableButtons();
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.filesButtonsPanel.add((Component)this.clearFilesButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.anchor = 12;
        fileListPanel.add((Component)this.filesButtonsPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 12;
        gbc.gridheight = 2;
        gbc.insets = new Insets(10, 5, 10, 5);
        this.mainPanel.add((Component)fileListPanel, gbc);
    }

    private void initProgressBar() {
        this.progressBarContainer = new JDialog(exportBatchDialog, "Exporting...", true);
        this.progressBar = new JProgressBar(0, this.fileList.getModel().getSize());
        this.progressBarContainer.add("Center", this.progressBar);
        this.progressBarContainer.setDefaultCloseOperation(0);
        this.progressBarContainer.setSize(400, 100);
        this.progressBarContainer.setLocationRelativeTo(exportBatchDialog);
        this.progressBarContainer.setVisible(false);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Exported Nets: 0 of " + this.fileList.getModel().getSize());
        this.progressBar.setValue(0);
        this.progressBarThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ExportBatchDialog.this.progressBarContainer.setVisible(true);
            }
        });
    }

    private void addFiles() {
        FileBrowser browser = FileBrowser.constructor("Timed-Arc Petri Nets", "tapn", "xml", this.lastSelectPath);
        File[] filesArray = browser.openFiles();
        if (filesArray.length > 0) {
            this.undoManager.newEdit();
            for (File file : filesArray) {
                this.lastSelectPath = file.getParent();
                if (this.files.contains(file)) continue;
                AddFileExportBatchCommand c = new AddFileExportBatchCommand(this.listModel, file, this.files, this);
                c.redo();
                this.undoManager.addEdit(c);
            }
        }
    }

    private void removeSelectedFiles() {
        this.undoManager.newEdit();
        Iterator<File> iterator = this.fileList.getSelectedValuesList().iterator();
        while (iterator.hasNext()) {
            File o;
            File file = o = iterator.next();
            RemoveFileExportBatchCommand c = new RemoveFileExportBatchCommand(this.listModel, file, this.files, this);
            c.redo();
            this.undoManager.addEdit(c);
        }
    }

    public void enableButtons() {
        this.fileList.setEnabled(true);
        this.uniqueQueryNames.setEnabled(true);
        this.addFilesButton.setEnabled(true);
        if (this.listModel.size() > 0) {
            this.clearFilesButton.setEnabled(true);
            this.removeFileButton.setEnabled(true);
        } else {
            this.clearFilesButton.setEnabled(false);
            this.removeFileButton.setEnabled(false);
        }
        if (this.listModel.size() > 0 && this.destinationFile != null && new File(this.destinationPathField.getText()).exists()) {
            this.exportFilesButton.setEnabled(true);
        } else {
            this.exportFilesButton.setEnabled(false);
        }
    }

    private void clearFiles() {
        this.undoManager.newEdit();
        for (Object o : this.listModel.toArray()) {
            File file = (File)o;
            RemoveFileExportBatchCommand c = new RemoveFileExportBatchCommand(this.listModel, file, this.files, this);
            c.redo();
            this.undoManager.addEdit(c);
        }
    }

    private void selectDestinationPath() {
        File chosenFile = FileBrowser.constructor("Select an export folder", ".", this.lastExportPath).saveFileToDir();
        if (chosenFile == null) {
            return;
        }
        this.destinationFile = chosenFile;
        this.lastExportPath = this.destinationFile.getAbsolutePath();
    }

    private void exportFiles() {
        this.initProgressBar();
        if (this.destinationFile != null && this.destinationFile.exists()) {
            String destPath;
            this.lastExportPath = destPath = this.destinationFile.isDirectory() ? this.destinationFile.getAbsolutePath() : this.destinationFile.getParent();
            this.progressBarThread.start();
            for (File file : this.files) {
                Path path = Paths.get(destPath + "/" + file.getName().replaceAll(".xml", "").replaceAll(".tapn", ""), new String[0]);
                try {
                    if (!Files.exists(path, new LinkOption[0])) {
                        String[] stringArray;
                        Files.createDirectories(path, new FileAttribute[0]);
                        this.exportModel(file, path);
                        if (!noOrphanTransitions) {
                            String[] stringArray2 = new String[3];
                            stringArray2[0] = file.getName();
                            stringArray2[1] = path.toString();
                            stringArray = stringArray2;
                            stringArray2[2] = NAME_SuccesString;
                        } else {
                            String[] stringArray3 = new String[3];
                            stringArray3[0] = file.getName();
                            stringArray3[1] = path.toString();
                            stringArray = stringArray3;
                            stringArray3[2] = NAME_SuccesStringOrphanTransitionsRemoved;
                        }
                        this.tableModel.addResult(stringArray);
                    } else {
                        this.tableModel.addResult(new String[]{file.getName(), path.toString(), NAME_FailStringFolderExists});
                    }
                }
                catch (Exception e) {
                    this.tableModel.addResult(new String[]{file.getName(), path.toString(), NAME_FailStringParseError});
                }
                this.progressBar.setString("Exported Nets: " + this.files.indexOf(file) + " of " + this.files.size());
                this.progressBar.setValue(this.files.indexOf(file));
                this.progressBar.paintImmediately(new Rectangle(0, 0, this.progressBar.getWidth(), this.progressBar.getHeight()));
                noOrphanTransitions = false;
                if (this.progressBar.getValue() != this.files.size() - 1) continue;
                this.progressBarContainer.setVisible(false);
                this.progressBar.setValue(0);
            }
        } else if (this.destinationFile == null) {
            new MessengerImpl().displayErrorMessage("Please choose a folder for exporting");
        } else if (!this.destinationFile.exists()) {
            new MessengerImpl().displayErrorMessage("The chosen path does not exist");
        }
    }

    public void textFieldChanged() {
        this.destinationFile = new File(this.destinationPathField.getText());
        this.enableButtons();
    }

    private void exportModel(File file, Path path) throws Exception {
        LoadedModel loadedModel = this.loader.load(file);
        Collection<TAPNQuery> queries = this.uniqueQueryNames.isSelected() ? this.renameQueries(file.getName(), loadedModel.queries()) : loadedModel.queries();
        switch (this.selectedEngine.getSelectedIndex()) {
            case 0: {
                this.exportPNML(path, loadedModel);
                Export.toQueryXML(loadedModel.network(), String.valueOf(path) + "/query.xml", queries, null);
                break;
            }
            case 1: {
                Export.toVerifyTAPN(loadedModel.network(), queries, path.toString() + "/model.xml", String.valueOf(path) + "/query", false);
                break;
            }
            case 2: {
                Export.toVerifyTAPN(loadedModel.network(), queries, path.toString() + "/model.xml", String.valueOf(path) + "/query", true);
            }
        }
    }

    private void exportPNML(Path path, LoadedModel loadedModel) throws DOMException, IOException, ParserConfigurationException, TransformerException {
        File f = new File(path.toString() + "/model.pnml");
        HashMap<TimedArcPetriNet, DataLayer> guiModel = new HashMap<TimedArcPetriNet, DataLayer>();
        for (Template template : loadedModel.templates()) {
            guiModel.put(template.model(), template.guiModel());
        }
        PNMLWriter pnmlWriter = new PNMLWriter(loadedModel.network(), guiModel, null);
        pnmlWriter.savePNML(f);
    }

    private Collection<TAPNQuery> renameQueries(String fileName, Collection<TAPNQuery> queries) {
        ArrayList<TAPNQuery> renamedQueries = new ArrayList<TAPNQuery>();
        int index = 1;
        Iterator<TAPNQuery> iterator = queries.iterator();
        while (iterator.hasNext()) {
            TAPNQuery query;
            TAPNQuery copy = query = iterator.next();
            copy.setName((fileName.replaceAll(".xml", "") + "." + query.getName() + "-" + index).replaceAll(" ", "_").replaceAll(".tapn", ""));
            renamedQueries.add(copy);
            ++index;
        }
        return renamedQueries;
    }

    private void makeShortcuts() {
        int shortcutkey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ActionMap am = this.mainPanel.getActionMap();
        am.put("undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportBatchDialog.this.undoManager.undo();
            }
        });
        am.put("redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportBatchDialog.this.undoManager.redo();
            }
        });
        InputMap im = this.mainPanel.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(90, shortcutkey), "undo");
        im.put(KeyStroke.getKeyStroke(89, shortcutkey), "redo");
    }

    private static class ExportResultTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ExportResultTableCellRenderer(boolean isBordered) {
            this.isBordered = isBordered;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.isBordered) {
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(table.getSelectionForeground());
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    boolean isResultColumn = table.getColumnName(column).equals("Status");
                    if (value != null) {
                        if (isResultColumn && value.toString().equals(ExportBatchDialog.NAME_SuccesString) || value.toString().equals(ExportBatchDialog.NAME_SuccesStringOrphanTransitionsRemoved)) {
                            this.setBackground(new Color(91, 255, 91));
                        } else if (isResultColumn && value.toString().equals(ExportBatchDialog.NAME_FailStringParseError)) {
                            this.setBackground(new Color(255, 91, 91));
                        } else if (isResultColumn && value.toString().equals(ExportBatchDialog.NAME_FailStringFolderExists)) {
                            this.setBackground(new Color(255, 255, 120));
                        } else {
                            this.setBackground(table.getBackground());
                        }
                    }
                    this.setForeground(table.getForeground());
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            this.setEnabled(table.isEnabled());
            this.setFont(table.getFont());
            this.setOpaque(true);
            if (value != null) {
                if (table.getColumnName(column).equals("Destination")) {
                    this.setText(".../" + new File(value.toString()).getName());
                    Point mousePos = table.getMousePosition();
                    String[] result = null;
                    if (mousePos != null) {
                        result = ((ExportBatchResultTableModel)table.getModel()).getResult(table.rowAtPoint(mousePos));
                    }
                    this.setToolTipText(result != null ? this.generateDestinationTooltip(result) : value.toString());
                } else {
                    this.setToolTipText(value.toString());
                    this.setText(value.toString());
                }
            } else {
                this.setToolTipText("");
                this.setText("");
            }
            return this;
        }

        private String generateDestinationTooltip(String[] result) {
            return result[1];
        }
    }
}

