/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public class DocumentFilters
extends DocumentFilter {
    private static final String INT_REGEX = "^\\d*$";
    private static final String DOUBLE_REGEX = "^\\d*\\.?\\d*$";

    public static DocumentFilter createIntegerFilter(int maxLength) {
        return DocumentFilters.createFilter(INT_REGEX, maxLength);
    }

    public static DocumentFilter createDoubleFilter(int maxLength) {
        return DocumentFilters.createFilter(DOUBLE_REGEX, maxLength);
    }

    private static DocumentFilter createFilter(final String regex, final int maxLength) {
        return new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                if (string == null) {
                    return;
                }
                String newValue = new StringBuilder(fb.getDocument().getText(0, fb.getDocument().getLength())).insert(offset, string).toString();
                if (newValue.matches(regex) && newValue.length() <= maxLength) {
                    super.insertString(fb, offset, string, attr);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                if (text == null) {
                    return;
                }
                String newValue = new StringBuilder(fb.getDocument().getText(0, fb.getDocument().getLength())).replace(offset, offset + length, text).toString();
                if (newValue.matches(regex) && newValue.length() <= maxLength) {
                    super.replace(fb, offset, length, text, attrs);
                }
            }
        };
    }

    public static void applyIntegerFilter(JTextField textField, int maxLength) {
        ((PlainDocument)textField.getDocument()).setDocumentFilter(DocumentFilters.createIntegerFilter(maxLength));
    }

    public static void applyDoubleFilter(JTextField textField, int maxLength) {
        ((PlainDocument)textField.getDocument()).setDocumentFilter(DocumentFilters.createDoubleFilter(maxLength));
    }

    public static void applyIntegerFilter(JTextField textField) {
        DocumentFilters.applyIntegerFilter(textField, 9);
    }

    public static void applyDoubleFilter(JTextField textField) {
        DocumentFilters.applyDoubleFilter(textField, 9);
    }
}

