/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.dialog;

import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.util.Require;
import dk.aau.cs.verification.batchProcessing.BatchProcessingVerificationResult;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class BatchProcessingResultsTableModel
extends AbstractTableModel {
    private final String[] HEADINGS = new String[]{"Option", "Model", "Query", "Result", "Verification Time", "Memory Usage"};
    private final List<BatchProcessingVerificationResult> results = new ArrayList<BatchProcessingVerificationResult>();

    public void addResult(BatchProcessingVerificationResult result) {
        int lastRow = this.results.size();
        this.results.add(result);
        this.fireTableRowsInserted(lastRow, lastRow);
    }

    @Override
    public String getColumnName(int column) {
        return this.HEADINGS[column];
    }

    @Override
    public int getColumnCount() {
        return this.HEADINGS.length;
    }

    @Override
    public int getRowCount() {
        return this.results.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.results.size()) {
            return null;
        }
        BatchProcessingVerificationResult result = this.results.get(row);
        switch (col) {
            case 0: {
                return result.getOptionNumber() == -1 ? this.getVerificationAcronym(result) : Integer.valueOf(result.getOptionNumber());
            }
            case 1: {
                return result.modelFile();
            }
            case 2: {
                return result.query();
            }
            case 3: {
                return result.verificationResult();
            }
            case 4: {
                return (double)result.verificationTimeInMs() / 1000.0 + " s";
            }
            case 5: {
                return result.verificationMemory();
            }
        }
        return null;
    }

    private String getVerificationAcronym(BatchProcessingVerificationResult result) {
        if (result.query() == null) {
            return "";
        }
        ReductionOption reduction = result.query().getReductionOption();
        if (reduction == ReductionOption.VerifyTAPN) {
            if (!result.query().discreteInclusion()) {
                return "A";
            }
            return "B";
        }
        if (reduction == ReductionOption.VerifyDTAPN) {
            if (result.query().useTimeDarts() && result.query().usePTrie()) {
                return "C";
            }
            if (result.query().useTimeDarts()) {
                return "D";
            }
            if (result.query().usePTrie()) {
                return "E";
            }
            return "F";
        }
        if (reduction == ReductionOption.COMBI) {
            return "G";
        }
        if (reduction == ReductionOption.STANDARD) {
            return "H";
        }
        if (reduction == ReductionOption.OPTIMIZEDSTANDARD) {
            return "I";
        }
        if (reduction == ReductionOption.BROADCAST) {
            return "J";
        }
        if (reduction == ReductionOption.DEGREE2BROADCAST) {
            return "K";
        }
        if (reduction == ReductionOption.VerifyPN || reduction == ReductionOption.VerifyPNApprox || reduction == ReductionOption.VerifyPNReduce) {
            return "L";
        }
        return "";
    }

    public void clear() {
        this.results.clear();
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Object t = this.getValueAt(0, c);
        if (t == null) {
            return Object.class;
        }
        return t.getClass();
    }

    public Iterable<BatchProcessingVerificationResult> getResults() {
        return this.results;
    }

    public BatchProcessingVerificationResult getResult(int index) {
        Require.that(index >= 0 && index < this.results.size(), "Index out of range");
        return this.results.get(index);
    }
}

