/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.animation;

import dk.aau.cs.model.tapn.simulation.DelayMode;
import dk.aau.cs.model.tapn.simulation.ManualDelayMode;
import dk.aau.cs.model.tapn.simulation.RandomDelayMode;
import dk.aau.cs.model.tapn.simulation.ShortestDelayMode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class DelayEnabledTransitionControl
extends JPanel {
    private static DelayMode defaultDelayMode = ShortestDelayMode.getInstance();
    private static BigDecimal defaultGranularity = new BigDecimal("0.1");
    private final JLabel precitionLabel;
    private final JSlider delayEnabledPrecision = new JSlider(0, 0, 5, 4);
    private final JLabel delayModeLabel;
    private final JComboBox<DelayMode> delayMode;
    private static DelayEnabledTransitionControl instance;

    private DelayEnabledTransitionControl() {
        super(new GridBagLayout());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel("0.00001"));
        labelTable.put(1, new JLabel("0.0001"));
        labelTable.put(2, new JLabel("0.001"));
        labelTable.put(3, new JLabel("0.01"));
        labelTable.put(4, new JLabel("0.1"));
        labelTable.put(5, new JLabel("1"));
        this.delayEnabledPrecision.setLabelTable(labelTable);
        this.delayEnabledPrecision.setSnapToTicks(true);
        this.delayEnabledPrecision.setMajorTickSpacing(1);
        this.delayEnabledPrecision.setPaintLabels(true);
        this.delayEnabledPrecision.setPaintTicks(true);
        this.delayEnabledPrecision.setPaintTrack(false);
        this.delayEnabledPrecision.setPreferredSize(new Dimension(340, this.delayEnabledPrecision.getPreferredSize().height));
        this.setValue(defaultGranularity);
        DelayMode[] items = new DelayMode[]{ShortestDelayMode.getInstance(), RandomDelayMode.getInstance(), ManualDelayMode.getInstance()};
        this.delayMode = new JComboBox<DelayMode>(items);
        this.setDelayMode(defaultDelayMode);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.precitionLabel = new JLabel("Set the delay granularity");
        this.add((Component)this.precitionLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.delayEnabledPrecision, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.delayModeLabel = new JLabel("Delay Mode:");
        this.add((Component)this.delayModeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.add(this.delayMode, gbc);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Delay controller"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
    }

    private int getValueFromDecimal(BigDecimal decimal) {
        if (new BigDecimal("0.00001").compareTo(decimal) == 0) {
            return 0;
        }
        if (new BigDecimal("0.0001").compareTo(decimal) == 0) {
            return 1;
        }
        if (new BigDecimal("0.001").compareTo(decimal) == 0) {
            return 2;
        }
        if (new BigDecimal("0.01").compareTo(decimal) == 0) {
            return 3;
        }
        if (new BigDecimal("0.1").compareTo(decimal) == 0) {
            return 4;
        }
        if (new BigDecimal("1").compareTo(decimal) == 0) {
            return 5;
        }
        return 4;
    }

    public BigDecimal getValue() {
        return new BigDecimal(1.0 / Math.pow(10.0, 5.0 - (double)this.delayEnabledPrecision.getValue()), new MathContext(9));
    }

    public void setValue(BigDecimal value) {
        this.delayEnabledPrecision.setValue(this.getValueFromDecimal(value));
    }

    public DelayMode getDelayMode() {
        return (DelayMode)this.delayMode.getSelectedItem();
    }

    public void setDelayMode(DelayMode delayMode) {
        this.delayMode.setSelectedItem(delayMode);
    }

    public static DelayEnabledTransitionControl getInstance() {
        if (instance == null) {
            instance = new DelayEnabledTransitionControl();
        }
        return instance;
    }

    public static void setDefaultDelayMode(DelayMode delayMode) {
        defaultDelayMode = delayMode;
    }

    public static DelayMode getDefaultDelayMode() {
        if (instance != null) {
            return DelayEnabledTransitionControl.getInstance().getDelayMode();
        }
        return defaultDelayMode;
    }

    public static void setDefaultGranularity(BigDecimal granularity) {
        defaultGranularity = granularity;
    }

    public static BigDecimal getDefaultGranularity() {
        if (instance != null) {
            return DelayEnabledTransitionControl.getInstance().getValue();
        }
        return defaultGranularity;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.precitionLabel.setEnabled(enabled);
        this.delayEnabledPrecision.setEnabled(enabled);
        this.delayModeLabel.setEnabled(enabled);
        this.delayMode.setEnabled(enabled);
    }
}

