/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet.animation;

import dk.aau.cs.model.tapn.TimedToken;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ArcTokenSelector
extends JPanel {
    final String placeName;
    final HashMap<JCheckBox, TimedToken> checkboxToToken = new HashMap();
    int missingToSelect;
    final JLabel informationLabel;
    final ArrayList<ArcTokenSelectorListener> listeners = new ArrayList();

    public ArcTokenSelector(String placeName, List<TimedToken> elligibleTokens, int weight) {
        super(new GridLayout(0, 1));
        this.placeName = placeName;
        this.missingToSelect = weight;
        this.informationLabel = new JLabel();
        this.updateInformationLabel();
        this.setBorder(BorderFactory.createTitledBorder("Place " + placeName));
        for (TimedToken token : elligibleTokens) {
            JCheckBox checkBox = new JCheckBox(token.toString());
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    ArcTokenSelector.this.missingToSelect = ((JCheckBox)arg0.getSource()).isSelected() ? --ArcTokenSelector.this.missingToSelect : ++ArcTokenSelector.this.missingToSelect;
                    ArcTokenSelector.this.updateInformationLabel();
                    ArcTokenSelector.this.notifyListeners();
                }
            });
            if (weight == elligibleTokens.size()) {
                checkBox.setSelected(true);
            }
            this.add(checkBox);
            this.checkboxToToken.put(checkBox, token);
        }
        this.add(this.informationLabel);
        if (weight == elligibleTokens.size()) {
            this.setEnabled(false);
        }
    }

    private void updateInformationLabel() {
        this.informationLabel.setText("Remaining to select " + this.missingToSelect + " tokens");
    }

    public List<TimedToken> getSelected() {
        ArrayList<TimedToken> result = new ArrayList<TimedToken>();
        for (Map.Entry<JCheckBox, TimedToken> entry : this.checkboxToToken.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public boolean allChosen() {
        return this.missingToSelect == 0;
    }

    public void addArcTokenSelectorListener(ArcTokenSelectorListener listener) {
        this.listeners.add(listener);
    }

    public void removeArcTokenSelectorListener(ArcTokenSelectorListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        for (ArcTokenSelectorListener listener : this.listeners) {
            listener.arcTokenSelectorActionPreformed(new ArcTokenSelectorListenerEvent(this));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    public static interface ArcTokenSelectorListener {
        public void arcTokenSelectorActionPreformed(ArcTokenSelectorListenerEvent var1);
    }

    public static class ArcTokenSelectorListenerEvent {
        private final ArcTokenSelector source;

        public ArcTokenSelectorListenerEvent(ArcTokenSelector source) {
            this.source = source;
        }

        ArcTokenSelector getSource() {
            return this.source;
        }
    }
}

