/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet;

import com.sun.jna.Platform;
import dk.aau.cs.TCTL.LTLFNode;
import dk.aau.cs.TCTL.LTLGNode;
import dk.aau.cs.TCTL.StringPosition;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.TCTLAndListNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.TCTL.TCTLNotNode;
import dk.aau.cs.TCTL.TCTLOrListNode;
import dk.aau.cs.TCTL.TCTLStatePlaceHolder;
import dk.aau.cs.TCTL.visitors.RenameAllPlacesVisitor;
import dk.aau.cs.TCTL.visitors.RenameAllTransitionsVisitor;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.CPN.Expressions.AddExpression;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.DotConstantExpression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.IntWeight;
import dk.aau.cs.model.tapn.SMCDistribution;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.SMCSettings;
import dk.aau.cs.verification.VerificationOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyPN;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.smartdraw.SmartDrawDialog;
import net.tapaal.gui.petrinet.verification.RunningVerificationDialog;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.verification.UnfoldNet;
import pipe.gui.FileFinder;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.ArcPath;
import pipe.gui.petrinet.graphicElements.ArcPathPoint;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;

public class TabTransformer {
    /*
     * Could not resolve type clashes
     */
    public static void removeTimingInformation(PetriNetTab tab) {
        for (Template template : tab.allTemplates()) {
            ArrayList<TimedOutputArcComponent> transportArcComponents = new ArrayList<TimedOutputArcComponent>();
            for (TimedPlace place : template.model().places()) {
                place.setInvariant(TimeInvariant.LESS_THAN_INFINITY);
                place.getCtiList().clear();
            }
            for (TimedTransition transition : template.model().transitions()) {
                transition.setUrgent(false);
            }
            for (Iterator<Object> arc : template.guiModel().getArcs()) {
                TimedOutputArcComponent arcComp;
                if (arc instanceof TimedInputArcComponent && !(arc instanceof TimedTransportArcComponent) && !(arc instanceof TimedInhibitorArcComponent)) {
                    arcComp = (TimedInputArcComponent)((Object)arc);
                    ((TimedInputArcComponent)arcComp).underlyingTimedInputArc().setColorTimeIntervals(new ArrayList<ColoredTimeInterval>());
                }
                if (arc instanceof TimedOutputArcComponent) {
                    arcComp = (TimedOutputArcComponent)((Object)arc);
                    arcComp.setGuardAndWeight(TimeInterval.ZERO_INF, arcComp.getWeight());
                }
                if (!(arc instanceof TimedTransportArcComponent)) continue;
                arcComp = (TimedTransportArcComponent)((Object)arc);
                ((TimedTransportArcComponent)arcComp).underlyingTransportArc().setColorTimeIntervals(new ArrayList<ColoredTimeInterval>());
                transportArcComponents.add(arcComp);
            }
            for (TimedTransportArcComponent arc : transportArcComponents) {
                if (!(arc.getSource() instanceof Place)) continue;
                TimedPlace source = template.model().getPlaceByName(arc.getSource().getName());
                TimedTransition destination = template.model().getTransitionByName(arc.getTarget().getName());
                TimedInputArc addedArc = new TimedInputArc(source, destination, TimeInterval.ZERO_INF, arc.getWeight(), arc.underlyingTransportArc().getInputExpression());
                DataLayer guiModel = template.guiModel();
                Place guiSource = guiModel.getPlaceByName(arc.getSource().getName());
                Transition guiTarget = guiModel.getTransitionByName(arc.getTarget().getName());
                TimedInputArcComponent newArc = new TimedInputArcComponent(new TimedOutputArcComponent((PlaceTransitionObject)guiSource, (PlaceTransitionObject)guiTarget, arc.getWeight().value(), arc.getSource().getName() + "_to_" + arc.getTarget().getName()), tab.getLens());
                Place oldGuiSource = guiModel.getPlaceByName(arc.getSource().getName());
                Transition oldGuiTarget = guiModel.getTransitionByName(arc.getTarget().getName());
                ArcPath newArcPath = TabTransformer.createArcPath(guiModel, oldGuiSource, oldGuiTarget, newArc);
                newArc.setUnderlyingArc(addedArc);
                newArc.setArcPath(newArcPath);
                newArc.updateArcPosition();
                guiModel.addPetriNetObject(newArc);
                TimedOutputArcComponent arc2 = TabTransformer.convertPartner(arc.getConnectedTo(), template, guiModel);
                TabTransformer.removeTransportArc(arc, guiModel);
                template.model().add(addedArc);
                template.model().add(arc2.underlyingArc());
            }
        }
    }

    static void removeTransportArc(TimedTransportArcComponent arc, DataLayer guiModel) {
        arc.underlyingTransportArc().delete();
        TimedTransportArcComponent partner = arc.getConnectedTo();
        guiModel.removePetriNetObject(arc);
        guiModel.removePetriNetObject(partner);
    }

    static TimedOutputArcComponent convertPartner(TimedTransportArcComponent arc, Template template, DataLayer guiModel) {
        TimedPlace destination = template.model().getPlaceByName(arc.getTarget().getName());
        TimedTransition source = template.model().getTransitionByName(arc.getSource().getName());
        TimedOutputArc addedArc = new TimedOutputArc(source, destination, arc.getWeight(), arc.underlyingTransportArc().getOutputExpression());
        Place guiTarget = guiModel.getPlaceByName(arc.getTarget().getName());
        Transition guiSource = guiModel.getTransitionByName(arc.getSource().getName());
        TimedOutputArcComponent newArc = new TimedOutputArcComponent((PlaceTransitionObject)guiSource, (PlaceTransitionObject)guiTarget, arc.getWeight().value(), arc.getSource().getName() + "_to_" + arc.getTarget().getName());
        Place oldGuiTarget = guiModel.getPlaceByName(arc.getTarget().getName());
        Transition oldGuiSource = guiModel.getTransitionByName(arc.getSource().getName());
        ArcPath newArcPath = TabTransformer.createArcPath(guiModel, oldGuiSource, oldGuiTarget, newArc);
        newArc.setUnderlyingArc(addedArc);
        newArc.setArcPath(newArcPath);
        newArc.updateArcPosition();
        guiModel.addPetriNetObject(newArc);
        return newArc;
    }

    private static ArcPath createArcPath(DataLayer currentGuiModel, PlaceTransitionObject source, PlaceTransitionObject target, Arc arc) {
        Arc guiArc = currentGuiModel.getArcByEndpoints(source, target);
        ArcPath arcPath = guiArc.getArcPath();
        int arcPathPointsNum = arcPath.getNumPoints();
        ArcPath newArcPath = new ArcPath(arc);
        newArcPath.purgePathPoints();
        for (int k = 0; k < arcPathPointsNum; ++k) {
            ArcPathPoint point = arcPath.getArcPathPoint(k);
            newArcPath.addPoint(point.getPoint().x, point.getPoint().y, point.getPointType());
        }
        return newArcPath;
    }

    public static void removeGameInformation(PetriNetTab tab) {
        for (Template template : tab.allTemplates()) {
            for (TimedTransition transition : template.model().transitions()) {
                if (!transition.isUncontrollable()) continue;
                transition.setUncontrollable(false);
            }
        }
    }

    public static void removeDistributionInformation(PetriNetTab tab) {
        for (Template template : tab.allTemplates()) {
            for (TimedTransition transition : template.model().transitions()) {
                if (!transition.hasCustomDistribution()) continue;
                transition.setDistribution(SMCDistribution.defaultDistribution());
            }
        }
    }

    public static void convertQueriesToOrFromSmc(Iterable<TAPNQuery> queries) {
        for (TAPNQuery query : queries) {
            boolean isSmc = query.getCategory().equals((Object)TAPNQuery.QueryCategory.SMC);
            TCTLAbstractProperty property = query.getProperty();
            query.setProperty(TabTransformer.smcConverter(property));
            query.setCategory(isSmc ? TAPNQuery.QueryCategory.CTL : TAPNQuery.QueryCategory.SMC);
            query.setSmcSettings(SMCSettings.Default());
        }
    }

    private static TCTLAbstractProperty smcConverter(TCTLAbstractProperty property) {
        TCTLAbstractStateProperty child = TabTransformer.getFirstChildOfProperty(property);
        if (property instanceof LTLFNode) {
            return new TCTLEFNode(child);
        }
        if (property instanceof LTLGNode) {
            return new TCTLAGNode(child);
        }
        if (property instanceof TCTLEFNode) {
            return new LTLFNode(child);
        }
        if (property instanceof TCTLEGNode) {
            return new LTLGNode(child);
        }
        if (property instanceof TCTLAFNode) {
            return new LTLFNode(child);
        }
        if (property instanceof TCTLAGNode) {
            return new LTLGNode(child);
        }
        if (property instanceof TCTLAndListNode) {
            TCTLAndListNode andNode = (TCTLAndListNode)property;
            List<TCTLAbstractStateProperty> properties = andNode.getProperties();
            ArrayList<TCTLAbstractStateProperty> convertedProperties = new ArrayList<TCTLAbstractStateProperty>();
            for (TCTLAbstractStateProperty prop : properties) {
                convertedProperties.add((TCTLAbstractStateProperty)TabTransformer.smcConverter(prop));
            }
            return new TCTLAndListNode(convertedProperties);
        }
        if (property instanceof TCTLOrListNode) {
            TCTLOrListNode orNode = (TCTLOrListNode)property;
            List<TCTLAbstractStateProperty> properties = orNode.getProperties();
            ArrayList<TCTLAbstractStateProperty> convertedProperties = new ArrayList<TCTLAbstractStateProperty>();
            for (TCTLAbstractStateProperty prop : properties) {
                convertedProperties.add((TCTLAbstractStateProperty)TabTransformer.smcConverter(prop));
            }
            return new TCTLOrListNode(convertedProperties);
        }
        if (property instanceof TCTLNotNode) {
            TCTLNotNode notNode = (TCTLNotNode)property;
            return new TCTLNotNode((TCTLAbstractStateProperty)TabTransformer.smcConverter(notNode.getProperty()));
        }
        return property;
    }

    private static TCTLAbstractStateProperty getFirstChildOfProperty(TCTLAbstractProperty property) {
        StringPosition[] children = property.getChildren();
        for (int i = 0; i < children.length; ++i) {
            TCTLAbstractProperty child = children[i].getObject();
            if (!(child instanceof TCTLAbstractStateProperty)) continue;
            return (TCTLAbstractStateProperty)child;
        }
        return new TCTLStatePlaceHolder();
    }

    public static void removeColorInformation(PetriNetTab tab) {
        tab.network().setColorTypes(List.of(ColorType.COLORTYPE_DOT));
        tab.network().setVariables(new ArrayList<Variable>());
        for (Template template : tab.allTemplates()) {
            NumberOfExpression numbExpr;
            Vector<ColorExpression> vecColorExpr;
            DotConstantExpression userOperatorExpression;
            int expressionWeight;
            for (TimedPlace timedPlace : template.model().places()) {
                timedPlace.setCtiList(new ArrayList<ColoredTimeInvariant>());
                timedPlace.setColorType(ColorType.COLORTYPE_DOT);
                int numberOfTokens = timedPlace.tokens().size();
                if (timedPlace.numberOfTokens() > 0) {
                    Vector<ColorExpression> v = new Vector<ColorExpression>();
                    v.add(new DotConstantExpression());
                    Vector<ArcExpression> numbOfExpression = new Vector<ArcExpression>();
                    numbOfExpression.add(new NumberOfExpression(timedPlace.numberOfTokens(), v));
                    timedPlace.setTokenExpression(new AddExpression(numbOfExpression));
                    continue;
                }
                timedPlace.resetNumberOfTokens();
            }
            for (TimedTransition timedTransition : template.model().transitions()) {
                timedTransition.setGuard(null);
            }
            for (TimedInputArc timedInputArc : template.model().inputArcs()) {
                timedInputArc.setColorTimeIntervals(new ArrayList<ColoredTimeInterval>());
                expressionWeight = timedInputArc.getArcExpression().weight();
                userOperatorExpression = new DotConstantExpression();
                vecColorExpr = new Vector<ColorExpression>();
                vecColorExpr.add(userOperatorExpression);
                numbExpr = new NumberOfExpression(expressionWeight, vecColorExpr);
                timedInputArc.setExpression(numbExpr);
                timedInputArc.setWeight(new IntWeight(expressionWeight));
            }
            for (TimedOutputArc timedOutputArc : template.model().outputArcs()) {
                expressionWeight = timedOutputArc.getExpression().weight();
                userOperatorExpression = new DotConstantExpression();
                vecColorExpr = new Vector();
                vecColorExpr.add(userOperatorExpression);
                numbExpr = new NumberOfExpression(expressionWeight, vecColorExpr);
                timedOutputArc.setExpression(numbExpr);
                timedOutputArc.setWeight(new IntWeight(expressionWeight));
            }
            for (TransportArc transportArc : template.model().transportArcs()) {
                ArcExpression oldInputExpr = transportArc.getInputExpression();
                transportArc.setColorTimeIntervals(new ArrayList<ColoredTimeInterval>());
                userOperatorExpression = new DotConstantExpression();
                vecColorExpr = new Vector();
                vecColorExpr.add(userOperatorExpression);
                numbExpr = new NumberOfExpression(oldInputExpr.weight(), vecColorExpr);
                transportArc.setInputExpression(numbExpr);
                transportArc.setOutputExpression(numbExpr);
                transportArc.setWeight(new IntWeight(oldInputExpr.weight()));
            }
        }
    }

    public static void addColorInformation(PetriNetTab tab) {
        for (Template template : tab.allTemplates()) {
            NumberOfExpression numbExpr;
            Vector<ColorExpression> vecColorExpr;
            UserOperatorExpression userOperatorExpression;
            ColorType ct;
            for (TimedInputArc timedInputArc : template.model().inputArcs()) {
                timedInputArc.setColorTimeIntervals(new ArrayList<ColoredTimeInterval>());
                ct = timedInputArc.source().getColorType();
                userOperatorExpression = new UserOperatorExpression(ct.getFirstColor());
                vecColorExpr = new Vector<ColorExpression>();
                vecColorExpr.add(userOperatorExpression);
                numbExpr = new NumberOfExpression(timedInputArc.getWeight().value(), vecColorExpr);
                timedInputArc.setExpression(numbExpr);
                timedInputArc.setWeight(new IntWeight(1));
            }
            for (TimedOutputArc timedOutputArc : template.model().outputArcs()) {
                ct = timedOutputArc.destination().getColorType();
                userOperatorExpression = new UserOperatorExpression(ct.getFirstColor());
                vecColorExpr = new Vector();
                vecColorExpr.add(userOperatorExpression);
                numbExpr = new NumberOfExpression(timedOutputArc.getWeight().value(), vecColorExpr);
                timedOutputArc.setExpression(numbExpr);
                timedOutputArc.setWeight(new IntWeight(1));
            }
            for (TransportArc transportArc : template.model().transportArcs()) {
                ct = transportArc.source().getColorType();
                userOperatorExpression = new UserOperatorExpression(ct.getFirstColor());
                vecColorExpr = new Vector();
                vecColorExpr.add(userOperatorExpression);
                numbExpr = new NumberOfExpression(transportArc.getWeight().value(), vecColorExpr);
                transportArc.setInputExpression(numbExpr);
                transportArc.setOutputExpression(numbExpr);
                transportArc.setWeight(new IntWeight(1));
            }
        }
    }

    public static void unfoldTab(PetriNetTab oldTab, boolean partition, boolean computeColorFixpoint, boolean useSymmetricVars) {
        ModelChecker engine = oldTab.getLens().isTimed() ? new VerifyDTAPN(new FileFinder(), new MessengerImpl()) : new VerifyPN(new FileFinder(), new MessengerImpl());
        engine.setup();
        if (!engine.isCorrectVersion()) {
            new MessengerImpl().displayErrorMessage("No " + String.valueOf(engine) + " specified: The verification is cancelled", "Verification Error");
            return;
        }
        UnfoldNet thread = new UnfoldNet(engine, new MessengerImpl(), oldTab.getGuiModels(), partition, computeColorFixpoint, useSymmetricVars);
        RunningVerificationDialog dialog = new RunningVerificationDialog(TAPAALGUI.getApp(), thread, "Unfolding");
        SmartDrawDialog.setupWorkerListener(thread);
        thread.execute(oldTab.network(), oldTab);
        dialog.setVisible(true);
    }

    public static void mapQueryToNewNames(TAPNQuery query, NameMapping mapping) {
        RenameAllPlacesVisitor placeVisitor = new RenameAllPlacesVisitor(mapping);
        RenameAllTransitionsVisitor transitionVisitor = new RenameAllTransitionsVisitor(mapping);
        query.getProperty().accept(placeVisitor, null);
        query.getProperty().accept(transitionVisitor, null);
    }

    public static String createUnfoldArgumentString(String modelFile, String queryFile, VerificationOptions options) {
        if (Platform.isWindows()) {
            return options.toString() + "\"" + modelFile + "\" \"" + queryFile + "\"";
        }
        return options.toString() + " " + modelFile + " " + queryFile;
    }
}

