/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.petrinet;

import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameGenerator {
    private static final String PLACE_NAME_PREFIX = "P";
    private static final String TRANSITION_NAME_PREFIX = "T";
    private static final String TEMPLATE_NAME_PREFIX = "TAPN";
    private final Hashtable<TimedArcPetriNet, Integer> placeIDs = new Hashtable();
    private final Hashtable<TimedArcPetriNet, Integer> transitionIDs = new Hashtable();
    private int tapnId = 0;

    public void add(TimedArcPetriNet net) {
        if (!this.placeIDs.containsKey(net) && !this.transitionIDs.containsKey(net)) {
            this.setupTemplate(net);
        }
    }

    public String getNewPlaceName(TimedArcPetriNet net) {
        int newId = this.placeIDs.get(net);
        newId = this.getNextFreeId(net, PLACE_NAME_PREFIX, newId);
        this.placeIDs.put(net, newId + 1);
        return PLACE_NAME_PREFIX + newId;
    }

    public String getNewTransitionName(TimedArcPetriNet net) {
        int newId = this.transitionIDs.get(net);
        newId = this.getNextFreeId(net, TRANSITION_NAME_PREFIX, newId);
        this.transitionIDs.put(net, newId + 1);
        return TRANSITION_NAME_PREFIX + newId;
    }

    private int getNextFreeId(TimedArcPetriNet net, String prefix, int currentId) {
        if (net.parentNetwork() != null && net.parentNetwork().isNameUsedForShared(prefix + currentId)) {
            while (net.parentNetwork().isNameUsedForShared(prefix + currentId)) {
                ++currentId;
            }
        }
        return currentId;
    }

    public String getNewTemplateName() {
        return TEMPLATE_NAME_PREFIX + ++this.tapnId;
    }

    private void setupTemplate(TimedArcPetriNet tapn) {
        int number;
        Pattern templatePattern = Pattern.compile("^TAPN(\\d+)$", 2);
        this.setupPlaceIDCounter(tapn);
        this.setupTransitionIDCounter(tapn);
        Matcher m = templatePattern.matcher(tapn.name());
        if (m.matches() && (number = Integer.parseInt(m.group(1))) > this.tapnId) {
            this.tapnId = number;
        }
    }

    private void setupTransitionIDCounter(TimedArcPetriNet tapn) {
        int number;
        Matcher m;
        Pattern transitionPattern = Pattern.compile("^T(\\d+)$", 2);
        int nameCounter = -1;
        for (TimedTransition timedTransition : tapn.transitions()) {
            m = transitionPattern.matcher(timedTransition.name().toLowerCase());
            if (!m.matches() || (number = Integer.parseInt(m.group(1))) <= nameCounter) continue;
            nameCounter = number;
        }
        for (SharedTransition sharedTransition : tapn.parentNetwork().sharedTransitions()) {
            m = transitionPattern.matcher(sharedTransition.name().toLowerCase());
            if (!m.matches() || (number = Integer.parseInt(m.group(1))) <= nameCounter) continue;
            nameCounter = number;
        }
        this.transitionIDs.put(tapn, ++nameCounter);
    }

    private void setupPlaceIDCounter(TimedArcPetriNet tapn) {
        int number;
        Matcher m;
        Pattern placePattern = Pattern.compile("^P(\\d+)$", 2);
        int nameCounter = -1;
        for (TimedPlace timedPlace : tapn.places()) {
            m = placePattern.matcher(timedPlace.name().toLowerCase());
            if (!m.matches() || (number = Integer.parseInt(m.group(1))) <= nameCounter) continue;
            nameCounter = number;
        }
        for (SharedPlace sharedPlace : tapn.parentNetwork().sharedPlaces()) {
            m = placePattern.matcher(sharedPlace.name().toLowerCase());
            if (!m.matches() || (number = Integer.parseInt(m.group(1))) <= nameCounter) continue;
            nameCounter = number;
        }
        this.placeIDs.put(tapn, ++nameCounter);
    }

    public void updateTemplateIndex(String newName) {
        int id;
        Pattern templatePattern = Pattern.compile("^TAPN(\\d+)$", 2);
        Matcher m = templatePattern.matcher(newName);
        if (m.matches() && (id = Integer.parseInt(m.group(1))) >= this.tapnId) {
            this.tapnId = ++id;
        }
    }

    private void updateMap(TimedArcPetriNet model, String newName, String pattern, Hashtable<TimedArcPetriNet, Integer> map) {
        Pattern compiledPattern = Pattern.compile(pattern, 2);
        Matcher m = compiledPattern.matcher(newName.toLowerCase());
        if (m.matches()) {
            int current = map.get(model);
            int id = Integer.parseInt(m.group(1));
            if (id >= current) {
                map.put(model, ++id);
            }
        }
    }

    public void updateIndices(TimedArcPetriNet model, String newName) {
        this.updateMap(model, newName, "^T(\\d+)$", this.transitionIDs);
        this.updateMap(model, newName, "^P(\\d+)$", this.placeIDs);
    }

    public void updateIndicesForAllModels(String name) {
        for (TimedArcPetriNet net : this.placeIDs.keySet()) {
            this.updateIndices(net, name);
        }
    }
}

