/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui;

import dk.aau.cs.debug.Logger;
import dk.aau.cs.model.tapn.simulation.ShortestDelayMode;
import dk.aau.cs.verification.UPPAAL.Verifyta;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPN;
import java.awt.Cursor;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import net.tapaal.Preferences;
import net.tapaal.TAPAAL;
import net.tapaal.gui.GuiFrameActions;
import net.tapaal.gui.GuiFrameControllerActions;
import net.tapaal.gui.TabActions;
import net.tapaal.gui.petrinet.animation.DelayEnabledTransitionControl;
import net.tapaal.gui.petrinet.dialog.BatchProcessingDialog;
import net.tapaal.gui.petrinet.dialog.NewTAPNPanel;
import net.tapaal.gui.petrinet.dialog.QueryDialog;
import net.tapaal.gui.petrinet.smartdraw.SmartDrawDialog;
import net.tapaal.gui.petrinet.verification.EngineDialogPanel;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.helpers.Reference.MutableReference;
import net.tapaal.resourcemanager.ResourceManager;
import net.tapaal.versioncheck.VersionChecker;
import pipe.gui.GuiFrame;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.animation.SimulationControl;
import pipe.gui.swingcomponents.filebrowser.FileBrowser;

public final class GuiFrameController
implements GuiFrameControllerActions {
    final GuiFrame guiFrameDirectAccess;
    final GuiFrameActions guiFrame;
    private final ArrayList<PetriNetTab> tabs = new ArrayList();
    final MutableReference<TabActions> currentTab = new MutableReference();
    boolean showComponents = true;
    boolean showSharedPT = true;
    boolean showConstants = true;
    boolean showColoredTokens = true;
    boolean showQueries = true;
    boolean showEnabledTransitions = true;
    boolean showDelayEnabledTransitions = true;
    private boolean showToolTips = true;
    private boolean showZeroToInfinityIntervals = true;
    private boolean showTokenAge = true;

    public GuiFrameController(GuiFrame appGui) {
        this.guiFrame = appGui;
        this.guiFrameDirectAccess = appGui;
        this.loadPreferences();
        appGui.registerController(this, this.currentTab);
    }

    public List<PetriNetTab> getTabs() {
        return Collections.unmodifiableList(this.tabs);
    }

    private void loadPreferences() {
        Preferences prefs = Preferences.getInstance();
        QueryDialog.setAdvancedView(prefs.getAdvancedQueryView());
        PetriNetTab.setEditorModelRoot(prefs.getEditorModelRoot());
        PetriNetTab.setSimulatorModelRoot(prefs.getSimulatorModelRoot());
        this.showComponents = prefs.getShowComponents();
        this.guiFrame.setShowComponentsSelected(this.showComponents);
        this.showSharedPT = prefs.getShowSharedPT();
        this.guiFrame.setShowSharedPTSelected(this.showSharedPT);
        this.showQueries = prefs.getShowQueries();
        this.guiFrame.setShowQueriesSelected(this.showQueries);
        this.showConstants = prefs.getShowConstants();
        this.guiFrame.setShowConstantsSelected(this.showConstants);
        this.showColoredTokens = prefs.getShowColoredTokens();
        this.guiFrame.setShowColoredTokensSelected(this.showColoredTokens);
        this.showEnabledTransitions = prefs.getShowEnabledTransitions();
        this.guiFrame.setShowEnabledTransitionsSelected(this.showEnabledTransitions);
        this.showDelayEnabledTransitions = prefs.getShowDelayEnabledTransitions();
        this.guiFrame.setShowDelayEnabledTransitionsSelected(this.showDelayEnabledTransitions);
        DelayEnabledTransitionControl.setDefaultDelayMode(prefs.getDelayEnabledTransitionDelayMode());
        DelayEnabledTransitionControl.setDefaultGranularity(prefs.getDelayEnabledTransitionGranularity());
        SimulationControl.setDefaultIsRandomTransition(prefs.getDelayEnabledTransitionIsRandomTransition());
        this.showToolTips = prefs.getShowToolTips();
        this.setDisplayToolTips(this.showToolTips);
        this.guiFrame.setShowToolTipsSelected(this.showToolTips);
        this.showZeroToInfinityIntervals = prefs.getShowZeroInfIntervals();
        this.guiFrame.setShowZeroToInfinityIntervalsSelected(this.showZeroToInfinityIntervals);
        this.showTokenAge = prefs.getShowTokenAge();
        this.guiFrame.setShowTokenAgeSelected(this.showTokenAge);
        this.guiFrame.setWindowSize(prefs.getWindowSize());
    }

    @Override
    public void setEnableSidepanel(PetriNetTab tab) {
        Preferences prefs = Preferences.getInstance();
        tab.showComponents(prefs.getShowComponents());
        tab.showSharedPT(prefs.getShowSharedPT());
        tab.showQueries(prefs.getShowQueries());
        tab.showConstantsPanel(prefs.getShowConstants());
        tab.showDelayEnabledTransitions(prefs.getShowDelayEnabledTransitions());
    }

    @Override
    public void openTab(PetriNetTab tab) {
        this.tabs.add(tab);
        tab.setSafeGuiFrameActions(this.guiFrameDirectAccess);
        tab.setGuiFrameControllerActions(this);
        this.guiFrame.attachTabToGuiFrame(tab);
        this.guiFrame.changeToTab(tab);
        tab.drawingSurface().repaintAll();
    }

    @Override
    public void closeTab(PetriNetTab tab) {
        if (tab != null) {
            boolean closeNet = true;
            if (tab.getNetChanged()) {
                closeNet = this.showSavePendingChangesDialog(tab);
            }
            if (closeNet) {
                tab.setSafeGuiFrameActions(null);
                tab.setGuiFrameControllerActions(null);
                this.guiFrame.detachTabFromGuiFrame(tab);
                this.tabs.remove(tab);
            }
        }
    }

    @Override
    public void changeToTab(PetriNetTab tab) {
        this.currentTab.ifPresent(t -> t.setApp(null));
        this.currentTab.setReference(tab);
        this.guiFrame.changeToTab(tab);
        this.currentTab.ifPresent(t -> t.setApp(this.guiFrame));
        this.guiFrame.setTitle(this.currentTab.map(TabActions::getTabTitle).orElse(null));
    }

    @Override
    public void clearPreferences() {
        Preferences.getInstance().clear();
        Verifyta.reset();
        VerifyTAPN.reset();
        VerifyDTAPN.reset();
    }

    @Override
    public void showEngineDialog() {
        new EngineDialogPanel().showDialog();
    }

    @Override
    public void openURL(String address) {
        GuiFrameController.showInBrowser(address);
    }

    @Override
    public void showNewPNDialog() {
        NewTAPNPanel.showNewTapnPanel(this.guiFrameDirectAccess);
    }

    @Override
    public void saveWorkspace() {
        Preferences prefs = Preferences.getInstance();
        prefs.setAdvancedQueryView(QueryDialog.getAdvancedView());
        prefs.setEditorModelRoot(PetriNetTab.getEditorModelRoot());
        prefs.setSimulatorModelRoot(PetriNetTab.getSimulatorModelRoot());
        prefs.setWindowSize(this.guiFrameDirectAccess.getSize());
        prefs.setShowComponents(this.showComponents);
        prefs.setShowSharedPT(this.showSharedPT);
        prefs.setShowQueries(this.showQueries);
        prefs.setShowConstants(this.showConstants);
        prefs.setShowColoredTokens(this.showColoredTokens);
        prefs.setShowEnabledTrasitions(this.showEnabledTransitions);
        prefs.setShowDelayEnabledTransitions(this.showDelayEnabledTransitions);
        prefs.setShowTokenAge(this.guiFrameDirectAccess.showTokenAge());
        prefs.setDelayEnabledTransitionDelayMode(DelayEnabledTransitionControl.getDefaultDelayMode());
        prefs.setDelayEnabledTransitionGranularity(DelayEnabledTransitionControl.getDefaultGranularity());
        prefs.setDelayEnabledTransitionIsRandomTransition(SimulationControl.isRandomTransition());
        JOptionPane.showMessageDialog(this.guiFrameDirectAccess, "The workspace has now been saved into your preferences.\nIt will be used as the initial workspace next time you run the tool.", "Workspace Saved", 1);
    }

    @Override
    public void checkForUpdate() {
        this.checkForUpdate(true);
    }

    @Override
    public void showAbout() {
        StringBuilder buffer = new StringBuilder("About " + TAPAAL.getProgramName());
        buffer.append("\n\n");
        buffer.append("TAPAAL is a tool for editing, simulation and verification of P/T and timed-arc Petri nets.\n");
        buffer.append("The GUI is based on PIPE2: http://pipe2.sourceforge.net/\n\n");
        buffer.append("License information and more is available at: www.tapaal.net\n\n");
        buffer.append("Credits\n\n");
        buffer.append("TAPAAL GUI and Translations:\n");
        buffer.append("Mathias Andersen, Sine V. Birch, Jacob Hjort Bundgaard, Joakim Byg, Malo Dautry, \nTanguy Dubois, Jakob Dyhr, Louise Foshammer, Malte Neve-Gr\u00e6sb\u00f8ll, ");
        buffer.append("Lasse Jacobsen, \nMorten Jacobsen,Thomas S. Jacobsen, Jacob J. Jensen, Peter G. Jensen, ");
        buffer.append("Mads Johannsen,\nKenneth Y. J\u00f8rgensen, Mikael H. M\u00f8ller, Christoffer Moesgaard, Kristian Morsing Pedersen,\nThomas Pedersen, Lena S. Ernstsen, Niels N. Samuelsen, Jiri Srba, Mathias G. S\u00f8rensen,\nJakob H. Taankvist, Peter H. Taankvist and Mikkel Tygesen\n");
        buffer.append("Aalborg University 2008-2026\n\n");
        buffer.append("TAPAAL Continuous Engine (verifytapn):\n");
        buffer.append("Alexandre David, Lasse Jacobsen, Morten Jacobsen and Jiri Srba\n");
        buffer.append("Aalborg University 2011-2026\n\n");
        buffer.append("TAPAAL Discrete Engine (verifydtapn):\n");
        buffer.append("Mathias Andersen, Tanguy Dubois, Peter G. Jensen, Heine G. Larsen, Jiri Srba,\n");
        buffer.append("Mathias G. S\u00f8rensen and Jakob H. Taankvist\n");
        buffer.append("Aalborg University 2012-2026\n\n");
        buffer.append("TAPAAL Untimed Engine (verifypn):\n");
        buffer.append("Alexander Bilgram, Emil Normann Brandt, Frederik M. B\u00f8nneland, Jakob Dyhr, Malo Dautry, Peter Fogh, \n");
        buffer.append("Jens Emil Fink H\u00f8jriis, Jonas F. Jensen, Emil Gybel Henriksen, Lasse S. Jensen, Peter G. Jensen,\nNicolaj \u00d8. Jensen, ");
        buffer.append("Tobias S. Jepsen, Mads Johannsen, Kenneth Y. J\u00f8rgensen, Isabella Kaufmann, \n");
        buffer.append("Alan Mozafar Khorsid, Andreas H. Klostergaard, Esben Nielsen, S\u00f8ren M. Nielsen, \nThomas S. Nielsen, ");
        buffer.append("Samuel Pastva, Thomas Pedersen, Kira S. Pedersen, Theodor Risager, Jiri Srba, \nAdam M. St\u00fcck, Andreas S. S\u00f8rensen, Mathias M. S\u00f8rensen, Peter H. Taankvist, Rasmus G. Tollund, \nNikolaj J. Ulrik, Simon M. Virenfeldt and Lars K. Oestergaard \n");
        buffer.append("Aalborg University 2014-2026\n\n");
        buffer.append("\n");
        JOptionPane.showMessageDialog(null, buffer.toString(), "About " + TAPAAL.getProgramName(), 1, ResourceManager.appIcon());
    }

    @Override
    public void exit() {
        if (this.showSavePendingChangesDialogForAllTabs()) {
            this.guiFrameDirectAccess.dispose();
            System.exit(0);
        }
    }

    @Override
    public void openFiles(List<File> files) {
        this.openTAPNFile(files.toArray(new File[0]));
    }

    @Override
    public void openTAPNFile() {
        File[] files = FileBrowser.constructor(new String[]{"tapn", "xml", "pnml"}, FileBrowser.userPath).openFiles();
        this.openTAPNFile(files);
    }

    @Override
    public void importPNMLFile() {
        File[] files = FileBrowser.constructor("Import PNML", "pnml", FileBrowser.userPath).openFiles();
        this.openPNMLFile(files);
    }

    private void openTAPNFile(final File[] files) {
        this.guiFrameDirectAccess.setCursor(Cursor.getPredefinedCursor(3));
        SwingWorker<List<PetriNetTab>, Void> worker = new SwingWorker<List<PetriNetTab>, Void>(this){
            final /* synthetic */ GuiFrameController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected List<PetriNetTab> doInBackground() throws Exception {
                ArrayList<PetriNetTab> filesOpened = new ArrayList<PetriNetTab>();
                for (File f : files) {
                    if (!f.exists() || !f.isFile() || !f.canRead()) continue;
                    FileBrowser.userPath = f.getParent();
                    FileType fileType = this.this$0.inferFileType(f);
                    if (fileType == FileType.PNML) {
                        filesOpened.add(PetriNetTab.createNewTabFromPNMLFile(f));
                        continue;
                    }
                    if (fileType == FileType.TAPN) {
                        filesOpened.add(PetriNetTab.createNewTabFromFile(f));
                        continue;
                    }
                    throw new UnsupportedOperationException("The file " + f.getName() + " has an unsupported file extension. Please use a .tapn, .xml or .pnml file.");
                }
                return filesOpened;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    List tabs = (List)this.get();
                    for (PetriNetTab tab : tabs) {
                        int dialogResult;
                        if (tab == null) continue;
                        this.this$0.openTab(tab);
                        if (tab.currentTemplate().getHasPositionalInfo() || tab.currentTemplate().guiModel().getPlaces().length + tab.currentTemplate().guiModel().getTransitions().length <= 0 || (dialogResult = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), "The net does not have any layout information. Would you like to do automatic layout?", "Automatic Layout?", 0)) != 0) continue;
                        SmartDrawDialog.showSmartDrawDialog();
                    }
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message.contains("Exception:")) {
                        message = message.split(":", 2)[1];
                    }
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, "Error loading file", 0);
                    e.printStackTrace();
                    return;
                }
                finally {
                    this.this$0.guiFrameDirectAccess.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        worker.execute();
        while (!worker.isDone()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private FileType inferFileType(File file) {
        String fileName = file.getName().toLowerCase();
        try {
            String content = Files.readString(file.toPath());
            if (content.contains("<query") || content.contains("<feature") || !content.contains("<page")) {
                return FileType.TAPN;
            }
            if (content.contains("<pnml")) {
                return FileType.PNML;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileName.endsWith(".tapn") || fileName.endsWith(".xml")) {
            return FileType.TAPN;
        }
        if (fileName.endsWith(".pnml")) {
            return FileType.PNML;
        }
        return FileType.UNKNOWN;
    }

    private void openPNMLFile(final File[] files) {
        this.guiFrameDirectAccess.setCursor(Cursor.getPredefinedCursor(3));
        SwingWorker<List<PetriNetTab>, Void> worker = new SwingWorker<List<PetriNetTab>, Void>(this){
            final /* synthetic */ GuiFrameController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected List<PetriNetTab> doInBackground() throws Exception {
                ArrayList<PetriNetTab> fileOpened = new ArrayList<PetriNetTab>();
                for (File f : files) {
                    if (!f.exists() || !f.isFile() || !f.canRead()) continue;
                    FileBrowser.userPath = f.getParent();
                    fileOpened.add(PetriNetTab.createNewTabFromPNMLFile(f));
                }
                return fileOpened;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    List tabs = (List)this.get();
                    for (PetriNetTab tab : tabs) {
                        int dialogResult;
                        this.this$0.openTab(tab);
                        if (tab.currentTemplate().getHasPositionalInfo() || tab.currentTemplate().guiModel().getPlaces().length + tab.currentTemplate().guiModel().getTransitions().length <= 0 || (dialogResult = JOptionPane.showConfirmDialog(null, "The net does not have any layout information. Would you like to do automatic layout?", "Automatic Layout?", 0)) != 0) continue;
                        SmartDrawDialog.showSmartDrawDialog();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(TAPAALGUI.getApp(), e.getMessage(), "Error loading file", 0);
                    e.printStackTrace();
                    return;
                }
                finally {
                    this.this$0.guiFrameDirectAccess.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        worker.execute();
        while (!worker.isDone()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void checkForUpdate(boolean forcecheck) {
        VersionChecker versionChecker = new VersionChecker();
        if (versionChecker.checkForNewVersion(forcecheck)) {
            StringBuilder message = new StringBuilder("There is a new version of TAPAAL available at www.tapaal.net.");
            message.append("\n\nCurrent version: ");
            message.append("4.0.3");
            message.append("\nNew version: ");
            message.append(versionChecker.getNewVersionNumber());
            String changelog = versionChecker.getChangelog();
            if (!changelog.equals("")) {
                message.append('\n');
                message.append('\n');
                message.append("Changelog:");
                message.append('\n');
                message.append(changelog);
            }
            JOptionPane optionPane = new JOptionPane();
            optionPane.setMessage(message.toString());
            optionPane.setMessageType(1);
            JButton updateButton = new JButton("Update now");
            updateButton.setMnemonic(67);
            optionPane.add(updateButton);
            JButton laterButton = new JButton("Update later");
            laterButton.setMnemonic(67);
            optionPane.add(laterButton);
            JButton ignoreButton = new JButton("Ignore this update");
            laterButton.setMnemonic(67);
            optionPane.add(ignoreButton);
            optionPane.setOptions(new Object[]{updateButton, laterButton, ignoreButton});
            JDialog dialog = optionPane.createDialog(null, "New Version of TAPAAL");
            laterButton.addActionListener(e -> {
                Preferences.getInstance().setLatestVersion(null);
                dialog.setVisible(false);
                dialog.dispose();
            });
            updateButton.addActionListener(e -> {
                Preferences.getInstance().setLatestVersion(null);
                dialog.setVisible(false);
                dialog.dispose();
                GuiFrameController.showInBrowserDeprecatedDirectCall("http://www.tapaal.net/download");
            });
            ignoreButton.addActionListener(e -> {
                Preferences.getInstance().setLatestVersion(versionChecker.getNewVersionNumber());
                dialog.setVisible(false);
                dialog.dispose();
            });
            updateButton.requestFocusInWindow();
            dialog.getRootPane().setDefaultButton(updateButton);
            dialog.setVisible(true);
        }
    }

    private static void openBrowser(URI url) {
        try {
            Desktop.getDesktop().browse(url);
        }
        catch (IOException | UnsupportedOperationException e) {
            Logger.log("Cannot open the browser.");
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "There was a problem opening the default web browser \nPlease open the url in your browser by entering " + url.toString(), "Error opening browser", 0);
        }
    }

    @Deprecated
    public static void showInBrowserDeprecatedDirectCall(String address) {
        GuiFrameController.showInBrowser(address);
    }

    private static void showInBrowser(String address) {
        try {
            URI url = new URI(address);
            GuiFrameController.openBrowser(url);
        }
        catch (URISyntaxException e) {
            Logger.log("Error converting to URL");
            e.printStackTrace();
        }
    }

    @Override
    public void save() {
        this.save((TabActions)this.currentTab.get());
    }

    @Override
    public void saveAs() {
        this.saveAs((TabActions)this.currentTab.get());
    }

    @Override
    public void showBatchProcessingDialog() {
        if (this.showSavePendingChangesDialogForAllTabs()) {
            BatchProcessingDialog.showBatchProcessingDialog(new JList<TAPNQuery>(new DefaultListModel()));
        }
    }

    private boolean save(TabActions tab) {
        boolean result;
        File modelFile = tab.getFile();
        if (modelFile != null) {
            tab.saveNet(modelFile);
            result = true;
        } else {
            result = this.saveAs(tab);
        }
        return result;
    }

    private boolean saveAs(TabActions tab) {
        boolean result;
        String path = tab.getTabTitle();
        String filename = FileBrowser.constructor("Timed-Arc Petri Net", "tapn", path).saveFile(path);
        if (filename != null) {
            File modelFile = new File(filename);
            tab.saveNet(modelFile);
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    private boolean showSavePendingChangesDialog(TabActions tab) {
        if (null == tab) {
            return false;
        }
        if (tab.getNetChanged()) {
            this.changeToTab((PetriNetTab)tab);
            int result = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), "The net has been modified. Save the current net?", "Confirm Save Current File", 1, 2);
            switch (result) {
                case 0: {
                    boolean saved = this.save(tab);
                    return saved;
                }
                case 1: {
                    return true;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean showSavePendingChangesDialogForAllTabs() {
        for (PetriNetTab tab : this.getTabs()) {
            if (!tab.getNetChanged() || this.showSavePendingChangesDialog(tab)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toggleQueries() {
        this.setQueries(!this.showQueries);
    }

    public void setQueries(boolean b) {
        this.showQueries = b;
        this.guiFrame.setShowQueriesSelected(this.showQueries);
        this.getTabs().forEach(o -> o.showQueries(this.showQueries));
    }

    @Override
    public void toggleConstants() {
        this.setConstants(!this.showConstants);
    }

    public void setConstants(boolean b) {
        this.showConstants = b;
        this.guiFrame.setShowConstantsSelected(this.showConstants);
        this.getTabs().forEach(o -> o.showConstantsPanel(this.showConstants));
    }

    @Override
    public void toggleTokenAge() {
        this.setTokenAge(!this.showTokenAge);
    }

    public void setTokenAge(boolean b) {
        this.showTokenAge = b;
        Preferences.getInstance().setShowTokenAge(this.showTokenAge);
        this.guiFrame.setShowTokenAgeSelected(this.showTokenAge);
        this.currentTab.ifPresent(TabActions::repaintAll);
    }

    @Override
    public void toggleColorTokens() {
        this.setColorTokens(!this.showColoredTokens);
    }

    public void setColorTokens(boolean b) {
        this.showColoredTokens = b;
        Preferences.getInstance().setShowColoredTokens(this.showColoredTokens);
        this.guiFrame.setShowColoredTokensSelected(this.showColoredTokens);
        this.currentTab.ifPresent(TabActions::repaintAll);
    }

    @Override
    public void toggleZeroToInfinityIntervals() {
        this.setZeroToInfinityIntervals(!this.showZeroToInfinityIntervals);
    }

    public void setZeroToInfinityIntervals(boolean b) {
        this.showZeroToInfinityIntervals = b;
        this.guiFrame.setShowZeroToInfinityIntervalsSelected(this.showZeroToInfinityIntervals);
        Preferences.getInstance().setShowZeroInfIntervals(this.showZeroToInfinityIntervals);
        this.currentTab.ifPresent(TabActions::repaintAll);
    }

    @Override
    public void toggleComponents() {
        this.setComponents(!this.showComponents);
    }

    public void setComponents(boolean b) {
        this.showComponents = b;
        this.guiFrame.setShowComponentsSelected(this.showComponents);
        this.getTabs().forEach(o -> o.showComponents(this.showComponents));
    }

    @Override
    public void toggleSharedPT() {
        this.setSharedPT(!this.showSharedPT);
    }

    public void setSharedPT(boolean b) {
        this.showSharedPT = b;
        this.guiFrame.setShowSharedPTSelected(this.showSharedPT);
        this.getTabs().forEach(o -> o.showSharedPT(this.showSharedPT));
    }

    @Override
    public void toggleEnabledTransitionsList() {
        this.setEnabledTransitionsList(!this.showEnabledTransitions);
    }

    @Override
    public void setEnabledTransitionsList(boolean b) {
        this.showEnabledTransitions = b;
        this.guiFrame.setShowEnabledTransitionsSelected(b);
        this.currentTab.ifPresent(o -> o.showEnabledTransitionsList(b));
    }

    @Override
    public boolean isEnabledTransitionsListVisible() {
        return this.showEnabledTransitions;
    }

    @Override
    public void toggleDelayEnabledTransitions() {
        this.setDelayEnabledTransitions(!this.showDelayEnabledTransitions);
    }

    private void setDelayEnabledTransitions(boolean b) {
        this.showDelayEnabledTransitions = b;
        this.guiFrame.setShowDelayEnabledTransitionsSelected(b);
        this.currentTab.ifPresent(o -> o.showDelayEnabledTransitions(b));
    }

    @Override
    public void toggleDisplayToolTips() {
        this.showToolTips = !this.showToolTips;
        this.setDisplayToolTips(this.showToolTips);
    }

    private void setDisplayToolTips(boolean b) {
        this.guiFrame.setShowToolTipsSelected(b);
        Preferences.getInstance().setShowToolTips(b);
        ToolTipManager.sharedInstance().setEnabled(b);
        ToolTipManager.sharedInstance().setInitialDelay(400);
        ToolTipManager.sharedInstance().setReshowDelay(800);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
    }

    @Override
    public void showAdvancedWorkspace() {
        this.showAdvancedWorkspace(true);
    }

    @Override
    public void showSimpleWorkspace() {
        this.showAdvancedWorkspace(false);
    }

    private void showAdvancedWorkspace(boolean advanced) {
        QueryDialog.setAdvancedView(advanced);
        this.setComponents(advanced);
        this.setSharedPT(advanced);
        this.setConstants(advanced);
        this.setQueries(true);
        this.setEnabledTransitionsList(true);
        this.setDisplayToolTips(true);
        this.currentTab.ifPresent(TabActions::setResizeingDefault);
        if (advanced) {
            this.setZeroToInfinityIntervals(true);
            this.setTokenAge(true);
        } else {
            this.setZeroToInfinityIntervals(false);
            this.setTokenAge(false);
        }
        DelayEnabledTransitionControl.getInstance().setValue(new BigDecimal("0.1"));
        DelayEnabledTransitionControl.getInstance().setDelayMode(ShortestDelayMode.getInstance());
        SimulationControl.getInstance().setRandomTransitionMode(false);
    }

    private static enum FileType {
        TAPN,
        PNML,
        UNKNOWN;

    }
}

