/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.gui.DrawingSurfaceManager;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.tapaal.gui.petrinet.model.GuiModelManager;
import pipe.gui.canvas.DrawingSurfaceImpl;
import pipe.gui.petrinet.graphicElements.GraphicalElement;

public abstract class AbstractDrawingSurfaceManager {
    protected DrawingSurfaceImpl canvas;
    protected GuiModelManager guiModelManager;
    private final Map<Predicate<DrawingSurfaceEvent>, Consumer<DrawingSurfaceEvent>> filter = new LinkedHashMap<Predicate<DrawingSurfaceEvent>, Consumer<DrawingSurfaceEvent>>();
    private AbstractDrawingSurfaceManager next = null;

    public void drawingSurfaceMouseClicked(MouseEvent e) {
    }

    public void drawingSurfaceMousePressed(MouseEvent e) {
    }

    public void drawingSurfaceMouseReleased(MouseEvent e) {
    }

    public void drawingSurfaceMouseDragged(MouseEvent e) {
    }

    public void drawingSurfaceMouseWheelMoved(MouseWheelEvent e) {
    }

    public void drawingSurfaceMouseMoved(MouseEvent e) {
    }

    public final void registerManager(DrawingSurfaceImpl canvas, GuiModelManager guiModelManager) {
        this.canvas = canvas;
        this.guiModelManager = guiModelManager;
        this.setupManager();
    }

    public final void deregisterManager() {
        this.teardownManager();
        this.canvas = null;
        this.guiModelManager = null;
    }

    public void setupManager() {
    }

    public void teardownManager() {
    }

    public AbstractDrawingSurfaceManager() {
        this.registerEvents();
    }

    public abstract void registerEvents();

    protected final void registerEvent(Predicate<DrawingSurfaceEvent> filterCondition, Consumer<DrawingSurfaceEvent> action) {
        this.filter.put(filterCondition, action);
    }

    public final void triggerEvent(DrawingSurfaceEvent e) {
        boolean handled = this.filter.keySet().stream().filter(f -> f.test(e)).findFirst().map(f -> {
            this.filter.get(f).accept(e);
            return true;
        }).orElse(false);
        if (!handled && this.next != null) {
            this.next.triggerEvent(e);
        }
    }

    public static class DrawingSurfaceEvent {
        public final GraphicalElement pno;
        public final MouseEvent e;
        public final MouseAction a;

        public DrawingSurfaceEvent(GraphicalElement pno, MouseEvent e, MouseAction a) {
            this.pno = pno;
            this.e = e;
            this.a = a;
        }
    }

    public static enum MouseAction {
        clicked,
        doubleClicked,
        rightClicked,
        pressed,
        released,
        dragged,
        entered,
        exited,
        wheel,
        moved;

    }
}

